/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.generator.customization;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.gegy1000.terrarium.server.event.TerrariumRegistryEvent;
import net.gegy1000.terrarium.server.util.JsonDiscoverer;
import net.gegy1000.terrarium.server.world.generator.customization.TerrariumPreset;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="terrarium")
public class TerrariumPresetRegistry {
    private static final Map<ResourceLocation, TerrariumPreset> PRESETS = new LinkedHashMap<ResourceLocation, TerrariumPreset>();
    private static final JsonDiscoverer<TerrariumPreset> DISCOVERER = new JsonDiscoverer<TerrariumPreset>(TerrariumPreset::parse);

    public static void onInit() {
        MinecraftForge.EVENT_BUS.post((net.minecraftforge.fml.common.eventhandler.Event)new Event(PRESETS));
    }

    @SubscribeEvent
    public static void onRegisterPresets(Event event) {
        List<JsonDiscoverer.Result<TerrariumPreset>> discoveredPresets = DISCOVERER.discoverFiles("data", "terrarium/presets");
        for (JsonDiscoverer.Result<TerrariumPreset> result : discoveredPresets) {
            event.register(result.getKey(), result.getParsed());
        }
    }

    public static TerrariumPreset get(ResourceLocation identifier) {
        return PRESETS.get(identifier);
    }

    public static Collection<TerrariumPreset> getPresets() {
        return PRESETS.values();
    }

    public static Map<ResourceLocation, TerrariumPreset> getRegistry() {
        return Collections.unmodifiableMap(PRESETS);
    }

    public static final class Event
    extends TerrariumRegistryEvent<TerrariumPreset> {
        private Event(Map<ResourceLocation, TerrariumPreset> registry) {
            super(registry);
        }
    }
}

