/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data.source;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Stream;
import net.gegy1000.terrarium.Terrarium;

public final class TerrariumCacheDirs {
    public static final Path LEGACY_ROOT;
    public static final Path GLOBAL_ROOT;

    static {
        block17: {
            LEGACY_ROOT = Paths.get(".", "mods/terrarium/cache");
            GLOBAL_ROOT = Paths.get(".", "mods/terrarium/cache2");
            try {
                if (!Files.exists(LEGACY_ROOT, new LinkOption[0])) break block17;
                Terrarium.LOGGER.info("Deleting legacy terrarium cache directory");
                try (Stream<Path> walk = Files.walk(LEGACY_ROOT, new FileVisitOption[0]);){
                    Stream<Path> stream = walk.sorted(Comparator.reverseOrder());
                    for (Path child : stream::iterator) {
                        Files.delete(child);
                    }
                }
            }
            catch (IOException e) {
                Terrarium.LOGGER.warn("Failed to delete legacy terrarium cache", (Throwable)e);
            }
        }
        try {
            Files.createDirectories(GLOBAL_ROOT, new FileAttribute[0]);
        }
        catch (IOException e) {
            Terrarium.LOGGER.warn("Failed to create cache directories", (Throwable)e);
        }
    }
}

