/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.data.raster;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Optional;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.DataKey;
import net.gegy1000.terrarium.server.world.data.DataSample;
import net.gegy1000.terrarium.server.world.data.DataView;
import net.gegy1000.terrarium.server.world.data.raster.AbstractRaster;
import net.gegy1000.terrarium.server.world.data.raster.IntegerRaster;
import net.gegy1000.terrarium.server.world.data.raster.Raster;
import net.minecraft.util.math.MathHelper;

public final class ByteRaster
extends AbstractRaster<byte[]>
implements IntegerRaster<byte[]> {
    private ByteRaster(byte[] data, int width, int height) {
        super(data, width, height);
    }

    public static ByteRaster create(int width, int height) {
        byte[] array = new byte[width * height];
        return new ByteRaster(array, width, height);
    }

    public static ByteRaster create(DataView view) {
        return ByteRaster.create(view.width(), view.height());
    }

    public static ByteRaster wrap(byte[] data, int width, int height) {
        Preconditions.checkArgument((data.length == width * height ? 1 : 0) != 0, (Object)"invalid buffer size");
        return new ByteRaster(data, width, height);
    }

    public static Sampler sampler(DataKey<ByteRaster> key) {
        return new Sampler(key);
    }

    public void set(int x, int y, byte value) {
        ((byte[])this.rawData)[this.index((int)x, (int)y)] = value;
    }

    public byte get(int x, int y) {
        return ((byte[])this.rawData)[this.index(x, y)];
    }

    public void fill(byte value) {
        Arrays.fill((byte[])this.rawData, value);
    }

    public void transform(Transformer transformer) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int index = this.index(x, y);
                ((byte[])this.rawData)[index] = transformer.apply(((byte[])this.rawData)[index], x, y);
            }
        }
    }

    public void iterate(Iterator iterator) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                iterator.accept(((byte[])this.rawData)[this.index(x, y)], x, y);
            }
        }
    }

    @Override
    public void setFloat(int x, int y, float value) {
        int rounded = (int)value;
        this.set(x, y, (byte)MathHelper.func_76125_a((int)rounded, (int)-128, (int)127));
    }

    @Override
    public float getFloat(int x, int y) {
        return this.get(x, y);
    }

    @Override
    public void setInt(int x, int y, int value) {
        this.set(x, y, (byte)MathHelper.func_76125_a((int)value, (int)-128, (int)127));
    }

    @Override
    public int getInt(int x, int y) {
        return this.get(x, y);
    }

    public ByteRaster copy() {
        return new ByteRaster(Arrays.copyOf((byte[])this.rawData, ((byte[])this.rawData).length), this.width, this.height);
    }

    public static class Sampler
    implements Raster.Sampler<ByteRaster> {
        private final DataKey<ByteRaster> key;
        private byte defaultValue;

        Sampler(DataKey<ByteRaster> key) {
            this.key = key;
        }

        public Sampler setDefaultValue(byte value) {
            this.defaultValue = value;
            return this;
        }

        public byte sample(ColumnDataCache dataCache, int x, int z) {
            DataSample data = dataCache.joinData(x >> 4, z >> 4);
            return this.sample(data, x & 0xF, z & 0xF);
        }

        public byte sample(DataSample data, int x, int z) {
            Optional<ByteRaster> optional = data.get(this.key);
            if (optional.isPresent()) {
                ByteRaster raster = optional.get();
                return raster.get(x, z);
            }
            return this.defaultValue;
        }

        @Override
        public ByteRaster sample(ColumnDataCache dataCache, DataView view) {
            ByteRaster raster = ByteRaster.create(view);
            if (this.defaultValue != 0) {
                Arrays.fill((byte[])raster.rawData, this.defaultValue);
            }
            AbstractRaster.sampleInto(raster, dataCache, view, this.key);
            return raster;
        }
    }

    public static interface Iterator {
        public void accept(byte var1, int var2, int var3);
    }

    public static interface Transformer {
        public byte apply(byte var1, int var2, int var3);
    }
}

