/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.composer.structure;

import dev.gegy.gengen.api.CubicPos;
import dev.gegy.gengen.api.writer.ChunkPopulationWriter;
import dev.gegy.gengen.api.writer.ChunkPrimeWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.world.composer.structure.StructureComposer;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public final class CompositeStructureComposer
implements StructureComposer {
    private final StructureComposer[] composers;

    private CompositeStructureComposer(StructureComposer[] composers) {
        this.composers = composers;
    }

    public static CompositeStructureComposer of(StructureComposer ... composers) {
        return new CompositeStructureComposer(composers);
    }

    public static CompositeStructureComposer of(Collection<StructureComposer> composers) {
        return new CompositeStructureComposer(composers.toArray(new StructureComposer[0]));
    }

    @Override
    public void prepareStructures(TerrariumWorld terrarium, CubicPos pos) {
        for (StructureComposer composer : this.composers) {
            composer.prepareStructures(terrarium, pos);
        }
    }

    @Override
    public void primeStructures(TerrariumWorld terrarium, CubicPos pos, ChunkPrimeWriter writer) {
        for (StructureComposer composer : this.composers) {
            composer.primeStructures(terrarium, pos, writer);
        }
    }

    @Override
    public void populateStructures(TerrariumWorld terrarium, CubicPos pos, ChunkPopulationWriter writer) {
        for (StructureComposer composer : this.composers) {
            composer.populateStructures(terrarium, pos, writer);
        }
    }

    @Override
    public boolean isInsideStructure(TerrariumWorld terrarium, World world, String name, BlockPos pos) {
        for (StructureComposer composer : this.composers) {
            if (!composer.isInsideStructure(terrarium, world, name, pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public BlockPos getClosestStructure(TerrariumWorld terrarium, World world, String name, BlockPos pos, boolean findUnexplored) {
        BlockPos nearest = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (StructureComposer composer : this.composers) {
            double distanceSq;
            BlockPos structure = composer.getClosestStructure(terrarium, world, name, pos, findUnexplored);
            if (structure == null || !((distanceSq = structure.func_177951_i((Vec3i)pos)) < nearestDistanceSq)) continue;
            nearestDistanceSq = distanceSq;
            nearest = structure;
        }
        return nearest;
    }

    @Override
    @Nullable
    public List<Biome.SpawnListEntry> getPossibleCreatures(TerrariumWorld terrarium, World world, EnumCreatureType type, BlockPos pos) {
        ArrayList<Biome.SpawnListEntry> result = null;
        for (StructureComposer composer : this.composers) {
            List<Biome.SpawnListEntry> creatures = composer.getPossibleCreatures(terrarium, world, type, pos);
            if (creatures == null) continue;
            if (result == null) {
                result = new ArrayList<Biome.SpawnListEntry>(creatures.size());
            }
            result.addAll(creatures);
        }
        return result;
    }
}

