/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world.chunk.tracker;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumMap;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class SavedColumnTracker {
    private static final EnumMap<DimensionType, WorldTracker> TRACKERS = new EnumMap(DimensionType.class);

    public static boolean isSaved(World world, ChunkPos columnPos) {
        WorldTracker tracker = TRACKERS.get(world.field_73011_w.func_186058_p());
        if (tracker != null) {
            return tracker.isSaved(columnPos);
        }
        return false;
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        TRACKERS.put(event.getWorld().field_73011_w.func_186058_p(), new WorldTracker());
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        TRACKERS.remove(event.getWorld().field_73011_w.func_186058_p());
    }

    @SubscribeEvent
    public static void onColumnWatch(ChunkWatchEvent.Watch event) {
        Chunk chunk = event.getChunkInstance();
        if (chunk == null) {
            return;
        }
        World world = chunk.func_177412_p();
        WorldTracker tracker = TRACKERS.get(world.field_73011_w.func_186058_p());
        if (tracker != null) {
            boolean saved = SavedColumnTracker.isColumnSaved(world, chunk.field_76635_g, chunk.field_76647_h);
            tracker.mark(chunk.func_76632_l(), saved);
        }
    }

    @SubscribeEvent
    public static void onColumnUnwatch(ChunkWatchEvent.UnWatch event) {
        WorldTracker tracker;
        Chunk chunk = event.getChunkInstance();
        if (chunk == null) {
            return;
        }
        World world = chunk.func_177412_p();
        if (!SavedColumnTracker.isColumnTracked(world, chunk.field_76635_g, chunk.field_76647_h) && (tracker = TRACKERS.get(world.field_73011_w.func_186058_p())) != null) {
            tracker.remove(chunk.func_76632_l());
        }
    }

    private static boolean isColumnTracked(World world, int x, int z) {
        if (world instanceof WorldServer) {
            PlayerChunkMap chunkMap = ((WorldServer)world).func_184164_w();
            return chunkMap.func_152621_a(x, z);
        }
        return false;
    }

    private static boolean isColumnSaved(World world, int x, int z) {
        if (world instanceof WorldServer) {
            return ((WorldServer)world).func_72863_F().field_73247_e.func_191063_a(x, z);
        }
        return false;
    }

    private static class WorldTracker {
        private final Object2BooleanMap<ChunkPos> savedStates = new Object2BooleanOpenHashMap();

        private WorldTracker() {
        }

        boolean isSaved(ChunkPos pos) {
            return this.savedStates.getBoolean((Object)pos);
        }

        void mark(ChunkPos pos, boolean saved) {
            this.savedStates.put((Object)pos, saved);
        }

        void remove(ChunkPos pos) {
            this.savedStates.removeBoolean((Object)pos);
        }
    }
}

