/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.world;

import dev.gegy.gengen.api.GenericWorldType;
import java.util.Collection;
import net.gegy1000.terrarium.server.util.Lazy;
import net.gegy1000.terrarium.server.world.TerrariumDataInitializer;
import net.gegy1000.terrarium.server.world.TerrariumGeneratorInitializer;
import net.gegy1000.terrarium.server.world.chunk.ComposableBiomeProvider;
import net.gegy1000.terrarium.server.world.chunk.ComposableChunkGenerator;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.generator.customization.GenerationSettings;
import net.gegy1000.terrarium.server.world.generator.customization.PropertySchema;
import net.gegy1000.terrarium.server.world.generator.customization.TerrariumCustomization;
import net.gegy1000.terrarium.server.world.generator.customization.TerrariumPreset;
import net.gegy1000.terrarium.server.world.generator.customization.TerrariumPresetRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TerrariumWorldType
implements GenericWorldType {
    private final String name;
    private final ResourceLocation identifier;
    private final ResourceLocation presetIdentifier;
    private final Lazy<TerrariumCustomization> customization;

    public TerrariumWorldType(String name, ResourceLocation identifier, ResourceLocation presetIdentifier) {
        this.name = "terrarium." + name;
        this.identifier = identifier;
        this.presetIdentifier = presetIdentifier;
        this.customization = Lazy.of(this::buildCustomization);
    }

    public abstract TerrariumGeneratorInitializer createGeneratorInitializer(WorldServer var1, GenerationSettings var2, ColumnDataCache var3);

    public abstract TerrariumDataInitializer createDataInitializer(GenerationSettings var1);

    public abstract Collection<ICapabilityProvider> createCapabilities(World var1, GenerationSettings var2);

    public abstract PropertySchema buildPropertySchema();

    public abstract TerrariumCustomization buildCustomization();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ComposableChunkGenerator createGenerator(World world) {
        return new ComposableChunkGenerator(world);
    }

    @Override
    public BiomeProvider createBiomeProvider(World world) {
        if (!world.field_72995_K) {
            return new ComposableBiomeProvider(world);
        }
        return new BiomeProviderSingle(Biomes.field_180279_ad);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract void onCustomize(Minecraft var1, WorldType var2, GuiCreateWorld var3);

    @Override
    public final boolean isCustomizable() {
        return !this.customization.get().getCategories().isEmpty();
    }

    @Override
    public final int getMinGenerationHeight(WorldServer world) {
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            return this.getMinGenerationHeight(world, GenerationSettings.parseFrom((World)world));
        }
        return 0;
    }

    @Override
    public final int getMaxGenerationHeight(WorldServer world) {
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            return this.getMaxGenerationHeight(world, GenerationSettings.parseFrom((World)world));
        }
        return 256;
    }

    protected int getMinGenerationHeight(WorldServer world, GenerationSettings settings) {
        return 0;
    }

    protected int getMaxGenerationHeight(WorldServer world, GenerationSettings settings) {
        return 256;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public TerrariumPreset getPreset() {
        return TerrariumPresetRegistry.get(this.presetIdentifier);
    }

    public TerrariumCustomization getCustomization() {
        return this.customization.get();
    }

    public boolean isHidden() {
        return false;
    }
}

