/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.compatibility;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.gegy1000.earth.server.world.compatibility.ColumnCompatibilityWorld;
import net.gegy1000.earth.server.world.compatibility.CompatibilityChunk;
import net.gegy1000.earth.server.world.compatibility.VoidChunkLoader;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;

class CompatibilityChunkProvider
extends ChunkProviderServer {
    private final ColumnCompatibilityWorld compatibilityWorld;

    public CompatibilityChunkProvider(ColumnCompatibilityWorld world) {
        super((WorldServer)world, (IChunkLoader)VoidChunkLoader.INSTANCE, (IChunkGenerator)new VoidGenerator((World)world));
        this.compatibilityWorld = world;
    }

    void clear() {
        this.field_73244_f.clear();
    }

    public void func_189549_a(Chunk chunk) {
    }

    public void func_73240_a() {
    }

    @Nullable
    public Chunk loadChunk(int x, int z, @Nullable Runnable runnable) {
        Chunk chunk = this.func_186026_b(x, z);
        if (chunk == null) {
            Chunk parentChunk = this.compatibilityWorld.parent.func_72964_e(x, z);
            chunk = new CompatibilityChunk(this.compatibilityWorld, parentChunk);
            this.field_73244_f.put(ChunkPos.func_77272_a((int)x, (int)z), (Object)chunk);
        }
        if (runnable != null) {
            runnable.run();
        }
        return chunk;
    }

    public Chunk func_186025_d(int x, int z) {
        return this.loadChunk(x, z, null);
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_191062_e(int x, int z) {
        return this.compatibilityWorld.parent.func_190526_b(x, z);
    }

    public boolean func_186027_a(boolean all) {
        return true;
    }

    public boolean func_73157_c() {
        return false;
    }

    public String func_73148_d() {
        return "ColumnCompatibilityChunkProvider";
    }

    private static class VoidGenerator
    implements IChunkGenerator {
        private final World world;

        private VoidGenerator(World world) {
            this.world = world;
        }

        public Chunk func_185932_a(int x, int z) {
            return new Chunk(this.world, x, z);
        }

        public void func_185931_b(int x, int z) {
        }

        public boolean func_185933_a(Chunk chunk, int x, int z) {
            return false;
        }

        public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType type, BlockPos pos) {
            return Collections.emptyList();
        }

        @Nullable
        public BlockPos func_180513_a(World world, String name, BlockPos origin, boolean findUnexplored) {
            return null;
        }

        public void func_180514_a(Chunk chunk, int x, int z) {
        }

        public boolean func_193414_a(World world, String name, BlockPos pos) {
            return false;
        }
    }
}

