/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.shared;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.gegy1000.earth.server.shared.SharedDataInitializer;
import net.gegy1000.earth.server.shared.SharedEarthData;
import net.gegy1000.earth.server.util.ProcessTracker;
import net.gegy1000.earth.server.util.TrackedInputStream;
import net.gegy1000.earth.server.world.data.source.WorldClimateRaster;
import net.gegy1000.earth.server.world.data.source.cache.CachingInput;
import net.gegy1000.terrarium.server.world.data.source.TerrariumCacheDirs;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public final class ClimateRasterInitializer
implements SharedDataInitializer {
    private static final Path PATH = TerrariumCacheDirs.GLOBAL_ROOT.resolve("climatic_variables.xz");
    private static final String URL = "https://terrarium.gegy.dev/geo3/climatic_variables.xz";

    @Override
    public void initialize(SharedEarthData data, ProcessTracker processTracker) {
        try (TrackedInputStream input = new TrackedInputStream(ClimateRasterInitializer.getStream());){
            input.submitTo((ITextComponent)new TextComponentTranslation("initializer.terrarium.climate_raster", new Object[0]), processTracker);
            data.put(SharedEarthData.CLIMATIC_VARIABLES, WorldClimateRaster.parse(input));
        }
        catch (IOException e) {
            processTracker.raiseException(e);
        }
    }

    private static InputStream getStream() throws IOException {
        if (Files.exists(PATH, new LinkOption[0])) {
            return Files.newInputStream(PATH, new OpenOption[0]);
        }
        return CachingInput.getCachingStream(ClimateRasterInitializer.getRemoteStream(), () -> Files.newOutputStream(PATH, new OpenOption[0]), e -> {
            try {
                Files.delete(PATH);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private static InputStream getRemoteStream() throws IOException {
        URLConnection connection = new URL(URL).openConnection();
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(30000);
        connection.setRequestProperty("User-Agent", "terrarium");
        return connection.getInputStream();
    }
}

