/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.gengen.core;

import dev.gegy.gengen.api.CubicPos;
import dev.gegy.gengen.api.generator.GenericChunkGenerator;
import dev.gegy.gengen.api.writer.ChunkPopulationWriter;
import io.github.opencubicchunks.cubicchunks.api.worldgen.ICubeGenerator;
import io.github.opencubicchunks.cubicchunks.api.worldgen.populator.WorldGenEntitySpawner;
import io.github.opencubicchunks.cubicchunks.api.worldgen.populator.event.PopulateCubeEvent;
import io.github.opencubicchunks.cubicchunks.core.server.CubeProviderServer;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public interface GenGenWorldProxy {
    @Nullable
    public GenericChunkGenerator unwrapChunkGenerator(World var1);

    public void populateEntities(CubicPos var1, ChunkPopulationWriter var2, Random var3);

    public static class Vanilla
    implements GenGenWorldProxy {
        @Override
        @Nullable
        public GenericChunkGenerator unwrapChunkGenerator(World world) {
            IChunkGenerator generator = this.getChunkGenerator(world);
            if (generator == null) {
                return null;
            }
            return GenericChunkGenerator.unwrap(generator);
        }

        @Override
        public void populateEntities(CubicPos pos, ChunkPopulationWriter writer, Random random) {
            if (pos.getY() != 0) {
                return;
            }
            World world = writer.getGlobal();
            Biome biome = writer.getCenterBiome();
            IChunkGenerator generator = this.getChunkGenerator(world);
            if (generator == null) {
                return;
            }
            if (TerrainGen.populate((IChunkGenerator)generator, (World)world, (Random)random, (int)pos.getX(), (int)pos.getZ(), (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
                int centerX = pos.getCenterX();
                int centerZ = pos.getCenterZ();
                WorldEntitySpawner.func_77191_a((World)world, (Biome)biome, (int)centerX, (int)centerZ, (int)16, (int)16, (Random)random);
            }
        }

        @Nullable
        private IChunkGenerator getChunkGenerator(World world) {
            IChunkProvider provider = world.func_72863_F();
            if (provider instanceof ChunkProviderServer) {
                return ((ChunkProviderServer)provider).field_186029_c;
            }
            return null;
        }
    }

    public static class Cubic
    implements GenGenWorldProxy {
        @Override
        @Nullable
        public GenericChunkGenerator unwrapChunkGenerator(World world) {
            IChunkProvider provider = world.func_72863_F();
            if (provider instanceof CubeProviderServer) {
                ICubeGenerator generator = ((CubeProviderServer)provider).getCubeGenerator();
                return GenericChunkGenerator.unwrap(generator);
            }
            if (provider instanceof ChunkProviderServer) {
                IChunkGenerator generator = ((ChunkProviderServer)provider).field_186029_c;
                return GenericChunkGenerator.unwrap(generator);
            }
            return null;
        }

        @Override
        public void populateEntities(CubicPos pos, ChunkPopulationWriter writer, Random random) {
            World world = writer.getGlobal();
            if (world instanceof WorldServer) {
                PopulateCubeEvent.Populate event = new PopulateCubeEvent.Populate(world, random, pos.getX(), pos.getY(), pos.getZ(), false, PopulateChunkEvent.Populate.EventType.ANIMALS);
                if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)event)) {
                    return;
                }
                BlockPos origin = pos.getCenter();
                Biome biome = writer.getCenterBiome();
                WorldGenEntitySpawner.initialWorldGenSpawn((WorldServer)((WorldServer)world), (Biome)biome, (int)origin.func_177958_n(), (int)origin.func_177956_o(), (int)origin.func_177952_p(), (int)16, (int)16, (int)16, (Random)random);
            }
        }
    }
}

