/*
 * Decompiled with CFR 0.152.
 */
package external.org.apache.logging.slf4j;

import external.org.apache.logging.slf4j.Log4jLogger;
import external.org.slf4j.ILoggerFactory;
import external.org.slf4j.Logger;
import external.org.slf4j.LoggerFactory;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;

public class Log4jLoggerFactory
implements ILoggerFactory {
    private static final String FQCN = Log4jLoggerFactory.class.getName();
    private static final String PACKAGE = "external.org.slf4j";
    private final Map<LoggerContext, ConcurrentMap<String, Logger>> contextMap = new WeakHashMap<LoggerContext, ConcurrentMap<String, Logger>>();

    @Override
    public Logger getLogger(String name) {
        LoggerContext context = this.getContext();
        ConcurrentMap<String, Logger> loggers = this.getLoggersMap(context);
        if (loggers.containsKey(name)) {
            return (Logger)loggers.get(name);
        }
        String key = "ROOT".equals(name) ? "" : name;
        loggers.putIfAbsent(name, new Log4jLogger(context.getLogger(key), name));
        return (Logger)loggers.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<String, Logger> getLoggersMap(LoggerContext context) {
        Map<LoggerContext, ConcurrentMap<String, Logger>> map = this.contextMap;
        synchronized (map) {
            ConcurrentMap<String, Logger> map2 = this.contextMap.get(context);
            if (map2 == null) {
                map2 = new ConcurrentHashMap<String, Logger>();
                this.contextMap.put(context, map2);
            }
            return map2;
        }
    }

    private LoggerContext getContext() {
        Throwable t = new Throwable();
        boolean next = false;
        boolean pkg = false;
        String fqcn = LoggerFactory.class.getName();
        for (StackTraceElement element : t.getStackTrace()) {
            if (FQCN.equals(element.getClassName())) {
                next = true;
                continue;
            }
            if (next && element.getClassName().startsWith(PACKAGE)) {
                fqcn = element.getClassName();
                pkg = true;
                continue;
            }
            if (pkg) break;
        }
        return PrivateManager.getContext(fqcn);
    }

    private static class PrivateManager
    extends LogManager {
        private static final String FQCN = LoggerFactory.class.getName();

        private PrivateManager() {
        }

        public static LoggerContext getContext() {
            return PrivateManager.getContext((String)FQCN, (boolean)false);
        }

        public static LoggerContext getContext(String fqcn) {
            return PrivateManager.getContext((String)fqcn, (boolean)false);
        }

        public static ExtendedLogger getLogger(String name) {
            return PrivateManager.getContext(FQCN).getLogger(name);
        }
    }
}

