/*
 * Decompiled with CFR 0.152.
 */
package dev.redstudio.redcore.utils;

import dev.redstudio.redcore.ProjectConstants;
import dev.redstudio.redcore.ticking.RedClientTicker;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class OptiNotFine {
    private static boolean checkedOptiFineInstalled = false;
    private static boolean isOptiFineInstalled = true;
    private static Field shaderPackLoadedField = null;
    private static Field fastRenderField = null;

    public static boolean isOptiFineInstalled() {
        if (!checkedOptiFineInstalled) {
            try {
                Class.forName("optifine.Installer");
            }
            catch (ClassNotFoundException ignored) {
                isOptiFineInstalled = false;
            }
            checkedOptiFineInstalled = true;
        }
        return isOptiFineInstalled;
    }

    public static boolean shadersEnabled() {
        if (!OptiNotFine.isOptiFineInstalled()) {
            return false;
        }
        try {
            if (shaderPackLoadedField == null) {
                shaderPackLoadedField = Class.forName("net.optifine.shaders.Shaders").getDeclaredField("shaderPackLoaded");
            }
            return (Boolean)shaderPackLoadedField.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException exception) {
            ProjectConstants.RED_LOGGER.printFramedError("OptiNotFine", "Could not get OptiFine shaders status.", "If shaders are enabled things might break", exception.getMessage());
            return false;
        }
    }

    public static void forceOptiFineFastRenderOff() {
        RedClientTicker.startClientTicker();
        MinecraftForge.EVENT_BUS.register(OptiNotFine.class);
    }

    private static void disableFastRender() {
        if (!OptiNotFine.isOptiFineInstalled()) {
            return;
        }
        try {
            if (fastRenderField == null) {
                fastRenderField = Class.forName("net.minecraft.client.settings.GameSettings").getDeclaredField("ofFastRender");
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (fastRenderField.getBoolean(mc.field_71474_y)) {
                fastRenderField.set(mc.field_71474_y, false);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException exception) {
            ProjectConstants.RED_LOGGER.printFramedError("OptiNotFine", "Could not disable OptiFine fast renderer", "Things will break", exception.getMessage());
        }
    }

    @SubscribeEvent
    public static void onClientQuarterTickEvent(TickEvent.ClientTickEvent clientTickEvent) {
        OptiNotFine.disableFastRender();
    }
}

