/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftblib.lib.util.InvUtils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemIcon
extends Icon {
    ItemStack stack;

    public static Icon getItemIcon(ItemStack stack) {
        return stack.func_190926_b() ? EMPTY : new ItemIcon(stack);
    }

    public static Icon getItemIcon(Item item) {
        return ItemIcon.getItemIcon(new ItemStack(item));
    }

    public static Icon getItemIcon(Block block) {
        return ItemIcon.getItemIcon(new ItemStack(block));
    }

    public static Icon getItemIcon(String lazyStackString) {
        return lazyStackString.isEmpty() ? EMPTY : new LazyItemIcon(lazyStackString);
    }

    private ItemIcon(ItemStack is) {
        this.stack = is;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h) {
        GuiHelper.drawItem(this.getStack(), x, y, (double)w / 16.0, (double)h / 16.0, true);
        GuiHelper.setupDrawing();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawStatic(int x, int y, int w, int h) {
        GuiHelper.drawItem(this.getStack(), x, y, (double)w / 16.0, (double)h / 16.0, false);
        GuiHelper.setupDrawing();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawItem3D(ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-0.02f);
        IBakedModel bakedmodel = mc.func_175599_af().func_184393_a(stack, (World)mc.field_71441_e, (EntityLivingBase)mc.field_71439_g);
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        mc.func_175599_af().func_180454_a(stack, bakedmodel);
        GlStateManager.func_179121_F();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw3D() {
        ItemIcon.drawItem3D(this.getStack());
    }

    public String toString() {
        return "item:" + ItemStackSerializer.toString(this.getStack());
    }

    @Override
    public int hashCode() {
        ItemStack stack = this.getStack();
        int h = stack.func_77973_b().hashCode();
        h = h * 31 + stack.func_190916_E();
        h = h * 31 + stack.func_77960_j();
        h = h * 31 + Objects.hashCode(stack.func_77973_b().getNBTShareTag(stack));
        return h;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof ItemIcon && ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)this.getStack(), (ItemStack)((ItemIcon)o).getStack());
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.getStack();
    }

    private static class LazyItemIcon
    extends ItemIcon {
        private String lazyStackString;
        private boolean createdStack;

        private LazyItemIcon(String s) {
            super(ItemStack.field_190927_a);
            this.lazyStackString = s;
        }

        @Override
        public ItemStack getStack() {
            if (!this.createdStack) {
                this.stack = ItemStackSerializer.parseItem(this.lazyStackString);
                this.createdStack = true;
                if (FTBLibConfig.debugging.print_more_errors && this.stack.func_190926_b()) {
                    this.stack = InvUtils.brokenItem(this.lazyStackString);
                }
            }
            return this.stack;
        }

        @Override
        public String toString() {
            return "item:" + this.lazyStackString;
        }
    }
}

