/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.pdd.network;

import gcewing.sg.BaseDataChannel;
import gcewing.sg.SGCraft;
import gcewing.sg.features.pdd.AddressData;
import gcewing.sg.features.pdd.client.gui.PddEntryScreen;
import gcewing.sg.features.pdd.client.gui.PddScreen;
import gcewing.sg.network.SGChannel;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.util.SGAddressing;
import gcewing.sg.util.SGState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PddNetworkHandler
extends SGChannel {
    protected static BaseDataChannel pddChannel;

    public PddNetworkHandler(String name) {
        super(name);
        pddChannel = this;
    }

    public static void addPddEntryFromServer(EntityPlayer player, String address, int nextIndex) {
        BaseDataChannel.ChannelOutput data = pddChannel.openPlayer(player, "AddPddEntry");
        data.writeUTF(address);
        data.writeInt(nextIndex);
        data.close();
    }

    @BaseDataChannel.ClientMessageHandler(value="AddPddEntry")
    public void handlePddAddAddressRequest(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        String address = data.readUTF();
        int nextIndex = data.readInt();
        address = SGAddressing.formatAddress(address, "-", "-");
        new PddEntryScreen(null, player, "Name Here", address, nextIndex, 0, false, false, false, 1).display();
    }

    public static void updatePdd(EntityPlayer player, boolean value, int status) {
        BaseDataChannel.ChannelOutput data = pddChannel.openPlayer(player, "UpdatePdd");
        data.writeInt(status);
        data.writeBoolean(value);
        data.close();
    }

    @BaseDataChannel.ClientMessageHandler(value="UpdatePdd")
    public void handleUpdatePddListRequest(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        int status = data.readInt();
        boolean update = data.readBoolean();
        if (Minecraft.func_71410_x().field_71462_r instanceof PddScreen) {
            PddScreen screen = (PddScreen)Minecraft.func_71410_x().field_71462_r;
            if (status == 2) {
                screen.stopDialing();
            }
        }
    }

    public static void sendPddInputToServer(SGBaseTE te, int function, String origin, String destination) {
        BaseDataChannel.ChannelOutput data = pddChannel.openServer("PddInput");
        PddNetworkHandler.writeCoords(data, te);
        data.writeInt(function);
        data.writeUTF(origin);
        data.writeUTF(destination);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="PddInput")
    public void handlePddInputFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) throws SGAddressing.AddressingError {
        boolean isPermissionsAdmin;
        BlockPos pos = this.readCoords(data);
        int setting = data.readInt();
        SGBaseTE localGate = SGBaseTE.at((IBlockAccess)player.field_70170_p, pos);
        String origin = data.readUTF();
        String destination = data.readUTF();
        if (!origin.isEmpty() && !destination.isEmpty() && SGAddressing.inSameDimension(origin, destination)) {
            destination = destination.substring(0, 7);
        }
        boolean bl = isPermissionsAdmin = SGCraft.hasPermissionSystem() && SGCraft.hasPermission(player, "sgcraft.admin");
        if (SGCraft.hasPermission(player, "sgcraft.gui.pdd") || isPermissionsAdmin) {
            if (setting == 1 && !localGate.isConnected() && (localGate.allowGateAccess(player.func_70005_c_()) || isPermissionsAdmin)) {
                localGate.connect(destination, player, false, false);
            }
            if (setting == 2 && localGate.isConnected() && (localGate.allowGateAccess(player.func_70005_c_()) || isPermissionsAdmin)) {
                localGate.disconnect(player);
            }
            if (setting == 3) {
                // empty if block
            }
            if (setting == 4 && (localGate.allowGateAccess(player.func_70005_c_()) || isPermissionsAdmin)) {
                if (localGate.state == SGState.Idle) {
                    localGate.isInitiator = true;
                }
                localGate.connectOrDisconnect("", player);
                localGate.clearIdleConnection();
                localGate.errorState = false;
            }
        } else {
            System.err.println("SGCraft - Hacked Client detected!");
            return;
        }
    }

    public static void sendPddEntryUpdateToServer(String name, String address, int index, int unid, boolean locked, boolean autoClose) {
        BaseDataChannel.ChannelOutput data = pddChannel.openServer("PddInputEntry");
        data.writeUTF(name);
        data.writeUTF(address);
        data.writeInt(index);
        data.writeInt(unid);
        data.writeBoolean(locked);
        data.writeBoolean(autoClose);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="PddInputEntry")
    public void handlePddEntryUpdateFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        NBTTagCompound compound;
        String name = data.readUTF();
        String address = data.readUTF();
        int index = data.readInt();
        int unid = data.readInt();
        boolean locked = data.readBoolean();
        boolean autoClose = data.readBoolean();
        if (!SGCraft.hasPermission(player, "sgcraft.gui.pdd.edit")) {
            System.err.println("SGCraft - Hacked Client detected!");
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack != null && (compound = stack.func_77978_p()) != null) {
            AddressData.updateAddress(player, compound, unid, name, address, index, locked, autoClose);
            stack.func_77982_d(compound);
            player.field_71069_bz.func_75142_b();
            PddNetworkHandler.updatePdd(player, false, 1);
        }
    }

    public static void sendEnterSymbolToServer(SGBaseTE te, String address, int digit) {
        BaseDataChannel.ChannelOutput data = pddChannel.openServer("EnterImmediateSymbol");
        PddNetworkHandler.writeCoords(data, te);
        data.writeUTF(address);
        data.writeInt(digit);
        data.close();
    }

    @Override
    @BaseDataChannel.ServerMessageHandler(value="EnterImmediateSymbol")
    public void handleEnterSymbolFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        BlockPos pos = this.readCoords(data);
        String address = data.readUTF();
        int digit = data.readInt();
        SGBaseTE localGate = SGBaseTE.at((IBlockAccess)player.field_70170_p, pos);
        if (localGate != null) {
            localGate.immediateDialSymbol(address, player, digit);
        }
    }
}

