/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.opf.client;

import com.madgag.gif.fmsware.GifDecoder;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ProcessedImageData {
    private final int width;
    private final int height;
    private final Frame[] frames;
    private final long[] delay;
    private final long duration;

    public ProcessedImageData(BufferedImage image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.frames = new Frame[]{ProcessedImageData.loadFrom(image)};
        this.delay = new long[]{0L};
        this.duration = 0L;
    }

    public ProcessedImageData(GifDecoder decoder) {
        Dimension frameSize = decoder.getFrameSize();
        this.width = (int)frameSize.getWidth();
        this.height = (int)frameSize.getHeight();
        this.frames = new Frame[decoder.getFrameCount()];
        this.delay = new long[decoder.getFrameCount()];
        long time = 0L;
        for (int i = 0; i < decoder.getFrameCount(); ++i) {
            this.frames[i] = ProcessedImageData.loadFrom(decoder.getFrame(i));
            this.delay[i] = time;
            time += (long)decoder.getDelay(i);
        }
        this.duration = time;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long[] getDelay() {
        return this.delay;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isAnimated() {
        return this.frames.length > 1;
    }

    public int getFrameCount() {
        return this.frames.length;
    }

    public int uploadFrame(int index) {
        Frame frame;
        if (index >= 0 && index < this.frames.length && (frame = this.frames[index]) != null) {
            this.frames[index] = null;
            return ProcessedImageData.uploadFrame(frame.buffer, frame.hasAlpha, this.width, this.height);
        }
        return -1;
    }

    private static int uploadFrame(ByteBuffer buffer, boolean hasAlpha, int width, int height) {
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        if (!hasAlpha) {
            GL11.glPixelStorei((int)3317, (int)1);
        }
        GL11.glTexImage2D((int)3553, (int)0, (int)(hasAlpha ? 32856 : 32849), (int)width, (int)height, (int)0, (int)(hasAlpha ? 6408 : 6407), (int)5121, (ByteBuffer)buffer);
        return textureID;
    }

    private static Frame loadFrom(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] pixels = new int[width * height];
        image.getRGB(0, 0, width, height, pixels, 0, width);
        boolean hasAlpha = false;
        if (image.getColorModel().hasAlpha()) {
            for (int pixel : pixels) {
                if ((pixel >> 24 & 0xFF) >= 255) continue;
                hasAlpha = true;
                break;
            }
        }
        int bytesPerPixel = hasAlpha ? 4 : 3;
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * bytesPerPixel));
        for (int pixel : pixels) {
            buffer.put((byte)(pixel >> 16 & 0xFF));
            buffer.put((byte)(pixel >> 8 & 0xFF));
            buffer.put((byte)(pixel & 0xFF));
            if (!hasAlpha) continue;
            buffer.put((byte)(pixel >> 24 & 0xFF));
        }
        buffer.flip();
        return new Frame(buffer, hasAlpha);
    }

    private static class Frame {
        private final ByteBuffer buffer;
        private final boolean hasAlpha;

        public Frame(ByteBuffer buffer, boolean alpha) {
            this.buffer = buffer;
            this.hasAlpha = alpha;
        }
    }
}

