/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.opf.block;

import com.creativemd.creativecore.common.tileentity.TileEntityCreative;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.opf.block.BlockPicFrame;
import com.creativemd.opf.client.DownloadThread;
import com.creativemd.opf.client.PictureTexture;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPicFrame
extends TileEntityCreative
implements ITickable {
    @SideOnly(value=Side.CLIENT)
    public DownloadThread downloader;
    @SideOnly(value=Side.CLIENT)
    public PictureTexture texture;
    @SideOnly(value=Side.CLIENT)
    public boolean failed;
    @SideOnly(value=Side.CLIENT)
    public String error;
    public int renderDistance = 512;
    public String url = "";
    public float sizeX = 1.0f;
    public float sizeY = 1.0f;
    public boolean flippedX;
    public boolean flippedY;
    public float rotationX;
    public float rotationY;
    public byte rotation = 0;
    public byte posX = 0;
    public byte posY = 0;
    public boolean visibleFrame = true;
    public float transparency = 1.0f;
    public float brightness = 1.0f;

    public TileEntityPicFrame() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.initClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initClient() {
        this.texture = null;
        this.failed = false;
        this.error = null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldLoadTexture() {
        return !this.isTextureLoaded() && !this.failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void loadTexture() {
        if (this.shouldLoadTexture()) {
            if (this.downloader == null && DownloadThread.activeDownloads < 5) {
                PictureTexture loadedTexture = DownloadThread.loadedImages.get(this.url);
                if (loadedTexture == null) {
                    Object object = DownloadThread.LOCK;
                    synchronized (object) {
                        if (!DownloadThread.loadingImages.contains(this.url)) {
                            this.downloader = new DownloadThread(this.url);
                            return;
                        }
                    }
                } else {
                    this.texture = loadedTexture;
                }
            }
            if (this.downloader != null && this.downloader.hasFinished()) {
                if (this.downloader.hasFailed()) {
                    this.failed = true;
                    this.error = this.downloader.getError();
                    DownloadThread.LOGGER.error("Could not load image of " + this.field_174879_c + " " + this.error);
                } else {
                    this.texture = DownloadThread.loadImage(this.downloader);
                }
                this.downloader = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isTextureLoaded() {
        return this.texture != null;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Math.pow(this.renderDistance, 2.0);
    }

    public static AxisAlignedBB getBoundingBox(TileEntityPicFrame frame, int meta) {
        float sizeY;
        AlignedBox cube = new AlignedBox(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
        float sizeX = frame.sizeX;
        if (sizeX == 0.0f) {
            sizeX = 1.0f;
        }
        if ((sizeY = frame.sizeY) == 0.0f) {
            sizeY = 1.0f;
        }
        double offsetX = 0.0;
        double offsetY = 0.0;
        switch (frame.rotation) {
            case 1: {
                sizeX = frame.sizeY;
                sizeY = -frame.sizeX;
                if (frame.posY == 0) {
                    offsetY += 1.0;
                    break;
                }
                if (frame.posY != 2) break;
                offsetY -= 1.0;
                break;
            }
            case 2: {
                sizeX = -frame.sizeX;
                sizeY = -frame.sizeY;
                if (frame.posX == 0) {
                    offsetX += 1.0;
                } else if (frame.posX == 2) {
                    offsetX -= 1.0;
                }
                if (frame.posY == 0) {
                    offsetY += 1.0;
                    break;
                }
                if (frame.posY != 2) break;
                offsetY -= 1.0;
                break;
            }
            case 3: {
                sizeX = -frame.sizeY;
                sizeY = frame.sizeX;
                if (frame.posX == 0) {
                    offsetX += 1.0;
                    break;
                }
                if (frame.posX != 2) break;
                offsetX -= 1.0;
            }
        }
        if (frame.posX == 1) {
            offsetX += (double)(-sizeX + 1.0f) / 2.0;
        } else if (frame.posX == 2) {
            offsetX += (double)(-sizeX + 1.0f);
        }
        if (frame.posY == 1) {
            offsetY += (double)(-sizeY + 1.0f) / 2.0;
        } else if (frame.posY == 2) {
            offsetY += (double)(-sizeY + 1.0f);
        }
        EnumFacing direction = EnumFacing.func_82600_a((int)meta);
        if (direction == EnumFacing.UP) {
            cube.minZ -= sizeX - 1.0f;
            cube.minY -= sizeY - 1.0f;
            cube.minZ = (float)((double)cube.minZ - offsetX);
            cube.maxZ = (float)((double)cube.maxZ - offsetX);
            cube.minY = (float)((double)cube.minY - offsetY);
            cube.maxY = (float)((double)cube.maxY - offsetY);
        } else {
            cube.maxZ += sizeX - 1.0f;
            cube.maxY += sizeY - 1.0f;
            cube.minZ = (float)((double)cube.minZ + offsetX);
            cube.maxZ = (float)((double)cube.maxZ + offsetX);
            cube.minY = (float)((double)cube.minY + offsetY);
            cube.maxY = (float)((double)cube.maxY + offsetY);
        }
        cube = new AlignedBox(Math.min(cube.minX, cube.maxX), Math.min(cube.minY, cube.maxY), Math.min(cube.minZ, cube.maxZ), Math.max(cube.minX, cube.maxX), Math.max(cube.minY, cube.maxY), Math.max(cube.minZ, cube.maxZ));
        return BlockPicFrame.rotateCube(cube, direction).getBB();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntityPicFrame.getBoundingBox(this, this.func_145832_p()).func_186670_a(this.field_174879_c);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74778_a("url", this.url);
        nbt.func_74776_a("sizeX", this.sizeX);
        nbt.func_74776_a("sizeY", this.sizeY);
        nbt.func_74768_a("render", this.renderDistance);
        nbt.func_74774_a("offsetX", this.posX);
        nbt.func_74774_a("offsetY", this.posY);
        nbt.func_74774_a("rotation", this.rotation);
        nbt.func_74757_a("visibleFrame", this.visibleFrame);
        nbt.func_74757_a("flippedX", this.flippedX);
        nbt.func_74757_a("flippedY", this.flippedY);
        nbt.func_74776_a("rotX", this.rotationX);
        nbt.func_74776_a("rotY", this.rotationY);
        nbt.func_74776_a("transparency", this.transparency);
        nbt.func_74776_a("brightness", this.brightness);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.url = nbt.func_74779_i("url");
        this.sizeX = nbt.func_74760_g("sizeX");
        this.sizeY = nbt.func_74760_g("sizeY");
        this.renderDistance = nbt.func_74762_e("render");
        this.posX = nbt.func_74771_c("offsetX");
        this.posY = nbt.func_74771_c("offsetY");
        this.rotation = nbt.func_74771_c("rotation");
        this.visibleFrame = nbt.func_74767_n("visibleFrame");
        this.flippedX = nbt.func_74767_n("flippedX");
        this.flippedY = nbt.func_74767_n("flippedY");
        this.rotationX = nbt.func_74760_g("rotX");
        this.rotationY = nbt.func_74760_g("rotY");
        this.transparency = nbt.func_74764_b("transparency") ? nbt.func_74760_g("transparency") : 1.0f;
        this.brightness = nbt.func_74764_b("brightness") ? nbt.func_74760_g("brightness") : 1.0f;
    }

    public void getDescriptionNBT(NBTTagCompound nbt) {
        super.getDescriptionNBT(nbt);
        nbt.func_74778_a("url", this.url);
        nbt.func_74776_a("sizeX", this.sizeX);
        nbt.func_74776_a("sizeY", this.sizeY);
        nbt.func_74768_a("render", this.renderDistance);
        nbt.func_74774_a("offsetX", this.posX);
        nbt.func_74774_a("offsetY", this.posY);
        nbt.func_74774_a("rotation", this.rotation);
        nbt.func_74757_a("visibleFrame", this.visibleFrame);
        nbt.func_74757_a("flippedX", this.flippedX);
        nbt.func_74757_a("flippedY", this.flippedY);
        nbt.func_74776_a("rotX", this.rotationX);
        nbt.func_74776_a("rotY", this.rotationY);
        nbt.func_74776_a("transparency", this.transparency);
        nbt.func_74776_a("brightness", this.brightness);
    }

    @SideOnly(value=Side.CLIENT)
    public void receiveUpdatePacket(NBTTagCompound nbt) {
        super.receiveUpdatePacket(nbt);
        this.url = nbt.func_74779_i("url");
        this.sizeX = nbt.func_74760_g("sizeX");
        this.sizeY = nbt.func_74760_g("sizeY");
        this.renderDistance = nbt.func_74762_e("render");
        this.posX = nbt.func_74771_c("offsetX");
        this.posY = nbt.func_74771_c("offsetY");
        this.rotation = nbt.func_74771_c("rotation");
        this.visibleFrame = nbt.func_74767_n("visibleFrame");
        this.flippedX = nbt.func_74767_n("flippedX");
        this.flippedY = nbt.func_74767_n("flippedY");
        this.rotationX = nbt.func_74760_g("rotX");
        this.rotationY = nbt.func_74760_g("rotY");
        this.transparency = nbt.func_74760_g("transparency");
        this.brightness = nbt.func_74760_g("brightness");
        this.initClient();
        this.updateRender();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.tickTexture();
        }
    }

    private void tickTexture() {
        if (this.texture != null) {
            this.texture.tick();
        }
    }
}

