/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.storm;

import CoroUtil.config.ConfigCoroUtil;
import CoroUtil.util.ChunkCoordinatesBlock;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilCompatibility;
import CoroUtil.util.CoroUtilEntOrParticle;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.Vec3;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviorFog;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weather2.ServerTickHandler;
import weather2.Weather;
import weather2.config.ConfigMisc;
import weather2.config.ConfigSnow;
import weather2.config.ConfigStorm;
import weather2.config.ConfigTornado;
import weather2.entity.EntityIceBall;
import weather2.entity.EntityLightningBolt;
import weather2.player.PlayerData;
import weather2.util.CachedNBTTagCompound;
import weather2.util.WeatherUtil;
import weather2.util.WeatherUtilBlock;
import weather2.util.WeatherUtilConfig;
import weather2.util.WeatherUtilEntity;
import weather2.weathersystem.WeatherManagerBase;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.TornadoHelper;
import weather2.weathersystem.storm.WeatherEntityConfig;
import weather2.weathersystem.storm.WeatherObject;
import weather2.weathersystem.storm.WeatherTypes;
import weather2.weathersystem.wind.WindManager;

public class StormObject
extends WeatherObject {
    public String userSpawnedFor = "";
    @SideOnly(value=Side.CLIENT)
    public HashMap<Integer, EntityRotFX> lookupParticlesCloud;
    @SideOnly(value=Side.CLIENT)
    public HashMap<Integer, EntityRotFX> lookupParticlesCloudLower;
    @SideOnly(value=Side.CLIENT)
    public HashMap<Integer, EntityRotFX> lookupParticlesFunnel;
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesCloud;
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesGround;
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesFunnel;
    @SideOnly(value=Side.CLIENT)
    public ParticleBehaviorFog particleBehaviorFog;
    public int sizeMaxFunnelParticles = 600;
    public static int static_YPos_layer0 = ConfigMisc.Cloud_Layer0_Height;
    public static int static_YPos_layer1 = ConfigMisc.Cloud_Layer1_Height;
    public static int static_YPos_layer2 = ConfigMisc.Cloud_Layer2_Height;
    public static List<Integer> layers = new ArrayList<Integer>(Arrays.asList(static_YPos_layer0, static_YPos_layer1, static_YPos_layer2));
    public int layer = 0;
    public boolean angleIsOverridden = false;
    public float angleMovementTornadoOverride = 0.0f;
    public boolean isGrowing = true;
    public int levelWater = 0;
    public float levelWindMomentum = 0.0f;
    public float levelTemperature = 0.0f;
    public int levelWaterStartRaining = 100;
    public int levelStormIntensityMax = 0;
    public int levelCurIntensityStage = 0;
    public float levelCurStagesIntensity = 0.0f;
    public boolean hasStormPeaked = false;
    public int maxIntensityStage = STATE_STAGE5;
    public int stormType = TYPE_LAND;
    public static int TYPE_LAND = 0;
    public static int TYPE_WATER = 1;
    public static int STATE_NORMAL = 0;
    public static int STATE_THUNDER = 1;
    public static int STATE_HIGHWIND = 2;
    public static int STATE_HAIL = 3;
    public static int STATE_FORMING = 4;
    public static int STATE_STAGE1 = 5;
    public static int STATE_STAGE2 = 6;
    public static int STATE_STAGE3 = 7;
    public static int STATE_STAGE4 = 8;
    public static int STATE_STAGE5 = 9;
    public static float levelStormIntensityFormingStartVal = STATE_FORMING;
    public double spinSpeed = 0.02;
    public boolean attrib_precipitation = false;
    public boolean attrib_waterSpout = false;
    public float scale = 1.0f;
    public float strength = 100.0f;
    public int maxHeight = 60;
    public int currentTopYBlock = -1;
    public TornadoHelper tornadoHelper = new TornadoHelper(this);
    public int updateLCG = new Random().nextInt();
    public float formingStrength = 0.0f;
    public Vec3 posBaseFormationPos;
    public boolean naturallySpawned;
    public boolean weatherMachineControlled;
    public boolean canSnowFromCloudTemperature;
    public boolean alwaysProgresses;
    public long ticksSinceLastPacketReceived;
    public boolean canBeDeadly;
    public boolean cloudlessStorm;
    public float cachedAngleAvoidance;
    public boolean isFirenado;
    public List<EntityLivingBase> listEntitiesUnderClouds;

    public StormObject(WeatherManagerBase parManager) {
        super(parManager);
        this.posBaseFormationPos = new Vec3(this.pos.xCoord, this.pos.yCoord, this.pos.zCoord);
        this.naturallySpawned = true;
        this.weatherMachineControlled = false;
        this.canSnowFromCloudTemperature = false;
        this.alwaysProgresses = false;
        this.ticksSinceLastPacketReceived = 0L;
        this.canBeDeadly = true;
        this.cloudlessStorm = false;
        this.cachedAngleAvoidance = 0.0f;
        this.isFirenado = false;
        this.listEntitiesUnderClouds = new ArrayList<EntityLivingBase>();
        this.pos = new Vec3(0.0, (double)static_YPos_layer0, 0.0);
        this.maxSize = ConfigStorm.Storm_MaxRadius;
        if (parManager.getWorld().field_72995_K) {
            this.listParticlesCloud = new ArrayList<EntityRotFX>();
            this.listParticlesFunnel = new ArrayList<EntityRotFX>();
            this.listParticlesGround = new ArrayList<EntityRotFX>();
            this.lookupParticlesCloud = new HashMap();
            this.lookupParticlesCloudLower = new HashMap();
            this.lookupParticlesFunnel = new HashMap();
        }
    }

    @Override
    public void initFirstTime() {
        super.initFirstTime();
        Biome bgb = this.manager.getWorld().func_180494_b(new BlockPos(MathHelper.func_76128_c((double)this.pos.xCoord), 0, MathHelper.func_76128_c((double)this.pos.zCoord)));
        float temp = 1.0f;
        if (bgb != null) {
            temp = CoroUtilCompatibility.getAdjustedTemperature((World)this.manager.getWorld(), (Biome)bgb, (BlockPos)new BlockPos(MathHelper.func_76128_c((double)this.pos.xCoord), MathHelper.func_76128_c((double)this.pos.yCoord), MathHelper.func_76128_c((double)this.pos.zCoord)));
        }
        if (this.naturallySpawned) {
            this.levelTemperature = this.getTemperatureMCToWeatherSys(temp);
        }
        this.levelWindMomentum = 0.0f;
    }

    public boolean isCloudlessStorm() {
        return this.cloudlessStorm;
    }

    public void setCloudlessStorm(boolean cloudlessStorm) {
        this.cloudlessStorm = cloudlessStorm;
    }

    public boolean isPrecipitating() {
        return this.attrib_precipitation;
    }

    public void setPrecipitating(boolean parVal) {
        this.attrib_precipitation = parVal;
    }

    public boolean isRealStorm() {
        return this.levelCurIntensityStage > STATE_NORMAL;
    }

    public boolean isTornadoFormingOrGreater() {
        return this.stormType == TYPE_LAND && this.levelCurIntensityStage >= STATE_FORMING;
    }

    public boolean isCycloneFormingOrGreater() {
        return this.stormType == TYPE_WATER && this.levelCurIntensityStage >= STATE_FORMING;
    }

    public boolean isSpinning() {
        return this.levelCurIntensityStage >= STATE_HIGHWIND;
    }

    public boolean isTropicalCyclone() {
        return this.levelCurIntensityStage >= STATE_STAGE1;
    }

    public boolean isHurricane() {
        return this.levelCurIntensityStage >= STATE_STAGE5;
    }

    @Override
    public void readFromNBT() {
        super.readFromNBT();
        this.nbtSyncFromServer();
        CachedNBTTagCompound var1 = this.getNbtCache();
        this.angleIsOverridden = var1.getBoolean("angleIsOverridden");
        this.angleMovementTornadoOverride = var1.getFloat("angleMovementTornadoOverride");
        this.userSpawnedFor = var1.getString("userSpawnedFor");
    }

    @Override
    public void writeToNBT() {
        super.writeToNBT();
        this.nbtSyncForClient();
        CachedNBTTagCompound nbt = this.getNbtCache();
        nbt.setBoolean("angleIsOverridden", this.angleIsOverridden);
        nbt.setFloat("angleMovementTornadoOverride", this.angleMovementTornadoOverride);
        nbt.setString("userSpawnedFor", this.userSpawnedFor);
    }

    @Override
    public void nbtSyncFromServer() {
        CachedNBTTagCompound parNBT = this.getNbtCache();
        boolean testNetworkData = false;
        if (testNetworkData) {
            System.out.println("Received payload from server; length=" + parNBT.getNewNBT().func_150296_c().size());
            Iterator iterator = parNBT.getNewNBT().func_150296_c().iterator();
            String keys = "";
            while (iterator.hasNext()) {
                keys = keys.concat((String)iterator.next() + "; ");
            }
            System.out.println("Received    " + keys);
        }
        super.nbtSyncFromServer();
        this.attrib_precipitation = parNBT.getBoolean("attrib_rain");
        this.attrib_waterSpout = parNBT.getBoolean("attrib_waterSpout");
        this.currentTopYBlock = parNBT.getInteger("currentTopYBlock");
        this.levelTemperature = parNBT.getFloat("levelTemperature");
        this.levelWater = parNBT.getInteger("levelWater");
        this.layer = parNBT.getInteger("layer");
        this.levelCurIntensityStage = parNBT.getInteger("levelCurIntensityStage");
        this.levelStormIntensityMax = parNBT.getInteger("levelStormIntensityMax");
        this.levelCurStagesIntensity = parNBT.getFloat("levelCurStagesIntensity");
        this.stormType = parNBT.getInteger("stormType");
        this.hasStormPeaked = parNBT.getBoolean("hasStormPeaked");
        this.isDead = parNBT.getBoolean("isDead");
        this.cloudlessStorm = parNBT.getBoolean("cloudlessStorm");
        this.isFirenado = parNBT.getBoolean("isFirenado");
        this.ticksSinceLastPacketReceived = 0L;
        this.weatherMachineControlled = parNBT.getBoolean("weatherMachineControlled");
    }

    @Override
    public void nbtSyncForClient() {
        super.nbtSyncForClient();
        CachedNBTTagCompound data = this.getNbtCache();
        data.setBoolean("attrib_rain", this.attrib_precipitation);
        data.setBoolean("attrib_waterSpout", this.attrib_waterSpout);
        data.setInteger("currentTopYBlock", this.currentTopYBlock);
        data.setFloat("levelTemperature", this.levelTemperature);
        data.setInteger("levelWater", this.levelWater);
        data.setInteger("layer", this.layer);
        data.setInteger("levelCurIntensityStage", this.levelCurIntensityStage);
        data.setFloat("levelCurStagesIntensity", this.levelCurStagesIntensity);
        data.setFloat("levelStormIntensityMax", this.levelStormIntensityMax);
        data.setInteger("stormType", this.stormType);
        data.setBoolean("hasStormPeaked", this.hasStormPeaked);
        data.setBoolean("isDead", this.isDead);
        data.setBoolean("cloudlessStorm", this.cloudlessStorm);
        data.setBoolean("isFirenado", this.isFirenado);
        data.setBoolean("weatherMachineControlled", this.weatherMachineControlled);
    }

    public NBTTagCompound nbtForIMC() {
        this.nbtSyncForClient();
        return this.getNbtCache().getNewNBT();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void tickRender(float partialTick) {
        super.tickRender(partialTick);
        if (!WeatherUtil.isPaused()) {
            Vec3 tryPos;
            int i;
            EntityRotFX ent;
            Map.Entry<Integer, EntityRotFX> entry;
            int count = 9;
            Iterator<Map.Entry<Integer, EntityRotFX>> it = this.lookupParticlesCloud.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                ent = entry.getValue();
                if (!ent.func_187113_k()) {
                    it.remove();
                    continue;
                }
                i = entry.getKey();
                tryPos = null;
                double spawnRad = 120.0;
                double speed = 2.0 / spawnRad;
                if (this.isSpinning()) {
                    speed = 50.0 / spawnRad;
                }
                ent.rotationSpeedAroundCenter = (float)speed;
                if (i == 0) {
                    tryPos = new Vec3(this.pos.xCoord, (double)layers.get(this.layer).intValue(), this.pos.zCoord);
                    ent.rotationYaw = ent.rotationAroundCenter;
                } else {
                    double rad = Math.toRadians(ent.rotationAroundCenter - ent.rotationSpeedAroundCenter + ent.rotationSpeedAroundCenter * partialTick);
                    double x = -Math.sin(rad) * spawnRad;
                    double z = Math.cos(rad) * spawnRad;
                    tryPos = new Vec3(this.pos.xCoord + x, (double)layers.get(this.layer).intValue(), this.pos.zCoord + z);
                    double var16 = this.pos.xCoord - ent.getPosX();
                    double var18 = this.pos.zCoord - ent.getPosZ();
                    ent.rotationYaw = (float)(Math.atan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
                }
                ent.func_187109_b(tryPos.xCoord, tryPos.yCoord, tryPos.zCoord);
            }
            count = 32;
            it = this.lookupParticlesCloudLower.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                ent = entry.getValue();
                if (!ent.func_187113_k()) {
                    it.remove();
                    continue;
                }
                i = entry.getKey();
                tryPos = null;
                ent.setScale(800.0f);
                double countPerLayer = 16.0;
                double rotPos = i % 16;
                int layerRot = i / 16;
                double spawnRad = 80.0;
                if (layerRot == 1) {
                    spawnRad = 60.0;
                    ent.setScale(600.0f);
                }
                double speed = 50.0 / (spawnRad * 2.0);
                ent.rotationSpeedAroundCenter = (float)speed;
                double rad = Math.toRadians(ent.rotationAroundCenter - ent.rotationSpeedAroundCenter + ent.rotationSpeedAroundCenter * partialTick);
                double x = -Math.sin(rad) * spawnRad;
                double z = Math.cos(rad) * spawnRad;
                tryPos = new Vec3(this.pos.xCoord + x, (double)(layers.get(this.layer) - 20), this.pos.zCoord + z);
                ent.func_187109_b(tryPos.xCoord, tryPos.yCoord, tryPos.zCoord);
                double var16 = this.pos.xCoord - ent.getPosX();
                double var18 = this.pos.zCoord - ent.getPosZ();
                ent.rotationYaw = (float)(Math.atan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
                ent.rotationPitch = -20.0f;
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.posGround = new Vec3(this.pos.xCoord, this.pos.yCoord, this.pos.zCoord);
        this.posGround.yCoord = this.currentTopYBlock;
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT) {
            if (!WeatherUtil.isPaused()) {
                ++this.ticksSinceLastPacketReceived;
                this.tickClient();
                if (this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater()) {
                    this.tornadoHelper.tick(this.manager.getWorld());
                }
                if (this.levelCurIntensityStage >= STATE_HIGHWIND && this.manager.getWorld().field_72995_K) {
                    this.tornadoHelper.soundUpdates(true, this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater());
                }
                this.tickMovementClient();
            }
        } else {
            if (this.isCloudlessStorm() && ConfigMisc.overcastMode && this.manager.getWorld().func_72896_J()) {
                this.setCloudlessStorm(false);
            }
            if (this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater()) {
                this.tornadoHelper.tick(this.manager.getWorld());
            }
            if (this.levelCurIntensityStage >= STATE_HIGHWIND && this.manager.getWorld().field_72995_K) {
                this.tornadoHelper.soundUpdates(true, this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater());
            }
            this.tickMovement();
            if (this.layer == 0) {
                if (!this.isCloudlessStorm()) {
                    this.tickWeatherEvents();
                    this.tickProgression();
                    this.tickSnowFall();
                }
            } else {
                this.size = this.maxSize;
            }
        }
        if (this.layer == 0) {
            this.posBaseFormationPos = new Vec3(this.pos.xCoord, this.pos.yCoord, this.pos.zCoord);
            if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal) {
                if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal + 1.0f) {
                    this.formingStrength = 1.0f;
                    this.posBaseFormationPos.yCoord = this.posGround.yCoord;
                } else {
                    float val;
                    float intensityAdj = Math.min(1.0f, this.levelCurStagesIntensity * 2.0f);
                    this.formingStrength = val = (float)this.levelCurIntensityStage + intensityAdj - levelStormIntensityFormingStartVal;
                    double yDiff = this.pos.yCoord - this.posGround.yCoord;
                    this.posBaseFormationPos.yCoord = this.pos.yCoord - yDiff * (double)this.formingStrength;
                }
            } else if (this.levelCurIntensityStage == STATE_HIGHWIND) {
                this.formingStrength = 1.0f;
                this.posBaseFormationPos.yCoord = this.posGround.yCoord;
            } else {
                this.formingStrength = 0.0f;
                this.posBaseFormationPos.yCoord = this.pos.yCoord;
            }
        }
    }

    public void tickMovement() {
        float angle = this.getAdjustedAngle();
        if (this.angleIsOverridden) {
            angle = this.angleMovementTornadoOverride;
        }
        Random rand = new Random();
        double scanDist = 50.0;
        double scanX = this.pos.xCoord + -Math.sin(Math.toRadians(angle += (rand.nextFloat() - rand.nextFloat()) * 0.15f)) * scanDist;
        double scanZ = this.pos.zCoord + Math.cos(Math.toRadians(angle)) * scanDist;
        int height = WeatherUtilBlock.getPrecipitationHeightSafe(this.manager.getWorld(), new BlockPos(scanX, 0.0, scanZ)).func_177956_o();
        if (this.pos.yCoord < (double)height) {
            float angleAdj = 45.0f;
            if (this.ID % 2L == 0L) {
                angleAdj = -45.0f;
            }
            angle += angleAdj;
        }
        double vecX = -Math.sin(Math.toRadians(angle));
        double vecZ = Math.cos(Math.toRadians(angle));
        float cloudSpeedAmp = 0.2f;
        float finalSpeed = this.getAdjustedSpeed() * cloudSpeedAmp;
        if (this.levelCurIntensityStage >= STATE_FORMING) {
            finalSpeed = 0.2f;
        } else if (this.levelCurIntensityStage >= STATE_THUNDER) {
            finalSpeed = 0.05f;
        }
        if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal) {
            finalSpeed /= (float)this.levelCurIntensityStage - levelStormIntensityFormingStartVal + 1.0f;
        }
        if (finalSpeed < 0.03f) {
            finalSpeed = 0.03f;
        }
        if (finalSpeed > 0.3f) {
            finalSpeed = 0.3f;
        }
        if (this.manager.getWorld().func_82737_E() % 100L != 0L || this.levelCurIntensityStage >= STATE_FORMING) {
            // empty if block
        }
        if (!this.weatherMachineControlled) {
            this.motion.xCoord = vecX * (double)finalSpeed;
            this.motion.zCoord = vecZ * (double)finalSpeed;
            double max = 0.2;
            this.pos.xCoord += this.motion.xCoord;
            this.pos.zCoord += this.motion.zCoord;
        }
    }

    public void tickMovementClient() {
        if (!this.weatherMachineControlled) {
            this.pos.xCoord += this.motion.xCoord;
            this.pos.zCoord += this.motion.zCoord;
        }
    }

    public void tickWeatherEvents() {
        int z;
        int x;
        Random rand = new Random();
        World world = this.manager.getWorld();
        this.currentTopYBlock = WeatherUtilBlock.getPrecipitationHeightSafe(world, new BlockPos(MathHelper.func_76128_c((double)this.pos.xCoord), 0, MathHelper.func_76128_c((double)this.pos.zCoord))).func_177956_o();
        if (this.levelCurIntensityStage >= STATE_THUNDER && rand.nextInt(Math.max(1, ConfigStorm.Storm_LightningStrikeBaseValueOddsTo1 - this.levelCurIntensityStage * 10)) == 0 && world.func_175667_e(new BlockPos(x = (int)(this.pos.xCoord + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size)), 0, z = (int)(this.pos.zCoord + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size))))) {
            int y = world.func_175725_q(new BlockPos(x, 0, z)).func_177956_o();
            this.addWeatherEffectLightning(new EntityLightningBolt(world, x, y, z), false);
        }
        if (this.isPrecipitating() && this.levelCurIntensityStage == STATE_HAIL && this.stormType == TYPE_LAND) {
            for (int i = 0; i < Math.max(1, ConfigStorm.Storm_HailPerTick * (this.size / this.maxSize)); ++i) {
                int z2;
                int x2 = (int)(this.pos.xCoord + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size));
                if (!world.func_175667_e(new BlockPos(x2, static_YPos_layer0, z2 = (int)(this.pos.zCoord + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size)))) || world.func_184137_a((double)x2, 50.0, (double)z2, 80.0, false) == null) continue;
                EntityIceBall hail = new EntityIceBall(world);
                hail.func_70107_b(x2, layers.get(this.layer).intValue(), z2);
                world.func_72838_d((Entity)hail);
            }
        }
        this.trackAndExtinguishEntities();
    }

    public void trackAndExtinguishEntities() {
        if (ConfigStorm.Storm_Rain_TrackAndExtinguishEntitiesRate <= 0) {
            return;
        }
        if (this.isPrecipitating()) {
            if ((this.manager.getWorld().func_82737_E() + this.ID * 20L) % (long)ConfigStorm.Storm_Rain_TrackAndExtinguishEntitiesRate == 0L) {
                this.listEntitiesUnderClouds.clear();
                BlockPos posBP = new BlockPos(this.posGround.xCoord, this.posGround.yCoord, this.posGround.zCoord);
                List listEnts = this.manager.getWorld().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(posBP).func_186662_g((double)this.size));
                for (EntityLivingBase ent : listEnts) {
                    if (!ent.field_70170_p.func_175710_j(ent.func_180425_c())) continue;
                    this.listEntitiesUnderClouds.add(ent);
                }
            }
            for (EntityLivingBase ent : this.listEntitiesUnderClouds) {
                ent.func_70066_B();
            }
        }
    }

    public void tickSnowFall() {
        if (!ConfigSnow.Snow_PerformSnowfall) {
            return;
        }
        if (!this.isPrecipitating()) {
            return;
        }
        World world = this.manager.getWorld();
        long startTime = System.nanoTime();
        int xx = 0;
        int zz = 0;
        xx = (int)(this.pos.xCoord - (double)(this.size / 2));
        while ((double)xx < this.pos.xCoord + (double)(this.size / 2)) {
            zz = (int)(this.pos.zCoord - (double)(this.size / 2));
            while ((double)zz < this.pos.zCoord + (double)(this.size / 2)) {
                Chunk chunk;
                int chunkX = xx / 16;
                int x = chunkX * 16;
                int chunkZ = zz / 16;
                int z = chunkZ * 16;
                if (world.func_175667_e(new BlockPos(x, 128, z)) && world.field_73011_w.canDoRainSnowIce(chunk = world.func_72964_e(chunkX, chunkZ)) && (ConfigSnow.Snow_RarityOfBuildup == 0 || world.field_73012_v.nextInt(ConfigSnow.Snow_RarityOfBuildup) == 0)) {
                    this.updateLCG = this.updateLCG * 3 + 1013904223;
                    int i1 = this.updateLCG >> 2;
                    int xxx = i1 & 0xF;
                    double d0 = this.pos.xCoord - (double)(xx + xxx);
                    int zzz = i1 >> 8 & 0xF;
                    double d2 = this.pos.zCoord - (double)(zz + zzz);
                    if (!((double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) > (double)this.size)) {
                        boolean betterBuildup;
                        int snowMetaMax = 7;
                        int setBlockHeight = world.func_175725_q(new BlockPos(xxx + x, 0, zzz + z)).func_177956_o();
                        if (this.canSnowAtBody(xxx + x, setBlockHeight, zzz + z) && Blocks.field_150433_aE.func_176196_c(world, new BlockPos(xxx + x, setBlockHeight, zzz + z)) && (betterBuildup = true)) {
                            WindManager windMan = this.manager.getWindManager();
                            float angle = windMan.getWindAngleForClouds();
                            Vec3 vecPos = new Vec3((double)(xxx + x), (double)setBlockHeight, (double)(zzz + z));
                            if (world.func_175667_e(vecPos.toBlockPos())) {
                                if (!ConfigMisc.overcastMode && world.func_175623_d(vecPos.toBlockPos())) {
                                    world.func_175656_a(vecPos.toBlockPos(), Blocks.field_150431_aC.func_176223_P());
                                }
                                WeatherUtilBlock.fillAgainstWallSmoothly(world, vecPos, angle, 15.0f, 2.0f, Blocks.field_150431_aC);
                            }
                        }
                    }
                }
                zz += 16;
            }
            xx += 16;
        }
    }

    public ChunkCoordinatesBlock getSnowfallEvenOutAdjustCheck(int x, int y, int z, int sourceMeta) {
        ChunkCoordinatesBlock attempt = this.getSnowfallEvenOutAdjust(x - 1, y, z, sourceMeta);
        if (attempt.posX != 0 || attempt.posZ != 0) {
            return attempt;
        }
        attempt = this.getSnowfallEvenOutAdjust(x + 1, y, z, sourceMeta);
        if (attempt.posX != 0 || attempt.posZ != 0) {
            return attempt;
        }
        attempt = this.getSnowfallEvenOutAdjust(x, y, z - 1, sourceMeta);
        if (attempt.posX != 0 || attempt.posZ != 0) {
            return attempt;
        }
        attempt = this.getSnowfallEvenOutAdjust(x, y, z + 1, sourceMeta);
        if (attempt.posX != 0 || attempt.posZ != 0) {
            return attempt;
        }
        return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
    }

    public ChunkCoordinatesBlock getSnowfallEvenOutAdjust(int x, int y, int z, int sourceMeta) {
        boolean metaToSet = false;
        World world = this.manager.getWorld();
        Block checkID = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (CoroUtilBlock.isAir((Block)checkID)) {
            Block checkID2 = world.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
            if (CoroUtilBlock.isAir((Block)checkID2)) {
                return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
            }
            return new ChunkCoordinatesBlock(x, y, z, Blocks.field_150350_a, 0);
        }
        if (checkID == Blocks.field_150433_aE) {
            IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
            int checkMeta = state.func_177230_c().func_176201_c(state);
            if (checkMeta < sourceMeta) {
                return new ChunkCoordinatesBlock(x, y, z, checkID, checkMeta);
            }
        } else {
            return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
        }
        return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
    }

    public boolean canSnowAtBody(int par1, int par2, int par3) {
        IBlockState iblockstate1;
        World world = this.manager.getWorld();
        Biome biomegenbase = world.func_180494_b(new BlockPos(par1, 0, par3));
        BlockPos pos = new BlockPos(par1, par2, par3);
        if (biomegenbase == null) {
            return false;
        }
        float temperature = CoroUtilCompatibility.getAdjustedTemperature((World)world, (Biome)biomegenbase, (BlockPos)pos);
        if (this.canSnowFromCloudTemperature && this.levelTemperature > 0.0f || !this.canSnowFromCloudTemperature && temperature > 0.15f) {
            return false;
        }
        return par2 >= 0 && par2 < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10 && ((iblockstate1 = world.func_180495_p(pos)).func_177230_c().isAir(iblockstate1, (IBlockAccess)world, pos) || iblockstate1.func_177230_c() == Blocks.field_150431_aC) && Blocks.field_150431_aC.func_176196_c(world, pos);
    }

    public void tickProgression() {
        World world = this.manager.getWorld();
        if (world.func_82737_E() % 3L == 0L && this.isGrowing && this.size < this.maxSize) {
            ++this.size;
        }
        float tempAdjustRate = (float)ConfigStorm.Storm_TemperatureAdjustRate;
        int levelWaterBuildRate = ConfigStorm.Storm_Rain_WaterBuildUpRate;
        int levelWaterSpendRate = ConfigStorm.Storm_Rain_WaterSpendRate;
        int randomChanceOfWaterBuildFromWater = ConfigStorm.Storm_Rain_WaterBuildUpOddsTo1FromSource;
        int randomChanceOfWaterBuildFromNothing = ConfigStorm.Storm_Rain_WaterBuildUpOddsTo1FromNothing;
        int randomChanceOfWaterBuildFromOvercastRaining = ConfigStorm.Storm_Rain_WaterBuildUpOddsTo1FromOvercastRaining;
        randomChanceOfWaterBuildFromOvercastRaining = 10;
        boolean isInOcean = false;
        boolean isOverWater = false;
        if (world.func_82737_E() % (long)ConfigStorm.Storm_AllTypes_TickRateDelay == 0L) {
            Block blockID;
            NBTTagCompound playerNBT = PlayerData.getPlayerNBT(this.userSpawnedFor);
            long lastStormDeadlyTime = playerNBT.func_74763_f("lastStormDeadlyTime");
            Biome bgb = world.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)this.pos.xCoord), 0, MathHelper.func_76128_c((double)this.pos.zCoord)));
            if (bgb != null) {
                isInOcean = bgb.field_76791_y.contains("Ocean") || bgb.field_76791_y.contains("ocean");
                float biomeTempAdj = this.getTemperatureMCToWeatherSys(CoroUtilCompatibility.getAdjustedTemperature((World)this.manager.getWorld(), (Biome)bgb, (BlockPos)new BlockPos(MathHelper.func_76128_c((double)this.pos.xCoord), MathHelper.func_76128_c((double)this.pos.yCoord), MathHelper.func_76128_c((double)this.pos.zCoord))));
                this.levelTemperature = this.levelTemperature > biomeTempAdj ? (this.levelTemperature -= tempAdjustRate) : (this.levelTemperature += tempAdjustRate);
            }
            boolean performBuildup = false;
            Random rand = new Random();
            if (!this.isPrecipitating() && rand.nextInt(randomChanceOfWaterBuildFromNothing) == 0) {
                performBuildup = true;
            }
            if (!this.isPrecipitating() && ConfigMisc.overcastMode && this.manager.getWorld().func_72896_J() && rand.nextInt(randomChanceOfWaterBuildFromOvercastRaining) == 0) {
                performBuildup = true;
            }
            if (!CoroUtilBlock.isAir((Block)(blockID = world.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.pos.xCoord), this.currentTopYBlock - 1, MathHelper.func_76128_c((double)this.pos.zCoord))).func_177230_c())) && blockID.func_149688_o(blockID.func_176223_P()) instanceof MaterialLiquid) {
                isOverWater = true;
            }
            if (!performBuildup && !this.isPrecipitating() && rand.nextInt(randomChanceOfWaterBuildFromWater) == 0) {
                if (isOverWater) {
                    performBuildup = true;
                }
                if (!performBuildup && bgb != null && (isInOcean || bgb.field_76791_y.contains("Swamp") || bgb.field_76791_y.contains("Jungle") || bgb.field_76791_y.contains("River"))) {
                    performBuildup = true;
                }
            }
            if (performBuildup) {
                this.levelWater += levelWaterBuildRate;
                Weather.dbg("building rain: " + this.levelWater);
            }
            if (this.isPrecipitating()) {
                this.levelWater -= levelWaterSpendRate;
                if (this.levelWater < 0) {
                    this.levelWater = 0;
                }
                if (this.levelWater <= 0) {
                    this.setPrecipitating(false);
                    Weather.dbg("ending raining for: " + this.ID);
                }
            } else if (this.levelWater >= this.levelWaterStartRaining) {
                if (ConfigMisc.overcastMode) {
                    if (this.manager.getWorld().func_72896_J() && ConfigStorm.Storm_Rain_Overcast_OddsTo1 != -1 && rand.nextInt(ConfigStorm.Storm_Rain_Overcast_OddsTo1) == 0) {
                        this.setPrecipitating(true);
                        Weather.dbg("starting raining for: " + this.ID);
                    }
                } else if (ConfigStorm.Storm_Rain_OddsTo1 != -1 && rand.nextInt(ConfigStorm.Storm_Rain_OddsTo1) == 0) {
                    this.setPrecipitating(true);
                    Weather.dbg("starting raining for: " + this.ID);
                }
            }
            WeatherManagerServer wm = ServerTickHandler.lookupDimToWeatherMan.get(world.field_73011_w.getDimension());
            boolean tryFormStorm = false;
            if (this.canBeDeadly && this.levelCurIntensityStage == STATE_NORMAL) {
                if (ConfigStorm.Server_Storm_Deadly_UseGlobalRate) {
                    if (ConfigStorm.Server_Storm_Deadly_TimeBetweenInTicks != -1 && (wm.lastStormFormed == 0L || wm.lastStormFormed + (long)ConfigStorm.Server_Storm_Deadly_TimeBetweenInTicks < world.func_82737_E())) {
                        tryFormStorm = true;
                    }
                } else if (ConfigStorm.Player_Storm_Deadly_TimeBetweenInTicks != -1 && (lastStormDeadlyTime == 0L || lastStormDeadlyTime + (long)ConfigStorm.Player_Storm_Deadly_TimeBetweenInTicks < world.func_82737_E())) {
                    tryFormStorm = true;
                }
            }
            if (this.weatherMachineControlled) {
                return;
            }
            if ((ConfigMisc.overcastMode && this.manager.getWorld().func_72896_J() || !ConfigMisc.overcastMode) && WeatherUtilConfig.listDimensionsStorms.contains(this.manager.getWorld().field_73011_w.getDimension()) && tryFormStorm) {
                int stormFrontCollideDist = ConfigStorm.Storm_Deadly_CollideDistance;
                int randomChanceOfCollide = ConfigStorm.Player_Storm_Deadly_OddsTo1;
                if (ConfigStorm.Server_Storm_Deadly_UseGlobalRate) {
                    randomChanceOfCollide = ConfigStorm.Server_Storm_Deadly_OddsTo1;
                }
                if (isInOcean && ConfigStorm.Storm_OddsTo1OfOceanBasedStorm > 0 && rand.nextInt(ConfigStorm.Storm_OddsTo1OfOceanBasedStorm) == 0) {
                    EntityPlayer entP = world.func_72924_a(this.userSpawnedFor);
                    if (entP != null) {
                        this.initRealStorm(entP, null);
                    } else {
                        this.initRealStorm(null, null);
                    }
                    if (ConfigStorm.Server_Storm_Deadly_UseGlobalRate) {
                        wm.lastStormFormed = world.func_82737_E();
                    } else {
                        playerNBT.func_74772_a("lastStormDeadlyTime", world.func_82737_E());
                    }
                } else if (!isInOcean && ConfigStorm.Storm_OddsTo1OfLandBasedStorm > 0 && rand.nextInt(ConfigStorm.Storm_OddsTo1OfLandBasedStorm) == 0) {
                    EntityPlayer entP = world.func_72924_a(this.userSpawnedFor);
                    if (entP != null) {
                        this.initRealStorm(entP, null);
                    } else {
                        this.initRealStorm(null, null);
                    }
                    if (ConfigStorm.Server_Storm_Deadly_UseGlobalRate) {
                        wm.lastStormFormed = world.func_82737_E();
                    } else {
                        playerNBT.func_74772_a("lastStormDeadlyTime", world.func_82737_E());
                    }
                } else if (rand.nextInt(randomChanceOfCollide) == 0) {
                    for (int i = 0; i < this.manager.getStormObjects().size(); ++i) {
                        WeatherObject wo = this.manager.getStormObjects().get(i);
                        if (!(wo instanceof StormObject)) continue;
                        StormObject so = (StormObject)wo;
                        boolean startStorm = false;
                        if (so.ID != this.ID && so.levelCurIntensityStage <= 0 && !so.isCloudlessStorm() && !so.weatherMachineControlled && so.pos.distanceTo(this.pos) < (double)stormFrontCollideDist) {
                            if (this.levelTemperature < 0.0f) {
                                if (so.levelTemperature > 0.0f) {
                                    startStorm = true;
                                }
                            } else if (this.levelTemperature > 0.0f && so.levelTemperature < 0.0f) {
                                startStorm = true;
                            }
                        }
                        if (!startStorm) continue;
                        playerNBT.func_74772_a("lastStormDeadlyTime", world.func_82737_E());
                        EntityPlayer entP = world.func_72924_a(this.userSpawnedFor);
                        if (entP != null) {
                            this.initRealStorm(entP, so);
                            break;
                        }
                        this.initRealStorm(null, so);
                        break;
                    }
                }
            }
            if (this.isRealStorm()) {
                if (ConfigMisc.overcastMode && !this.manager.getWorld().func_72896_J()) {
                    this.hasStormPeaked = true;
                }
                if (!this.hasStormPeaked) {
                    this.levelWater = this.levelWaterStartRaining;
                    this.setPrecipitating(true);
                }
                if ((this.levelCurIntensityStage == STATE_HIGHWIND || this.levelCurIntensityStage == STATE_HAIL) && isOverWater) {
                    if (ConfigStorm.Storm_OddsTo1OfHighWindWaterSpout != 0 && rand.nextInt(ConfigStorm.Storm_OddsTo1OfHighWindWaterSpout) == 0) {
                        this.attrib_waterSpout = true;
                    }
                } else {
                    this.attrib_waterSpout = false;
                }
                float levelStormIntensityRate = 0.02f;
                float minIntensityToProgress = 0.6f;
                if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal) {
                    levelStormIntensityRate *= 3.0f;
                }
                if (!this.hasStormPeaked) {
                    this.levelCurStagesIntensity += levelStormIntensityRate;
                    if (!(this.levelCurIntensityStage >= this.maxIntensityStage || ConfigTornado.Storm_NoTornadosOrCyclones && this.levelCurIntensityStage >= STATE_FORMING - 1 || !(this.levelCurStagesIntensity >= minIntensityToProgress) || !this.alwaysProgresses && this.levelCurIntensityStage >= this.levelStormIntensityMax)) {
                        this.stageNext();
                        Weather.dbg("storm ID: " + this.ID + " - growing, stage: " + this.levelCurIntensityStage);
                        if (isInOcean && this.levelCurIntensityStage == STATE_FORMING) {
                            Weather.dbg("storm ID: " + this.ID + " marked as tropical cyclone!");
                            this.stormType = TYPE_WATER;
                            this.levelStormIntensityMax = this.rollDiceOnMaxIntensity();
                            Weather.dbg("rerolled odds for ocean storm, max stage will be: " + this.levelStormIntensityMax);
                        }
                    }
                    Weather.dbg("storm ID: " + this.ID + " - growing, stage " + this.levelCurIntensityStage + " of max " + this.levelStormIntensityMax + ", at intensity: " + this.levelCurStagesIntensity);
                    if (this.levelCurStagesIntensity >= 1.0f) {
                        Weather.dbg("storm peaked at: " + this.levelCurIntensityStage);
                        this.hasStormPeaked = true;
                    }
                } else {
                    this.levelCurStagesIntensity = ConfigMisc.overcastMode && this.manager.getWorld().func_72896_J() ? (this.levelCurStagesIntensity -= levelStormIntensityRate * 0.9f) : (this.levelCurStagesIntensity -= levelStormIntensityRate * 0.3f);
                    if (this.levelCurStagesIntensity <= 0.0f) {
                        this.stagePrev();
                        Weather.dbg("storm ID: " + this.ID + " - dying, stage: " + this.levelCurIntensityStage);
                        if (this.levelCurIntensityStage <= 0) {
                            this.setNoStorm();
                        }
                    }
                }
            } else if (ConfigMisc.overcastMode && !this.manager.getWorld().func_72896_J() && this.attrib_precipitation) {
                this.setPrecipitating(false);
            }
        }
    }

    public WeatherEntityConfig getWeatherEntityConfigForStorm() {
        WeatherEntityConfig weatherConfig = WeatherTypes.weatherEntTypes.get(0);
        if (this.levelCurIntensityStage >= STATE_STAGE5) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(5);
        } else if (this.levelCurIntensityStage >= STATE_STAGE4) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(4);
        } else if (this.levelCurIntensityStage >= STATE_STAGE3) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(3);
        } else if (this.levelCurIntensityStage >= STATE_STAGE2) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(2);
        } else if (this.levelCurIntensityStage >= STATE_STAGE1) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(1);
        } else if (this.levelCurIntensityStage >= STATE_FORMING) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(0);
        }
        return weatherConfig;
    }

    public void stageNext() {
        ++this.levelCurIntensityStage;
        this.levelCurStagesIntensity = 0.0f;
        if (ConfigTornado.Storm_Tornado_aimAtPlayerOnSpawn && !this.hasStormPeaked && this.levelCurIntensityStage == STATE_FORMING) {
            this.aimStormAtClosestOrProvidedPlayer(null);
        }
    }

    public void stagePrev() {
        --this.levelCurIntensityStage;
        this.levelCurStagesIntensity = 1.0f;
    }

    public void initRealStorm(EntityPlayer entP, StormObject stormToAbsorb) {
        this.levelCurIntensityStage = STATE_THUNDER;
        float diff = 4.0f;
        if (stormToAbsorb != null) {
            diff = this.levelTemperature - stormToAbsorb.levelTemperature;
        }
        if (this.naturallySpawned) {
            this.levelWater = this.levelWaterStartRaining * 2;
        }
        this.levelStormIntensityMax = this.rollDiceOnMaxIntensity();
        Weather.dbg("rolled odds for storm, unless it becomes ocean storm, max stage will be: " + this.levelStormIntensityMax);
        this.attrib_precipitation = true;
        if (stormToAbsorb != null) {
            Weather.dbg("stormfront collision happened between ID " + this.ID + " and " + stormToAbsorb.ID);
            this.manager.removeStormObject(stormToAbsorb.ID);
            ((WeatherManagerServer)this.manager).syncStormRemove(stormToAbsorb);
        } else {
            Weather.dbg("ocean storm happened, ID " + this.ID);
        }
        if (ConfigTornado.Storm_Tornado_aimAtPlayerOnSpawn) {
            this.aimStormAtClosestOrProvidedPlayer(entP);
        }
    }

    public int rollDiceOnMaxIntensity() {
        Random rand = new Random();
        int randVal = rand.nextInt(100);
        if (this.stormType == TYPE_LAND) {
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_F5_Tornado) {
                return STATE_STAGE5;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_F4_Tornado) {
                return STATE_STAGE4;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_F3_Tornado) {
                return STATE_STAGE3;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_F2_Tornado) {
                return STATE_STAGE2;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_F1_Tornado) {
                return STATE_STAGE1;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_F0_Tornado) {
                return STATE_FORMING;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_Hail) {
                return STATE_HAIL;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_HighWind) {
                return STATE_HIGHWIND;
            }
        } else if (this.stormType == TYPE_WATER) {
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_C5_Cyclone) {
                return STATE_STAGE5;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_C4_Cyclone) {
                return STATE_STAGE4;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_C3_Cyclone) {
                return STATE_STAGE3;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_C2_Cyclone) {
                return STATE_STAGE2;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_C1_Cyclone) {
                return STATE_STAGE1;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_C0_Cyclone) {
                return STATE_FORMING;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_Hail) {
                return STATE_HAIL;
            }
            if (randVal <= ConfigStorm.Storm_PercentChanceOf_HighWind) {
                return STATE_HIGHWIND;
            }
        }
        return STATE_THUNDER;
    }

    public void aimStormAtClosestOrProvidedPlayer(EntityPlayer entP) {
        if (entP == null) {
            entP = this.manager.getWorld().func_184137_a(this.pos.xCoord, this.pos.yCoord, this.pos.zCoord, -1.0, false);
        }
        if (entP != null) {
            Random rand = new Random();
            double var11 = entP.field_70165_t - this.pos.xCoord;
            double var15 = entP.field_70161_v - this.pos.zCoord;
            float yaw = -((float)(Math.atan2(var11, var15) * 180.0 / Math.PI));
            int size = ConfigTornado.Storm_Tornado_aimAtPlayerAngleVariance;
            if (size > 0) {
                yaw += (float)(rand.nextInt(size) - size / 2);
            }
            this.angleIsOverridden = true;
            this.angleMovementTornadoOverride = yaw;
            Weather.dbg("stormfront aimed at player " + CoroUtilEntity.getName((Entity)entP));
        }
    }

    public void setNoStorm() {
        Weather.dbg("storm ID: " + this.ID + " - ended storm event");
        this.levelCurIntensityStage = STATE_NORMAL;
        this.levelCurStagesIntensity = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient() {
        EntityRotFX ent;
        int i;
        Vec3 tryPos;
        int i2;
        if (this.isCloudlessStorm()) {
            return;
        }
        if (this.particleBehaviorFog == null) {
            this.particleBehaviorFog = new ParticleBehaviorFog(new Vec3(this.pos.xCoord, this.pos.yCoord, this.pos.zCoord));
        } else if (!Minecraft.func_71410_x().func_71356_B() || !(Minecraft.func_71410_x().field_71462_r instanceof GuiIngameMenu)) {
            this.particleBehaviorFog.tickUpdateList();
        }
        EntityPlayerSP entP = Minecraft.func_71410_x().field_71439_g;
        this.spinSpeed = 0.02;
        double spinSpeedMax = 0.4;
        this.spinSpeed = this.isCycloneFormingOrGreater() ? spinSpeedMax * 0.0 + (double)((float)this.levelCurIntensityStage - levelStormIntensityFormingStartVal + 1.0f) * spinSpeedMax * 0.2 : (this.isTornadoFormingOrGreater() ? spinSpeedMax * 0.2 : (this.levelCurIntensityStage >= STATE_HIGHWIND ? spinSpeedMax * 0.05 : spinSpeedMax * 0.02));
        if (this.isHurricane()) {
            this.spinSpeed += 0.1;
        }
        if (this.size == 0) {
            this.size = 1;
        }
        int delay = Math.max(1, (int)(100.0f / (float)this.size * 1.0f));
        int loopSize = 1;
        int extraSpawning = 0;
        if (this.isSpinning()) {
            loopSize += 4;
            extraSpawning = 300;
        }
        if (this.stormType == TYPE_WATER) {
            if (this.levelCurIntensityStage >= STATE_STAGE5) {
                loopSize = 10;
                extraSpawning = 800;
            } else if (this.levelCurIntensityStage >= STATE_STAGE4) {
                loopSize = 8;
                extraSpawning = 700;
            } else if (this.levelCurIntensityStage >= STATE_STAGE3) {
                loopSize = 6;
                extraSpawning = 500;
            } else if (this.levelCurIntensityStage >= STATE_STAGE2) {
                loopSize = 4;
                extraSpawning = 400;
            } else {
                extraSpawning = 300;
            }
        }
        Random rand = new Random();
        Vec3 playerAdjPos = new Vec3(entP.field_70165_t, this.pos.yCoord, entP.field_70161_v);
        double maxSpawnDistFromPlayer = 512.0;
        if (ConfigCoroUtil.optimizedCloudRendering) {
            float radStart;
            double rotPos;
            EntityRotFX particle;
            Vec3 tryPos2;
            int i3;
            int count = 9;
            for (i3 = 0; i3 < count; ++i3) {
                if (this.lookupParticlesCloud.containsKey(i3)) continue;
                tryPos2 = new Vec3(this.pos.xCoord, (double)layers.get(this.layer).intValue(), this.pos.zCoord);
                particle = WeatherUtil.isAprilFoolsDay() ? this.spawnFogParticle(tryPos2.xCoord, tryPos2.yCoord, tryPos2.zCoord, 0, ParticleRegistry.chicken) : this.spawnFogParticle(tryPos2.xCoord, tryPos2.yCoord, tryPos2.zCoord, 0, ParticleRegistry.cloud256_test);
                if (i3 != 0) {
                    rotPos = i3 - 1;
                    particle.rotationAroundCenter = radStart = (float)(45.0 * rotPos);
                }
                this.lookupParticlesCloud.put(i3, particle);
            }
            if (this.isSpinning()) {
                count = 32;
                for (i3 = 0; i3 < count; ++i3) {
                    if (this.lookupParticlesCloudLower.containsKey(i3)) continue;
                    tryPos2 = new Vec3(this.pos.xCoord, (double)layers.get(this.layer).intValue(), this.pos.zCoord);
                    particle = WeatherUtil.isAprilFoolsDay() ? this.spawnFogParticle(tryPos2.xCoord, tryPos2.yCoord, tryPos2.zCoord, 1, ParticleRegistry.chicken) : this.spawnFogParticle(tryPos2.xCoord, tryPos2.yCoord, tryPos2.zCoord, 1, ParticleRegistry.cloud256_test);
                    rotPos = i3 % 15;
                    particle.rotationAroundCenter = radStart = (float)(22.5 * rotPos);
                    this.lookupParticlesCloudLower.put(i3, particle);
                }
            }
        }
        if (this.manager.getWorld().func_82737_E() % (long)(delay + (this.isSpinning() ? ConfigStorm.Storm_ParticleSpawnDelay : ConfigMisc.Cloud_ParticleSpawnDelay)) == 0L) {
            for (i2 = 0; i2 < loopSize; ++i2) {
                EntityRotFX particle;
                if (ConfigCoroUtil.optimizedCloudRendering || !((float)this.listParticlesCloud.size() < (float)(this.size + extraSpawning) / 1.0f)) continue;
                double spawnRad = this.size;
                tryPos = new Vec3(this.pos.xCoord + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, (double)layers.get(this.layer).intValue(), this.pos.zCoord + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad);
                if (!(tryPos.distanceTo(playerAdjPos) < maxSpawnDistFromPlayer) || this.getAvoidAngleIfTerrainAtOrAheadOfPosition(this.getAdjustedAngle(), tryPos) != 0.0f) continue;
                if (WeatherUtil.isAprilFoolsDay()) {
                    particle = this.spawnFogParticle(tryPos.xCoord, tryPos.yCoord, tryPos.zCoord, 0, ParticleRegistry.chicken);
                } else {
                    particle = this.spawnFogParticle(tryPos.xCoord, tryPos.yCoord, tryPos.zCoord, 0);
                    if (this.isFirenado && this.isSpinning()) {
                        particle.func_187117_a(ParticleRegistry.cloud256_fire);
                        particle.func_70538_b(1.0f, 1.0f, 1.0f);
                    }
                }
                this.listParticlesCloud.add(particle);
            }
        }
        if (!ConfigCoroUtil.optimizedCloudRendering && this.levelCurIntensityStage >= STATE_HIGHWIND) {
            for (i2 = 0; i2 < (this.stormType == TYPE_WATER ? 50 : 3); ++i2) {
                if (this.listParticlesGround.size() >= (this.stormType == TYPE_WATER ? 600 : 150)) continue;
                double spawnRad = this.size / 4 * 3;
                if (this.stormType == TYPE_WATER) {
                    spawnRad = this.size * 3;
                }
                if (!((tryPos = new Vec3(this.pos.xCoord + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, this.posGround.yCoord, this.pos.zCoord + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad)).distanceTo(playerAdjPos) < maxSpawnDistFromPlayer)) continue;
                int groundY = WeatherUtilBlock.getPrecipitationHeightSafe(this.manager.getWorld(), new BlockPos((int)tryPos.xCoord, 0, (int)tryPos.zCoord)).func_177956_o();
                EntityRotFX particle = WeatherUtil.isAprilFoolsDay() ? this.spawnFogParticle(tryPos.xCoord, groundY + 3, tryPos.zCoord, 0, ParticleRegistry.potato) : this.spawnFogParticle(tryPos.xCoord, groundY + 3, tryPos.zCoord, 0);
                particle.setScale(200.0f);
                particle.rotationYaw = rand.nextInt(360);
                particle.rotationPitch = rand.nextInt(360);
                this.listParticlesGround.add(particle);
            }
        }
        delay = 1;
        loopSize = 2;
        double spawnRad = this.size / 48;
        if (this.levelCurIntensityStage >= STATE_STAGE5) {
            spawnRad = 200.0;
            loopSize = 10;
            this.sizeMaxFunnelParticles = 1200;
        } else if (this.levelCurIntensityStage >= STATE_STAGE4) {
            spawnRad = 150.0;
            loopSize = 8;
            this.sizeMaxFunnelParticles = 1000;
        } else if (this.levelCurIntensityStage >= STATE_STAGE3) {
            spawnRad = 100.0;
            loopSize = 6;
            this.sizeMaxFunnelParticles = 800;
        } else if (this.levelCurIntensityStage >= STATE_STAGE2) {
            spawnRad = 50.0;
            loopSize = 4;
            this.sizeMaxFunnelParticles = 600;
        } else {
            this.sizeMaxFunnelParticles = 600;
        }
        if ((this.isTornadoFormingOrGreater() || this.attrib_waterSpout) && this.manager.getWorld().func_82737_E() % (long)(delay + ConfigStorm.Storm_ParticleSpawnDelay) == 0L) {
            for (int i4 = 0; i4 < loopSize; ++i4) {
                if (this.listParticlesFunnel.size() >= this.sizeMaxFunnelParticles) {
                    this.listParticlesFunnel.get(0).func_187112_i();
                    this.listParticlesFunnel.remove(0);
                }
                if (this.listParticlesFunnel.size() >= this.sizeMaxFunnelParticles || !((tryPos = new Vec3(this.pos.xCoord + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, this.pos.yCoord, this.pos.zCoord + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad)).distanceTo(playerAdjPos) < maxSpawnDistFromPlayer)) continue;
                EntityRotFX particle = !this.isFirenado ? (WeatherUtil.isAprilFoolsDay() ? this.spawnFogParticle(tryPos.xCoord, this.posBaseFormationPos.yCoord, tryPos.zCoord, 1, ParticleRegistry.potato) : this.spawnFogParticle(tryPos.xCoord, this.posBaseFormationPos.yCoord, tryPos.zCoord, 1)) : this.spawnFogParticle(tryPos.xCoord, this.posBaseFormationPos.yCoord, tryPos.zCoord, 1, ParticleRegistry.cloud256_fire);
                particle.func_187114_a(150 + (this.levelCurIntensityStage - 1) * 100 + rand.nextInt(100));
                float baseBright = 0.3f;
                float randFloat = rand.nextFloat() * 0.6f;
                particle.rotationYaw = rand.nextInt(360);
                float finalBright = Math.min(1.0f, baseBright + randFloat);
                if (this.levelCurIntensityStage == STATE_HIGHWIND) {
                    particle.setScale(150.0f);
                    particle.func_70538_b(finalBright - 0.2f, finalBright - 0.2f, finalBright);
                } else {
                    particle.setScale(250.0f);
                    particle.func_70538_b(finalBright, finalBright, finalBright);
                }
                if (this.isFirenado) {
                    particle.func_70538_b(1.0f, 1.0f, 1.0f);
                    particle.setScale(particle.getScale() * 0.7f);
                }
                this.listParticlesFunnel.add(particle);
            }
        }
        for (i = 0; i < this.listParticlesFunnel.size(); ++i) {
            ent = this.listParticlesFunnel.get(i);
            if (!ent.func_187113_k()) {
                this.listParticlesFunnel.remove(ent);
                continue;
            }
            if (ent.getPosY() > this.pos.yCoord) {
                ent.func_187112_i();
                this.listParticlesFunnel.remove(ent);
                continue;
            }
            double var16 = this.pos.xCoord - ent.getPosX();
            double var18 = this.pos.zCoord - ent.getPosZ();
            ent.rotationYaw = (float)(Math.atan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
            ent.rotationYaw += (float)(ent.getEntityId() % 90);
            ent.rotationPitch = -30.0f;
            if (this.levelCurIntensityStage == STATE_HIGHWIND) {
                int fadingDistStart = 30;
                if (ent.getPosY() > this.posGround.yCoord + (double)fadingDistStart) {
                    float maxVal = ent.func_70535_g();
                    float fadeRate = 0.002f;
                    ent.func_70538_b(Math.min(maxVal, ent.func_70534_d() + fadeRate), Math.min(maxVal, ent.func_70542_f() + fadeRate), maxVal);
                }
            }
            this.spinEntity(ent);
        }
        for (i = 0; i < this.listParticlesCloud.size(); ++i) {
            ent = this.listParticlesCloud.get(i);
            if (!ent.func_187113_k()) {
                this.listParticlesCloud.remove(ent);
                continue;
            }
            double curSpeed = Math.sqrt(ent.getMotionX() * ent.getMotionX() + ent.getMotionY() * ent.getMotionY() + ent.getMotionZ() * ent.getMotionZ());
            double curDist = ent.getDistance(this.pos.xCoord, ent.getPosY(), this.pos.zCoord);
            float dropDownRange = 15.0f;
            float extraDropCalc = 0.0f;
            if (curDist < 200.0 && ent.getEntityId() % 20 < 5) {
                extraDropCalc = (float)(ent.getEntityId() % 20) * dropDownRange;
                if (this.isCycloneFormingOrGreater()) {
                    extraDropCalc = (float)(ent.getEntityId() % 20) * dropDownRange * 5.0f;
                }
            }
            if (this.isSpinning()) {
                double speed = this.spinSpeed + rand.nextDouble() * 0.01;
                double distt = this.size;
                double vecX = ent.getPosX() - this.pos.xCoord;
                double vecZ = ent.getPosZ() - this.pos.zCoord;
                float angle = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
                angle = (float)((double)angle + speed * 50.0);
                angle = (float)((double)angle - (double)(ent.getEntityId() % 10) * 3.0);
                angle += (float)(rand.nextInt(10) - rand.nextInt(10));
                if (curDist > distt) {
                    angle += 40.0f;
                }
                if (ent.getEntityId() % 20 < 5) {
                    if (this.levelCurIntensityStage >= STATE_FORMING) {
                        if (this.stormType == TYPE_WATER) {
                            angle += (float)(40 + ent.getEntityId() % 5 * 4);
                            if (curDist > (double)(150.0f + ((float)this.levelCurIntensityStage - levelStormIntensityFormingStartVal + 1.0f) * 30.0f)) {
                                angle += 10.0f;
                            }
                        } else {
                            angle += (float)(30 + ent.getEntityId() % 5 * 4);
                        }
                    } else if (curDist > 150.0) {
                        angle += (float)(50 + ent.getEntityId() % 5 * 4);
                    }
                    double var16 = this.pos.xCoord - ent.getPosX();
                    double var18 = this.pos.zCoord - ent.getPosZ();
                    ent.rotationYaw = (float)(Math.atan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
                    ent.rotationPitch = -20.0f - (float)(ent.getEntityId() % 10);
                }
                if (curSpeed < speed * 20.0) {
                    ent.setMotionX(ent.getMotionX() + -Math.sin(Math.toRadians(angle)) * speed);
                    ent.setMotionZ(ent.getMotionZ() + Math.cos(Math.toRadians(angle)) * speed);
                }
            } else {
                float cloudMoveAmp = 0.2f * (float)(1 + this.layer);
                float speed = this.getAdjustedSpeed() * cloudMoveAmp;
                float angle = this.getAdjustedAngle();
                if ((this.manager.getWorld().func_82737_E() + this.ID) % 40L == 0L) {
                    ent.avoidTerrainAngle = this.getAvoidAngleIfTerrainAtOrAheadOfPosition(angle, ent.getPos());
                }
                angle += ent.avoidTerrainAngle;
                if (ent.avoidTerrainAngle != 0.0f) {
                    speed = (float)((double)speed * 0.5);
                }
                dropDownRange = 5.0f;
                if (ent.getEntityId() % 20 < 5) {
                    extraDropCalc = (float)(ent.getEntityId() % 20) * dropDownRange;
                }
                if (curSpeed < (double)speed * 1.0) {
                    ent.setMotionX(ent.getMotionX() + -Math.sin(Math.toRadians(angle)) * (double)speed);
                    ent.setMotionZ(ent.getMotionZ() + Math.cos(Math.toRadians(angle)) * (double)speed);
                }
            }
            if (Math.abs(ent.getPosY() - (this.pos.yCoord - (double)extraDropCalc)) > 2.0) {
                if (ent.getPosY() < this.pos.yCoord - (double)extraDropCalc) {
                    ent.setMotionY(ent.getMotionY() + 0.1);
                } else {
                    ent.setMotionY(ent.getMotionY() - 0.1);
                }
            }
            float dropDownSpeedMax = 0.15f;
            if (this.isCycloneFormingOrGreater()) {
                dropDownSpeedMax = 0.9f;
            }
            if (ent.getMotionY() < (double)(-dropDownSpeedMax)) {
                ent.setMotionY((double)(-dropDownSpeedMax));
            }
            if (!(ent.getMotionY() > (double)dropDownSpeedMax)) continue;
            ent.setMotionY((double)dropDownSpeedMax);
        }
        for (i = 0; i < this.listParticlesGround.size(); ++i) {
            ent = this.listParticlesGround.get(i);
            double curDist = ent.getDistance(this.pos.xCoord, ent.getPosY(), this.pos.zCoord);
            if (!ent.func_187113_k()) {
                this.listParticlesGround.remove(ent);
                continue;
            }
            double curSpeed = Math.sqrt(ent.getMotionX() * ent.getMotionX() + ent.getMotionY() * ent.getMotionY() + ent.getMotionZ() * ent.getMotionZ());
            double speed = Math.max((double)0.2f, 5.0 * this.spinSpeed) + rand.nextDouble() * 0.01;
            double distt = this.size;
            double vecX = ent.getPosX() - this.pos.xCoord;
            double vecZ = ent.getPosZ() - this.pos.zCoord;
            float angle = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
            angle += 85.0f;
            int maxParticleSize = 60;
            if (this.stormType == TYPE_WATER) {
                maxParticleSize = 150;
                speed /= 5.0;
            }
            ent.setScale((float)Math.min((double)maxParticleSize, curDist * 2.0));
            if (curDist < 20.0) {
                ent.func_187112_i();
            }
            double var16 = this.pos.xCoord - ent.getPosX();
            double var18 = this.pos.zCoord - ent.getPosZ();
            if (!(curSpeed < speed * 20.0)) continue;
            ent.setMotionX(ent.getMotionX() + -Math.sin(Math.toRadians(angle)) * speed);
            ent.setMotionZ(ent.getMotionZ() + Math.cos(Math.toRadians(angle)) * speed);
        }
    }

    public float getAdjustedSpeed() {
        return this.manager.windMan.getWindSpeedForClouds();
    }

    public float getAdjustedAngle() {
        float angle = this.manager.windMan.getWindAngleForClouds();
        float angleAdjust = Math.max(10.0f, Math.min(45.0f, 45.0f * this.levelTemperature * 0.2f));
        float targetYaw = 0.0f;
        targetYaw = this.levelTemperature > 0.0f ? 180.0f : 0.0f;
        float bestMove = MathHelper.func_76142_g((float)(targetYaw - angle));
        if (Math.abs(bestMove) < 180.0f) {
            if (bestMove > 0.0f) {
                angle -= angleAdjust;
            }
            if (bestMove < 0.0f) {
                angle += angleAdjust;
            }
        }
        return angle;
    }

    public float getAvoidAngleIfTerrainAtOrAheadOfPosition(float angle, Vec3 pos) {
        double scanDistMax = 120.0;
        for (int scanAngle = -20; scanAngle < 20; scanAngle += 10) {
            for (double scanDistRange = 20.0; scanDistRange < scanDistMax; scanDistRange += 10.0) {
                double scanX = pos.xCoord + -Math.sin(Math.toRadians(angle + (float)scanAngle)) * scanDistRange;
                double scanZ = pos.zCoord + Math.cos(Math.toRadians(angle + (float)scanAngle)) * scanDistRange;
                int height = WeatherUtilBlock.getPrecipitationHeightSafe(this.manager.getWorld(), new BlockPos(scanX, 0.0, scanZ)).func_177956_o();
                if (!(pos.yCoord < (double)height)) continue;
                if (scanAngle <= 0) {
                    return 90.0f;
                }
                return -90.0f;
            }
        }
        return 0.0f;
    }

    public void spinEntity(Object entity1) {
        double adjPull;
        float f;
        float f1;
        StormObject entT = this;
        StormObject entity = this;
        WeatherEntityConfig conf = this.getWeatherEntityConfigForStorm();
        Random rand = new Random();
        boolean forTornado = true;
        World world = CoroUtilEntOrParticle.getWorld((Object)entity1);
        long worldTime = world.func_82737_E();
        Entity ent = null;
        if (entity1 instanceof Entity) {
            ent = (Entity)entity1;
        }
        double radius = 10.0;
        double scale = conf.tornadoWidthScale;
        double d1 = entity.pos.xCoord - CoroUtilEntOrParticle.getPosX((Object)entity1);
        double d2 = entity.pos.zCoord - CoroUtilEntOrParticle.getPosZ((Object)entity1);
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT) {
            float range = 30.0f * (float)Math.sin(Math.toRadians(((float)worldTime * 0.5f + (float)(this.ID * 50L)) % 360.0f));
            float heightPercent = (float)(1.0 - (CoroUtilEntOrParticle.getPosY((Object)entity1) - this.posGround.yCoord) / (this.pos.yCoord - this.posGround.yCoord));
            float posOffsetX = (float)Math.sin(Math.toRadians(heightPercent * 360.0f));
            float posOffsetZ = (float)(-Math.cos(Math.toRadians(heightPercent * 360.0f)));
            d1 += (double)(range * posOffsetX);
            d2 += (double)(range * posOffsetZ);
        }
        for (f1 = f = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f; f1 < -180.0f; f1 += 360.0f) {
        }
        while (f1 >= 180.0f) {
            f1 -= 360.0f;
        }
        double distY = entity.pos.yCoord - CoroUtilEntOrParticle.getPosY((Object)entity1);
        double distXZ = Math.sqrt(Math.abs(d1)) + Math.sqrt(Math.abs(d2));
        distY = CoroUtilEntOrParticle.getPosY((Object)entity1) - entity.pos.yCoord < 0.0 ? 1.0 : CoroUtilEntOrParticle.getPosY((Object)entity1) - entity.pos.yCoord;
        if (distY > (double)this.maxHeight) {
            distY = this.maxHeight;
        }
        float weight = WeatherUtilEntity.getWeight(entity1, forTornado);
        double grab = 10.0 / (double)weight * (Math.abs((double)this.maxHeight - distY) / (double)this.maxHeight);
        float pullY = 0.0f;
        if (rand.nextInt(5) != 0) {
            // empty if block
        }
        if (distXZ > 5.0) {
            grab *= radius / distXZ;
        }
        pullY += conf.tornadoLiftRate / (weight / 2.0f);
        if (entity1 instanceof EntityPlayer) {
            adjPull = 0.2 / ((double)weight * ((distXZ + 1.0) / radius));
            pullY = (float)((double)pullY + adjPull);
            double adjGrab = 10.0 * (double)((float)(((double)WeatherUtilEntity.playerInAirTime + 1.0) / 400.0));
            if (adjGrab > 50.0) {
                adjGrab = 50.0;
            }
            if (adjGrab < -50.0) {
                adjGrab = -50.0;
            }
            grab -= adjGrab;
            if (CoroUtilEntOrParticle.getMotionY((Object)entity1) > -0.8) {
                ent.field_70143_R = 0.0f;
            }
        } else if (entity1 instanceof EntityLivingBase) {
            adjPull = 0.005 / ((double)weight * ((distXZ + 1.0) / radius));
            pullY = (float)((double)pullY + adjPull);
            int airTime = ent.getEntityData().func_74762_e("timeInAir");
            double adjGrab = 10.0 * (double)((float)(((double)airTime + 1.0) / 400.0));
            if (adjGrab > 50.0) {
                adjGrab = 50.0;
            }
            if (adjGrab < -50.0) {
                adjGrab = -50.0;
            }
            grab -= adjGrab;
            if (ent.field_70181_x > -1.5) {
                ent.field_70143_R = 0.0f;
            }
            if (ent.field_70181_x > (double)0.3f) {
                ent.field_70181_x = 0.3f;
            }
            if (forTornado) {
                ent.field_70122_E = false;
            }
            ent.func_70066_B();
        }
        double profileAngle = Math.max(1.0, 75.0 + (grab += (double)conf.relTornadoSize) - 10.0 * scale);
        f1 = (float)((double)f1 + profileAngle);
        if (entT != null && entT.scale != 1.0f) {
            f1 += 20.0f - 20.0f * entT.scale;
        }
        float f3 = (float)Math.cos(-f1 * 0.01745329f - (float)Math.PI);
        float f4 = (float)Math.sin(-f1 * 0.01745329f - (float)Math.PI);
        float f5 = conf.tornadoPullRate * 1.0f;
        if (entT != null && entT.scale != 1.0f) {
            f5 *= entT.scale * 1.2f;
        }
        if (entity1 instanceof EntityLivingBase) {
            f5 = (float)((double)f5 / ((double)WeatherUtilEntity.getWeight(entity1, forTornado) * ((distXZ + 1.0) / radius)));
        }
        if (entity1 instanceof EntityPlayer && conf.type != 0) {
            f5 = ent.field_70122_E ? (f5 *= 10.5f) : (f5 *= 5.0f);
        } else if (entity1 instanceof EntityLivingBase && conf.type != 0) {
            f5 *= 1.5f;
        }
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT && entity1 instanceof EntityLivingBase) {
            f5 *= 0.3f;
        }
        float moveX = f3 * f5;
        float moveZ = f4 * f5;
        float str = 1.0f;
        str = this.strength;
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT && entity1 instanceof EntityLivingBase) {
            str *= 0.3f;
        }
        pullY *= str / 100.0f;
        if (entT != null && entT.scale != 1.0f) {
            pullY *= entT.scale * 1.0f;
            pullY += 0.002f;
        }
        if (entity1 instanceof Entity) {
            long lastPullTime = ent.getEntityData().func_74763_f("lastPullTime");
            if (lastPullTime == worldTime) {
                pullY = 0.0f;
            }
            ent.getEntityData().func_74772_a("lastPullTime", worldTime);
        }
        this.setVel(entity1, -moveX, pullY, moveZ);
    }

    public void setVel(Object entity, float f, float f1, float f2) {
        CoroUtilEntOrParticle.setMotionX((Object)entity, (double)(CoroUtilEntOrParticle.getMotionX((Object)entity) + (double)f));
        CoroUtilEntOrParticle.setMotionY((Object)entity, (double)(CoroUtilEntOrParticle.getMotionY((Object)entity) + (double)f1));
        CoroUtilEntOrParticle.setMotionZ((Object)entity, (double)(CoroUtilEntOrParticle.getMotionZ((Object)entity) + (double)f2));
        if (entity instanceof EntitySquid) {
            Entity ent = (Entity)entity;
            ent.func_70107_b(ent.field_70165_t + ent.field_70159_w * 5.0, ent.field_70163_u, ent.field_70161_v + ent.field_70179_y * 5.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EntityRotFX spawnFogParticle(double x, double y, double z, int parRenderOrder) {
        return this.spawnFogParticle(x, y, z, parRenderOrder, ParticleRegistry.cloud256);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityRotFX spawnFogParticle(double x, double y, double z, int parRenderOrder, TextureAtlasSprite tex) {
        double speed = 0.0;
        Random rand = new Random();
        EntityRotFX entityfx = this.particleBehaviorFog.spawnNewParticleIconFX((World)Minecraft.func_71410_x().field_71441_e, tex, x, y, z, (rand.nextDouble() - rand.nextDouble()) * speed, 0.0, (rand.nextDouble() - rand.nextDouble()) * speed, parRenderOrder);
        this.particleBehaviorFog.initParticle(entityfx);
        entityfx.setCanCollide(false);
        entityfx.callUpdatePB = false;
        boolean debug = false;
        if (debug) {
            // empty if block
        }
        if (this.levelCurIntensityStage == STATE_NORMAL) {
            entityfx.func_187114_a(300 + rand.nextInt(100));
        } else {
            entityfx.func_187114_a(this.size / 2 + rand.nextInt(100));
        }
        if (entityfx.getEntityId() % 20 < 5 && this.isSpinning()) {
            entityfx.renderOrder = 1;
            entityfx.func_187114_a(this.size + rand.nextInt(100));
        }
        if (ConfigCoroUtil.optimizedCloudRendering) {
            entityfx.func_187114_a(400);
        }
        float randFloat = rand.nextFloat() * 0.6f;
        if (ConfigCoroUtil.optimizedCloudRendering) {
            randFloat = rand.nextFloat() * 0.4f;
        }
        float baseBright = 0.7f;
        if (this.levelCurIntensityStage > STATE_NORMAL) {
            baseBright = 0.2f;
        } else if (this.attrib_precipitation) {
            baseBright = 0.2f;
        } else if (this.manager.isVanillaRainActiveOnServer) {
            baseBright = 0.2f;
        } else {
            float adj = Math.min(1.0f, (float)(this.levelWater / this.levelWaterStartRaining)) * 0.6f;
            baseBright -= adj;
        }
        float finalBright = Math.min(1.0f, baseBright + randFloat);
        entityfx.func_70538_b(finalBright, finalBright, finalBright);
        if (debug) {
            if (this.levelTemperature < 0.0f) {
                entityfx.func_70538_b(0.0f, 0.0f, finalBright);
            } else if (this.levelTemperature > 0.0f) {
                entityfx.func_70538_b(finalBright, 0.0f, 0.0f);
            }
        }
        ExtendedRenderer.rotEffRenderer.addEffect((Particle)entityfx);
        this.particleBehaviorFog.particles.add(entityfx);
        return entityfx;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.tornadoHelper != null) {
            this.tornadoHelper.cleanup();
        }
        this.tornadoHelper = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void cleanupClient() {
        super.cleanupClient();
        this.listParticlesCloud.clear();
        this.listParticlesFunnel.clear();
        if (this.particleBehaviorFog != null && this.particleBehaviorFog.particles != null) {
            this.particleBehaviorFog.particles.clear();
        }
        this.particleBehaviorFog = null;
    }

    public float getTemperatureMCToWeatherSys(float parOrigVal) {
        parOrigVal = (float)((double)parOrigVal - 0.7);
        return parOrigVal *= 2.0f;
    }

    public void addWeatherEffectLightning(EntityLightningBolt parEnt, boolean custom) {
        this.manager.getWorld().field_73007_j.add(parEnt);
        ((WeatherManagerServer)this.manager).syncLightningNew((Entity)parEnt, custom);
    }

    @Override
    public int getUpdateRateForNetwork() {
        if (this.levelCurIntensityStage >= STATE_HIGHWIND) {
            return 2;
        }
        return super.getUpdateRateForNetwork();
    }
}

