/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem;

import CoroUtil.packet.PacketHelper;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.Vec3;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import weather2.Weather;
import weather2.config.ConfigMisc;
import weather2.config.ConfigSand;
import weather2.config.ConfigStorm;
import weather2.player.PlayerData;
import weather2.util.CachedNBTTagCompound;
import weather2.util.WeatherUtilBlock;
import weather2.util.WeatherUtilConfig;
import weather2.util.WeatherUtilEntity;
import weather2.volcano.VolcanoObject;
import weather2.weathersystem.WeatherManagerBase;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObject;
import weather2.weathersystem.storm.WeatherObjectSandstorm;
import weather2.weathersystem.wind.WindManager;

public class WeatherManagerServer
extends WeatherManagerBase {
    public int syncRange = 256;

    public WeatherManagerServer(int parDim) {
        super(parDim);
    }

    @Override
    public World getWorld() {
        return DimensionManager.getWorld((int)this.dim);
    }

    @Override
    public void tick() {
        super.tick();
        World world = this.getWorld();
        if (WeatherObject.lastUsedStormID >= Long.MAX_VALUE) {
            WeatherObject.lastUsedStormID = 0L;
        }
        this.tickWeatherCoverage();
        if (world != null) {
            EntityPlayer entP;
            Random rand;
            int i;
            for (i = 0; i < this.getStormObjects().size(); ++i) {
                WeatherObject wo = this.getStormObjects().get(i);
                int updateRate = wo.getUpdateRateForNetwork();
                if (world.func_82737_E() % (long)updateRate != 0L) continue;
                this.syncStormUpdate(wo);
            }
            if (world.func_82737_E() % 40L == 0L) {
                for (i = 0; i < this.getVolcanoObjects().size(); ++i) {
                    this.syncVolcanoUpdate(this.getVolcanoObjects().get(i));
                }
            }
            if (world.func_82737_E() % 60L == 0L) {
                this.syncWindUpdate(this.windMan);
            }
            if (world.func_82737_E() % 60L == 0L) {
                this.nbtStormsForIMC();
            }
            int rate = 20;
            if (world.func_82737_E() % (long)rate == 0L) {
                for (int i2 = 0; i2 < this.getStormObjects().size(); ++i2) {
                    WeatherObject so = this.getStormObjects().get(i2);
                    EntityPlayer closestPlayer = WeatherUtilEntity.getClosestPlayerAny(world, so.posGround.xCoord, so.posGround.yCoord, so.posGround.zCoord, ConfigMisc.Misc_simBoxRadiusCutoff);
                    if (closestPlayer == null || ConfigMisc.Aesthetic_Only_Mode) {
                        so.ticksSinceNoNearPlayer += rate;
                        if (so.ticksSinceNoNearPlayer <= 600 && !ConfigMisc.Aesthetic_Only_Mode) continue;
                        if (world.field_73010_i.size() == 0) {
                            Weather.dbg("removing distant storm: " + so.ID + ", running without players");
                        } else {
                            Weather.dbg("removing distant storm: " + so.ID);
                        }
                        this.removeStormObject(so.ID);
                        this.syncStormRemove(so);
                        continue;
                    }
                    so.ticksSinceNoNearPlayer = 0;
                }
                rand = new Random();
                if (!ConfigMisc.Aesthetic_Only_Mode && WeatherUtilConfig.listDimensionsClouds.contains(world.field_73011_w.getDimension())) {
                    for (int i3 = 0; i3 < world.field_73010_i.size(); ++i3) {
                        entP = (EntityPlayer)world.field_73010_i.get(i3);
                        if (this.getStormObjectsByLayer(0).size() < ConfigStorm.Storm_MaxPerPlayerPerLayer * world.field_73010_i.size() && rand.nextInt(5) == 0) {
                            this.trySpawnStormCloudNearPlayerForLayer(entP, 0);
                        }
                        if (this.getStormObjectsByLayer(1).size() >= ConfigStorm.Storm_MaxPerPlayerPerLayer * world.field_73010_i.size() || !ConfigMisc.Cloud_Layer1_Enable || rand.nextInt(5) != 0) continue;
                        this.trySpawnStormCloudNearPlayerForLayer(entP, 1);
                    }
                }
            }
            if (!ConfigMisc.Aesthetic_Only_Mode && !ConfigSand.Storm_NoSandstorms && WeatherUtilConfig.listDimensionsStorms.contains(world.field_73011_w.getDimension()) && world.func_82737_E() % 200L == 0L && this.windMan.isHighWindEventActive()) {
                rand = new Random();
                if (ConfigSand.Sandstorm_OddsTo1 <= 0 || rand.nextInt(ConfigSand.Sandstorm_OddsTo1) == 0) {
                    if (ConfigSand.Sandstorm_UseGlobalServerRate) {
                        EntityPlayer entP2;
                        boolean sandstormMade;
                        if (world.field_73010_i.size() > 0 && (sandstormMade = this.trySandstormForPlayer(entP2 = (EntityPlayer)world.field_73010_i.get(rand.nextInt(world.field_73010_i.size())), this.lastSandstormFormed))) {
                            this.lastSandstormFormed = world.func_82737_E();
                        }
                    } else {
                        for (int i4 = 0; i4 < world.field_73010_i.size(); ++i4) {
                            NBTTagCompound playerNBT;
                            entP = (EntityPlayer)world.field_73010_i.get(i4);
                            boolean sandstormMade = this.trySandstormForPlayer(entP, (playerNBT = PlayerData.getPlayerNBT(CoroUtilEntity.getName((Entity)entP))).func_74763_f("lastSandstormTime"));
                            if (!sandstormMade) continue;
                            playerNBT.func_74772_a("lastSandstormTime", world.func_82737_E());
                        }
                    }
                }
            }
        }
    }

    public void tickWeatherCoverage() {
        World world = this.getWorld();
        if (world != null) {
            if (!ConfigMisc.overcastMode && ConfigMisc.lockServerWeatherMode != -1) {
                world.func_72912_H().func_76084_b(ConfigMisc.lockServerWeatherMode == 1);
                world.func_72912_H().func_76069_a(ConfigMisc.lockServerWeatherMode == 1);
            }
            boolean test = world.func_72912_H().func_76059_o();
            if (ConfigStorm.preventServerThunderstorms) {
                world.func_72912_H().func_76069_a(false);
            }
            if (world.func_82737_E() % 40L == 0L) {
                this.isVanillaRainActiveOnServer = this.getWorld().func_72896_J();
                this.isVanillaThunderActiveOnServer = this.getWorld().func_72911_I();
                this.vanillaRainTimeOnServer = this.getWorld().func_72912_H().func_76083_p();
                this.syncWeatherVanilla();
            }
            if (world.func_82737_E() % 400L == 0L) {
                // empty if block
            }
            if (world.func_82737_E() % 200L == 0L) {
                Random rand = new Random();
                this.cloudIntensity += (float)(rand.nextDouble() * ConfigMisc.Cloud_Coverage_Random_Change_Amount - rand.nextDouble() * ConfigMisc.Cloud_Coverage_Random_Change_Amount);
                if (ConfigMisc.overcastMode && world.func_72896_J()) {
                    this.cloudIntensity = 1.0f;
                } else if ((double)this.cloudIntensity < ConfigMisc.Cloud_Coverage_Min_Percent / 100.0) {
                    this.cloudIntensity = (float)ConfigMisc.Cloud_Coverage_Min_Percent / 100.0f;
                } else if ((double)this.cloudIntensity > ConfigMisc.Cloud_Coverage_Max_Percent / 100.0) {
                    this.cloudIntensity = (float)ConfigMisc.Cloud_Coverage_Max_Percent / 100.0f;
                }
                if (world.func_82737_E() % 2000L == 0L) {
                    // empty if block
                }
            }
        }
    }

    public boolean trySandstormForPlayer(EntityPlayer player, long lastSandstormTime) {
        boolean sandstormMade = false;
        if (lastSandstormTime == 0L || lastSandstormTime + (long)ConfigSand.Sandstorm_TimeBetweenInTicks < player.func_130014_f_().func_82737_E()) {
            sandstormMade = this.trySpawnSandstormNearPos(player.func_130014_f_(), new Vec3(player.func_174791_d()));
        }
        return sandstormMade;
    }

    public boolean trySpawnSandstormNearPos(World world, Vec3 posIn) {
        int searchRadius = 512;
        double angle = this.windMan.getWindAngleForClouds();
        double dirX = -Math.sin(Math.toRadians(angle));
        double dirZ = Math.cos(Math.toRadians(angle));
        double vecX = dirX * (double)searchRadius / 2.0 * -1.0;
        double vecZ = dirZ * (double)searchRadius / 2.0 * -1.0;
        Random rand = new Random();
        BlockPos foundPos = null;
        int findTriesMax = 30;
        for (int i = 0; i < findTriesMax; ++i) {
            int zz;
            int xx;
            BlockPos posRight;
            Biome biomeIn;
            int z;
            int x = MathHelper.func_76128_c((double)(posIn.xCoord + vecX + (double)rand.nextInt(searchRadius * 2) - (double)searchRadius));
            BlockPos pos = new BlockPos(x, 0, z = MathHelper.func_76128_c((double)(posIn.zCoord + vecZ + (double)rand.nextInt(searchRadius * 2) - (double)searchRadius)));
            if (!world.func_175667_e(pos) || !WeatherObjectSandstorm.isDesert(biomeIn = world.getBiomeForCoordsBody(pos), true)) continue;
            foundPos = pos;
            double dirXLeft = -Math.sin(Math.toRadians(angle - 90.0));
            double dirZLeft = Math.cos(Math.toRadians(angle - 90.0));
            double dirXRight = -Math.sin(Math.toRadians(angle + 90.0));
            double dirZRight = Math.cos(Math.toRadians(angle + 90.0));
            double distLeftRight = 20.0;
            BlockPos posLeft = new BlockPos((double)foundPos.func_177958_n() + dirXLeft * distLeftRight, 0.0, (double)foundPos.func_177952_p() + dirZLeft * distLeftRight);
            if (!world.func_175667_e(posLeft) || !WeatherObjectSandstorm.isDesert(world.getBiomeForCoordsBody(posLeft)) || !world.func_175667_e(posRight = new BlockPos((double)foundPos.func_177958_n() + dirXRight * distLeftRight, 0.0, (double)foundPos.func_177952_p() + dirZRight * distLeftRight)) || !WeatherObjectSandstorm.isDesert(world.getBiomeForCoordsBody(posRight))) continue;
            BlockPos posFind = new BlockPos((Vec3i)foundPos);
            BlockPos posFindLastGoodUpwind = new BlockPos((Vec3i)foundPos);
            BlockPos posFindLastGoodDownwind = new BlockPos((Vec3i)foundPos);
            double tickDist = 10.0;
            while (world.func_175667_e(posFind) && WeatherObjectSandstorm.isDesert(world.getBiomeForCoordsBody(posFind))) {
                posFindLastGoodUpwind = new BlockPos((Vec3i)posFind);
                xx = MathHelper.func_76128_c((double)((double)posFind.func_177958_n() + dirX * -1.0 * tickDist));
                zz = MathHelper.func_76128_c((double)((double)posFind.func_177952_p() + dirZ * -1.0 * tickDist));
                posFind = new BlockPos(xx, 0, zz);
            }
            posFind = new BlockPos((Vec3i)foundPos);
            while (world.func_175667_e(posFind) && WeatherObjectSandstorm.isDesert(world.getBiomeForCoordsBody(posFind))) {
                posFindLastGoodDownwind = new BlockPos((Vec3i)posFind);
                xx = MathHelper.func_76128_c((double)((double)posFind.func_177958_n() + dirX * 1.0 * tickDist));
                zz = MathHelper.func_76128_c((double)((double)posFind.func_177952_p() + dirZ * 1.0 * tickDist));
                posFind = new BlockPos(xx, 0, zz);
            }
            int minDistanceOfDesertStretchNeeded = 200;
            double dist = posFindLastGoodUpwind.func_185332_f(posFindLastGoodDownwind.func_177958_n(), posFindLastGoodDownwind.func_177956_o(), posFindLastGoodDownwind.func_177952_p());
            if (!(dist >= (double)minDistanceOfDesertStretchNeeded)) continue;
            WeatherObjectSandstorm sandstorm = new WeatherObjectSandstorm(this);
            sandstorm.initFirstTime();
            BlockPos posSpawn = new BlockPos((Vec3i)WeatherUtilBlock.getPrecipitationHeightSafe(world, posFindLastGoodUpwind)).func_177982_a(0, 1, 0);
            sandstorm.initSandstormSpawn(new Vec3(posSpawn));
            this.addStormObject(sandstorm);
            this.syncStormNew(sandstorm);
            Weather.dbg("found decent spot and stretch for sandstorm, stretch: " + dist);
            return true;
        }
        Weather.dbg("couldnt spawn sandstorm");
        return false;
    }

    public void trySpawnStormCloudNearPlayerForLayer(EntityPlayer entP, int layer) {
        Random rand = new Random();
        int tryCountMax = 10;
        int tryCountCur = 0;
        int spawnX = -1;
        int spawnZ = -1;
        Vec3 tryPos = null;
        StormObject soClose = null;
        EntityPlayer playerClose = null;
        int closestToPlayer = 128;
        float windOffsetDist = Math.min(256, ConfigMisc.Misc_simBoxRadiusCutoff / 4 * 3);
        double angle = this.windMan.getWindAngleForClouds();
        double vecX = -Math.sin(Math.toRadians(angle)) * (double)windOffsetDist;
        double vecZ = Math.cos(Math.toRadians(angle)) * (double)windOffsetDist;
        while (tryCountCur++ == 0 || tryCountCur < tryCountMax && (soClose != null || playerClose != null)) {
            spawnX = (int)(entP.field_70165_t - vecX + (double)rand.nextInt(ConfigMisc.Misc_simBoxRadiusSpawn) - (double)rand.nextInt(ConfigMisc.Misc_simBoxRadiusSpawn));
            spawnZ = (int)(entP.field_70161_v - vecZ + (double)rand.nextInt(ConfigMisc.Misc_simBoxRadiusSpawn) - (double)rand.nextInt(ConfigMisc.Misc_simBoxRadiusSpawn));
            tryPos = new Vec3((double)spawnX, (double)StormObject.layers.get(layer).intValue(), (double)spawnZ);
            soClose = this.getClosestStormAny(tryPos, ConfigMisc.Cloud_Formation_MinDistBetweenSpawned);
            playerClose = entP.field_70170_p.func_184137_a((double)spawnX, 50.0, (double)spawnZ, (double)closestToPlayer, false);
        }
        if (soClose == null) {
            StormObject so = new StormObject(this);
            so.initFirstTime();
            so.pos = tryPos;
            so.layer = layer;
            if (layer != 0) {
                so.canBeDeadly = false;
            }
            so.userSpawnedFor = CoroUtilEntity.getName((Entity)entP);
            if (rand.nextFloat() >= this.cloudIntensity) {
                so.setCloudlessStorm(true);
            }
            this.addStormObject(so);
            this.syncStormNew(so);
        }
    }

    public void playerJoinedWorldSyncFull(EntityPlayerMP entP) {
        Weather.dbg("Weather2: playerJoinedWorldSyncFull for dim: " + this.dim);
        World world = this.getWorld();
        if (world != null) {
            int i;
            Weather.dbg("Weather2: playerJoinedWorldSyncFull, sending " + this.getStormObjects().size() + " weather objects to: " + entP.func_70005_c_() + ", dim: " + this.dim);
            for (i = 0; i < this.getStormObjects().size(); ++i) {
                this.syncStormNew(this.getStormObjects().get(i), entP);
            }
            for (i = 0; i < this.getVolcanoObjects().size(); ++i) {
                this.syncVolcanoNew(this.getVolcanoObjects().get(i), entP);
            }
        }
    }

    public void nbtStormsForIMC() {
        NBTTagCompound data = new NBTTagCompound();
        for (int i = 0; i < this.getStormObjects().size(); ++i) {
            WeatherObject wo = this.getStormObjects().get(i);
            if (!(wo instanceof StormObject)) continue;
            StormObject so = (StormObject)wo;
            if (so.levelCurIntensityStage <= 0 && !so.attrib_precipitation) continue;
            NBTTagCompound nbtStorm = so.nbtForIMC();
            data.func_74782_a("storm_" + so.ID, (NBTBase)nbtStorm);
        }
        if (!data.func_82582_d()) {
            FMLInterModComms.sendRuntimeMessage((Object)Weather.instance, (String)"weather2", (String)"weather.storms", (NBTTagCompound)data);
        }
    }

    public void syncLightningNew(Entity parEnt, boolean custom) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncLightningNew");
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("posX", MathHelper.func_76128_c((double)parEnt.field_70165_t));
        nbt.func_74768_a("posY", MathHelper.func_76128_c((double)parEnt.field_70163_u));
        nbt.func_74768_a("posZ", MathHelper.func_76128_c((double)parEnt.field_70161_v));
        nbt.func_74768_a("entityID", parEnt.func_145782_y());
        nbt.func_74757_a("custom", custom);
        data.func_74782_a("data", (NBTBase)nbt);
        Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.getDimension());
        FMLInterModComms.sendRuntimeMessage((Object)Weather.instance, (String)"weather2", (String)"weather.lightning", (NBTTagCompound)data);
    }

    public void syncWindUpdate(WindManager parManager) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncWindUpdate");
        data.func_74782_a("data", (NBTBase)parManager.nbtSyncForClient());
        Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.getDimension());
        FMLInterModComms.sendRuntimeMessage((Object)Weather.instance, (String)"weather2", (String)"weather.wind", (NBTTagCompound)data);
    }

    public void syncStormNew(WeatherObject parStorm) {
        this.syncStormNew(parStorm, null);
    }

    public void syncStormNew(WeatherObject parStorm, EntityPlayerMP entP) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncStormNew");
        CachedNBTTagCompound cache = parStorm.getNbtCache();
        cache.setUpdateForced(true);
        parStorm.nbtSyncForClient();
        cache.setUpdateForced(false);
        data.func_74782_a("data", (NBTBase)cache.getNewNBT());
        if (entP == null) {
            Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.getDimension());
        } else {
            Weather.eventChannel.sendTo(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), entP);
        }
    }

    public void syncStormUpdate(WeatherObject parStorm) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncStormUpdate");
        parStorm.getNbtCache().setNewNBT(new NBTTagCompound());
        parStorm.nbtSyncForClient();
        data.func_74782_a("data", (NBTBase)parStorm.getNbtCache().getNewNBT());
        boolean testNetworkData = false;
        if (testNetworkData) {
            System.out.println("sending to client: " + parStorm.getNbtCache().getNewNBT().func_150296_c().size());
            if (parStorm instanceof StormObject) {
                System.out.println("Real: " + ((StormObject)parStorm).levelCurIntensityStage);
                if (parStorm.getNbtCache().getNewNBT().func_74764_b("levelCurIntensityStage")) {
                    System.out.println(" vs " + parStorm.getNbtCache().getNewNBT().func_74762_e("levelCurIntensityStage"));
                } else {
                    System.out.println("no key!");
                }
            }
            Iterator iterator = parStorm.getNbtCache().getNewNBT().func_150296_c().iterator();
            String keys = "";
            while (iterator.hasNext()) {
                keys = keys.concat((String)iterator.next() + "; ");
            }
            System.out.println("sending    " + keys);
        }
        Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.getDimension());
    }

    public void syncStormRemove(WeatherObject parStorm) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncStormRemove");
        parStorm.nbtSyncForClient();
        data.func_74782_a("data", (NBTBase)parStorm.getNbtCache().getNewNBT());
        data.func_74775_l("data").func_74757_a("isDead", true);
        Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.getDimension());
    }

    public void syncVolcanoNew(VolcanoObject parStorm) {
        this.syncVolcanoNew(parStorm, null);
    }

    public void syncVolcanoNew(VolcanoObject parStorm, EntityPlayerMP entP) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncVolcanoNew");
        data.func_74782_a("data", (NBTBase)parStorm.nbtSyncForClient());
        if (entP == null) {
            Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.getDimension());
        } else {
            Weather.eventChannel.sendTo(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), entP);
        }
    }

    public void syncVolcanoUpdate(VolcanoObject parStorm) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncVolcanoUpdate");
        data.func_74782_a("data", (NBTBase)parStorm.nbtSyncForClient());
        Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.getDimension());
    }

    public void syncVolcanoRemove(VolcanoObject parStorm) {
    }

    public void syncWeatherVanilla() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "WeatherData");
        data.func_74778_a("command", "syncWeatherUpdate");
        data.func_74757_a("isVanillaRainActiveOnServer", this.isVanillaRainActiveOnServer);
        data.func_74757_a("isVanillaThunderActiveOnServer", this.isVanillaThunderActiveOnServer);
        data.func_74768_a("vanillaRainTimeOnServer", this.vanillaRainTimeOnServer);
        Weather.eventChannel.sendToDimension(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), this.getWorld().field_73011_w.getDimension());
    }
}

