/*
 * Decompiled with CFR 0.152.
 */
package weather2.entity.AI;

import CoroUtil.ai.ITaskInitializer;
import CoroUtil.util.CoroUtilPhysics;
import CoroUtil.util.Vec3;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;
import weather2.ServerTickHandler;
import weather2.config.ConfigMisc;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObjectSandstorm;

public class EntityAIMoveIndoorsStorm
extends EntityAIBase
implements ITaskInitializer {
    private EntityCreature entityObj;
    private VillageDoorInfo doorInfo;
    private int insidePosX = -1;
    private int insidePosZ = -1;

    public EntityAIMoveIndoorsStorm() {
        this.func_75248_a(1);
    }

    public EntityAIMoveIndoorsStorm(EntityCreature entityObjIn) {
        this();
        this.entityObj = entityObjIn;
    }

    public boolean func_75250_a() {
        WeatherManagerServer weatherManager = ServerTickHandler.getWeatherSystemForDim(this.entityObj.field_70170_p.field_73011_w.getDimension());
        if (weatherManager == null) {
            return false;
        }
        BlockPos blockpos = new BlockPos((Entity)this.entityObj);
        Vec3 pos = new Vec3(blockpos);
        boolean runInside = false;
        if (!this.entityObj.field_70170_p.func_72935_r()) {
            runInside = true;
        } else {
            StormObject so = weatherManager.getClosestStorm(pos, ConfigMisc.Villager_MoveInsideForStorms_Dist, StormObject.STATE_THUNDER);
            if (so != null) {
                runInside = true;
            } else {
                List<Vec3> points;
                WeatherObjectSandstorm sandstorm = weatherManager.getClosestSandstormByIntensity(pos);
                if (sandstorm != null && CoroUtilPhysics.getDistanceToShape((Vec3)pos, points = sandstorm.getSandstormAsShape()) < (double)ConfigMisc.Villager_MoveInsideForStorms_Dist) {
                    runInside = true;
                }
            }
        }
        if (runInside) {
            if (this.insidePosX != -1 && this.entityObj.func_70092_e((double)this.insidePosX, this.entityObj.field_70163_u, (double)this.insidePosZ) < 4.0) {
                return false;
            }
            Village village = this.entityObj.field_70170_p.func_175714_ae().func_176056_a(blockpos, 14);
            if (village == null) {
                return false;
            }
            this.doorInfo = village.func_179863_c(blockpos);
            return this.doorInfo != null;
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.entityObj.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.insidePosX = -1;
        BlockPos blockpos = this.doorInfo.func_179856_e();
        int i = blockpos.func_177958_n();
        int j = blockpos.func_177956_o();
        int k = blockpos.func_177952_p();
        if (this.entityObj.func_174818_b(blockpos) > 256.0) {
            Vec3d vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.entityObj, (int)14, (int)3, (Vec3d)new Vec3d((double)i + 0.5, (double)j, (double)k + 0.5));
            if (vec3d != null) {
                this.entityObj.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            }
        } else {
            this.entityObj.func_70661_as().func_75492_a((double)i + 0.5, (double)j, (double)k + 0.5, 1.0);
        }
    }

    public void func_75251_c() {
        this.insidePosX = this.doorInfo.func_179856_e().func_177958_n();
        this.insidePosZ = this.doorInfo.func_179856_e().func_177952_p();
        this.doorInfo = null;
    }

    public void setEntity(EntityCreature creature) {
        this.entityObj = creature;
    }
}

