/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import CoroUtil.forge.CULog;
import CoroUtil.packet.PacketHelper;
import CoroUtil.util.Vec3;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import modconfig.ConfigMod;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import weather2.ClientConfigData;
import weather2.CommonProxy;
import weather2.Weather;
import weather2.config.ConfigMisc;
import weather2.entity.EntityLightningBoltCustom;
import weather2.util.WeatherUtilBlock;
import weather2.util.WeatherUtilConfig;
import weather2.weathersystem.WeatherManagerBase;
import weather2.weathersystem.WeatherManagerServer;

public class ServerTickHandler {
    public static ArrayList<WeatherManagerServer> listWeatherMans;
    public static HashMap<Integer, WeatherManagerServer> lookupDimToWeatherMan;
    public static World lastWorld;
    public static NBTTagCompound worldNBT;

    public static void onTickInGame() {
        ItemStack is;
        EntityPlayer player;
        boolean derp;
        EntityPlayer player2;
        boolean testCustomLightning;
        boolean debugIMC;
        boolean testRainRequest;
        if (FMLCommonHandler.instance() == null || FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return;
        }
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        if (world != null && lastWorld != world) {
            lastWorld = world;
        }
        if (world != null && world.func_82737_E() % (long)ConfigMisc.Misc_AutoDataSaveIntervalInTicks == 0L) {
            Weather.writeOutData(false);
        }
        WorldServer[] worlds = DimensionManager.getWorlds();
        for (int i = 0; i < worlds.length; ++i) {
            WeatherManagerServer wms;
            if (!lookupDimToWeatherMan.containsKey(worlds[i].field_73011_w.getDimension()) && WeatherUtilConfig.listDimensionsWeather.contains(worlds[i].field_73011_w.getDimension())) {
                ServerTickHandler.addWorldToWeather(worlds[i].field_73011_w.getDimension());
            }
            if ((wms = lookupDimToWeatherMan.get(worlds[i].field_73011_w.getDimension())) == null) continue;
            lookupDimToWeatherMan.get(worlds[i].field_73011_w.getDimension()).tick();
        }
        if (ConfigMisc.Aesthetic_Only_Mode && !ConfigMisc.overcastMode) {
            ConfigMisc.overcastMode = true;
            CULog.dbg((String)"detected Aesthetic_Only_Mode on, setting overcast mode on");
            WeatherUtilConfig.setOvercastModeServerSide(ConfigMisc.overcastMode);
            ConfigMod.forceSaveAllFilesFromRuntimeSettings();
            ServerTickHandler.syncServerConfigToClient();
        }
        if (world.func_82737_E() % 200L == 0L) {
            ServerTickHandler.syncServerConfigToClient();
        }
        if (testRainRequest = false) {
            ImmutableList listMsgs = new ArrayList();
            listMsgs = FMLInterModComms.fetchRuntimeMessages((Object)"weather2");
            for (int i = 0; i < listMsgs.size(); ++i) {
                if (!((FMLInterModComms.IMCMessage)listMsgs.get((int)i)).key.equals("weather.raining")) continue;
                NBTTagCompound nbt = ((FMLInterModComms.IMCMessage)listMsgs.get(i)).getNBTValue();
                String replyMod = nbt.func_74779_i("replymod");
                nbt.func_74757_a("isRaining", true);
                FMLInterModComms.sendRuntimeMessage((Object)replyMod, (String)replyMod, (String)"weather.raining", (NBTTagCompound)nbt);
            }
        }
        if (debugIMC = false) {
            try {
                ImmutableList listMsgs = new ArrayList();
                listMsgs = FMLInterModComms.fetchRuntimeMessages((Object)"weather2");
                for (int i = 0; i < listMsgs.size(); ++i) {
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((testCustomLightning = false) && world.func_82737_E() % 20L == 0L && (player2 = world.func_184137_a(0.0, 0.0, 0.0, -1.0, false)) != null) {
            EntityLightningBoltCustom lightning = new EntityLightningBoltCustom((World)world, player2.field_70165_t, player2.field_70163_u, player2.field_70161_v);
            world.func_72942_c((Entity)lightning);
            lookupDimToWeatherMan.get(0).syncLightningNew((Entity)lightning, true);
        }
        if ((derp = false) && world.func_82737_E() % 2L == 0L && (player = world.func_184137_a(0.0, 0.0, 0.0, -1.0, false)) != null && (is = player.func_184582_a(EntityEquipmentSlot.MAINHAND)) != null && is.func_77973_b() instanceof ItemSpade) {
            int y = world.func_175645_m(new BlockPos(player.field_70165_t, 0.0, player.field_70161_v)).func_177956_o();
            System.out.println("y " + y);
            WeatherUtilBlock.fillAgainstWallSmoothly(player.field_70170_p, new Vec3(player.field_70165_t, (double)y + 0.5, player.field_70161_v), player.field_70759_as, 15.0f, 2.0f, CommonProxy.blockSandLayer);
        }
    }

    public static void addWorldToWeather(int dim) {
        Weather.dbg("Registering Weather2 manager for dim: " + dim);
        WeatherManagerServer wm = new WeatherManagerServer(dim);
        listWeatherMans.add(wm);
        lookupDimToWeatherMan.put(dim, wm);
        wm.readFromFile();
    }

    public static void removeWorldFromWeather(int dim) {
        Weather.dbg("Weather2: Unregistering manager for dim: " + dim);
        WeatherManagerServer wm = lookupDimToWeatherMan.get(dim);
        if (wm != null) {
            listWeatherMans.remove(wm);
            lookupDimToWeatherMan.remove(dim);
        }
        wm.writeToFile();
    }

    public static void playerClientRequestsFullSync(EntityPlayerMP entP) {
        WeatherManagerServer wm = lookupDimToWeatherMan.get(entP.field_70170_p.field_73011_w.getDimension());
        if (wm != null) {
            wm.playerJoinedWorldSyncFull(entP);
        }
    }

    public static void initialize() {
        if (lookupDimToWeatherMan.get(0) == null) {
            ServerTickHandler.addWorldToWeather(0);
        }
    }

    public static void reset() {
        Weather.dbg("Weather2: ServerTickHandler resetting");
        for (int i = 0; i < listWeatherMans.size(); ++i) {
            WeatherManagerBase wm = listWeatherMans.get(i);
            int dim = wm.dim;
            if (!lookupDimToWeatherMan.containsKey(dim)) continue;
            ServerTickHandler.removeWorldFromWeather(dim);
        }
        if (listWeatherMans.size() > 0 || lookupDimToWeatherMan.size() > 0) {
            Weather.dbg("Weather2: reset state failed to manually clear lists, listWeatherMans.size(): " + listWeatherMans.size() + " - lookupDimToWeatherMan.size(): " + lookupDimToWeatherMan.size() + " - forcing a full clear of lists");
            listWeatherMans.clear();
            lookupDimToWeatherMan.clear();
        }
    }

    public static WeatherManagerServer getWeatherSystemForDim(int dimID) {
        return lookupDimToWeatherMan.get(dimID);
    }

    public static void syncServerConfigToClient() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "ClientConfigData");
        data.func_74778_a("command", "syncUpdate");
        ClientConfigData.writeNBT(data);
        Weather.eventChannel.sendToAll(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName));
    }

    public static void syncServerConfigToClientPlayer(EntityPlayerMP player) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("packetCommand", "ClientConfigData");
        data.func_74778_a("command", "syncUpdate");
        ClientConfigData.writeNBT(data);
        Weather.eventChannel.sendTo(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName), player);
    }

    static {
        worldNBT = new NBTTagCompound();
        listWeatherMans = new ArrayList();
        lookupDimToWeatherMan = new HashMap();
    }
}

