/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import weather2.CreativeTabWeather;
import weather2.SoundRegistry;
import weather2.Weather;
import weather2.block.BlockAnemometer;
import weather2.block.BlockSandLayer;
import weather2.block.BlockTSensor;
import weather2.block.BlockTSiren;
import weather2.block.BlockTSirenManual;
import weather2.block.BlockWeatherDeflector;
import weather2.block.BlockWeatherForecast;
import weather2.block.BlockWeatherMachine;
import weather2.block.BlockWindVane;
import weather2.block.TileEntityAnemometer;
import weather2.block.TileEntityTSiren;
import weather2.block.TileEntityTSirenManual;
import weather2.block.TileEntityWeatherDeflector;
import weather2.block.TileEntityWeatherForecast;
import weather2.block.TileEntityWeatherMachine;
import weather2.block.TileEntityWindVane;
import weather2.config.ConfigMisc;
import weather2.entity.EntityIceBall;
import weather2.entity.EntityLightningBolt;
import weather2.entity.EntityLightningBoltCustom;
import weather2.entity.EntityMovingBlock;
import weather2.item.ItemPocketSand;
import weather2.item.ItemSandLayer;
import weather2.item.ItemWeatherRecipe;
import weather2.util.WeatherUtil;
import weather2.util.WeatherUtilConfig;

@Mod.EventBusSubscriber
public class CommonProxy
implements IGuiHandler {
    public static final String tornado_sensor = "tornado_sensor";
    public static final String tornado_siren = "tornado_siren";
    public static final String tornado_siren_manual = "tornado_siren_manual";
    public static final String wind_vane = "wind_vane";
    public static final String weather_forecast = "weather_forecast";
    public static final String weather_machine = "weather_machine";
    public static final String weather_deflector = "weather_deflector";
    public static final String anemometer = "anemometer";
    public static final String sand_layer = "sand_layer";
    public static final String sand_layer_placeable = "sand_layer_placeable";
    public static final String weather_item = "weather_item";
    public static final String pocket_sand = "pocket_sand";
    @GameRegistry.ObjectHolder(value="weather2:tornado_sensor")
    public static Block blockTSensor;
    @GameRegistry.ObjectHolder(value="weather2:tornado_siren_manual")
    public static Block blockTSirenManual;
    @GameRegistry.ObjectHolder(value="weather2:tornado_siren")
    public static Block blockTSiren;
    @GameRegistry.ObjectHolder(value="weather2:wind_vane")
    public static Block blockWindVane;
    @GameRegistry.ObjectHolder(value="weather2:anemometer")
    public static Block blockAnemometer;
    @GameRegistry.ObjectHolder(value="weather2:weather_forecast")
    public static Block blockWeatherForecast;
    @GameRegistry.ObjectHolder(value="weather2:weather_machine")
    public static Block blockWeatherMachine;
    @GameRegistry.ObjectHolder(value="weather2:weather_deflector")
    public static Block blockWeatherDeflector;
    @GameRegistry.ObjectHolder(value="weather2:sand_layer")
    public static Block blockSandLayer;
    @GameRegistry.ObjectHolder(value="weather2:sand_layer_placeable")
    public static Item itemSandLayer;
    @GameRegistry.ObjectHolder(value="weather2:weather_item")
    public static Item itemWeatherRecipe;
    @GameRegistry.ObjectHolder(value="weather2:pocket_sand")
    public static Item itemPocketSand;
    public static CreativeTabWeather tab;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        blockTSensor = new BlockTSensor();
        Weather.proxy.addBlock(event, blockTSensor, tornado_sensor);
        blockTSiren = new BlockTSiren();
        Weather.proxy.addBlock(event, blockTSiren, TileEntityTSiren.class, tornado_siren);
        blockTSirenManual = new BlockTSirenManual();
        Weather.proxy.addBlock(event, blockTSirenManual, TileEntityTSirenManual.class, tornado_siren_manual);
        blockWindVane = new BlockWindVane();
        Weather.proxy.addBlock(event, blockWindVane, TileEntityWindVane.class, wind_vane);
        blockWeatherForecast = new BlockWeatherForecast();
        Weather.proxy.addBlock(event, blockWeatherForecast, TileEntityWeatherForecast.class, weather_forecast);
        blockWeatherMachine = new BlockWeatherMachine();
        Weather.proxy.addBlock(event, blockWeatherMachine, TileEntityWeatherMachine.class, weather_machine);
        blockWeatherDeflector = new BlockWeatherDeflector();
        Weather.proxy.addBlock(event, blockWeatherDeflector, TileEntityWeatherDeflector.class, weather_deflector);
        blockAnemometer = new BlockAnemometer();
        Weather.proxy.addBlock(event, blockAnemometer, TileEntityAnemometer.class, anemometer);
        blockSandLayer = new BlockSandLayer();
        Weather.proxy.addBlock(event, blockSandLayer, sand_layer, false);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        itemSandLayer = new ItemSandLayer(blockSandLayer);
        Weather.proxy.addItem(event, itemSandLayer, sand_layer_placeable);
        itemWeatherRecipe = new ItemWeatherRecipe();
        Weather.proxy.addItem(event, itemWeatherRecipe, weather_item);
        itemPocketSand = new ItemPocketSand();
        Weather.proxy.addItem(event, itemPocketSand, pocket_sand);
        Weather.proxy.addItemBlock(event, (Item)new ItemBlock(blockTSensor).setRegistryName(blockTSensor.getRegistryName()));
        Weather.proxy.addItemBlock(event, (Item)new ItemBlock(blockTSiren).setRegistryName(blockTSiren.getRegistryName()));
        Weather.proxy.addItemBlock(event, (Item)new ItemBlock(blockTSirenManual).setRegistryName(blockTSirenManual.getRegistryName()));
        Weather.proxy.addItemBlock(event, (Item)new ItemBlock(blockWindVane).setRegistryName(blockWindVane.getRegistryName()));
        Weather.proxy.addItemBlock(event, (Item)new ItemBlock(blockWeatherForecast).setRegistryName(blockWeatherForecast.getRegistryName()));
        Weather.proxy.addItemBlock(event, (Item)new ItemBlock(blockWeatherMachine).setRegistryName(blockWeatherMachine.getRegistryName()));
        Weather.proxy.addItemBlock(event, (Item)new ItemBlock(blockWeatherDeflector).setRegistryName(blockWeatherDeflector.getRegistryName()));
        Weather.proxy.addItemBlock(event, (Item)new ItemBlock(blockAnemometer).setRegistryName(blockAnemometer.getRegistryName()));
    }

    public void init() {
        WeatherUtil.doBlockList();
        WeatherUtilConfig.processLists();
        SoundRegistry.init();
        this.addMapping(EntityIceBall.class, "weather_hail", 0, 128, 5, true);
        this.addMapping(EntityMovingBlock.class, "moving_block", 1, 128, 5, true);
        this.addMapping(EntityLightningBolt.class, "weather2_lightning_bolt", 2, 512, 5, true);
        this.addMapping(EntityLightningBoltCustom.class, "weather2_lightning_bolt_custom", 2, 512, 5, true);
    }

    public void preInit() {
        tab = new CreativeTabWeather("Weather2");
    }

    public void postInit() {
        ResourceLocation group = new ResourceLocation("weather2", "weather2_misc");
        if (!ConfigMisc.Item_WeatherItemNoRecipe) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("weather2", weather_item), (ResourceLocation)group, (ItemStack)new ItemStack(itemWeatherRecipe, 1), (Object[])new Object[]{"X X", "DID", "X X", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('I'), Items.field_151043_k, Character.valueOf('X'), Items.field_151042_j});
        }
        if (!ConfigMisc.Block_SensorNoRecipe) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("weather2", tornado_sensor), (ResourceLocation)group, (ItemStack)new ItemStack(blockTSensor, 1), (Object[])new Object[]{"X X", "DID", "X X", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('I'), itemWeatherRecipe, Character.valueOf('X'), Items.field_151042_j});
        }
        if (!ConfigMisc.Block_SirenNoRecipe) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("weather2", tornado_siren), (ResourceLocation)group, (ItemStack)new ItemStack(blockTSiren, 1), (Object[])new Object[]{"XDX", "DID", "XDX", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('I'), blockTSensor, Character.valueOf('X'), Items.field_151042_j});
        }
        if (!ConfigMisc.Block_SirenManualNoRecipe) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("weather2", tornado_siren_manual), (ResourceLocation)group, (ItemStack)new ItemStack(blockTSirenManual, 1), (Object[])new Object[]{"XLX", "DID", "XLX", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('I'), blockTSensor, Character.valueOf('X'), Items.field_151042_j, Character.valueOf('L'), Blocks.field_150442_at});
        }
        if (!ConfigMisc.Block_WindVaneNoRecipe) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("weather2", wind_vane), (ResourceLocation)group, (ItemStack)new ItemStack(blockWindVane, 1), (Object[])new Object[]{"X X", "DXD", "X X", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('X'), itemWeatherRecipe});
        }
        if (!ConfigMisc.Block_AnemometerNoRecipe) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("weather2", anemometer), (ResourceLocation)group, (ItemStack)new ItemStack(blockAnemometer, 1), (Object[])new Object[]{"X X", "XDX", "X X", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('X'), itemWeatherRecipe});
        }
        if (!ConfigMisc.Block_WeatherForecastNoRecipe) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("weather2", weather_forecast), (ResourceLocation)group, (ItemStack)new ItemStack(blockWeatherForecast, 1), (Object[])new Object[]{"XDX", "DID", "XDX", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('I'), Items.field_151111_aL, Character.valueOf('X'), itemWeatherRecipe});
        }
        if (!ConfigMisc.Block_WeatherMachineNoRecipe) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("weather2", weather_machine), (ResourceLocation)group, (ItemStack)new ItemStack(blockWeatherMachine, 1), (Object[])new Object[]{"XDX", "DID", "XDX", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('I'), Items.field_151045_i, Character.valueOf('X'), itemWeatherRecipe});
        }
        if (!ConfigMisc.Block_WeatherDeflectorNoRecipe) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("weather2", weather_deflector), (ResourceLocation)group, (ItemStack)new ItemStack(blockWeatherDeflector, 1), (Object[])new Object[]{"XDX", "DID", "XDX", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('I'), itemWeatherRecipe, Character.valueOf('X'), Items.field_151042_j});
        }
        if (!ConfigMisc.Block_SandLayerNoRecipe) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("weather2", sand_layer), (ResourceLocation)group, (ItemStack)new ItemStack(itemSandLayer, 64), (Object[])new Object[]{"DDD", "DID", "DDD", Character.valueOf('D'), Blocks.field_150354_m, Character.valueOf('I'), itemWeatherRecipe});
        }
        if (!ConfigMisc.Block_SandNoRecipe) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("weather2", "sand"), (ResourceLocation)group, (ItemStack)new ItemStack((Block)Blocks.field_150354_m, 1), (Object[])new Object[]{"DDD", "D D", "DDD", Character.valueOf('D'), itemSandLayer});
        }
        if (!ConfigMisc.Item_PocketSandNoRecipe) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("weather2", pocket_sand), (ResourceLocation)group, (ItemStack)new ItemStack(itemPocketSand, 8), (Object[])new Object[]{"DDD", "DID", "DDD", Character.valueOf('D'), itemSandLayer, Character.valueOf('I'), itemWeatherRecipe});
        }
    }

    public void addBlock(RegistryEvent.Register<Block> event, Block block, Class tEnt, String unlocalizedName) {
        this.addBlock(event, block, tEnt, unlocalizedName, true);
    }

    public void addBlock(RegistryEvent.Register<Block> event, Block block, Class tEnt, String unlocalizedName, boolean creativeTab) {
        this.addBlock(event, block, unlocalizedName, creativeTab);
        GameRegistry.registerTileEntity((Class)tEnt, (String)unlocalizedName);
    }

    public void addBlock(RegistryEvent.Register<Block> event, Block parBlock, String unlocalizedName) {
        this.addBlock(event, parBlock, unlocalizedName, true);
    }

    public void addBlock(RegistryEvent.Register<Block> event, Block parBlock, String unlocalizedName, boolean creativeTab) {
        parBlock.func_149663_c("weather2." + unlocalizedName);
        parBlock.setRegistryName(unlocalizedName);
        if (creativeTab) {
            parBlock.func_149647_a((CreativeTabs)tab);
        } else {
            parBlock.func_149647_a(null);
        }
        if (event != null) {
            event.getRegistry().register((IForgeRegistryEntry)parBlock);
        }
    }

    public void addItemBlock(RegistryEvent.Register<Item> event, Item item) {
        event.getRegistry().register((IForgeRegistryEntry)item);
    }

    public void addItem(RegistryEvent.Register<Item> event, Item item, String name) {
        item.func_77655_b("weather2." + name);
        item.setRegistryName(name);
        item.func_77637_a((CreativeTabs)tab);
        if (event != null) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    public void addMapping(Class par0Class, String par1Str, int entityId, int distSync, int tickRateSync, boolean syncMotion) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("weather2", par1Str), (Class)par0Class, (String)par1Str, (int)entityId, (Object)Weather.instance, (int)distSync, (int)tickRateSync, (boolean)syncMotion);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }
}

