/*
 * Decompiled with CFR 0.152.
 */
package glmath.glm.quat;

import glmath.glm.quat.Quat;
import glmath.glm.quat.funcCommon;
import glmath.glm.vec._3.Vec3;

abstract class funcGeometric
extends funcCommon {
    funcGeometric() {
    }

    public Quat angleAxis(float angle, Vec3 v) {
        return Quat.angleAxis(angle, v, (Quat)this);
    }

    public static Quat angleAxis_(float degAngle, Vec3 v) {
        return Quat.angleAxis(degAngle, v, new Quat());
    }

    public static Quat angleAxis(float degAngle, Vec3 v, Quat res) {
        float a = degAngle;
        float s = (float)Math.sin(Math.toRadians(a) * 0.5);
        res.w = (float)Math.cos(Math.toRadians(a) * 0.5);
        res.x = v.x * s;
        res.y = v.y * s;
        res.z = v.z * s;
        return res;
    }

    public float dot(Quat q) {
        return this.w * q.w + this.x * q.x + this.y * q.y + this.z * q.z;
    }

    public static float dot(Quat q1, Quat q2) {
        return q1.x * q2.x + q1.y * q2.y + q1.z * q2.z + q1.w * q2.w;
    }

    public float length() {
        return funcGeometric.length((Quat)this);
    }

    public static float length(Quat q) {
        return (float)Math.sqrt(funcGeometric.dot(q, q));
    }

    public Quat normalize() {
        return Quat.normalize((Quat)this, (Quat)this);
    }

    public Quat normalize_() {
        return Quat.normalize((Quat)this, new Quat());
    }

    public Quat normalize(Quat res) {
        return Quat.normalize((Quat)this, res);
    }

    public static Quat normalize(Quat q, Quat res) {
        float len = funcGeometric.length(q);
        if (len <= 0.0f) {
            return new Quat(1.0f, 0.0f, 0.0f, 0.0f);
        }
        float oneOverLen = 1.0f / len;
        return res.set(q.w * oneOverLen, q.x * oneOverLen, q.y * oneOverLen, q.z * oneOverLen);
    }
}

