/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.lib.ModDamageSource;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityMachineTeleporter
extends TileEntityLoadedBase
implements ITickable,
IEnergyUser,
INBTPacketReceiver {
    public long power = 0L;
    public BlockPos target = null;
    public boolean linked = false;
    public boolean prevLinked = false;
    public byte packageTimer = 0;
    public static final int consumption = 100000000;
    public static final int maxPower = 1000000000;

    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        if (compound.func_74767_n("hastarget")) {
            int x = compound.func_74762_e("x1");
            int y = compound.func_74762_e("y1");
            int z = compound.func_74762_e("z1");
            this.target = new BlockPos(x, y, z);
        }
        this.linked = compound.func_74767_n("linked");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        if (this.target != null) {
            compound.func_74757_a("hastarget", true);
            compound.func_74768_a("x1", this.target.func_177958_n());
            compound.func_74768_a("y1", this.target.func_177956_o());
            compound.func_74768_a("z1", this.target.func_177952_p());
        } else {
            compound.func_74757_a("hastarget", false);
        }
        compound.func_74757_a("linked", this.linked);
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        boolean b0 = false;
        this.packageTimer = (byte)(this.packageTimer + 1);
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            List entities = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - 0.25, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() - 0.25, (double)this.field_174879_c.func_177958_n() + 0.75, (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p() + 0.75));
            if (!entities.isEmpty()) {
                for (Entity e : entities) {
                    if (e.field_70173_aa < 10) continue;
                    this.teleport(e);
                    b0 = true;
                }
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            this.networkPack();
            this.prevLinked = this.linked;
        }
        if (b0) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.PORTAL, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.1, 0.5, new int[0]);
        }
    }

    public void networkPack() {
        if (this.linked != this.prevLinked || this.packageTimer == 0) {
            NBTTagCompound data = new NBTTagCompound();
            if (this.target != null) {
                data.func_74768_a("targetX", this.target.func_177958_n());
                data.func_74768_a("targetY", this.target.func_177956_o());
                data.func_74768_a("targetZ", this.target.func_177952_p());
            }
            data.func_74757_a("linked", this.linked);
            INBTPacketReceiver.networkPack(this, data, 150);
            this.packageTimer = (byte)40;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        if (data.func_74764_b("targetX")) {
            this.target = new BlockPos(data.func_74762_e("targetX"), data.func_74762_e("targetY"), data.func_74762_e("targetZ"));
        }
        if (data.func_74764_b("linked")) {
            this.linked = data.func_74767_n("linked");
        }
    }

    public void teleport(Entity entity) {
        if (this.power < 100000000L) {
            return;
        }
        this.field_145850_b.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (this.target == null && !this.linked) {
            entity.func_70097_a(ModDamageSource.teleporter, 10000.0f);
        } else {
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).func_70634_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 1.6 + entity.func_70033_W(), (double)this.target.func_177952_p() + 0.5);
            } else {
                entity.func_70080_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 1.6 + entity.func_70033_W(), (double)this.target.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
            }
            this.field_145850_b.func_184133_a(null, this.target, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        this.power -= 100000000L;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000000L;
    }
}

