/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineITER;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityITER;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachinePlasmaHeater
extends TileEntityMachineBase
implements ITickable,
IFluidHandler,
ITankPacketAcceptor,
IEnergyUser {
    public long power;
    public static final long maxPower = 10000000000L;
    public FluidTank[] tanks;
    public Fluid[] types = new Fluid[]{ModForgeFluids.deuterium, ModForgeFluids.tritium};
    public FluidTank plasma;
    public Fluid plasmaType = ModForgeFluids.plasma_dt;

    public TileEntityMachinePlasmaHeater() {
        super(1);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(16000);
        this.tanks[1] = new FluidTank(16000);
        this.plasma = new FluidTank(64000);
    }

    @Override
    public String getName() {
        return "container.plasmaHeater";
    }

    public void func_73660_a() {
        this.updateType();
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.updateConnections();
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 10000000000L);
            int maxConv = 50;
            int powerReq = 100000;
            int convert = Math.min(this.tanks[0].getFluidAmount(), this.tanks[1].getFluidAmount());
            convert = Math.min(convert, (this.plasma.getCapacity() - this.plasma.getFluidAmount()) * 2);
            convert = Math.min(convert, maxConv);
            convert = (int)Math.min((long)convert, this.power / (long)powerReq);
            if ((convert = Math.max(0, convert)) > 0 && this.plasmaType != null) {
                this.tanks[0].drain(convert, true);
                this.tanks[1].drain(convert, true);
                this.plasma.fill(new FluidStack(this.plasmaType, convert * 2), true);
                this.power -= (long)(convert * powerReq);
                this.func_70296_d();
            }
            ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10).getOpposite();
            int dist = 11;
            if (this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n() + dir.offsetX * dist, this.field_174879_c.func_177956_o() + 2, this.field_174879_c.func_177952_p() + dir.offsetZ * dist)).func_177230_c() == ModBlocks.iter) {
                TileEntity te;
                Fluid type;
                int[] pos1 = ((MachineITER)ModBlocks.iter).findCore((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177958_n() + dir.offsetX * dist, this.field_174879_c.func_177956_o() + 2, this.field_174879_c.func_177952_p() + dir.offsetZ * dist);
                Fluid fluid = type = this.plasma.getFluid() == null ? null : this.plasma.getFluid().getFluid();
                if (pos1 != null && (te = this.field_145850_b.func_175625_s(new BlockPos(pos1[0], pos1[1], pos1[2]))) instanceof TileEntityITER) {
                    TileEntityITER iter = (TileEntityITER)te;
                    if (iter.plasma.getFluidAmount() == 0 && type != null) {
                        iter.plasmaType = type;
                    }
                    if (iter.isOn && type != null && iter.plasmaType == type) {
                        int toLoad = Math.min(iter.plasma.getCapacity() - iter.plasma.getFluidAmount(), this.plasma.getFluidAmount());
                        toLoad = Math.min(toLoad, 40);
                        this.plasma.drain(toLoad, true);
                        iter.plasma.fill(new FluidStack(type, toLoad), true);
                        this.func_70296_d();
                        iter.func_70296_d();
                    }
                }
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks[0], this.tanks[1], this.plasma), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            this.networkPack(data, 50);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
    }

    private void updateConnections() {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection side = dir.getRotation(ForgeDirection.UP);
        for (int i = 1; i < 4; ++i) {
            for (int j = -1; j < 2; ++j) {
                this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(side.offsetX * j + dir.offsetX * 2, i, side.offsetZ * j + dir.offsetZ * 2), j < 0 ? ForgeDirection.DOWN : ForgeDirection.UP);
            }
        }
    }

    private void updateType() {
        this.types[0] = this.tanks[0].getFluid() == null ? null : this.tanks[0].getFluid().getFluid();
        this.types[1] = this.tanks[1].getFluid() == null ? null : this.tanks[1].getFluid().getFluid();
        List<Fluid> types = Arrays.asList(this.types[0], this.types[1]);
        if (types.contains(ModForgeFluids.deuterium) && types.contains(ModForgeFluids.tritium)) {
            this.plasmaType = ModForgeFluids.plasma_dt;
            return;
        }
        if (types.contains(ModForgeFluids.deuterium) && types.contains(ModForgeFluids.hydrogen)) {
            this.plasmaType = ModForgeFluids.plasma_hd;
            return;
        }
        if (types.contains(ModForgeFluids.hydrogen) && types.contains(ModForgeFluids.tritium)) {
            this.plasmaType = ModForgeFluids.plasma_ht;
            return;
        }
        if (types.contains(ModForgeFluids.xenon) && types.contains(ModForgeFluids.mercury)) {
            this.plasmaType = ModForgeFluids.plasma_xm;
            return;
        }
        if (types.contains(ModForgeFluids.puf6) && types.contains(ModForgeFluids.tritium)) {
            this.plasmaType = ModForgeFluids.plasma_put;
            return;
        }
        if (types.contains(ModForgeFluids.balefire) && types.contains(ModForgeFluids.amat)) {
            this.plasmaType = ModForgeFluids.plasma_bf;
            return;
        }
        this.plasmaType = null;
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 10000000000L;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("fuel_1", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("fuel_2", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("plasma", (NBTBase)this.plasma.writeToNBT(new NBTTagCompound()));
        if (this.plasmaType != null) {
            compound.func_74778_a("plasma_type", this.plasmaType.getName());
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tanks[0].readFromNBT(compound.func_74775_l("fuel_1"));
        this.tanks[1].readFromNBT(compound.func_74775_l("fuel_2"));
        this.plasma.readFromNBT(compound.func_74775_l("plasma"));
        this.plasmaType = FluidRegistry.getFluid((String)compound.func_74779_i("plasma_type"));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 10000000000L;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.plasma.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null) {
            if (this.tanks[0].getFluid() == null || this.tanks[0].getFluid().getFluid() == resource.getFluid()) {
                if (this.tanks[1].getFluid() != null && this.tanks[1].getFluid().getFluid() == resource.getFluid()) {
                    return this.tanks[1].fill(resource, doFill);
                }
                return this.tanks[0].fill(resource, doFill);
            }
            if (this.tanks[1].getFluid() == null || this.tanks[1].getFluid().getFluid() == resource.getFluid()) {
                return this.tanks[1].fill(resource, doFill);
            }
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 3) {
            this.tanks[0].readFromNBT(tags[0]);
            this.tanks[1].readFromNBT(tags[1]);
            this.plasma.readFromNBT(tags[2]);
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

