/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.inventory.ChemplantRecipes;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.InventoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public abstract class TileEntityMachineChemplantBase
extends TileEntityMachineBase
implements IEnergyUser,
ITickable,
IFluidHandler {
    public long power;
    public int[] progress;
    public int[] maxProgress;
    public boolean isProgressing;
    public TypedFluidTank[] tanks;
    int consumption = 100;
    int speed = 100;

    public TileEntityMachineChemplantBase(int scount) {
        super(scount);
        int count = this.getRecipeCount();
        this.progress = new int[count];
        this.maxProgress = new int[count];
        this.tanks = new TypedFluidTank[4 * count];
        for (int idx = 0; idx < this.tanks.length; ++idx) {
            this.tanks[idx] = new TypedFluidTank(null, new FluidTank(this.getTankCapacity()));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int count = this.getRecipeCount();
            this.isProgressing = false;
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, this.getMaxPower());
            for (int idx = 0; idx < count; ++idx) {
                this.loadItems(idx);
                this.unloadItems(idx);
            }
            for (int i = 0; i < count; ++i) {
                if (!this.canProcess(i)) {
                    this.progress[i] = 0;
                    continue;
                }
                this.isProgressing = true;
                this.process(i);
            }
        }
    }

    protected boolean canProcess(int index) {
        int templateIdx = this.getTemplateIndex(index);
        ItemStack templateStack = this.inventory.getStackInSlot(templateIdx);
        if (templateStack.func_190926_b() || templateStack.func_77973_b() != ModItems.chemistry_template) {
            return false;
        }
        if (!ChemplantRecipes.hasRecipe(templateStack)) {
            return false;
        }
        List<RecipesCommon.AStack> itemInputs = ChemplantRecipes.getChemInputFromTempate(templateStack);
        FluidStack[] fluidInputs = ChemplantRecipes.getFluidInputFromTempate(templateStack);
        ItemStack[] itemOutputs = ChemplantRecipes.getChemOutputFromTempate(templateStack);
        FluidStack[] fluidOutputs = ChemplantRecipes.getFluidOutputFromTempate(templateStack);
        this.setupTanks(fluidInputs, fluidOutputs, index);
        if (this.power < (long)this.consumption) {
            return false;
        }
        if (!this.hasRequiredFluids(fluidInputs, index)) {
            return false;
        }
        if (!this.hasSpaceForFluids(fluidOutputs, index)) {
            return false;
        }
        if (!this.hasRequiredItems(itemInputs, index)) {
            return false;
        }
        return this.hasSpaceForItems(itemOutputs, index);
    }

    private void setupTanks(@Nullable FluidStack[] inputs, @Nullable FluidStack[] outputs, int index) {
        int i;
        if (inputs != null) {
            for (i = 0; i < inputs.length; ++i) {
                if (inputs[i] == null) continue;
                this.tanks[index * 4 + i].setType(inputs[i].getFluid());
            }
        }
        if (outputs != null) {
            for (i = 0; i < outputs.length; ++i) {
                if (outputs[i] == null) continue;
                this.tanks[index * 4 + i + 2].setType(outputs[i].getFluid());
            }
        }
    }

    private boolean hasRequiredFluids(@Nullable FluidStack[] inputs, int index) {
        if (inputs == null) {
            return true;
        }
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null || this.tanks[index * 4 + i].tank.getFluidAmount() >= inputs[i].amount) continue;
            return false;
        }
        return true;
    }

    private boolean hasSpaceForFluids(@Nullable FluidStack[] inputs, int index) {
        if (inputs == null) {
            return true;
        }
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null || this.tanks[index * 4 + i + 2].tank.getFluidAmount() + inputs[i].amount <= this.tanks[index * 4 + i + 2].tank.getCapacity()) continue;
            return false;
        }
        return true;
    }

    private boolean hasRequiredItems(@Nullable List<RecipesCommon.AStack> inputs, int index) {
        if (inputs == null) {
            return true;
        }
        int[] indices = this.getSlotIndicesFromIndex(index);
        return InventoryUtil.doesArrayHaveIngredients((IItemHandler)this.inventory, indices[0], indices[1], inputs);
    }

    private boolean hasSpaceForItems(@Nullable ItemStack[] outputs, int index) {
        if (outputs == null) {
            return true;
        }
        int[] indices = this.getSlotIndicesFromIndex(index);
        return InventoryUtil.doesArrayHaveSpace((IItemHandler)this.inventory, indices[2], indices[3], outputs);
    }

    protected void process(int index) {
        this.power -= (long)this.consumption;
        int n = index;
        this.progress[n] = this.progress[n] + 1;
        if (this.inventory.getStackInSlot(0).func_77973_b() == ModItems.meteorite_sword_machined) {
            this.inventory.setStackInSlot(0, new ItemStack(ModItems.meteorite_sword_machined));
        }
        int templateIdx = this.getTemplateIndex(index);
        ItemStack templateStack = this.inventory.getStackInSlot(templateIdx);
        List<RecipesCommon.AStack> itemInputs = ChemplantRecipes.getChemInputFromTempate(templateStack);
        FluidStack[] fluidInputs = ChemplantRecipes.getFluidInputFromTempate(templateStack);
        ItemStack[] itemOutputs = ChemplantRecipes.getChemOutputFromTempate(templateStack);
        FluidStack[] fluidOutputs = ChemplantRecipes.getFluidOutputFromTempate(templateStack);
        this.maxProgress[index] = ChemplantRecipes.getProcessTime(templateStack) * this.speed / 100;
        if (this.progress[index] >= this.maxProgress[index]) {
            this.consumeFluids(fluidInputs, index);
            this.produceFluids(fluidOutputs, index);
            this.consumeItems(itemInputs, index);
            this.produceItems(itemOutputs, index);
            this.progress[index] = 0;
            this.func_70296_d();
        }
    }

    private void consumeFluids(@Nullable FluidStack[] inputs, int index) {
        if (inputs == null) {
            return;
        }
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) continue;
            this.tanks[index * 4 + i].tank.drain(inputs[i].amount, true);
        }
    }

    private void produceFluids(@Nullable FluidStack[] outputs, int index) {
        if (outputs == null) {
            return;
        }
        for (int i = 0; i < outputs.length; ++i) {
            if (outputs[i] == null) continue;
            this.tanks[index * 4 + i + 2].tank.fill(outputs[i], true);
        }
    }

    private void consumeItems(@Nullable List<RecipesCommon.AStack> inputs, int index) {
        if (inputs == null) {
            return;
        }
        int[] indices = this.getSlotIndicesFromIndex(index);
        for (RecipesCommon.AStack in : inputs) {
            if (in == null) continue;
            InventoryUtil.tryConsumeAStack((IItemHandlerModifiable)this.inventory, indices[0], indices[1], in);
        }
    }

    private void produceItems(@Nullable ItemStack[] outputs, int index) {
        if (outputs == null) {
            return;
        }
        int[] indices = this.getSlotIndicesFromIndex(index);
        for (ItemStack out : outputs) {
            if (out == null) continue;
            InventoryUtil.tryAddItemToInventory((IItemHandlerModifiable)this.inventory, indices[2], indices[3], out.func_77946_l());
        }
    }

    private void loadItems(int index) {
        int templateIdx = this.getTemplateIndex(index);
        ItemStack templateStack = this.inventory.getStackInSlot(templateIdx);
        if (templateStack.func_190926_b() || templateStack.func_77973_b() != ModItems.chemistry_template) {
            return;
        }
        if (ChemplantRecipes.hasRecipe(templateStack)) {
            List<RecipesCommon.AStack> itemInputs = ChemplantRecipes.getChemInputFromTempate(templateStack);
            if (itemInputs == null) {
                return;
            }
            BlockPos[] positions = this.getInputPositions();
            int[] indices = this.getSlotIndicesFromIndex(index);
            for (BlockPos pos : positions) {
                int[] slots;
                TileEntity te = this.field_145850_b.func_175625_s(pos);
                if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH)) continue;
                IItemHandler cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
                if (te instanceof TileEntityMachineBase) {
                    ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10).getOpposite();
                    slots = ((TileEntityMachineBase)te).getAccessibleSlotsFromSide(dir.toEnumFacing());
                    this.tryFillAssemblerCap(cap, slots, (TileEntityMachineBase)te, indices[0], indices[1], itemInputs);
                    continue;
                }
                slots = new int[cap.getSlots()];
                for (int i = 0; i < slots.length; ++i) {
                    slots[i] = i;
                }
                this.tryFillAssemblerCap(cap, slots, null, indices[0], indices[1], itemInputs);
            }
        }
    }

    private void unloadItems(int index) {
        BlockPos[] positions = this.getOutputPositions();
        int[] indices = this.getSlotIndicesFromIndex(index);
        for (BlockPos pos : positions) {
            TileEntity te = this.field_145850_b.func_175625_s(pos);
            if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH)) continue;
            IItemHandler cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
            for (int i = indices[2]; i <= indices[3]; ++i) {
                this.tryFillContainerCap(cap, i);
            }
        }
    }

    public boolean tryFillContainerCap(IItemHandler chest, int slot) {
        if (this.inventory.getStackInSlot(slot).func_190926_b()) {
            return false;
        }
        for (int i = 0; i < chest.getSlots(); ++i) {
            ItemStack outputStack = this.inventory.getStackInSlot(slot).func_77946_l();
            if (outputStack.func_190926_b()) {
                return false;
            }
            ItemStack chestItem = chest.getStackInSlot(i).func_77946_l();
            if (!chestItem.func_190926_b() && (!Library.areItemStacksCompatible(outputStack, chestItem, false) || chestItem.func_190916_E() >= chestItem.func_77976_d())) continue;
            this.inventory.getStackInSlot(slot).func_190918_g(1);
            outputStack.func_190920_e(1);
            chest.insertItem(i, outputStack, false);
            return true;
        }
        return false;
    }

    public boolean tryFillAssemblerCap(IItemHandler container, int[] allowedSlots, TileEntityMachineBase te, int minSlot, int maxSlot, List<RecipesCommon.AStack> recipeIngredients) {
        if (allowedSlots.length < 1) {
            return false;
        }
        if (recipeIngredients == null) {
            return false;
        }
        HashMap<Integer, ItemStack> itemStackMap = new HashMap<Integer, ItemStack>();
        for (int slot : allowedSlots) {
            container.getStackInSlot(slot);
            if (container.getStackInSlot(slot).func_190926_b()) continue;
            itemStackMap.put(slot, container.getStackInSlot(slot).func_77946_l());
        }
        if (itemStackMap.size() == 0) {
            return false;
        }
        block1: for (int ig = 0; ig < recipeIngredients.size(); ++ig) {
            RecipesCommon.AStack nextIngredient = recipeIngredients.get(ig).copy();
            int ingredientSlot = this.getValidSlot(nextIngredient, minSlot, maxSlot);
            if (ingredientSlot < minSlot) continue;
            int possibleAmount = this.inventory.getStackInSlot(ingredientSlot).func_77976_d() - this.inventory.getStackInSlot(ingredientSlot).func_190916_E();
            if (possibleAmount == 0) {
                System.out.println("This should never happen method getValidSlot broke");
                continue;
            }
            for (Map.Entry set : itemStackMap.entrySet()) {
                ItemStack stack = (ItemStack)set.getValue();
                int slot = (Integer)set.getKey();
                ItemStack compareStack = stack.func_77946_l();
                compareStack.func_190920_e(1);
                if (!this.isItemAcceptable(nextIngredient.getStack(), compareStack)) continue;
                int foundCount = Math.min(stack.func_190916_E(), possibleAmount);
                if (te != null && !te.canExtractItem(slot, stack, foundCount)) continue;
                if (foundCount <= 0) continue block1;
                possibleAmount -= foundCount;
                container.extractItem(slot, foundCount, false);
                this.inventory.getStackInSlot(ingredientSlot);
                if (this.inventory.getStackInSlot(ingredientSlot).func_190926_b()) {
                    stack.func_190920_e(foundCount);
                    this.inventory.setStackInSlot(ingredientSlot, stack);
                    continue;
                }
                this.inventory.getStackInSlot(ingredientSlot).func_190917_f(foundCount);
            }
        }
        return true;
    }

    private int getValidSlot(RecipesCommon.AStack nextIngredient, int minSlot, int maxSlot) {
        int firstFreeSlot = -1;
        int stackCount = (int)Math.ceil((float)nextIngredient.count() / 64.0f);
        int stacksFound = 0;
        nextIngredient = nextIngredient.singulize();
        for (int k = minSlot; k <= maxSlot; ++k) {
            if (stacksFound < stackCount) {
                ItemStack assStack = this.inventory.getStackInSlot(k).func_77946_l();
                if (assStack.func_190926_b()) {
                    if (firstFreeSlot >= minSlot) continue;
                    firstFreeSlot = k;
                    continue;
                }
                assStack.func_190920_e(1);
                if (!nextIngredient.isApplicable(assStack)) continue;
                if (this.inventory.getStackInSlot(k).func_190916_E() < assStack.func_77976_d()) {
                    return k;
                }
                ++stacksFound;
                continue;
            }
            return -1;
        }
        if (firstFreeSlot < minSlot) {
            return -2;
        }
        return firstFreeSlot;
    }

    public boolean isItemAcceptable(ItemStack stack1, ItemStack stack2) {
        if (stack1 != null && stack2 != null && stack1.func_77973_b() != Items.field_190931_a && stack1.func_77973_b() != Items.field_190931_a) {
            if (Library.areItemStacksCompatible(stack1, stack2)) {
                return true;
            }
            int[] ids1 = OreDictionary.getOreIDs((ItemStack)stack1);
            int[] ids2 = OreDictionary.getOreIDs((ItemStack)stack2);
            if (ids1.length > 0 && ids2.length > 0) {
                for (int i = 0; i < ids1.length; ++i) {
                    for (int j = 0; j < ids2.length; ++j) {
                        if (ids1[i] != ids2[j]) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    protected List<TypedFluidTank> inTanks() {
        ArrayList<TypedFluidTank> inTanks = new ArrayList<TypedFluidTank>();
        for (int i = 0; i < this.tanks.length; ++i) {
            if (i % 4 >= 2) continue;
            inTanks.add(this.tanks[i]);
        }
        return inTanks;
    }

    public List<TypedFluidTank> outTanks() {
        ArrayList<TypedFluidTank> outTanks = new ArrayList<TypedFluidTank>();
        for (int i = 0; i < this.tanks.length; ++i) {
            if (i % 4 <= 1) continue;
            outTanks.add(this.tanks[i]);
        }
        return outTanks;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        int i;
        if (resource.amount <= 0) {
            return null;
        }
        ArrayList<TypedFluidTank> send = new ArrayList<TypedFluidTank>();
        for (TypedFluidTank tank : this.outTanks()) {
            if (tank.type != resource.getFluid()) continue;
            send.add(tank);
        }
        if (send.isEmpty()) {
            return null;
        }
        int offer = 0;
        ArrayList<Integer> weight = new ArrayList<Integer>();
        for (TypedFluidTank tank : send) {
            int drainWeight = tank.tank.getFluidAmount();
            if (drainWeight < 0) {
                drainWeight = 0;
            }
            offer += drainWeight;
            weight.add(drainWeight);
        }
        if (offer <= 0) {
            return null;
        }
        if (!doDrain) {
            return new FluidStack(resource.getFluid(), offer);
        }
        int needed = resource.amount;
        for (i = 0; i < send.size(); ++i) {
            TypedFluidTank tank = (TypedFluidTank)send.get(i);
            int fillWeight = (Integer)weight.get(i);
            int part = (int)((float)resource.amount * ((float)fillWeight / (float)offer));
            FluidStack drained = tank.tank.drain(part, true);
            if (drained == null) continue;
            needed -= drained.amount;
        }
        for (i = 0; i < 100 && needed > 0 && i < send.size(); ++i) {
            TypedFluidTank tank = (TypedFluidTank)send.get(i);
            if (tank.tank.getFluidAmount() <= 0) continue;
            int total = Math.min(tank.tank.getFluidAmount(), needed);
            tank.tank.drain(total, true);
            needed -= total;
        }
        int drained = resource.amount - needed;
        if (drained > 0) {
            return new FluidStack(resource.getFluid(), drained);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        for (TypedFluidTank tank : this.outTanks()) {
            if (tank.type == null || tank.tank.getFluidAmount() <= 0) continue;
            return tank.tank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        int total = resource.amount;
        if (total <= 0) {
            return 0;
        }
        Fluid inType = resource.getFluid();
        ArrayList<TypedFluidTank> rec = new ArrayList<TypedFluidTank>();
        for (TypedFluidTank tank : this.inTanks()) {
            if (tank.type != inType) continue;
            rec.add(tank);
        }
        if (rec.isEmpty()) {
            return 0;
        }
        int demand = 0;
        ArrayList<Integer> weight = new ArrayList<Integer>();
        for (TypedFluidTank tank : rec) {
            int fillWeight = tank.tank.getCapacity() - tank.tank.getFluidAmount();
            if (fillWeight < 0) {
                fillWeight = 0;
            }
            demand += fillWeight;
            weight.add(fillWeight);
        }
        if (demand <= 0) {
            return 0;
        }
        if (!doFill) {
            return demand;
        }
        int fluidUsed = 0;
        for (int i = 0; i < rec.size(); ++i) {
            TypedFluidTank tank = (TypedFluidTank)rec.get(i);
            int fillWeight = (Integer)weight.get(i);
            int part = (int)((float)Math.min(total, demand) * (float)fillWeight / (float)demand);
            fluidUsed += tank.tank.fill(new FluidStack(resource.getFluid(), part), true);
        }
        return fluidUsed;
    }

    protected NBTTagList serializeTanks() {
        NBTTagList tankList = new NBTTagList();
        for (int i = 0; i < this.tanks.length; ++i) {
            NBTTagCompound tank = new NBTTagCompound();
            this.tanks[i].writeToNBT(tank);
            tank.func_74774_a("index", (byte)i);
            tankList.func_74742_a((NBTBase)tank);
        }
        return tankList;
    }

    protected void deserializeTanks(NBTTagList tankList) {
        for (int i = 0; i < tankList.func_74745_c(); ++i) {
            NBTTagCompound tank = tankList.func_150305_b(i);
            byte index = tank.func_74771_c("index");
            this.tanks[index].readFromNBT(tank);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("power", this.power);
        nbt.func_74783_a("progress", this.progress);
        nbt.func_74782_a("tanks", (NBTBase)this.serializeTanks());
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74759_k("progress");
        if (this.progress.length == 0) {
            this.progress = new int[this.getRecipeCount()];
        }
        NBTTagList tankList = nbt.func_150295_c("tanks", 10);
        this.deserializeTanks(tankList);
    }

    public abstract int getRecipeCount();

    public abstract int getTankCapacity();

    public abstract int getTemplateIndex(int var1);

    public abstract int[] getSlotIndicesFromIndex(int var1);

    public abstract BlockPos[] getInputPositions();

    public abstract BlockPos[] getOutputPositions();

    public static class TypedFluidTank {
        protected Fluid type;
        protected final FluidTank tank;

        protected TypedFluidTank(Fluid type, FluidTank tank) {
            this.type = type;
            this.tank = tank;
        }

        public void setType(@Nullable Fluid type) {
            if (type == null) {
                this.tank.setFluid(null);
            }
            if (this.type == type) {
                return;
            }
            this.type = type;
            this.tank.setFluid(null);
        }

        public void writeToNBT(NBTTagCompound nbt) {
            if (this.type != null) {
                nbt.func_74778_a("type", this.type.getName());
            }
            this.tank.writeToNBT(nbt);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("type")) {
                this.type = FluidRegistry.getFluid((String)nbt.func_74779_i("type"));
            }
            this.tank.readFromNBT(nbt);
        }

        public FluidTank getTank() {
            return this.tank;
        }

        public Fluid getType() {
            return this.type;
        }
    }
}

