/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEFFPacket;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.TileEntityLoadedBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityForceField
extends TileEntityLoadedBase
implements ITickable,
IEnergyUser {
    public ItemStackHandler inventory;
    public int health = 100;
    public int maxHealth = 100;
    public long power;
    public int powerCons;
    public int cooldown = 0;
    public int blink = 0;
    public float radius = 16.0f;
    public boolean isOn = false;
    public int color = 50943;
    public final int baseCon = 1000;
    public final int radCon = 500;
    public final int shCon = 250;
    public static final long maxPower = 1000000L;
    private String customName;
    List<Entity> outside = new ArrayList<Entity>();
    List<Entity> inside = new ArrayList<Entity>();

    public TileEntityForceField() {
        this.inventory = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                TileEntityForceField.this.func_70296_d();
                super.onContentsChanged(slot);
            }
        };
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.forceField";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("powerTime");
        this.health = nbt.func_74762_e("health");
        this.maxHealth = nbt.func_74762_e("maxHealth");
        this.cooldown = nbt.func_74762_e("cooldown");
        this.blink = nbt.func_74762_e("blink");
        this.radius = nbt.func_74760_g("radius");
        this.isOn = nbt.func_74767_n("isOn");
        if (nbt.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        }
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74768_a("health", this.health);
        nbt.func_74768_a("maxHealth", this.maxHealth);
        nbt.func_74768_a("cooldown", this.cooldown);
        nbt.func_74768_a("blink", this.blink);
        nbt.func_74776_a("radius", this.radius);
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public int getHealthScaled(int i) {
        return this.health * i / Math.max(1, this.maxHealth);
    }

    public long getPowerScaled(long i) {
        return this.power * i / Math.max(1L, 1000000L);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            int rStack = 0;
            int hStack = 0;
            this.radius = 16.0f;
            this.maxHealth = 100;
            if (this.inventory.getStackInSlot(1).func_77973_b() == ModItems.upgrade_radius) {
                rStack = this.inventory.getStackInSlot(1).func_190916_E();
                this.radius += (float)(rStack * 16);
            }
            if (this.inventory.getStackInSlot(2).func_77973_b() == ModItems.upgrade_health) {
                hStack = this.inventory.getStackInSlot(2).func_190916_E();
                this.maxHealth += hStack * 50;
            }
            this.powerCons = this.baseCon + rStack * this.radCon + hStack * this.shCon;
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 1000000L);
            if (this.blink > 0) {
                --this.blink;
                this.color = 0xFF0000;
            } else {
                this.color = 50943;
            }
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            if (this.health < this.maxHealth) {
                this.health += this.maxHealth / 50;
            }
            if (this.health > this.maxHealth) {
                this.health = this.maxHealth;
            }
        }
        if (this.isOn && this.cooldown == 0 && this.health > 0 && this.power >= (long)this.powerCons) {
            this.doField(this.radius);
            if (!this.field_145850_b.field_72995_K) {
                this.power -= (long)this.powerCons;
                this.func_70296_d();
            }
        } else {
            this.outside.clear();
            this.inside.clear();
        }
        if (!this.field_145850_b.field_72995_K && this.power < (long)this.powerCons) {
            this.power = 0L;
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new TEFFPacket(this.field_174879_c, this.radius, this.health, this.maxHealth, (int)this.power, this.isOn, this.color, this.cooldown), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
        }
    }

    private int impact(Entity e) {
        double mass = e.field_70131_O * e.field_70130_N * e.field_70130_N;
        double speed = this.getMotionWithFallback(e);
        return (int)(mass * speed * 50.0);
    }

    private void damage(int ouch) {
        this.health -= ouch;
        if (ouch >= this.maxHealth / 250) {
            this.blink = 5;
        }
        if (this.health <= 0) {
            this.health = 0;
            this.cooldown = (int)(100.0f + this.radius);
        }
    }

    private void doField(float rad) {
        ArrayList<Entity> oLegacy = new ArrayList<Entity>(this.outside);
        ArrayList<Entity> iLegacy = new ArrayList<Entity>(this.inside);
        this.outside.clear();
        this.inside.clear();
        List list = this.field_145850_b.func_72839_b(null, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.5 - (double)(rad + 25.0f), (double)this.field_174879_c.func_177956_o() + 0.5 - (double)(rad + 25.0f), (double)this.field_174879_c.func_177952_p() + 0.5 - (double)(rad + 25.0f), (double)this.field_174879_c.func_177958_n() + 0.5 + (double)(rad + 25.0f), (double)this.field_174879_c.func_177956_o() + 0.5 + (double)(rad + 25.0f), (double)this.field_174879_c.func_177952_p() + 0.5 + (double)(rad + 25.0f)));
        for (Entity entity : list) {
            double mo;
            double mz;
            double my;
            double mx;
            Vec3 vec;
            boolean out;
            if (entity instanceof EntityPlayer || entity instanceof EntityItem) continue;
            double dist = Math.sqrt(Math.pow((double)this.field_174879_c.func_177958_n() + 0.5 - entity.field_70165_t, 2.0) + Math.pow((double)this.field_174879_c.func_177956_o() + 0.5 - entity.field_70163_u, 2.0) + Math.pow((double)this.field_174879_c.func_177952_p() + 0.5 - entity.field_70161_v, 2.0));
            boolean bl = out = dist > (double)rad;
            if (!oLegacy.contains(entity) && !iLegacy.contains(entity)) {
                if (out) {
                    this.outside.add(entity);
                    continue;
                }
                this.inside.add(entity);
                continue;
            }
            if (oLegacy.contains(entity) && !out) {
                vec = Vec3.createVectorHelper((double)this.field_174879_c.func_177958_n() + 0.5 - entity.field_70165_t, (double)this.field_174879_c.func_177956_o() + 0.5 - entity.field_70163_u, (double)this.field_174879_c.func_177952_p() + 0.5 - entity.field_70161_v);
                vec = vec.normalize();
                mx = -vec.xCoord * (double)(rad + 1.0f);
                my = -vec.yCoord * (double)(rad + 1.0f);
                mz = -vec.zCoord * (double)(rad + 1.0f);
                entity.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5 + mx, (double)this.field_174879_c.func_177956_o() + 0.5 + my, (double)this.field_174879_c.func_177952_p() + 0.5 + mz, 0.0f, 0.0f);
                mo = Math.sqrt(Math.pow(entity.field_70159_w, 2.0) + Math.pow(entity.field_70181_x, 2.0) + Math.pow(entity.field_70179_y, 2.0));
                entity.field_70159_w = vec.xCoord * -mo;
                entity.field_70181_x = vec.yCoord * -mo;
                entity.field_70179_y = vec.zCoord * -mo;
                entity.field_70165_t -= entity.field_70159_w;
                entity.field_70163_u -= entity.field_70181_x;
                entity.field_70161_v -= entity.field_70179_y;
                this.field_145850_b.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, HBMSoundHandler.sparkShoot, SoundCategory.BLOCKS, 2.5f, 1.0f);
                this.outside.add(entity);
                if (this.field_145850_b.field_72995_K) continue;
                this.damage(this.impact(entity));
                continue;
            }
            if (iLegacy.contains(entity) && out) {
                vec = Vec3.createVectorHelper((double)this.field_174879_c.func_177958_n() + 0.5 - entity.field_70165_t, (double)this.field_174879_c.func_177956_o() + 0.5 - entity.field_70163_u, (double)this.field_174879_c.func_177952_p() + 0.5 - entity.field_70161_v);
                vec = vec.normalize();
                mx = -vec.xCoord * (double)(rad - 1.0f);
                my = -vec.yCoord * (double)(rad - 1.0f);
                mz = -vec.zCoord * (double)(rad - 1.0f);
                entity.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5 + mx, (double)this.field_174879_c.func_177956_o() + 0.5 + my, (double)this.field_174879_c.func_177952_p() + 0.5 + mz, 0.0f, 0.0f);
                mo = Math.sqrt(Math.pow(entity.field_70159_w, 2.0) + Math.pow(entity.field_70181_x, 2.0) + Math.pow(entity.field_70179_y, 2.0));
                entity.field_70159_w = vec.xCoord * mo;
                entity.field_70181_x = vec.yCoord * mo;
                entity.field_70179_y = vec.zCoord * mo;
                entity.field_70165_t -= entity.field_70159_w;
                entity.field_70163_u -= entity.field_70181_x;
                entity.field_70161_v -= entity.field_70179_y;
                this.field_145850_b.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, HBMSoundHandler.sparkShoot, SoundCategory.BLOCKS, 2.5f, 1.0f);
                this.inside.add(entity);
                if (this.field_145850_b.field_72995_K) continue;
                this.damage(this.impact(entity));
                continue;
            }
            if (out) {
                this.outside.add(entity);
                continue;
            }
            this.inside.add(entity);
        }
    }

    private double getMotionWithFallback(Entity e) {
        Vec3 v1 = Vec3.createVectorHelper(e.field_70159_w, e.field_70181_x, e.field_70179_y);
        Vec3 v2 = Vec3.createVectorHelper(e.field_70165_t - e.field_70167_r, e.field_70163_u - e.field_70167_r, e.field_70161_v - e.field_70166_s);
        double s1 = v1.lengthVector();
        double s2 = v2.lengthVector();
        if (s1 == 0.0) {
            return s2;
        }
        if (s2 == 0.0) {
            return s1;
        }
        return Math.min(s1, s2);
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

