/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.saveddata;

import com.hbm.config.GeneralConfig;
import com.hbm.config.RadiationConfig;
import com.hbm.handler.RadiationSystemNT;
import com.hbm.packet.AuxParticlePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.RadiationSaveStructure;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RadiationSavedData
extends WorldSavedData {
    public Map<ChunkPos, RadiationSaveStructure> contamination = new HashMap<ChunkPos, RadiationSaveStructure>();
    private static RadiationSavedData openInstance;
    public World worldObj;

    public RadiationSavedData(String p_i2141_1_) {
        super(p_i2141_1_);
    }

    public RadiationSavedData(World p_i1678_1_) {
        super("radiation");
        this.worldObj = p_i1678_1_;
        this.func_76185_a();
    }

    public boolean doesEntryExist(int x, int y) {
        return this.getRadFromCoord(x, y) != null;
    }

    public void createEntry(int x, int y, float rad) {
        this.contamination.put(new ChunkPos(x, y), new RadiationSaveStructure(x, y, rad));
        this.func_76185_a();
    }

    public void deleteEntry(RadiationSaveStructure struct) {
        this.contamination.remove(struct);
        this.func_76185_a();
    }

    public void jettisonData() {
        if (GeneralConfig.advancedRadiation) {
            RadiationSystemNT.jettisonData(this.worldObj);
            return;
        }
        this.contamination.clear();
        this.func_76185_a();
    }

    public void setRadForChunkCoord(int x, int y, float radiation) {
        ChunkPos pos = new ChunkPos(x, y);
        RadiationSaveStructure entry = this.contamination.get(pos);
        if (entry == null) {
            entry = new RadiationSaveStructure(x, y, radiation);
            this.contamination.put(pos, entry);
        }
        entry.radiation = radiation;
        this.func_76185_a();
    }

    public void setRadForCoord(BlockPos pos, float radiation) {
        if (GeneralConfig.advancedRadiation) {
            RadiationSystemNT.setRadForCoord(this.worldObj, pos, radiation);
            return;
        }
        ChunkPos cPos = new ChunkPos(pos);
        RadiationSaveStructure entry = this.contamination.get(cPos);
        if (entry == null) {
            entry = new RadiationSaveStructure(cPos.field_77276_a, cPos.field_77275_b, radiation);
            this.contamination.put(cPos, entry);
        }
        entry.radiation = radiation;
        this.func_76185_a();
    }

    private RadiationSaveStructure getRadFromCoord(int x, int y) {
        ChunkPos pos = new ChunkPos(x, y);
        return this.contamination.get(pos);
    }

    private float getRadNumFromChunkCoord(int x, int y) {
        RadiationSaveStructure rad = this.contamination.get(new ChunkPos(x, y));
        if (rad != null) {
            return rad.radiation;
        }
        return 0.0f;
    }

    public float getRadNumFromCoord(BlockPos pos) {
        if (GeneralConfig.advancedRadiation) {
            return RadiationSystemNT.getRadForCoord(this.worldObj, pos);
        }
        RadiationSaveStructure rad = this.contamination.get(new ChunkPos(pos));
        if (rad != null) {
            return rad.radiation;
        }
        return 0.0f;
    }

    public void updateSystem() {
        if (GeneralConfig.advancedRadiation) {
            return;
        }
        HashMap<ChunkPos, RadiationSaveStructure> tempList = new HashMap<ChunkPos, RadiationSaveStructure>(this.contamination);
        this.contamination.clear();
        for (RadiationSaveStructure struct : tempList.values()) {
            if (struct.radiation == 0.0f) continue;
            struct.radiation *= 0.999f;
            struct.radiation -= 0.05f;
            if (struct.radiation <= 0.0f) {
                struct.radiation = 0.0f;
            }
            if (struct.radiation > (float)RadiationConfig.fogRad && this.worldObj != null && this.worldObj.field_73012_v.nextInt(RadiationConfig.fogCh) == 0 && this.worldObj.func_72964_e(struct.chunkX, struct.chunkY).func_177410_o()) {
                int x = struct.chunkX * 16 + this.worldObj.field_73012_v.nextInt(16);
                int z = struct.chunkY * 16 + this.worldObj.field_73012_v.nextInt(16);
                int y = this.worldObj.func_189649_b(x, z) + this.worldObj.field_73012_v.nextInt(5);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacket(x, y, z, 3), new NetworkRegistry.TargetPoint(this.worldObj.field_73011_w.getDimension(), (double)x, (double)y, (double)z, 100.0));
            }
            if (struct.radiation > 1.0f) {
                float[] rads = new float[]{this.getRadNumFromChunkCoord(struct.chunkX + 1, struct.chunkY + 1), this.getRadNumFromChunkCoord(struct.chunkX, struct.chunkY + 1), this.getRadNumFromChunkCoord(struct.chunkX - 1, struct.chunkY + 1), this.getRadNumFromChunkCoord(struct.chunkX - 1, struct.chunkY), this.getRadNumFromChunkCoord(struct.chunkX - 1, struct.chunkY - 1), this.getRadNumFromChunkCoord(struct.chunkX, struct.chunkY - 1), this.getRadNumFromChunkCoord(struct.chunkX + 1, struct.chunkY - 1), this.getRadNumFromChunkCoord(struct.chunkX + 1, struct.chunkY), this.getRadNumFromChunkCoord(struct.chunkX, struct.chunkY)};
                float main2 = 0.6f;
                float side = 0.075f;
                float corner = 0.025f;
                this.setRadForChunkCoord(struct.chunkX + 1, struct.chunkY + 1, rads[0] + struct.radiation * corner);
                this.setRadForChunkCoord(struct.chunkX, struct.chunkY + 1, rads[1] + struct.radiation * side);
                this.setRadForChunkCoord(struct.chunkX - 1, struct.chunkY + 1, rads[2] + struct.radiation * corner);
                this.setRadForChunkCoord(struct.chunkX - 1, struct.chunkY, rads[3] + struct.radiation * side);
                this.setRadForChunkCoord(struct.chunkX - 1, struct.chunkY - 1, rads[4] + struct.radiation * corner);
                this.setRadForChunkCoord(struct.chunkX, struct.chunkY - 1, rads[5] + struct.radiation * side);
                this.setRadForChunkCoord(struct.chunkX + 1, struct.chunkY - 1, rads[6] + struct.radiation * corner);
                this.setRadForChunkCoord(struct.chunkX + 1, struct.chunkY, rads[7] + struct.radiation * side);
                this.setRadForChunkCoord(struct.chunkX, struct.chunkY, rads[8] + struct.radiation * main2);
                continue;
            }
            this.setRadForChunkCoord(struct.chunkX, struct.chunkY, this.getRadNumFromChunkCoord(struct.chunkX, struct.chunkY) + struct.radiation);
        }
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (!GeneralConfig.enableRads || GeneralConfig.advancedRadiation) {
            return;
        }
        int count = nbt.func_74762_e("radCount");
        for (int i = 0; i < count; ++i) {
            RadiationSaveStructure struct = new RadiationSaveStructure();
            struct.readFromNBT(nbt, i);
            this.contamination.put(new ChunkPos(struct.chunkX, struct.chunkY), struct);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74768_a("radCount", this.contamination.size());
        int i = 0;
        Iterator<RadiationSaveStructure> itr = this.contamination.values().iterator();
        while (itr.hasNext()) {
            itr.next().writeToNBT(nbt, i);
            ++i;
        }
        return nbt;
    }

    public static RadiationSavedData getData(World worldObj) {
        if (openInstance != null && RadiationSavedData.openInstance.worldObj == worldObj) {
            return openInstance;
        }
        RadiationSavedData data = (RadiationSavedData)worldObj.getPerWorldStorage().func_75742_a(RadiationSavedData.class, "radiation");
        if (data == null) {
            worldObj.getPerWorldStorage().func_75745_a("radiation", (WorldSavedData)new RadiationSavedData(worldObj));
            data = (RadiationSavedData)worldObj.getPerWorldStorage().func_75742_a(RadiationSavedData.class, "radiation");
        }
        data.worldObj = worldObj;
        openInstance = data;
        return openInstance;
    }

    public static void incrementRad(World worldObj, BlockPos pos, float rad, float maxRad) {
        if (GeneralConfig.advancedRadiation) {
            RadiationSystemNT.incrementRad(worldObj, pos, rad, maxRad);
            return;
        }
        RadiationSavedData data = RadiationSavedData.getData(worldObj);
        Chunk chunk = worldObj.func_175726_f(pos);
        float r = data.getRadNumFromChunkCoord(chunk.field_76635_g, chunk.field_76647_h);
        if (r < maxRad) {
            data.setRadForChunkCoord(chunk.field_76635_g, chunk.field_76647_h, r + rad);
        }
    }

    public static void decrementRad(World worldObj, BlockPos pos, float rad) {
        if (GeneralConfig.advancedRadiation) {
            RadiationSystemNT.decrementRad(worldObj, pos, rad);
            return;
        }
        RadiationSavedData data = RadiationSavedData.getData(worldObj);
        Chunk chunk = worldObj.func_175726_f(pos);
        float r = data.getRadNumFromChunkCoord(chunk.field_76635_g, chunk.field_76647_h);
        if ((r -= rad) > 0.0f) {
            data.setRadForChunkCoord(chunk.field_76635_g, chunk.field_76647_h, r);
        } else {
            data.setRadForChunkCoord(chunk.field_76635_g, chunk.field_76647_h, 0.0f);
        }
    }
}

