/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.google.common.collect.Queues;
import com.hbm.particle.ParticleLayerBase;
import com.hbm.particle.ParticleRenderLayer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="hbm")
public class ParticleBatchRenderer {
    public static List<ParticleRenderLayer> layers = new ArrayList<ParticleRenderLayer>();
    private static final Queue<ParticleLayerBase> queue = Queues.newArrayDeque();

    public static void registerRenderLayer(ParticleRenderLayer r) {
        layers.add(r);
        r.isRegistered = true;
    }

    public static void addParticle(ParticleLayerBase p) {
        if (p != null) {
            queue.add(p);
        }
    }

    public static void updateParticles() {
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        for (ParticleRenderLayer layer : layers) {
            Iterator<ParticleLayerBase> itr = layer.particles.iterator();
            while (itr.hasNext()) {
                ParticleLayerBase p = itr.next();
                p.func_189213_a();
                if (p.func_187113_k()) continue;
                itr.remove();
            }
        }
        if (!queue.isEmpty()) {
            ParticleLayerBase particle = queue.poll();
            while (particle != null) {
                ParticleRenderLayer layer;
                layer = particle.getRenderLayer();
                if (layer == null) {
                    throw new RuntimeException("Particle " + (Object)((Object)particle) + " does not use a custom render layer!");
                }
                if (!layer.isRegistered) {
                    ParticleBatchRenderer.registerRenderLayer(layer);
                }
                if (layer.particles.size() > 16384) {
                    layer.particles.removeFirst();
                }
                layer.particles.add(particle);
                particle = queue.poll();
            }
        }
    }

    public static void renderParticles(Entity entityIn, float partialTicks) {
        float f = ActiveRenderInfo.func_178808_b();
        float f1 = ActiveRenderInfo.func_178803_d();
        float f2 = ActiveRenderInfo.func_178805_e();
        float f3 = ActiveRenderInfo.func_178807_f();
        float f4 = ActiveRenderInfo.func_178809_c();
        Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        Particle.field_190016_K = entityIn.func_70676_i(partialTicks);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (ParticleRenderLayer layer : layers) {
            if (layer.particles.isEmpty()) continue;
            layer.preRender();
            for (ParticleLayerBase particle : layer.particles) {
                particle.func_180434_a(Tessellator.func_178181_a().func_178180_c(), entityIn, partialTicks, f, f4, f1, f2, f3);
            }
            layer.postRender();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    public static void renderLast(RenderWorldLastEvent event) {
        ParticleBatchRenderer.renderParticles(Minecraft.func_71410_x().func_175606_aa(), event.getPartialTicks());
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ParticleBatchRenderer.updateParticles();
        }
    }
}

