/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.interfaces.ITankPacketAcceptor;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidTankPacket
implements IMessage {
    int x;
    int y;
    int z;
    FluidTank[] tanks;
    NBTTagCompound[] tags;
    int length;

    public FluidTankPacket() {
    }

    public FluidTankPacket(int x, int y, int z, FluidTank[] tanks) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.tanks = tanks;
        this.length = tanks.length;
    }

    public FluidTankPacket(BlockPos pos, FluidTank ... tanks) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), tanks);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.length = buf.readInt();
        this.tags = new NBTTagCompound[this.length];
        for (int i = 0; i < this.length; ++i) {
            int amount = buf.readInt();
            byte[] bytes = new byte[buf.readInt()];
            buf.readBytes(bytes);
            String id = new String(bytes);
            NBTTagCompound tag = new NBTTagCompound();
            if (id.equals("HBM_EMPTY") || FluidRegistry.getFluid((String)id) == null) {
                tag.func_74778_a("Empty", "");
            } else {
                new FluidStack(FluidRegistry.getFluid((String)id), amount).writeToNBT(tag);
            }
            this.tags[i] = tag;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.length);
        for (int i = 0; i < this.length; ++i) {
            buf.writeInt(this.tanks[i].getFluidAmount());
            byte[] bytes = this.tanks[i].getFluid() == null ? "HBM_EMPTY".getBytes() : FluidRegistry.getFluidName((FluidStack)this.tanks[i].getFluid()).getBytes();
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
        }
    }

    public static class Handler
    implements IMessageHandler<FluidTankPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(FluidTankPacket m, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(m.x, m.y, m.z));
                if (te != null && te instanceof ITankPacketAcceptor) {
                    ((ITankPacketAcceptor)te).recievePacket(m.tags);
                }
            });
            return null;
        }
    }
}

