/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.lib;

import com.google.common.base.Predicate;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockBedrockOreTE;
import com.hbm.blocks.generic.BlockStorageCrate;
import com.hbm.blocks.machine.PinkCloudBroadcaster;
import com.hbm.blocks.machine.SoyuzCapsule;
import com.hbm.config.BedrockOreJsonConfig;
import com.hbm.config.CompatibilityConfig;
import com.hbm.config.GeneralConfig;
import com.hbm.handler.WeightedRandomChestContentFrom1710;
import com.hbm.inventory.BedrockOreRegistry;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmChestContents;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntitySafe;
import com.hbm.tileentity.machine.TileEntitySoyuzCapsule;
import com.hbm.world.Antenna;
import com.hbm.world.Barrel;
import com.hbm.world.Bunker;
import com.hbm.world.CrashedVertibird;
import com.hbm.world.DesertAtom001;
import com.hbm.world.Dud;
import com.hbm.world.Factory;
import com.hbm.world.Geyser;
import com.hbm.world.GeyserLarge;
import com.hbm.world.LibraryDungeon;
import com.hbm.world.OilBubble;
import com.hbm.world.OilSandBubble;
import com.hbm.world.Radio01;
import com.hbm.world.Relay;
import com.hbm.world.Satellite;
import com.hbm.world.Sellafield;
import com.hbm.world.Silo;
import com.hbm.world.Spaceship;
import com.hbm.world.Vertibird;
import com.hbm.world.dungeon.AncientTomb;
import com.hbm.world.dungeon.ArcticVault;
import com.hbm.world.feature.DepthDeposit;
import com.hbm.world.feature.OilSpot;
import com.hbm.world.generator.CellularDungeonFactory;
import com.hbm.world.generator.DungeonToolbox;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class HbmWorldGen
implements IWorldGenerator {
    private int parseInt(Object e) {
        if (e == null) {
            return 0;
        }
        return (Integer)e;
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        try {
            this.generateOres(world, rand, chunkX * 16, chunkZ * 16);
            if (world.func_72912_H().func_76089_r()) {
                this.generateStructures(world, rand, chunkX * 16, chunkZ * 16);
            }
        }
        catch (Throwable t) {
            System.out.println("NTM Worldgen Error " + t);
            t.printStackTrace();
        }
    }

    public void generateOres(World world, Random rand, int i, int j) {
        int dimExplosivebubbleSpawn;
        int dimGasbubbleSpawn;
        int dimID = world.field_73011_w.getDimension();
        int dimOilcoalSpawn = this.parseInt(CompatibilityConfig.oilcoalSpawn.get(dimID));
        if (dimOilcoalSpawn > 0 && rand.nextInt(dimOilcoalSpawn) == 0) {
            DungeonToolbox.generateOre(world, rand, i, j, 1, 64, 32, 32, ModBlocks.ore_coal_oil);
        }
        if ((dimGasbubbleSpawn = this.parseInt(CompatibilityConfig.gasbubbleSpawn.get(dimID))) > 0 && rand.nextInt(dimGasbubbleSpawn) == 0) {
            DungeonToolbox.generateOre(world, rand, i, j, 4, 64, 20, 10, ModBlocks.gas_flammable, Blocks.field_150350_a);
        }
        if ((dimExplosivebubbleSpawn = this.parseInt(CompatibilityConfig.explosivebubbleSpawn.get(dimID))) > 0 && rand.nextInt(dimExplosivebubbleSpawn) == 0) {
            DungeonToolbox.generateOre(world, rand, i, j, 4, 64, 20, 10, ModBlocks.gas_explosive, Blocks.field_150350_a);
        }
        if (dimID == 0) {
            DepthDeposit.generateConditionOverworld(world, i, 0, 3, j, 5, 0.6, ModBlocks.cluster_depth_iron, rand, 24);
            DepthDeposit.generateConditionOverworld(world, i, 0, 3, j, 5, 0.6, ModBlocks.cluster_depth_titanium, rand, 32);
            DepthDeposit.generateConditionOverworld(world, i, 0, 3, j, 5, 0.6, ModBlocks.cluster_depth_tungsten, rand, 32);
            DepthDeposit.generateConditionOverworld(world, i, 0, 3, j, 5, 0.8, ModBlocks.ore_depth_cinnebar, rand, 16);
            DepthDeposit.generateConditionOverworld(world, i, 0, 3, j, 5, 0.8, ModBlocks.ore_depth_zirconium, rand, 16);
            DepthDeposit.generateConditionOverworld(world, i, 0, 3, j, 5, 0.8, ModBlocks.ore_depth_borax, rand, 16);
        }
        if (dimID == -1) {
            DepthDeposit.generateConditionNether(world, i, 0, 3, j, 7, 0.6, ModBlocks.ore_depth_nether_neodymium, rand, 16);
            DepthDeposit.generateConditionNether(world, i, 125, 3, j, 7, 0.6, ModBlocks.ore_depth_nether_neodymium, rand, 16);
            DepthDeposit.generateConditionNether(world, i, 0, 3, j, 7, 0.6, ModBlocks.ore_depth_nether_nitan, rand, 16);
            DepthDeposit.generateConditionNether(world, i, 125, 3, j, 7, 0.6, ModBlocks.ore_depth_nether_nitan, rand, 16);
            for (int k = 0; k < 30; ++k) {
                int x = i + rand.nextInt(16);
                int z = j + rand.nextInt(16);
                int d = 16 + rand.nextInt(96);
                for (int y = d - 5; y <= d; ++y) {
                    if (world.func_180495_p(new BlockPos(x, y + 1, z)).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != Blocks.field_150424_aL) continue;
                    world.func_175656_a(new BlockPos(x, y, z), ModBlocks.ore_nether_smoldering.func_176223_P());
                }
            }
        }
        DungeonToolbox.generateOre(world, rand, i, j, dimID == 0 ? 25 : 0, 6, 30, 10, ModBlocks.ore_gneiss_iron, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, dimID == 0 ? 10 : 0, 6, 30, 10, ModBlocks.ore_gneiss_gold, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.uraniumSpawn.get(dimID)) * 3, 6, 30, 10, ModBlocks.ore_gneiss_uranium, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.copperSpawn.get(dimID)) * 3, 6, 30, 10, ModBlocks.ore_gneiss_copper, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.asbestosSpawn.get(dimID)) * 3, 6, 30, 10, ModBlocks.ore_gneiss_asbestos, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.lithiumSpawn.get(dimID)), 6, 30, 10, ModBlocks.ore_gneiss_lithium, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.rareSpawn.get(dimID)), 6, 30, 10, ModBlocks.ore_gneiss_asbestos, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.gassshaleSpawn.get(dimID)) * 3, 10, 30, 10, ModBlocks.ore_gneiss_gas, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.uraniumSpawn.get(dimID)), 5, 5, 20, ModBlocks.ore_uranium);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.thoriumSpawn.get(dimID)), 5, 5, 25, ModBlocks.ore_thorium);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.titaniumSpawn.get(dimID)), 6, 5, 30, ModBlocks.ore_titanium);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.sulfurSpawn.get(dimID)), 8, 5, 30, ModBlocks.ore_sulfur);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.aluminiumSpawn.get(dimID)), 6, 5, 40, ModBlocks.ore_aluminium);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.copperSpawn.get(dimID)), 6, 5, 45, ModBlocks.ore_copper);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.fluoriteSpawn.get(dimID)), 4, 5, 45, ModBlocks.ore_fluorite);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.niterSpawn.get(dimID)), 6, 5, 30, ModBlocks.ore_niter);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.tungstenSpawn.get(dimID)), 8, 5, 30, ModBlocks.ore_tungsten);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.leadSpawn.get(dimID)), 9, 5, 30, ModBlocks.ore_lead);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.berylliumSpawn.get(dimID)), 4, 5, 30, ModBlocks.ore_beryllium);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.rareSpawn.get(dimID)), 5, 5, 20, ModBlocks.ore_rare);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.ligniteSpawn.get(dimID)), 24, 35, 25, ModBlocks.ore_lignite);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.asbestosSpawn.get(dimID)), 4, 16, 16, ModBlocks.ore_asbestos);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.cinnebarSpawn.get(dimID)), 4, 8, 16, ModBlocks.ore_cinnebar);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.cobaltSpawn.get(dimID)), 4, 4, 8, ModBlocks.ore_cobalt);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.ironClusterSpawn.get(dimID)), 6, 15, 45, ModBlocks.cluster_iron);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.titaniumClusterSpawn.get(dimID)), 6, 15, 30, ModBlocks.cluster_titanium);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.aluminiumClusterSpawn.get(dimID)), 6, 15, 35, ModBlocks.cluster_aluminium);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.copperClusterSpawn.get(dimID)), 6, 15, 20, ModBlocks.cluster_copper);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.reiiumSpawn.get(dimID)), 2, 14, 18, ModBlocks.ore_reiium);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.weidaniumSpawn.get(dimID)), 2, 14, 18, ModBlocks.ore_weidanium);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.australiumSpawn.get(dimID)), 2, 14, 18, ModBlocks.ore_australium);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.verticiumSpawn.get(dimID)), 2, 14, 18, ModBlocks.ore_verticium);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.unobtainiumSpawn.get(dimID)), 2, 14, 18, ModBlocks.ore_unobtainium);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.daffergonSpawn.get(dimID)), 2, 14, 18, ModBlocks.ore_daffergon);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.netherUraniumSpawn.get(dimID)), 6, 0, 127, ModBlocks.ore_nether_uranium, Blocks.field_150424_aL);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.netherTungstenSpawn.get(dimID)), 10, 0, 127, ModBlocks.ore_nether_tungsten, Blocks.field_150424_aL);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.netherSulfurSpawn.get(dimID)), 12, 0, 127, ModBlocks.ore_nether_sulfur, Blocks.field_150424_aL);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.netherPhosphorusSpawn.get(dimID)), 6, 0, 127, ModBlocks.ore_nether_fire, Blocks.field_150424_aL);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.netherCoalSpawn.get(dimID)), 32, 16, 96, ModBlocks.ore_nether_coal, Blocks.field_150424_aL);
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.netherCobaltSpawn.get(dimID)), 6, 100, 26, ModBlocks.ore_nether_cobalt, Blocks.field_150424_aL);
        if (GeneralConfig.enablePlutoniumOre) {
            DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.netherPlutoniumSpawn.get(dimID)), 4, 0, 127, ModBlocks.ore_nether_plutonium, Blocks.field_150424_aL);
        }
        DungeonToolbox.generateOre(world, rand, i, j, this.parseInt(CompatibilityConfig.endTixiteSpawn.get(dimID)), 6, 0, 127, ModBlocks.ore_tikite, Blocks.field_150377_bs);
        if (dimID == 0 && GeneralConfig.enable528) {
            Random colRand = new Random(world.func_72905_C() + 5L);
            int colX = (int)(colRand.nextGaussian() * 1500.0);
            int colZ = (int)(colRand.nextGaussian() * 1500.0);
            int colRange = 750;
            if (GeneralConfig.enable528ColtanDeposit) {
                for (int k = 0; k < 2; ++k) {
                    for (int r = 1; r <= 5; ++r) {
                        int randPosX = i + rand.nextInt(16);
                        int randPosY = rand.nextInt(25) + 15;
                        int randPosZ = j + rand.nextInt(16);
                        int range = colRange / r;
                        if (randPosX > colX + range || randPosX < colX - range || randPosZ > colZ + range || randPosZ < colZ - range) continue;
                        new WorldGenMinable(ModBlocks.ore_coltan.func_176223_P(), 4).func_180709_b(world, rand, new BlockPos(randPosX, randPosY, randPosZ));
                    }
                }
            }
        }
        this.generateBedrockOil(world, rand, i, j, dimID);
        this.generateBedrockOre(world, rand, i, j, dimID);
    }

    private double generateUnruh(long seed, int x, int z, double scale, int depth) {
        scale = 1.0 / scale;
        double result = 1.0;
        Random rand = new Random(seed);
        for (int i = 0; i < depth; ++i) {
            double offsetX = rand.nextDouble() * Math.PI * 2.0;
            double offsetZ = rand.nextDouble() * Math.PI * 2.0;
            result += Math.sin((double)x / Math.pow(2.0, depth) * scale + offsetX) * Math.sin((double)z / Math.pow(2.0, depth) * scale + offsetZ);
        }
        return result / (double)depth;
    }

    private void generateAStructure(World world, Random rand, int i, int j, WorldGenerator structure, int chance) {
        if (chance > 0 && rand.nextInt(chance) == 0) {
            int x = i + rand.nextInt(16);
            int z = j + rand.nextInt(16);
            int y = world.func_189649_b(x, z);
            structure.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }

    private void generateBedrockOre(World world, Random rand, int i, int j, int dimID) {
        int dimBedrockOreFreq = this.parseInt(BedrockOreJsonConfig.dimOreRarity.get(dimID));
        if (dimBedrockOreFreq > 0 && rand.nextInt(dimBedrockOreFreq) == 0) {
            int sqrsize;
            String oreName = BedrockOreRegistry.rollOreName(dimID, rand);
            if (oreName == null) {
                return;
            }
            for (int v = sqrsize = 2; v >= -sqrsize; --v) {
                for (int w = sqrsize; w >= -sqrsize; --w) {
                    for (int y = 6; y >= 0; --y) {
                        if (rand.nextInt(4) == 0) continue;
                        this.placeBedrockOre(world, new BlockPos(i + 8 + w, y, j + 8 + v), oreName);
                    }
                }
            }
        }
    }

    private void placeBedrockOre(World world, BlockPos orePos, String oreName) {
        if (!this.isBedrock(world, orePos)) {
            return;
        }
        world.func_175656_a(orePos, ModBlocks.ore_bedrock_block.func_176223_P());
        BlockBedrockOreTE.TileEntityBedrockOre bedrockOre = (BlockBedrockOreTE.TileEntityBedrockOre)world.func_175625_s(orePos);
        bedrockOre.setOre(oreName);
    }

    private boolean isBedrock(World world, BlockPos bPos) {
        return world.func_180495_p(bPos).func_177230_c().isReplaceableOreGen(world.func_180495_p(bPos), (IBlockAccess)world, bPos, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150357_h));
    }

    private void generateBedrockOil(World world, Random rand, int i, int j, int dimID) {
        int dimBedrockOilFreq = this.parseInt(CompatibilityConfig.bedrockOilSpawn.get(dimID));
        if (dimBedrockOilFreq > 0 && rand.nextInt(dimBedrockOilFreq) == 0) {
            int randPosX = i + rand.nextInt(16);
            int randPosZ = j + rand.nextInt(16);
            for (int v = 5; v >= -5; --v) {
                for (int w = 5; w >= -5; --w) {
                    for (int y = 6; y >= 0; --y) {
                        if (!this.isBedrock(world, new BlockPos(randPosX + w, y, randPosZ + v))) continue;
                        world.func_175656_a(new BlockPos(randPosX + w, y, randPosZ + v), ModBlocks.ore_bedrock_oil.func_176223_P());
                    }
                }
            }
            DungeonToolbox.generateOre(world, rand, i, j, 16, 8, 10, 50, ModBlocks.stone_porous);
            OilSpot.generateOilSpot(world, randPosX, randPosZ, 5, 50);
        }
    }

    private void generateSellafieldPool(World world, Random rand, int i, int j, int dimID) {
        int dimRadFreq = this.parseInt(CompatibilityConfig.radfreq.get(dimID));
        if (dimRadFreq > 0 && rand.nextInt(dimRadFreq) == 0) {
            int x = i + rand.nextInt(16);
            int z = j + rand.nextInt(16);
            double r = rand.nextInt(15) + 10;
            if (rand.nextInt(50) == 0) {
                r = 50.0;
            }
            new Sellafield().generate(world, x, z, r, r * 0.35);
            if (GeneralConfig.enableDebugMode) {
                MainRegistry.logger.info("[Debug] Successfully spawned raditation hotspot at x=" + x + " z=" + z);
            }
        }
    }

    private void generateStructures(World world, Random rand, int i, int j) {
        int dimID = world.field_73011_w.getDimension();
        if (GeneralConfig.enableDungeons) {
            int dimPyramidStructure;
            int dimArcticStructure;
            int z;
            int x;
            int dimJungleStructure;
            int dimMeteorStructure;
            boolean set;
            int dimVaultFreq;
            int z2;
            int x2;
            int dimCapsuleStructure;
            int y;
            int z3;
            int x3;
            int dimGeyserNether;
            int dimGeyserVapor;
            int dimGeyserChlorine;
            int y2;
            int x4;
            int dimGeyserWater;
            int z4;
            int dimDungeonStructure;
            int dimBroadcaster;
            int z5;
            int y3;
            int x5;
            int dimMineFreq;
            Biome biome = world.func_180494_b(new BlockPos(i += 8, 0, j += 8));
            if (biome.func_185353_n() >= 1.0f && biome.func_76727_i() > 1.0f) {
                this.generateAStructure(world, rand, i, j, new Radio01(), this.parseInt(CompatibilityConfig.radioStructure.get(dimID)));
            }
            if (biome.func_185353_n() <= 0.5f) {
                this.generateAStructure(world, rand, i, j, new Antenna(), this.parseInt(CompatibilityConfig.antennaStructure.get(dimID)));
            }
            if (!biome.func_76738_d() && biome.func_185353_n() >= 2.0f) {
                this.generateAStructure(world, rand, i, j, new DesertAtom001(), this.parseInt(CompatibilityConfig.atomStructure.get(dimID)));
            }
            if (biome.func_185353_n() < 2.0f || biome.func_185353_n() > 1.0f) {
                this.generateAStructure(world, rand, i, j, new Relay(), this.parseInt(CompatibilityConfig.relayStructure.get(dimID)));
            }
            if (biome.func_185353_n() > 1.8f) {
                this.generateAStructure(world, rand, i, j, new Barrel(), this.parseInt(CompatibilityConfig.barrelStructure.get(dimID)));
            }
            if (!biome.func_76738_d() && biome.func_185353_n() >= 2.0f) {
                if (rand.nextInt(2) == 0) {
                    this.generateAStructure(world, rand, i, j, new Vertibird(), this.parseInt(CompatibilityConfig.vertibirdStructure.get(dimID)));
                } else {
                    this.generateAStructure(world, rand, i, j, new CrashedVertibird(), this.parseInt(CompatibilityConfig.vertibirdStructure.get(dimID)));
                }
            }
            if (biome.func_185353_n() < 1.0f || biome.func_185353_n() > 1.8f) {
                this.generateAStructure(world, rand, i, j, new Satellite(), this.parseInt(CompatibilityConfig.satelliteStructure.get(dimID)));
            }
            this.generateAStructure(world, rand, i, j, new Spaceship(), this.parseInt(CompatibilityConfig.spaceshipStructure.get(dimID)));
            this.generateAStructure(world, rand, i, j, new Bunker(), this.parseInt(CompatibilityConfig.bunkerStructure.get(dimID)));
            this.generateAStructure(world, rand, i, j, new Silo(), this.parseInt(CompatibilityConfig.siloStructure.get(dimID)));
            this.generateAStructure(world, rand, i, j, new Factory(), this.parseInt(CompatibilityConfig.factoryStructure.get(dimID)));
            this.generateAStructure(world, rand, i, j, new Dud(), this.parseInt(CompatibilityConfig.dudStructure.get(dimID)));
            if (biome.func_150561_m() == Biome.TempCategory.WARM && biome.func_150561_m() != Biome.TempCategory.OCEAN) {
                this.generateSellafieldPool(world, rand, i, j, dimID);
            }
            if (GeneralConfig.enableMines && (dimMineFreq = this.parseInt(CompatibilityConfig.minefreq.get(dimID))) > 0 && rand.nextInt(dimMineFreq) == 0 && world.func_180495_p(new BlockPos(x5 = i + rand.nextInt(16), (y3 = world.func_189649_b(x5, z5 = j + rand.nextInt(16))) - 1, z5)).isSideSolid((IBlockAccess)world, new BlockPos(x5, y3 - 1, z5), EnumFacing.UP)) {
                world.func_175656_a(new BlockPos(x5, y3, z5), ModBlocks.mine_ap.func_176223_P());
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned landmine at x=" + x5 + " y=" + y3 + " z=" + z5);
                }
            }
            if ((dimBroadcaster = this.parseInt(CompatibilityConfig.broadcaster.get(dimID))) > 0 && rand.nextInt(dimBroadcaster) == 0 && world.func_180495_p(new BlockPos(x5 = i + rand.nextInt(16), (y3 = world.func_189649_b(x5, z5 = j + rand.nextInt(16))) - 1, z5)).isSideSolid((IBlockAccess)world, new BlockPos(x5, y3 - 1, z5), EnumFacing.UP)) {
                world.func_180501_a(new BlockPos(x5, y3, z5), ModBlocks.broadcaster_pc.func_176223_P().func_177226_a((IProperty)PinkCloudBroadcaster.FACING, (Comparable)EnumFacing.func_82600_a((int)(rand.nextInt(4) + 2))), 2);
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned corrupted broadcaster at x=" + x5 + " y=" + y3 + " z=" + z5);
                }
            }
            if ((dimDungeonStructure = this.parseInt(CompatibilityConfig.dungeonStructure.get(dimID))) > 0 && rand.nextInt(dimDungeonStructure) == 0) {
                int x6 = i + rand.nextInt(16);
                y3 = rand.nextInt(256);
                z4 = j + rand.nextInt(16);
                new LibraryDungeon().func_180709_b(world, rand, new BlockPos(x6, y3, z4));
            }
            if (biome.func_76727_i() > 2.0f && (dimGeyserWater = this.parseInt(CompatibilityConfig.geyserWater.get(dimID))) > 0 && rand.nextInt(dimGeyserWater) == 0 && world.func_180495_p(new BlockPos(x4 = i + rand.nextInt(16), (y2 = world.func_189649_b(x4, z4 = j + rand.nextInt(16))) - 1, z4)).func_177230_c() == Blocks.field_150349_c) {
                new Geyser().func_180709_b(world, rand, new BlockPos(x4, y2, z4));
            }
            if (biome.func_185353_n() > 1.8f && biome.func_76727_i() < 1.0f && (dimGeyserChlorine = this.parseInt(CompatibilityConfig.geyserChlorine.get(dimID))) > 0 && rand.nextInt(dimGeyserChlorine) == 0 && world.func_180495_p(new BlockPos(x4 = i + rand.nextInt(16), (y2 = world.func_189649_b(x4, z4 = j + rand.nextInt(16))) - 1, z4)).func_177230_c() == Blocks.field_150354_m) {
                new GeyserLarge().func_180709_b(world, rand, new BlockPos(x4, y2, z4));
            }
            if ((dimGeyserVapor = this.parseInt(CompatibilityConfig.geyserVapor.get(dimID))) > 0 && rand.nextInt(dimGeyserVapor) == 0 && world.func_180495_p(new BlockPos(x4 = i + rand.nextInt(16), (y2 = world.func_189649_b(x4, z4 = j + rand.nextInt(16))) - 1, z4)).func_177230_c() == Blocks.field_150348_b) {
                world.func_175656_a(new BlockPos(x4, y2 - 1, z4), ModBlocks.geysir_vapor.func_176223_P());
            }
            if ((dimGeyserNether = this.parseInt(CompatibilityConfig.geyserNether.get(dimID))) > 0 && rand.nextInt(dimGeyserNether) == 0) {
                x3 = i + rand.nextInt(16);
                z3 = j + rand.nextInt(16);
                int d = 16 + rand.nextInt(96);
                for (y = d - 5; y <= d; ++y) {
                    if (world.func_180495_p(new BlockPos(x3, y + 1, z3)).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(new BlockPos(x3, y, z3)).func_177230_c() != Blocks.field_150424_aL) continue;
                    world.func_175656_a(new BlockPos(x3, y, z3), ModBlocks.geysir_nether.func_176223_P());
                }
            }
            if (biome.func_185353_n() <= 1.0f && (dimCapsuleStructure = this.parseInt(CompatibilityConfig.capsuleStructure.get(dimID))) > 0 && rand.nextInt(dimCapsuleStructure) == 0 && world.func_180495_p(new BlockPos(x2 = i + rand.nextInt(16), (y = world.func_189649_b(x2, z2 = j + rand.nextInt(16)) - 4) + 1, z2)).isSideSolid((IBlockAccess)world, new BlockPos(x2, y + 1, z2), EnumFacing.UP)) {
                world.func_180501_a(new BlockPos(x2, y, z2), ModBlocks.soyuz_capsule.func_176223_P().func_177226_a((IProperty)SoyuzCapsule.RUSTY, (Comparable)Boolean.valueOf(true)), 2);
                TileEntitySoyuzCapsule cap = (TileEntitySoyuzCapsule)world.func_175625_s(new BlockPos(x2, y, z2));
                if (cap != null) {
                    cap.inventory.setStackInSlot(rand.nextInt(cap.inventory.getSlots()), new ItemStack(ModItems.record_glass));
                }
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned capsule at x=" + x2 + " z=" + z2);
                }
            }
            if (rand.nextInt(1000) == 0) {
                x3 = i + rand.nextInt(16);
                z3 = j + rand.nextInt(16);
                boolean done = false;
                for (int k = 0; k < 256; ++k) {
                    IBlockState state = world.func_180495_p(new BlockPos(x3, k, z3));
                    if (state.func_177230_c() != Blocks.field_150364_r || state.func_177229_b((IProperty)BlockOldLog.field_176301_b) != BlockPlanks.EnumType.OAK) continue;
                    world.func_175656_a(new BlockPos(x3, k, z3), ModBlocks.pink_log.func_176223_P());
                    done = true;
                }
                if (GeneralConfig.enableDebugMode && done) {
                    MainRegistry.logger.info("[Debug] Successfully spawned pink tree at x=" + x3 + " z=" + z3);
                }
            }
            if (GeneralConfig.enableVaults && (dimVaultFreq = this.parseInt(CompatibilityConfig.vaultfreq.get(dimID))) > 0 && rand.nextInt(dimVaultFreq) == 0 && world.func_180495_p(new BlockPos(x2 = i + rand.nextInt(16), (y = world.func_189649_b(x2, z2 = j + rand.nextInt(16))) - 1, z2)).isSideSolid((IBlockAccess)world, new BlockPos(x2, y - 1, z2), EnumFacing.UP) && (set = world.func_180501_a(new BlockPos(x2, y, z2), ModBlocks.safe.func_176223_P().func_177226_a((IProperty)BlockStorageCrate.FACING, (Comparable)EnumFacing.func_82600_a((int)(rand.nextInt(4) + 2))), 2))) {
                switch (rand.nextInt(10)) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        WeightedRandomChestContentFrom1710.generateChestContents(rand, HbmChestContents.getLoot(10), (ICapabilityProvider)((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))), rand.nextInt(4) + 3);
                        ((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))).setPins(rand.nextInt(999) + 1);
                        ((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))).setMod(1.0);
                        ((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))).lock();
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        WeightedRandomChestContentFrom1710.generateChestContents(rand, HbmChestContents.getLoot(11), (ICapabilityProvider)((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))), rand.nextInt(3) + 2);
                        ((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))).setPins(rand.nextInt(999) + 1);
                        ((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))).setMod(0.1);
                        ((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))).lock();
                        break;
                    }
                    case 7: 
                    case 8: {
                        WeightedRandomChestContentFrom1710.generateChestContents(rand, HbmChestContents.getLoot(12), (ICapabilityProvider)((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))), rand.nextInt(3) + 1);
                        ((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))).setPins(rand.nextInt(999) + 1);
                        ((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))).setMod(0.02);
                        ((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))).lock();
                        break;
                    }
                    case 9: {
                        WeightedRandomChestContentFrom1710.generateChestContents(rand, HbmChestContents.getLoot(13), (ICapabilityProvider)((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))), rand.nextInt(2) + 1);
                        ((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))).setPins(rand.nextInt(999) + 1);
                        ((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))).setMod(0.0);
                        ((TileEntitySafe)world.func_175625_s(new BlockPos(x2, y, z2))).lock();
                    }
                }
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned safe at x=" + x2 + " y=" + (y + 1) + " z=" + z2);
                }
            }
            if ((dimMeteorStructure = this.parseInt(CompatibilityConfig.meteorStructure.get(dimID))) > 0 && rand.nextInt(dimMeteorStructure) == 0) {
                int f;
                x2 = i + rand.nextInt(16);
                z2 = j + rand.nextInt(16);
                CellularDungeonFactory.meteor.generate(world, x2, 12, z2, rand);
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned meteor dungeon at x=" + x2 + " y=10 z=" + z2);
                }
                int columnY = y = world.func_189649_b(x2, z2);
                for (int y1 = y + 1; y1 > 1; --y1) {
                    if (world.func_180495_p(new BlockPos(x2, y1, z2)).func_177230_c().func_176200_f((IBlockAccess)world, new BlockPos(x2, y1, z2))) continue;
                    columnY = y1 + 1;
                    break;
                }
                for (f = 0; f < 3; ++f) {
                    world.func_175656_a(new BlockPos(x2, columnY + f, z2), ModBlocks.meteor_pillar.func_176223_P().func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Y));
                }
                world.func_175656_a(new BlockPos(x2, columnY + 3, z2), ModBlocks.meteor_brick_chiseled.func_176223_P());
                for (f = 0; f < 10; ++f) {
                    TileEntitySkull skull;
                    x2 = i + rand.nextInt(65) - 32;
                    if (!world.func_180495_p(new BlockPos(x2, y = world.func_189649_b(x2, z2 = j + rand.nextInt(65) - 32), z2)).isSideSolid((IBlockAccess)world, new BlockPos(x2, y, z2), EnumFacing.UP) || !world.func_180501_a(new BlockPos(x2, y - 1, z2), Blocks.field_150465_bP.func_176223_P().func_177226_a((IProperty)BlockSkull.field_176418_a, (Comparable)EnumFacing.UP), 2) || (skull = (TileEntitySkull)world.func_175625_s(new BlockPos(x2, y - 1, z2))) == null) continue;
                    skull.func_152107_a(rand.nextInt(16));
                }
            }
            if (biome.func_76736_e() && (double)biome.func_185353_n() < 1.2 && (double)biome.func_185353_n() > 0.8 && (dimJungleStructure = this.parseInt(CompatibilityConfig.jungleStructure.get(dimID))) > 0 && rand.nextInt(dimJungleStructure) == 0) {
                int y4;
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                CellularDungeonFactory.jungle.generate(world, x, 20, z, world.field_73012_v);
                CellularDungeonFactory.jungle.generate(world, x, 24, z, world.field_73012_v);
                CellularDungeonFactory.jungle.generate(world, x, 28, z, world.field_73012_v);
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned jungle dungeon at x=" + x + " y=10 z=" + z);
                }
                int columnY = y4 = world.func_189649_b(x, z);
                for (int y1 = y4 + 1; y1 > 1; --y1) {
                    if (world.func_180495_p(new BlockPos(x, y1, z)).func_177230_c().func_176200_f((IBlockAccess)world, new BlockPos(x, y1, z))) continue;
                    columnY = y1 + 1;
                    break;
                }
                for (int f = 0; f < 3; ++f) {
                    world.func_175656_a(new BlockPos(x, columnY + f, z), ModBlocks.deco_titanium.func_176223_P());
                }
                world.func_175656_a(new BlockPos(x, columnY + 3, z), Blocks.field_150451_bX.func_176223_P());
            }
            if (biome.func_150561_m() == Biome.TempCategory.COLD && (dimArcticStructure = this.parseInt(CompatibilityConfig.arcticStructure.get(dimID))) > 0 && rand.nextInt(dimArcticStructure) == 0) {
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                int y5 = 16 + rand.nextInt(32);
                new ArcticVault().trySpawn(world, x, y5, z);
            }
            if (biome.func_185353_n() >= 1.8f && (dimPyramidStructure = this.parseInt(CompatibilityConfig.pyramidStructure.get(dimID))) > 0 && rand.nextInt(dimPyramidStructure) == 0) {
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                int y6 = world.func_189649_b(x, z);
                new AncientTomb().build(world, rand, x, y6, z);
            }
            if (!biome.func_76738_d() && biome.func_185353_n() >= 1.8f && rand.nextInt(600) == 0) {
                for (int a = 0; a < 1; ++a) {
                    x = i + rand.nextInt(16);
                    z = j + rand.nextInt(16);
                    int y7 = world.func_189649_b(x, z);
                    OilSandBubble.spawnOil(world, x, y7, z, 15 + rand.nextInt(31));
                }
            }
        }
        if (rand.nextInt(25) == 0) {
            int randPosX = i + rand.nextInt(16);
            int randPosY = rand.nextInt(25);
            int randPosZ = j + rand.nextInt(16);
            OilBubble.spawnOil(world, randPosX, randPosY, randPosZ, 7 + rand.nextInt(9));
        }
        if (GeneralConfig.enableNITAN) {
            if (i <= 10000 && i + 16 >= 10000 && j <= 10000 && j + 16 >= 10000 && world.func_180495_p(new BlockPos(10000, 250, 10000)).func_177230_c() == Blocks.field_150350_a) {
                world.func_175656_a(new BlockPos(10000, 250, 10000), Blocks.field_150486_ae.func_176223_P());
                if (world.func_180495_p(new BlockPos(10000, 250, 10000)).func_177230_c() == Blocks.field_150486_ae) {
                    WeightedRandomChestContentFrom1710.generateChestContents(rand, HbmChestContents.getLoot(9), (ICapabilityProvider)((TileEntityChest)world.func_175625_s(new BlockPos(10000, 250, 10000))), 29);
                }
            }
            if (i <= 0 && i + 16 >= 0 && j <= 10000 && j + 16 >= 10000 && world.func_180495_p(new BlockPos(0, 250, 10000)).func_177230_c() == Blocks.field_150350_a) {
                world.func_175656_a(new BlockPos(0, 250, 10000), Blocks.field_150486_ae.func_176223_P());
                if (world.func_180495_p(new BlockPos(0, 250, 10000)).func_177230_c() == Blocks.field_150486_ae) {
                    WeightedRandomChestContentFrom1710.generateChestContents(rand, HbmChestContents.getLoot(9), (ICapabilityProvider)((TileEntityChest)world.func_175625_s(new BlockPos(0, 250, 10000))), 29);
                }
            }
            if (i <= -10000 && i + 16 >= -10000 && j <= 10000 && j + 16 >= 10000 && world.func_180495_p(new BlockPos(-10000, 250, 10000)).func_177230_c() == Blocks.field_150350_a) {
                world.func_175656_a(new BlockPos(-10000, 250, 10000), Blocks.field_150486_ae.func_176223_P());
                if (world.func_180495_p(new BlockPos(-10000, 250, 10000)).func_177230_c() == Blocks.field_150486_ae) {
                    WeightedRandomChestContentFrom1710.generateChestContents(rand, HbmChestContents.getLoot(9), (ICapabilityProvider)((TileEntityChest)world.func_175625_s(new BlockPos(-10000, 250, 10000))), 29);
                }
            }
            if (i <= 10000 && i + 16 >= 10000 && j <= 0 && j + 16 >= 0 && world.func_180495_p(new BlockPos(10000, 250, 0)).func_177230_c() == Blocks.field_150350_a) {
                world.func_175656_a(new BlockPos(10000, 250, 0), Blocks.field_150486_ae.func_176223_P());
                if (world.func_180495_p(new BlockPos(10000, 250, 0)).func_177230_c() == Blocks.field_150486_ae) {
                    WeightedRandomChestContentFrom1710.generateChestContents(rand, HbmChestContents.getLoot(9), (ICapabilityProvider)((TileEntityChest)world.func_175625_s(new BlockPos(10000, 250, 0))), 29);
                }
            }
            if (i <= -10000 && i + 16 >= -10000 && j <= 0 && j + 16 >= 0 && world.func_180495_p(new BlockPos(-10000, 250, 0)).func_177230_c() == Blocks.field_150350_a) {
                world.func_175656_a(new BlockPos(-10000, 250, 0), Blocks.field_150486_ae.func_176223_P());
                if (world.func_180495_p(new BlockPos(-10000, 250, 0)).func_177230_c() == Blocks.field_150486_ae) {
                    WeightedRandomChestContentFrom1710.generateChestContents(rand, HbmChestContents.getLoot(9), (ICapabilityProvider)((TileEntityChest)world.func_175625_s(new BlockPos(-10000, 250, 0))), 29);
                }
            }
            if (i <= 10000 && i + 16 >= 10000 && j <= -10000 && j + 16 >= -10000 && world.func_180495_p(new BlockPos(10000, 250, -10000)).func_177230_c() == Blocks.field_150350_a) {
                world.func_175656_a(new BlockPos(10000, 250, -10000), Blocks.field_150486_ae.func_176223_P());
                if (world.func_180495_p(new BlockPos(10000, 250, -10000)).func_177230_c() == Blocks.field_150486_ae) {
                    WeightedRandomChestContentFrom1710.generateChestContents(rand, HbmChestContents.getLoot(9), (ICapabilityProvider)((TileEntityChest)world.func_175625_s(new BlockPos(10000, 250, -10000))), 29);
                }
            }
            if (i <= 0 && i + 16 >= 0 && j <= -10000 && j + 16 >= -10000 && world.func_180495_p(new BlockPos(0, 250, -10000)).func_177230_c() == Blocks.field_150350_a) {
                world.func_175656_a(new BlockPos(0, 250, -10000), Blocks.field_150486_ae.func_176223_P());
                if (world.func_180495_p(new BlockPos(0, 250, -10000)).func_177230_c() == Blocks.field_150486_ae) {
                    WeightedRandomChestContentFrom1710.generateChestContents(rand, HbmChestContents.getLoot(9), (ICapabilityProvider)((TileEntityChest)world.func_175625_s(new BlockPos(0, 250, -10000))), 29);
                }
            }
            if (i <= -10000 && i + 16 >= -10000 && j <= -10000 && j + 16 >= -10000 && world.func_180495_p(new BlockPos(-10000, 250, -10000)).func_177230_c() == Blocks.field_150350_a) {
                world.func_175656_a(new BlockPos(-10000, 250, -10000), Blocks.field_150486_ae.func_176223_P());
                if (world.func_180495_p(new BlockPos(-10000, 250, -10000)).func_177230_c() == Blocks.field_150486_ae) {
                    WeightedRandomChestContentFrom1710.generateChestContents(rand, HbmChestContents.getLoot(9), (ICapabilityProvider)((TileEntityChest)world.func_175625_s(new BlockPos(-10000, 250, -10000))), 29);
                }
            }
        }
    }
}

