/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.items.ModItems;
import com.hbm.items.special.ItemLootCrate;
import com.hbm.main.MainRegistry;
import com.hbm.util.I18nUtil;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemMissile
extends Item {
    public PartType type;
    public PartSize top;
    public PartSize bottom;
    public Rarity rarity;
    public float health;
    private String title;
    private String author;
    private String witty;
    public static HashMap<Integer, ItemMissile> parts = new HashMap();
    public Object[] attributes;

    public ItemMissile(String s) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.func_77625_d(1);
        this.func_77637_a(MainRegistry.missileTab);
        ModItems.ALL_ITEMS.add(this);
    }

    public ItemMissile makeChip(float inaccuracy) {
        this.type = PartType.CHIP;
        this.top = PartSize.ANY;
        this.bottom = PartSize.ANY;
        this.attributes = new Object[]{Float.valueOf(inaccuracy)};
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemMissile makeWarhead(WarheadType type, float punch, float weight, PartSize size) {
        this.type = PartType.WARHEAD;
        this.top = PartSize.NONE;
        this.bottom = size;
        this.attributes = new Object[]{type, Float.valueOf(punch), Float.valueOf(weight)};
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemMissile makeFuselage(FuelType type, float fuel, PartSize top, PartSize bottom) {
        this.type = PartType.FUSELAGE;
        this.top = top;
        this.bottom = bottom;
        this.attributes = new Object[]{type, Float.valueOf(fuel)};
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemMissile makeStability(float inaccuracy, PartSize size) {
        this.type = PartType.FINS;
        this.top = size;
        this.bottom = size;
        this.attributes = new Object[]{Float.valueOf(inaccuracy)};
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemMissile makeThruster(FuelType type, float consumption, float lift, PartSize size) {
        this.type = PartType.THRUSTER;
        this.top = size;
        this.bottom = PartSize.NONE;
        this.attributes = new Object[]{type, Float.valueOf(consumption), Float.valueOf(lift)};
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        if (this.title != null) {
            list.add(TextFormatting.DARK_PURPLE + "\"" + this.title + "\"");
        }
        try {
            switch (this.type) {
                case CHIP: {
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.inaccuracy", new Object[0]) + " " + TextFormatting.GRAY + ((Float)this.attributes[0]).floatValue() * 100.0f + "%");
                    break;
                }
                case WARHEAD: {
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.size", new Object[0]) + " " + TextFormatting.GRAY + this.getSize(this.bottom));
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.type", new Object[0]) + " " + TextFormatting.GRAY + this.getWarhead((WarheadType)((Object)this.attributes[0])));
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.strength", new Object[0]) + " " + TextFormatting.RED + (Float)this.attributes[1]);
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.weight", new Object[0]) + " " + TextFormatting.GRAY + (Float)this.attributes[2] + "t");
                    break;
                }
                case FUSELAGE: {
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.topsize", new Object[0]) + " " + TextFormatting.GRAY + this.getSize(this.top));
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.botsize", new Object[0]) + " " + TextFormatting.GRAY + this.getSize(this.bottom));
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.fueltype", new Object[0]) + " " + TextFormatting.GRAY + this.getFuel((FuelType)((Object)this.attributes[0])));
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.fuelamnt", new Object[0]) + " " + TextFormatting.GRAY + (Float)this.attributes[1] + "l");
                    break;
                }
                case FINS: {
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.size", new Object[0]) + " " + TextFormatting.GRAY + this.getSize(this.top));
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.inaccuracy", new Object[0]) + " " + TextFormatting.GRAY + ((Float)this.attributes[0]).floatValue() * 100.0f + "%");
                    break;
                }
                case THRUSTER: {
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.size", new Object[0]) + " " + TextFormatting.GRAY + this.getSize(this.top));
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.fuelamnt", new Object[0]) + " " + TextFormatting.GRAY + this.getFuel((FuelType)((Object)this.attributes[0])));
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.fuelcon", new Object[0]) + " " + TextFormatting.GRAY + (Float)this.attributes[1] + "l/tick");
                    list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.payload", new Object[0]) + " " + TextFormatting.GRAY + (Float)this.attributes[2] + "t");
                }
            }
        }
        catch (Exception ex) {
            list.add("### I AM ERROR ###");
        }
        if (this.type != PartType.CHIP) {
            list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.health", new Object[0]) + " " + TextFormatting.GREEN + this.health + "HP");
        }
        if (this.rarity != null) {
            list.add(TextFormatting.BOLD + I18nUtil.resolveKey("desc.rarity", new Object[0]) + " " + TextFormatting.GRAY + I18nUtil.resolveKey(this.rarity.name, new Object[0]));
        }
        if (this.author != null) {
            list.add(TextFormatting.WHITE + "  " + I18nUtil.resolveKey("desc.author", new Object[0]) + " " + this.author);
        }
        if (this.witty != null) {
            list.add(TextFormatting.GOLD + "   " + TextFormatting.ITALIC + "\"" + this.witty + "\"");
        }
    }

    public String getSize(PartSize size) {
        switch (size) {
            case ANY: {
                return I18nUtil.resolveKey("desc.any", new Object[0]);
            }
            case SIZE_10: {
                return "\u00a7e1.0m";
            }
            case SIZE_15: {
                return "\u00a761.5m";
            }
            case SIZE_20: {
                return "\u00a7c2.0m";
            }
        }
        return I18nUtil.resolveKey("desc.none", new Object[0]);
    }

    public String getWarhead(WarheadType type) {
        switch (type) {
            case HE: {
                return TextFormatting.YELLOW + I18nUtil.resolveKey("warhead.he", new Object[0]);
            }
            case INC: {
                return TextFormatting.GOLD + I18nUtil.resolveKey("warhead.inc", new Object[0]);
            }
            case CLUSTER: {
                return TextFormatting.GRAY + I18nUtil.resolveKey("warhead.cluster", new Object[0]);
            }
            case BUSTER: {
                return TextFormatting.WHITE + I18nUtil.resolveKey("warhead.buster", new Object[0]);
            }
            case NUCLEAR: {
                return TextFormatting.DARK_GREEN + I18nUtil.resolveKey("warhead.nuclear", new Object[0]);
            }
            case TX: {
                return TextFormatting.DARK_PURPLE + I18nUtil.resolveKey("warhead.tx", new Object[0]);
            }
            case N2: {
                return TextFormatting.RED + I18nUtil.resolveKey("warhead.n2", new Object[0]);
            }
            case BALEFIRE: {
                return TextFormatting.GREEN + I18nUtil.resolveKey("warhead.balefire", new Object[0]);
            }
            case SCHRAB: {
                return TextFormatting.AQUA + I18nUtil.resolveKey("warhead.schrab", new Object[0]);
            }
            case TAINT: {
                return TextFormatting.DARK_PURPLE + I18nUtil.resolveKey("warhead.taint", new Object[0]);
            }
            case CLOUD: {
                return TextFormatting.LIGHT_PURPLE + I18nUtil.resolveKey("warhead.cloud", new Object[0]);
            }
            case VOLCANO: {
                return TextFormatting.DARK_RED + I18nUtil.resolveKey("warhead.volcano", new Object[0]);
            }
            case MIRV: {
                return TextFormatting.DARK_PURPLE + I18nUtil.resolveKey("warhead.mirv", new Object[0]);
            }
        }
        return TextFormatting.BOLD + I18nUtil.resolveKey("desc.na", new Object[0]);
    }

    public String getFuel(FuelType type) {
        switch (type) {
            case KEROSENE: {
                return TextFormatting.LIGHT_PURPLE + I18nUtil.resolveKey("fuel.kerosene", new Object[0]);
            }
            case SOLID: {
                return TextFormatting.GOLD + I18nUtil.resolveKey("fuel.solid", new Object[0]);
            }
            case HYDROGEN: {
                return TextFormatting.DARK_AQUA + I18nUtil.resolveKey("fuel.hydrogen", new Object[0]);
            }
            case XENON: {
                return TextFormatting.DARK_PURPLE + I18nUtil.resolveKey("fuel.xenon", new Object[0]);
            }
            case BALEFIRE: {
                return TextFormatting.GREEN + I18nUtil.resolveKey("fuel.balefire", new Object[0]);
            }
        }
        return TextFormatting.BOLD + I18nUtil.resolveKey("desc.na", new Object[0]);
    }

    public ItemMissile copy(String s) {
        ItemMissile part = new ItemMissile(s);
        part.type = this.type;
        part.top = this.top;
        part.bottom = this.bottom;
        part.health = this.health;
        part.attributes = this.attributes;
        part.health = this.health;
        return part;
    }

    public ItemMissile setAuthor(String author) {
        this.author = author;
        return this;
    }

    public ItemMissile setTitle(String title) {
        this.title = title;
        return this;
    }

    public ItemMissile setWittyText(String witty) {
        this.witty = witty;
        return this;
    }

    public ItemMissile setHealth(float health) {
        this.health = health;
        return this;
    }

    public ItemMissile setRarity(Rarity rarity) {
        this.rarity = rarity;
        if (this.type == PartType.FUSELAGE) {
            if (this.top == PartSize.SIZE_10) {
                ItemLootCrate.list10.add(this);
            }
            if (this.top == PartSize.SIZE_15) {
                ItemLootCrate.list15.add(this);
            }
        } else {
            ItemLootCrate.listMisc.add(this);
        }
        return this;
    }

    public static enum Rarity {
        COMMON("rarity.common"),
        UNCOMMON("rarity.uncommon"),
        RARE("rarity.rare"),
        EPIC("rarity.epic"),
        LEGENDARY("rarity.legendary"),
        SEWS_CLOTHES_AND_SUCKS_HORSE_COCK("rarity.strange");

        String name;

        private Rarity(String name) {
            this.name = name;
        }
    }

    public static enum FuelType {
        KEROSENE,
        SOLID,
        HYDROGEN,
        XENON,
        BALEFIRE;

    }

    public static enum WarheadType {
        HE,
        INC,
        BUSTER,
        CLUSTER,
        NUCLEAR,
        TX,
        N2,
        BALEFIRE,
        SCHRAB,
        TAINT,
        CLOUD,
        VOLCANO,
        MIRV;

    }

    public static enum PartSize {
        ANY,
        NONE,
        SIZE_10,
        SIZE_15,
        SIZE_20;

    }

    public static enum PartType {
        CHIP,
        WARHEAD,
        FUSELAGE,
        FINS,
        THRUSTER;

    }
}

