/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.gear;

import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.handler.JetpackHandler;
import com.hbm.interfaces.IItemFluidHandler;
import com.hbm.items.armor.ItemArmorMod;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class JetpackGlider
extends ItemArmorMod
implements IItemFluidHandler {
    public int capacity;

    public JetpackGlider(ItemArmor.ArmorMaterial enumArmorMaterialSteel, int i, EntityEquipmentSlot chest, int capacity, String s) {
        super(1, false, true, false, false, s);
        this.capacity = capacity;
    }

    public FluidTank getTank(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return new FluidTank(this.capacity);
        }
        return new FluidTank(this.capacity).readFromNBT(stack.func_77978_p().func_74775_l("fuelTank"));
    }

    public void setTank(ItemStack stack, FluidTank tank) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a("fuelTank", (NBTBase)tank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        FluidTank tank = this.getTank(stack);
        if (tank.getFluid() == null) {
            list.add(TextFormatting.RED + "    Fuel Type: None");
            list.add(TextFormatting.RED + "    Fuel Speed: " + JetpackHandler.getSpeed(null));
        } else {
            list.add(TextFormatting.RED + "    Fuel Type: " + I18n.func_135052_a((String)tank.getFluid().getUnlocalizedName(), (Object[])new Object[0]));
            list.add(TextFormatting.RED + "    Fuel Speed: " + JetpackHandler.getSpeed(tank.getFluid().getFluid()));
        }
        int percent = (int)((float)tank.getFluidAmount() / (float)tank.getCapacity() * 100.0f);
        list.add(TextFormatting.RED + "    Fuel Amount: " + tank.getFluidAmount() + "/" + tank.getCapacity() + " (" + percent + "%)");
    }

    @Override
    public void addDesc(List<String> list, ItemStack stack, ItemStack armor) {
        super.addDesc(list, stack, armor);
        this.func_77624_a(stack, null, list, null);
    }

    @Override
    public int fill(ItemStack stack, FluidStack fluid, boolean doFill) {
        if (fluid == null) {
            return 0;
        }
        if (fluid.getFluid() == ModForgeFluids.kerosene || fluid.getFluid() == ModForgeFluids.balefire || fluid.getFluid() == ModForgeFluids.nitan) {
            FluidTank tank = this.getTank(stack);
            int fill = tank.fill(fluid, doFill);
            if (doFill) {
                this.setTank(stack, tank);
            }
            return fill;
        }
        return 0;
    }

    @Override
    public FluidStack drain(ItemStack stack, FluidStack resource, boolean doDrain) {
        FluidTank tank = this.getTank(stack);
        FluidStack drain = tank.drain(resource, doDrain);
        if (doDrain) {
            this.setTank(stack, tank);
        }
        return drain;
    }

    @Override
    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain) {
        FluidTank tank = this.getTank(stack);
        FluidStack drain = tank.drain(maxDrain, doDrain);
        if (doDrain) {
            this.setTank(stack, tank);
        }
        return drain;
    }
}

