/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.nodes;

import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.NodeElement;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.NodeType;
import com.hbm.inventory.control_panel.nodes.NodeBoolean;
import com.hbm.inventory.control_panel.nodes.NodeBuffer;
import com.hbm.inventory.control_panel.nodes.NodeCancelEvent;
import com.hbm.inventory.control_panel.nodes.NodeConditional;
import com.hbm.inventory.control_panel.nodes.NodeEventBroadcast;
import com.hbm.inventory.control_panel.nodes.NodeFunction;
import com.hbm.inventory.control_panel.nodes.NodeGetVar;
import com.hbm.inventory.control_panel.nodes.NodeInput;
import com.hbm.inventory.control_panel.nodes.NodeMath;
import com.hbm.inventory.control_panel.nodes.NodeQueryBlock;
import com.hbm.inventory.control_panel.nodes.NodeSetVar;
import com.hbm.render.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public abstract class Node {
    public float posX;
    public float posY;
    public float size;
    public List<NodeElement> otherElements = new ArrayList<NodeElement>();
    public List<NodeConnection> inputs = new ArrayList<NodeConnection>();
    public List<NodeConnection> outputs = new ArrayList<NodeConnection>();
    public boolean cacheValid = false;
    public DataValue[] evalCache = null;

    public abstract DataValue evaluate(int var1);

    public abstract NodeType getType();

    public abstract String getDisplayName();

    public Node(float x, float y) {
        this.setPosition(x, y);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag, NodeSystem sys) {
        NBTTagCompound inputs = new NBTTagCompound();
        for (int i = 0; i < this.inputs.size(); ++i) {
            inputs.func_74782_a("con" + i, (NBTBase)this.inputs.get(i).writeToNBT(new NBTTagCompound(), sys));
        }
        tag.func_74782_a("in", (NBTBase)inputs);
        NBTTagCompound outputs = new NBTTagCompound();
        for (int i = 0; i < this.outputs.size(); ++i) {
            outputs.func_74782_a("con" + i, (NBTBase)this.outputs.get(i).writeToNBT(new NBTTagCompound(), sys));
        }
        tag.func_74782_a("out", (NBTBase)outputs);
        tag.func_74768_a("T", this.getType().ordinal());
        tag.func_74776_a("X", this.posX);
        tag.func_74776_a("Y", this.posY);
        tag.func_74776_a("S", this.size);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag, NodeSystem sys) {
        this.inputs.clear();
        this.outputs.clear();
        NBTTagCompound inputs = tag.func_74775_l("in");
        for (int i = 0; i < inputs.func_150296_c().size(); ++i) {
            NodeConnection c = new NodeConnection(null, this, 0, false, null, new DataValueFloat(0.0f));
            c.readFromNBT(inputs.func_74775_l("con" + i), sys);
            this.inputs.add(c);
        }
        NBTTagCompound outputs = tag.func_74775_l("out");
        for (int i = 0; i < outputs.func_150296_c().size(); ++i) {
            NodeConnection c = new NodeConnection(null, this, 0, false, null, new DataValueFloat(0.0f));
            c.readFromNBT(outputs.func_74775_l("con" + i), sys);
            this.outputs.add(c);
        }
        this.posX = tag.func_74760_g("X");
        this.posY = tag.func_74760_g("Y");
        this.size = tag.func_74760_g("S");
        this.cacheValid = false;
    }

    public static Node nodeFromNBT(NBTTagCompound tag, NodeSystem sys) {
        Node node = null;
        switch (tag.func_74779_i("nodeType")) {
            case "cancelEvent": {
                node = new NodeCancelEvent(0.0f, 0.0f);
                break;
            }
            case "eventBroadcast": {
                NBTTagCompound list = tag.func_74775_l("itemList");
                ArrayList<ControlEvent> l = new ArrayList<ControlEvent>();
                for (int i = 0; i < list.func_150296_c().size(); ++i) {
                    l.add(ControlEvent.getRegisteredEvent(list.func_74779_i("item" + i)));
                }
                node = new NodeEventBroadcast(0.0f, 0.0f, l);
                break;
            }
            case "getVar": {
                int ctrlIdx = tag.func_74762_e("controlIdx");
                node = new NodeGetVar(0.0f, 0.0f, sys.parent.panel.controls.get(ctrlIdx));
                break;
            }
            case "queryBlock": {
                int ctrlIdx = tag.func_74762_e("controlIdx");
                node = new NodeQueryBlock(0.0f, 0.0f, sys.parent.panel.controls.get(ctrlIdx));
                break;
            }
            case "math": {
                node = new NodeMath(0.0f, 0.0f);
                break;
            }
            case "boolean": {
                node = new NodeBoolean(0.0f, 0.0f);
                break;
            }
            case "function": {
                node = new NodeFunction(0.0f, 0.0f);
                break;
            }
            case "buffer": {
                node = new NodeBuffer(0.0f, 0.0f);
                break;
            }
            case "conditional": {
                node = new NodeConditional(0.0f, 0.0f);
                break;
            }
            case "setVar": {
                int ctrlIdx2 = tag.func_74762_e("controlIdx");
                node = new NodeSetVar(0.0f, 0.0f, sys.parent.panel.controls.get(ctrlIdx2));
                break;
            }
            case "input": {
                node = new NodeInput(0.0f, 0.0f, null);
            }
        }
        return node;
    }

    public void setPosition(float x, float y) {
        this.posX = x;
        this.posY = y;
        for (NodeElement nodeElement : this.otherElements) {
            nodeElement.resetOffset();
        }
        for (NodeConnection nodeConnection : this.inputs) {
            nodeConnection.resetOffset();
        }
        for (NodeConnection nodeConnection : this.outputs) {
            nodeConnection.resetOffset();
        }
    }

    public void render(float mX, float mY, boolean isActive, boolean isSelected) {
        int i;
        float[] color;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(NodeSystem.node_tex);
        if (isActive || isSelected) {
            float[] fArray;
            if (isActive) {
                float[] fArray2 = new float[3];
                fArray2[0] = 0.7f;
                fArray2[1] = 0.7f;
                fArray = fArray2;
                fArray2[2] = 0.7f;
            } else {
                float[] fArray3 = new float[3];
                fArray3[0] = 1.0f;
                fArray3[1] = 0.5f;
                fArray = fArray3;
                fArray3[2] = 0.1f;
            }
            color = fArray;
            float edge = 0.5f;
            Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
            RenderHelper.drawGuiRectBatchedColor(this.posX - edge, this.posY - edge, 0.0f, 0.875f, 40.0f + edge * 2.0f, 6.0f + edge * 2.0f, 0.625f, 0.96875f, color[0], color[1], color[2], 1.0f);
            RenderHelper.drawGuiRectBatchedColor(this.posX - edge, this.posY + 6.0f, 0.0f, 0.96875f, 40.0f + edge * 2.0f, this.size + edge, 0.625f, 0.984375f, color[0], color[1], color[2], 1.0f);
            RenderHelper.drawGuiRectBatchedColor(this.posX - edge, this.posY + 6.0f + this.size, 0.0f, 0.984375f, 40.0f + edge * 2.0f, 1.0f + edge, 0.625f, 1.0f, color[0], color[1], color[2], 1.0f);
            Tessellator.func_178181_a().func_78381_a();
        }
        color = this.getType().getColor();
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        RenderHelper.drawGuiRectBatchedColor(this.posX, this.posY, 0.0f, 0.0f, 40.0f, 6.0f, 0.625f, 0.09375f, 1.0f, 1.0f, 1.0f, 1.0f);
        RenderHelper.drawGuiRectBatchedColor(this.posX, this.posY + 6.0f, 0.0f, 0.09375f, 40.0f, this.size, 0.625f, 0.109375f, 1.0f, 1.0f, 1.0f, 1.0f);
        RenderHelper.drawGuiRectBatchedColor(this.posX, this.posY + 6.0f + this.size, 0.0f, 0.109375f, 40.0f, 1.0f, 0.625f, 0.125f, 1.0f, 1.0f, 1.0f, 1.0f);
        RenderHelper.drawGuiRectBatchedColor(this.posX, this.posY + 1.0f, 0.0f, 0.125f, 40.0f, 5.0f, 0.625f, 0.203125f, color[0], color[1], color[2], 1.0f);
        Tessellator.func_178181_a().func_78381_a();
        for (i = this.inputs.size() - 1; i >= 0; --i) {
            this.inputs.get(i).render(mX, mY);
        }
        for (i = this.outputs.size() - 1; i >= 0; --i) {
            this.outputs.get(i).render(mX, mY);
        }
        for (i = this.otherElements.size() - 1; i >= 0; --i) {
            this.otherElements.get(i).render(mX, mY);
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.posX, (double)this.posY, (double)0.0);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GL11.glTranslated((double)(-this.posX), (double)(-this.posY), (double)0.0);
        font.func_175065_a(this.getDisplayName(), this.posX + 4.0f, this.posY + 3.0f, -13684945, false);
        GL11.glPopMatrix();
    }

    public void drawConnections(float mX, float mY) {
        for (NodeConnection n : this.inputs) {
            n.drawLine(mX, mY);
        }
        for (NodeConnection n : this.outputs) {
            n.drawLine(mX, mY);
        }
    }

    public void recalcSize() {
        this.size = (this.otherElements.size() + this.inputs.size() + this.outputs.size()) * 8 + 2;
        this.setPosition(this.posX, this.posY);
    }

    public boolean onClick(float x, float y) {
        for (NodeElement n : this.otherElements) {
            if (!n.onClick(x, y)) continue;
            return true;
        }
        return false;
    }

    public float[] getBoundingBox() {
        return new float[]{this.posX, this.posY, this.posX + 40.0f, this.posY + 6.0f + this.size};
    }

    public float[] getExtendedBoundingBox() {
        return new float[]{this.posX - 2.0f, this.posY, this.posX + 42.0f, this.posY + 6.0f + this.size};
    }
}

