/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.hazard.HazardData;
import com.hbm.hazard.HazardEntry;
import com.hbm.hazard.HazardRegistry;
import com.hbm.hazard.HazardSystem;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictManager {
    private static final HashMap<String, HashSet<String>> reRegistration = new HashMap();
    public static final String KEY_STICK = "stickWood";
    public static final String KEY_ANYGLASS = "blockGlass";
    public static final String KEY_CLEARGLASS = "blockGlassColorless";
    public static final String KEY_ANYPANE = "paneGlass";
    public static final String KEY_CLEARPANE = "paneGlassColorless";
    public static final String KEY_BRICK = "ingotBrick";
    public static final String KEY_NETHERBRICK = "ingotBrickNether";
    public static final String KEY_SLIME = "slimeball";
    public static final String KEY_LOG = "logWood";
    public static final String KEY_PLANKS = "plankWood";
    public static final String KEY_SLAB = "slabWood";
    public static final String KEY_LEAVES = "treeLeaves";
    public static final String KEY_SAPLING = "treeSapling";
    public static final String KEY_SAND = "sand";
    public static final String KEY_GRAVEL = "gravel";
    public static final String KEY_BLACK = "dyeBlack";
    public static final String KEY_RED = "dyeRed";
    public static final String KEY_GREEN = "dyeGreen";
    public static final String KEY_BROWN = "dyeBrown";
    public static final String KEY_BLUE = "dyeBlue";
    public static final String KEY_PURPLE = "dyePurple";
    public static final String KEY_CYAN = "dyeCyan";
    public static final String KEY_LIGHTGRAY = "dyeLightGray";
    public static final String KEY_GRAY = "dyeGray";
    public static final String KEY_PINK = "dyePink";
    public static final String KEY_LIME = "dyeLime";
    public static final String KEY_YELLOW = "dyeYellow";
    public static final String KEY_LIGHTBLUE = "dyeLightBlue";
    public static final String KEY_MAGENTA = "dyeMagenta";
    public static final String KEY_ORANGE = "dyeOrange";
    public static final String KEY_WHITE = "dyeWhite";
    public static final String KEY_OIL_TAR = "oiltar";
    public static final String KEY_CRACK_TAR = "cracktar";
    public static final String KEY_COAL_TAR = "coaltar";
    public static final String KEY_UNIVERSAL_TANK = "ntmuniversaltank";
    public static final String KEY_HAZARD_TANK = "ntmhazardtank";
    public static final String KEY_UNIVERSAL_BARREL = "ntmuniversalbarrel";
    public static final String KEY_TOOL_SCREWDRIVER = "ntmscrewdriver";
    public static final String KEY_TOOL_HANDDRILL = "ntmhanddrill";
    public static final String KEY_TOOL_CHEMISTRYSET = "ntmchemistryset";
    public static final String KEY_CIRCUIT_BISMUTH = "circuitVersatile";
    public static final DictFrame COAL = new DictFrame("Coal");
    public static final DictFrame IRON = new DictFrame("Iron");
    public static final DictFrame GOLD = new DictFrame("Gold");
    public static final DictFrame LAPIS = new DictFrame("Lapis");
    public static final DictFrame REDSTONE = new DictFrame("Redstone");
    public static final DictFrame NETHERQUARTZ = new DictFrame("NetherQuartz");
    public static final DictFrame DIAMOND = new DictFrame("Diamond");
    public static final DictFrame EMERALD = new DictFrame("Emerald");
    public static final DictFrame U = new DictFrame("Uranium");
    public static final DictFrame U233 = new DictFrame("Uranium233", "U233");
    public static final DictFrame U235 = new DictFrame("Uranium235", "U235");
    public static final DictFrame U238 = new DictFrame("Uranium238", "U238");
    public static final DictFrame TH232 = new DictFrame("Thorium232", "Th232", "Thorium");
    public static final DictFrame PU = new DictFrame("Plutonium");
    public static final DictFrame PURG = new DictFrame("PlutoniumRG");
    public static final DictFrame PU238 = new DictFrame("Plutonium238", "Pu238");
    public static final DictFrame PU239 = new DictFrame("Plutonium239", "Pu239");
    public static final DictFrame PU240 = new DictFrame("Plutonium240", "Pu240");
    public static final DictFrame PU241 = new DictFrame("Plutonium241", "Pu241");
    public static final DictFrame AM241 = new DictFrame("Americium241", "Am241");
    public static final DictFrame AM242 = new DictFrame("Americium242", "Am242");
    public static final DictFrame AMRG = new DictFrame("AmericiumRG");
    public static final DictFrame NP237 = new DictFrame("Neptunium237", "Np237", "Neptunium");
    public static final DictFrame PO210 = new DictFrame("Polonium210", "Po210", "Polonium");
    public static final DictFrame TC99 = new DictFrame("Technetium99", "Tc99");
    public static final DictFrame RA226 = new DictFrame("Radium226", "Ra226");
    public static final DictFrame AC227 = new DictFrame("Actinium227", "Ac227");
    public static final DictFrame CO60 = new DictFrame("Cobalt60", "Co60");
    public static final DictFrame AU198 = new DictFrame("Gold198", "Au198");
    public static final DictFrame PB209 = new DictFrame("Lead209", "Pb209");
    public static final DictFrame SA326 = new DictFrame("Schrabidium");
    public static final DictFrame SA327 = new DictFrame("Solinium");
    public static final DictFrame SBD = new DictFrame("Schrabidate");
    public static final DictFrame SRN = new DictFrame("Schraranium");
    public static final DictFrame GH336 = new DictFrame("Ghiorsium336", "Gh336");
    public static final DictFrame RAREEARTH = new DictFrame("RareEarth");
    public static final DictFrame NITANIUM = new DictFrame("Nitanium");
    public static final DictFrame TI = new DictFrame("Titanium");
    public static final DictFrame CU = new DictFrame("Copper");
    public static final DictFrame MINGRADE = new DictFrame("Mingrade");
    public static final DictFrame ALLOY = new DictFrame("AdvancedAlloy");
    public static final DictFrame W = new DictFrame("Tungsten");
    public static final DictFrame AL = new DictFrame("Aluminum");
    public static final DictFrame STEEL = new DictFrame("Steel");
    public static final DictFrame TCALLOY = new DictFrame("TcAlloy");
    public static final DictFrame CDALLOY = new DictFrame("CdAlloy");
    public static final DictFrame PB = new DictFrame("Lead");
    public static final DictFrame CD = new DictFrame("Cadmium");
    public static final DictFrame AS = new DictFrame("Arsenic");
    public static final DictFrame TA = new DictFrame("Tantalum");
    public static final DictFrame COLTAN = new DictFrame("Coltan");
    public static final DictFrame NB = new DictFrame("Niobium");
    public static final DictFrame BE = new DictFrame("Beryllium");
    public static final DictFrame CO = new DictFrame("Cobalt");
    public static final DictFrame B = new DictFrame("Boron");
    public static final DictFrame GRAPHITE = new DictFrame("Graphite");
    public static final DictFrame DURA = new DictFrame("DuraSteel");
    public static final DictFrame POLYMER = new DictFrame("Polymer");
    public static final DictFrame BAKELITE = new DictFrame("Bakelite");
    public static final DictFrame RUBBER = new DictFrame("Rubber");
    public static final DictFrame LATEX = new DictFrame("Latex");
    public static final DictFrame MAGTUNG = new DictFrame("MagnetizedTungsten");
    public static final DictFrame CMB = new DictFrame("CMBSteel");
    public static final DictFrame DESH = new DictFrame("WorkersAlloy");
    public static final DictFrame STAR = new DictFrame("Starmetal");
    public static final DictFrame BIGMT = new DictFrame("Saturnite");
    public static final DictFrame FERRO = new DictFrame("Ferrouranium");
    public static final DictFrame EUPH = new DictFrame("Euphemium");
    public static final DictFrame DNT = new DictFrame("Dineutronium");
    public static final DictFrame FIBER = new DictFrame("Fiberglass");
    public static final DictFrame ASBESTOS = new DictFrame("Asbestos");
    public static final DictFrame OSMIRIDIUM = new DictFrame("Osmiridium");
    public static final DictFrame S = new DictFrame("Sulfur");
    public static final DictFrame KNO = new DictFrame("Saltpeter");
    public static final DictFrame F = new DictFrame("Fluorite");
    public static final DictFrame LIGNITE = new DictFrame("Lignite");
    public static final DictFrame COALCOKE = new DictFrame("CoalCoke");
    public static final DictFrame PETCOKE = new DictFrame("PetCoke");
    public static final DictFrame LIGCOKE = new DictFrame("LigniteCoke");
    public static final DictFrame CINNABAR = new DictFrame("Cinnabar");
    public static final DictFrame BORAX = new DictFrame("Borax");
    public static final DictFrame VOLCANIC = new DictFrame("Volcanic");
    public static final DictFrame HEMATITE = new DictFrame("Hematite");
    public static final DictFrame MALACHITE = new DictFrame("Malachite");
    public static final DictFrame SLAG = new DictFrame("Slag");
    public static final DictFrame INFERNAL = new DictFrame("InfernalCoal");
    public static final DictFrame LI = new DictFrame("Lithium");
    public static final DictFrame P_WHITE = new DictFrame("WhitePhosphorus");
    public static final DictFrame P_RED = new DictFrame("RedPhosphorus");
    public static final DictFrame AUSTRALIUM = new DictFrame("Australium");
    public static final DictFrame REIIUM = new DictFrame("Reiium");
    public static final DictFrame WEIDANIUM = new DictFrame("Weidanium");
    public static final DictFrame UNOBTAINIUM = new DictFrame("Unobtainium");
    public static final DictFrame VERTICIUM = new DictFrame("Verticium");
    public static final DictFrame DAFFERGON = new DictFrame("Daffergon");
    public static final DictFrame LA = new DictFrame("Lanthanum");
    public static final DictFrame AC = new DictFrame("Actinium");
    public static final DictFrame ZR = new DictFrame("Zirconium");
    public static final DictFrame ND = new DictFrame("Neodymium");
    public static final DictFrame CE = new DictFrame("Cerium");
    public static final DictFrame I = new DictFrame("Iodine");
    public static final DictFrame AT = new DictFrame("Astatine");
    public static final DictFrame CS = new DictFrame("Caesium");
    public static final DictFrame SR = new DictFrame("Strontium");
    public static final DictFrame BR = new DictFrame("Bromine");
    public static final DictFrame TS = new DictFrame("Tennessine");
    public static final DictFrame SR90 = new DictFrame("Strontium90", "Sr90");
    public static final DictFrame I131 = new DictFrame("Iodine131", "I131");
    public static final DictFrame XE135 = new DictFrame("Xenon135", "Xe135");
    public static final DictFrame CS137 = new DictFrame("Caesium137", "Cs137");
    public static final DictFrame AT209 = new DictFrame("Astatine209", "At209");
    public static final DictGroup ANY_RUBBER = new DictGroup("AnyRubber", LATEX, RUBBER);
    public static final DictGroup ANY_PLASTIC = new DictGroup("AnyPlastic", POLYMER, BAKELITE);
    public static final DictGroup ANY_RESISTANTALLOY = new DictGroup("AnyResistantAlloy", TCALLOY, CDALLOY);
    public static final DictFrame ANY_GUNPOWDER = new DictFrame("AnyPropellant");
    public static final DictFrame ANY_SMOKELESS = new DictFrame("AnySmokeless");
    public static final DictFrame ANY_PLASTICEXPLOSIVE = new DictFrame("AnyPlasticexplosive");
    public static final DictFrame ANY_HIGHEXPLOSIVE = new DictFrame("AnyHighexplosive");
    public static final DictFrame ANY_COKE = new DictFrame("AnyCoke", "Coke");
    public static final DictFrame ANY_CONCRETE = new DictFrame("Concrete");
    public static final DictGroup ANY_TAR = new DictGroup("Tar", "oiltar", "coaltar", "cracktar");
    public static final DictFrame ANY_BISMOID = new DictFrame("AnyBismoid");
    private static boolean recursionBrake = false;

    public static void registerOres() {
        COAL.dust(ModItems.powder_coal).dustSmall(ModItems.powder_coal_tiny).gem(Items.field_151044_h).crystal(ModItems.crystal_coal);
        IRON.dust(ModItems.powder_iron).crystal(ModItems.crystal_iron).plate(ModItems.plate_iron).ore(ModBlocks.ore_gneiss_iron, ModBlocks.cluster_iron, ModBlocks.cluster_depth_iron);
        GOLD.dust(ModItems.powder_gold).crystal(ModItems.crystal_gold).plate(ModItems.plate_gold).ore(ModBlocks.ore_gneiss_gold);
        LAPIS.dust(ModItems.powder_lapis).crystal(ModItems.crystal_lapis);
        REDSTONE.crystal(ModItems.crystal_redstone);
        NETHERQUARTZ.dust(ModItems.powder_quartz).gem(Items.field_151128_bU);
        DIAMOND.dust(ModItems.powder_diamond).crystal(ModItems.crystal_diamond).ore(ModBlocks.gravel_diamond);
        EMERALD.dust(ModItems.powder_emerald);
        TI.ingot(ModItems.ingot_titanium).dust(ModItems.powder_titanium).block(ModBlocks.block_titanium).crystal(ModItems.crystal_titanium).plate(ModItems.plate_titanium).ore(ModBlocks.ore_titanium, ModBlocks.cluster_titanium, ModBlocks.cluster_depth_titanium, ModBlocks.ore_meteor_titanium);
        CU.ingot(ModItems.ingot_copper).dust(ModItems.powder_copper).block(ModBlocks.block_copper).crystal(ModItems.crystal_copper).plate(ModItems.plate_copper).ore(ModBlocks.ore_copper, ModBlocks.ore_gneiss_copper, ModBlocks.ore_meteor_copper);
        W.ingot(ModItems.ingot_tungsten).dust(ModItems.powder_tungsten).block(ModBlocks.block_tungsten).crystal(ModItems.crystal_tungsten).ore(ModBlocks.ore_tungsten, ModBlocks.cluster_depth_tungsten, ModBlocks.ore_nether_tungsten, ModBlocks.ore_meteor_tungsten).oreNether(ModBlocks.ore_nether_tungsten);
        AL.ingot(ModItems.ingot_aluminium).dust(ModItems.powder_aluminium).block(ModBlocks.block_aluminium).crystal(ModItems.crystal_aluminium).plate(ModItems.plate_aluminium).ore(ModBlocks.ore_aluminium, ModBlocks.cluster_aluminium, ModBlocks.ore_meteor_aluminium);
        PB.nugget(ModItems.nugget_lead).ingot(ModItems.ingot_lead).dust(ModItems.powder_lead).block(ModBlocks.block_lead).crystal(ModItems.crystal_lead).plate(ModItems.plate_lead).ore(ModBlocks.ore_lead, ModBlocks.ore_meteor_lead);
        AS.nugget(ModItems.nugget_arsenic).ingot(ModItems.ingot_arsenic);
        CD.nugget(ModItems.nugget_cadmium).ingot(ModItems.ingot_cadmium).dust(ModItems.powder_cadmium).block(ModBlocks.block_cadmium);
        TA.nugget(ModItems.nugget_tantalium).ingot(ModItems.ingot_tantalium).dust(ModItems.powder_tantalium).block(ModBlocks.block_tantalium).gem(ModItems.gem_tantalium);
        COLTAN.ingot(ModItems.fragment_coltan).dust(ModItems.powder_coltan_ore).block(ModBlocks.block_coltan).ore(ModBlocks.ore_coltan);
        NB.nugget(ModItems.fragment_niobium).ingot(ModItems.ingot_niobium).dust(ModItems.powder_niobium).dustSmall(ModItems.powder_niobium_tiny).block(ModBlocks.block_niobium);
        BE.nugget(ModItems.nugget_beryllium).billet(ModItems.billet_beryllium).ingot(ModItems.ingot_beryllium).dust(ModItems.powder_beryllium).block(ModBlocks.block_beryllium).crystal(ModItems.crystal_beryllium).ore(ModBlocks.ore_beryllium);
        B.nugget(ModItems.fragment_boron).ingot(ModItems.ingot_boron).dust(ModItems.powder_boron).dustSmall(ModItems.powder_boron_tiny).block(ModBlocks.block_boron);
        ANY_BISMOID.nugget(ModItems.nugget_bismuth).ingot(ModItems.ingot_bismuth).dust(ModItems.powder_bismuth).block(ModBlocks.block_bismuth);
        LA.nugget(ModItems.fragment_lanthanium).ingot(ModItems.ingot_lanthanium).dust(ModItems.powder_lanthanium).dustSmall(ModItems.powder_lanthanium_tiny).block(ModBlocks.block_lanthanium);
        AC.nugget(ModItems.nugget_actinium).ingot(ModItems.ingot_actinium).dust(ModItems.powder_actinium).dustSmall(ModItems.powder_actinium_tiny).block(ModBlocks.block_actinium);
        ZR.nugget(ModItems.nugget_zirconium).billet(ModItems.billet_zirconium).ingot(ModItems.ingot_zirconium).dust(ModItems.powder_zirconium).block(ModBlocks.block_zirconium).ore(ModBlocks.ore_depth_zirconium);
        ND.nugget(ModItems.fragment_neodymium).ingot(ModItems.ingot_neodymium).dust(ModItems.powder_neodymium).dustSmall(ModItems.powder_neodymium_tiny).ore(ModBlocks.ore_depth_nether_neodymium).oreNether(ModBlocks.ore_depth_nether_neodymium);
        CE.nugget(ModItems.fragment_cerium).ingot(ModItems.ingot_cerium).dust(ModItems.powder_cerium).dustSmall(ModItems.powder_cerium_tiny);
        BR.ingot(ModItems.ingot_bromine).dust(ModItems.powder_bromine);
        LI.hydro(1.0f).ingot(ModItems.lithium).dust(ModItems.powder_lithium).dustSmall(ModItems.powder_lithium_tiny).block(ModBlocks.block_lithium).crystal(ModItems.crystal_lithium).ore(ModBlocks.ore_gneiss_lithium, ModBlocks.ore_meteor_lithium);
        P_WHITE.hot(5.0f).ingot(ModItems.ingot_phosphorus).block(ModBlocks.block_white_phosphorus);
        P_RED.hot(2.0f).dust(ModItems.powder_fire).block(ModBlocks.block_red_phosphorus).crystal(ModItems.crystal_phosphorus).ore(ModBlocks.ore_nether_fire);
        S.dust(ModItems.sulfur).block(ModBlocks.block_sulfur).crystal(ModItems.crystal_sulfur).ore(ModBlocks.ore_sulfur, ModBlocks.ore_nether_sulfur, ModBlocks.basalt_sulfur, ModBlocks.ore_meteor_sulfur);
        KNO.dust(ModItems.niter).block(ModBlocks.block_niter).crystal(ModItems.crystal_niter).ore(ModBlocks.ore_niter);
        F.dust(ModItems.fluorite).block(ModBlocks.block_fluorite).crystal(ModItems.crystal_fluorite).ore(ModBlocks.ore_fluorite, ModBlocks.basalt_fluorite);
        INFERNAL.block(ModBlocks.block_coal_infernal).gem(ModItems.coal_infernal).ore(ModBlocks.ore_nether_coal);
        RAREEARTH.dust(ModItems.powder_desh_mix).crystal(ModItems.crystal_rare).ore(ModBlocks.ore_rare, ModBlocks.ore_gneiss_rare);
        NITANIUM.dust(ModItems.powder_nitan_mix).ore(ModBlocks.ore_depth_nether_nitan);
        MINGRADE.ingot(ModItems.ingot_red_copper).dust(ModItems.powder_red_copper).block(ModBlocks.block_red_copper);
        ALLOY.ingot(ModItems.ingot_advanced_alloy).dust(ModItems.powder_advanced_alloy).block(ModBlocks.block_advanced_alloy).plate(ModItems.plate_advanced_alloy);
        STEEL.ingot(ModItems.ingot_steel).dust(ModItems.powder_steel).dustSmall(ModItems.powder_steel_tiny).block(ModBlocks.block_steel).plate(ModItems.plate_steel);
        TCALLOY.ingot(ModItems.ingot_tcalloy).dust(ModItems.powder_tcalloy);
        CDALLOY.ingot(ModItems.ingot_cdalloy).dust(ModItems.powder_cdalloy);
        GRAPHITE.ingot(ModItems.ingot_graphite).block(ModBlocks.block_graphite);
        DURA.ingot(ModItems.ingot_dura_steel).dust(ModItems.powder_dura_steel).block(ModBlocks.block_dura_steel);
        POLYMER.ingot(ModItems.ingot_polymer).dust(ModItems.powder_polymer).block(ModBlocks.block_polymer);
        BAKELITE.ingot(ModItems.ingot_bakelite).dust(ModItems.powder_bakelite).block(ModBlocks.block_bakelite);
        RUBBER.ingot(ModItems.ingot_rubber).block(ModBlocks.block_rubber);
        LATEX.ingot(ModItems.ingot_biorubber).gem(ModItems.ball_resin);
        MAGTUNG.ingot(ModItems.ingot_magnetized_tungsten).dust(ModItems.powder_magnetized_tungsten).block(ModBlocks.block_magnetized_tungsten);
        CMB.ingot(ModItems.ingot_combine_steel).dust(ModItems.powder_combine_steel).block(ModBlocks.block_combine_steel).plate(ModItems.plate_combine_steel);
        DESH.nugget(ModItems.nugget_desh).ingot(ModItems.ingot_desh).dust(ModItems.powder_desh).block(ModBlocks.block_desh);
        STAR.ingot(ModItems.ingot_starmetal).block(ModBlocks.block_starmetal).crystal(ModItems.crystal_starmetal).ore(ModBlocks.ore_meteor_starmetal);
        BIGMT.ingot(ModItems.ingot_saturnite).plate(ModItems.plate_saturnite);
        FERRO.ingot(ModItems.ingot_ferrouranium);
        EUPH.nugget(ModItems.nugget_euphemium).ingot(ModItems.ingot_euphemium).dust(ModItems.powder_euphemium).block(ModBlocks.block_euphemium);
        DNT.nugget(ModItems.nugget_dineutronium).ingot(ModItems.ingot_dineutronium).dust(ModItems.powder_dineutronium).block(ModBlocks.block_dineutronium);
        FIBER.ingot(ModItems.ingot_fiberglass).block(ModBlocks.block_fiberglass);
        ASBESTOS.asbestos(1.0f).ingot(ModItems.ingot_asbestos).dust(ModItems.powder_asbestos).block(ModBlocks.block_asbestos).crystal(ModItems.crystal_asbestos).ore(ModBlocks.ore_asbestos, ModBlocks.ore_gneiss_asbestos, ModBlocks.basalt_asbestos);
        OSMIRIDIUM.nugget(ModItems.nugget_osmiridium).ingot(ModItems.ingot_osmiridium).dust(ModItems.powder_osmiridium).crystal(ModItems.crystal_osmiridium);
        U.rad(0.35f).nugget(ModItems.nugget_uranium).billet(ModItems.billet_uranium).ingot(ModItems.ingot_uranium).dust(ModItems.powder_uranium).block(ModBlocks.block_uranium).crystal(ModItems.crystal_uranium).ore(ModBlocks.ore_uranium, ModBlocks.ore_uranium_scorched, ModBlocks.ore_gneiss_uranium, ModBlocks.ore_gneiss_uranium_scorched, ModBlocks.ore_nether_uranium, ModBlocks.ore_nether_uranium_scorched, ModBlocks.ore_meteor_uranium).oreNether(ModBlocks.ore_nether_uranium, ModBlocks.ore_nether_uranium_scorched);
        U233.rad(5.0f).nugget(ModItems.nugget_u233).billet(ModItems.billet_u233).ingot(ModItems.ingot_u233).block(ModBlocks.block_u233);
        U235.rad(1.0f).nugget(ModItems.nugget_u235).billet(ModItems.billet_u235).ingot(ModItems.ingot_u235).block(ModBlocks.block_u235);
        U238.rad(0.25f).nugget(ModItems.nugget_u238).billet(ModItems.billet_u238).ingot(ModItems.ingot_u238).block(ModBlocks.block_u238);
        TH232.rad(0.1f).nugget(ModItems.nugget_th232).billet(ModItems.billet_th232).ingot(ModItems.ingot_th232).dust(ModItems.powder_thorium).block(ModBlocks.block_thorium).crystal(ModItems.crystal_thorium).ore(ModBlocks.ore_thorium, ModBlocks.ore_meteor_thorium);
        PU.rad(7.5f).nugget(ModItems.nugget_plutonium).billet(ModItems.billet_plutonium).ingot(ModItems.ingot_plutonium).dust(ModItems.powder_plutonium).block(ModBlocks.block_plutonium).crystal(ModItems.crystal_plutonium).ore(ModBlocks.ore_nether_plutonium).oreNether(ModBlocks.ore_nether_plutonium);
        PURG.rad(6.25f).nugget(ModItems.nugget_pu_mix).billet(ModItems.billet_pu_mix).ingot(ModItems.ingot_pu_mix).block(ModBlocks.block_pu_mix);
        PU238.rad(10.0f).hot(3.0f).nugget(ModItems.nugget_pu238).billet(ModItems.billet_pu238).ingot(ModItems.ingot_pu238).block(ModBlocks.block_pu238);
        PU239.rad(5.0f).nugget(ModItems.nugget_pu239).billet(ModItems.billet_pu239).ingot(ModItems.ingot_pu239).block(ModBlocks.block_pu239);
        PU240.rad(7.5f).nugget(ModItems.nugget_pu240).billet(ModItems.billet_pu240).ingot(ModItems.ingot_pu240).block(ModBlocks.block_pu240);
        PU241.rad(25.0f).nugget(ModItems.nugget_pu241).billet(ModItems.billet_pu241).ingot(ModItems.ingot_pu241);
        AM241.rad(8.5f).nugget(ModItems.nugget_am241).billet(ModItems.billet_am241).ingot(ModItems.ingot_am241);
        AM242.rad(9.5f).nugget(ModItems.nugget_am242).billet(ModItems.billet_am242).ingot(ModItems.ingot_am242);
        AMRG.rad(9.0f).nugget(ModItems.nugget_am_mix).billet(ModItems.billet_am_mix).ingot(ModItems.ingot_am_mix);
        SA326.rad(15.0f).blinding(50.0f).nugget(ModItems.nugget_schrabidium).billet(ModItems.billet_schrabidium).ingot(ModItems.ingot_schrabidium).dust(ModItems.powder_schrabidium).block(ModBlocks.block_schrabidium).crystal(ModItems.crystal_schrabidium).plate(ModItems.plate_schrabidium).ore(ModBlocks.ore_schrabidium, ModBlocks.ore_gneiss_schrabidium, ModBlocks.ore_nether_schrabidium).oreNether(ModBlocks.ore_nether_schrabidium);
        SA327.rad(17.5f).blinding(50.0f).nugget(ModItems.nugget_solinium).billet(ModItems.billet_solinium).ingot(ModItems.ingot_solinium).block(ModBlocks.block_solinium);
        SBD.rad(3.0f).blinding(50.0f).ingot(ModItems.ingot_schrabidate).dust(ModItems.powder_schrabidate).block(ModBlocks.block_schrabidate);
        SRN.rad(1.5f).blinding(50.0f).ingot(ModItems.ingot_schraranium).block(ModBlocks.block_schraranium).crystal(ModItems.crystal_schraranium);
        CO.nugget(ModItems.fragment_cobalt, ModItems.nugget_cobalt).ingot(ModItems.ingot_cobalt).dust(ModItems.powder_cobalt).dustSmall(ModItems.powder_cobalt_tiny).block(ModBlocks.block_cobalt).crystal(ModItems.crystal_cobalt).ore(ModBlocks.ore_cobalt, ModBlocks.ore_nether_cobalt);
        CO60.rad(30.0f).hot(1.0f).nugget(ModItems.nugget_co60).billet(ModItems.billet_co60).ingot(ModItems.ingot_co60).dust(ModItems.powder_co60).dustSmall(ModItems.powder_co60_tiny);
        SR.nugget(ModItems.nugget_strontium).ingot(ModItems.ingot_strontium).dust(ModItems.powder_strontium);
        SR90.rad(15.0f).hot(1.0f).hydro(1.0f).nugget(ModItems.nugget_sr90).billet(ModItems.billet_sr90).ingot(ModItems.ingot_sr90).dust(ModItems.powder_sr90).dustSmall(ModItems.powder_sr90_tiny);
        I.ingot(ModItems.ingot_iodine).dust(ModItems.powder_iodine).dustSmall(ModItems.powder_iodine_tiny);
        I131.rad(150.0f).hot(1.0f).ingot(ModItems.ingot_i131).dust(ModItems.powder_i131).dustSmall(ModItems.powder_i131_tiny);
        CS.ingot(ModItems.ingot_caesium).dust(ModItems.powder_caesium);
        CS137.rad(20.0f).hot(3.0f).hydro(3.0f).dust(ModItems.powder_cs137).dustSmall(ModItems.powder_cs137_tiny);
        AT.ingot(ModItems.ingot_astatine).dust(ModItems.powder_astatine);
        AT209.rad(7500.0f).hot(20.0f).dust(ModItems.powder_at209).dustSmall(ModItems.powder_at209_tiny);
        XE135.rad(1250.0f).hot(10.0f).dust(ModItems.powder_xe135).dustSmall(ModItems.powder_xe135_tiny);
        TS.ingot(ModItems.ingot_tennessine).dust(ModItems.powder_tennessine);
        NP237.rad(2.5f).nugget(ModItems.nugget_neptunium).billet(ModItems.billet_neptunium).ingot(ModItems.ingot_neptunium).dust(ModItems.powder_neptunium).block(ModBlocks.block_neptunium);
        PO210.rad(75.0f).hot(3.0f).nugget(ModItems.nugget_polonium).billet(ModItems.billet_polonium).ingot(ModItems.ingot_polonium).dust(ModItems.powder_polonium).block(ModBlocks.block_polonium);
        TC99.rad(2.75f).nugget(ModItems.nugget_technetium).billet(ModItems.billet_technetium).ingot(ModItems.ingot_technetium);
        RA226.rad(7.5f).nugget(ModItems.nugget_ra226).billet(ModItems.billet_ra226).ingot(ModItems.ingot_ra226).dust(ModItems.powder_ra226).block(ModBlocks.block_ra226);
        AC227.rad(30.0f).nugget(ModItems.nugget_ac227).billet(ModItems.billet_ac227).ingot(ModItems.ingot_ac227).dust(ModItems.powder_ac227).dustSmall(ModItems.powder_ac227_tiny);
        AU198.rad(500.0f).hot(5.0f).nugget(ModItems.nugget_au198).billet(ModItems.billet_au198).ingot(ModItems.ingot_au198).dust(ModItems.powder_au198).dustSmall(ModItems.powder_au198_tiny).block(ModBlocks.block_au198);
        PB209.rad(10000.0f).blinding(50.0f).hot(7.0f).nugget(ModItems.nugget_pb209).billet(ModItems.billet_pb209).ingot(ModItems.ingot_pb209).dust(ModItems.powder_pb209).dustSmall(ModItems.powder_pb209_tiny);
        GH336.rad(5.0f).nugget(ModItems.nugget_gh336).billet(ModItems.billet_gh336).ingot(ModItems.ingot_gh336);
        AUSTRALIUM.nugget(ModItems.nugget_australium).billet(ModItems.billet_australium).ingot(ModItems.ingot_australium).dust(ModItems.powder_australium).block(ModBlocks.block_australium).ore(ModBlocks.ore_australium);
        REIIUM.nugget(ModItems.nugget_reiium).ingot(ModItems.ingot_reiium).dust(ModItems.powder_reiium).block(ModBlocks.block_reiium).ore(ModBlocks.ore_reiium);
        WEIDANIUM.nugget(ModItems.nugget_weidanium).ingot(ModItems.ingot_weidanium).dust(ModItems.powder_weidanium).block(ModBlocks.block_weidanium).ore(ModBlocks.ore_weidanium);
        UNOBTAINIUM.nugget(ModItems.nugget_unobtainium).billet(ModItems.billet_unobtainium).ingot(ModItems.ingot_unobtainium).dust(ModItems.powder_unobtainium).block(ModBlocks.block_unobtainium).ore(ModBlocks.ore_unobtainium);
        VERTICIUM.nugget(ModItems.nugget_verticium).ingot(ModItems.ingot_verticium).dust(ModItems.powder_verticium).block(ModBlocks.block_verticium).ore(ModBlocks.ore_verticium);
        DAFFERGON.nugget(ModItems.nugget_daffergon).ingot(ModItems.ingot_daffergon).dust(ModItems.powder_daffergon).block(ModBlocks.block_daffergon).ore(ModBlocks.ore_daffergon);
        ANY_GUNPOWDER.dust(Items.field_151016_H, ModItems.ballistite, ModItems.cordite);
        ANY_SMOKELESS.dust(ModItems.ballistite, ModItems.cordite);
        ANY_PLASTICEXPLOSIVE.ingot(ModItems.ingot_semtex, ModItems.ingot_c4);
        ANY_HIGHEXPLOSIVE.ingot(ModItems.ball_tnt, ModItems.ball_dynamite);
        ANY_CONCRETE.any(ModBlocks.concrete, ModBlocks.concrete_smooth, ModBlocks.concrete_asbestos, ModBlocks.ducrete, ModBlocks.ducrete_smooth);
        ANY_COKE.block(ModBlocks.block_coke).gem(DictFrame.fromAll(ModItems.coke, ItemEnums.EnumCokeType.class));
        LIGNITE.dust(ModItems.powder_lignite).block(ModBlocks.block_lignite).gem(ModItems.lignite).ore(ModBlocks.ore_lignite);
        CINNABAR.gem(ModItems.cinnebar).crystal(ModItems.crystal_cinnebar).ore(ModBlocks.ore_cinnebar, ModBlocks.ore_depth_cinnebar);
        BORAX.dust(ModItems.powder_borax).ore(ModBlocks.ore_depth_borax);
        VOLCANIC.gem(ModItems.gem_volcanic).ore(ModBlocks.basalt_gem);
        OreDictionary.registerOre((String)KEY_OIL_TAR, (ItemStack)DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRUDE));
        OreDictionary.registerOre((String)KEY_UNIVERSAL_TANK, (ItemStack)new ItemStack(ModItems.fluid_tank_full, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)KEY_UNIVERSAL_BARREL, (ItemStack)new ItemStack(ModItems.fluid_barrel_full, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)KEY_TOOL_SCREWDRIVER, (ItemStack)new ItemStack(ModItems.screwdriver, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)KEY_TOOL_SCREWDRIVER, (ItemStack)new ItemStack(ModItems.screwdriver_desh, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)KEY_TOOL_HANDDRILL, (ItemStack)new ItemStack(ModItems.hand_drill, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)KEY_TOOL_HANDDRILL, (ItemStack)new ItemStack(ModItems.hand_drill_desh, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)KEY_CIRCUIT_BISMUTH, (Item)ModItems.circuit_bismuth);
        OreDictionary.registerOre((String)KEY_CIRCUIT_BISMUTH, (Item)ModItems.circuit_arsenic);
        OreDictionary.registerOre((String)"itemRubber", (Item)ModItems.ingot_rubber);
        OreDictionary.registerOre((String)"coalCoke", (ItemStack)DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.COAL));
        for (String name : new String[]{"fuelCoke", "coke"}) {
            OreDictionary.registerOre((String)name, (ItemStack)DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.COAL));
        }
        OreDictionary.registerOre((String)OreDictManager.getReflector(), (Item)ModItems.neutron_reflector);
        OreDictionary.registerOre((String)KEY_LOG, (Block)ModBlocks.pink_log);
        OreDictionary.registerOre((String)"logWoodPink", (Block)ModBlocks.pink_log);
        OreDictionary.registerOre((String)KEY_PLANKS, (Block)ModBlocks.pink_planks);
        OreDictionary.registerOre((String)"plankWoodPink", (Block)ModBlocks.pink_planks);
        OreDictionary.registerOre((String)KEY_SLAB, (Block)ModBlocks.pink_slab);
        OreDictionary.registerOre((String)"slabWoodPink", (Block)ModBlocks.pink_slab);
        OreDictionary.registerOre((String)"stairWood", (Block)ModBlocks.pink_stairs);
        OreDictionary.registerOre((String)"stairWoodPink", (Block)ModBlocks.pink_stairs);
        OreDictionary.registerOre((String)KEY_SAND, (Block)Blocks.field_150354_m);
        OreDictionary.registerOre((String)KEY_SAND, (ItemStack)new ItemStack((Block)Blocks.field_150354_m, 1, 1));
        OreDictionary.registerOre((String)KEY_GRAVEL, (Block)Blocks.field_150351_n);
        OreDictionary.registerOre((String)KEY_PLANKS, (Block)Blocks.field_150344_f);
        OreDictionary.registerOre((String)KEY_PLANKS, (ItemStack)new ItemStack(Blocks.field_150344_f, 1, 1));
        OreDictionary.registerOre((String)KEY_PLANKS, (ItemStack)new ItemStack(Blocks.field_150344_f, 1, 2));
        OreDictionary.registerOre((String)KEY_PLANKS, (ItemStack)new ItemStack(Blocks.field_150344_f, 1, 3));
        OreDictionary.registerOre((String)KEY_PLANKS, (ItemStack)new ItemStack(Blocks.field_150344_f, 1, 4));
        OreDictionary.registerOre((String)KEY_PLANKS, (ItemStack)new ItemStack(Blocks.field_150344_f, 1, 5));
        OreDictionary.registerOre((String)KEY_RED, (Item)ModItems.cinnebar);
        OreDictionary.registerOre((String)"dye", (Item)ModItems.cinnebar);
        OreDictionary.registerOre((String)KEY_YELLOW, (Item)ModItems.sulfur);
        OreDictionary.registerOre((String)"dye", (Item)ModItems.sulfur);
        OreDictionary.registerOre((String)KEY_BLACK, (Item)ModItems.powder_coal);
        OreDictionary.registerOre((String)"dye", (Item)ModItems.powder_coal);
        OreDictionary.registerOre((String)KEY_BROWN, (Item)ModItems.powder_lignite);
        OreDictionary.registerOre((String)"dye", (Item)ModItems.powder_lignite);
        OreDictionary.registerOre((String)KEY_LIGHTGRAY, (Item)ModItems.powder_titanium);
        OreDictionary.registerOre((String)"dye", (Item)ModItems.powder_titanium);
        OreDictionary.registerOre((String)KEY_WHITE, (Item)ModItems.fluorite);
        OreDictionary.registerOre((String)"dye", (Item)ModItems.fluorite);
        OreDictionary.registerOre((String)KEY_BLUE, (Item)ModItems.powder_lapis);
        OreDictionary.registerOre((String)"dye", (Item)ModItems.powder_lapis);
        OreDictionary.registerOre((String)KEY_BLACK, (ItemStack)DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRUDE));
        OreDictionary.registerOre((String)"dye", (Item)ModItems.oil_tar);
        OreDictionary.registerOre((String)KEY_ANYGLASS, (Block)ModBlocks.glass_boron);
        OreDictionary.registerOre((String)KEY_ANYGLASS, (Block)ModBlocks.glass_lead);
        OreDictionary.registerOre((String)KEY_ANYGLASS, (Block)ModBlocks.glass_uranium);
        OreDictionary.registerOre((String)KEY_ANYGLASS, (Block)ModBlocks.glass_trinitite);
        OreDictionary.registerOre((String)KEY_ANYGLASS, (Block)ModBlocks.glass_polonium);
        OreDictionary.registerOre((String)KEY_ANYGLASS, (Block)ModBlocks.glass_ash);
        OreDictionary.registerOre((String)"blockGlassYellow", (Block)ModBlocks.glass_uranium);
        OreDictionary.registerOre((String)"blockGlassLime", (Block)ModBlocks.glass_trinitite);
        OreDictionary.registerOre((String)"blockGlassRed", (Block)ModBlocks.glass_polonium);
        OreDictionary.registerOre((String)"blockGlassBlack", (Block)ModBlocks.glass_ash);
    }

    public static String getReflector() {
        return GeneralConfig.enableReflectorCompat ? "plateDenseLead" : "plateTungCar";
    }

    public static void registerGroups() {
        ANY_RUBBER.addPrefix("ingot", true);
        ANY_PLASTIC.addPrefix("ingot", true).addPrefix("dust", true).addPrefix("block", true);
        ANY_RESISTANTALLOY.addPrefix("ingot", true).addPrefix("dust", true);
        ANY_TAR.addPrefix("any", false);
    }

    @SubscribeEvent
    public void onRegisterOre(OreDictionary.OreRegisterEvent event) {
        if (recursionBrake) {
            return;
        }
        recursionBrake = true;
        HashSet<String> strings = reRegistration.get(event.getName());
        if (strings != null) {
            for (String name : strings) {
                OreDictionary.registerOre((String)name, (ItemStack)event.getOre());
                MainRegistry.logger.info("OreDict: Re-registration for " + event.getName() + " to " + name);
            }
        }
        recursionBrake = false;
    }

    private static void addReRegistration(String original, String additional) {
        HashSet<String> strings = reRegistration.get(original);
        if (strings == null) {
            strings = new HashSet();
        }
        strings.add(additional);
        reRegistration.put(original, strings);
    }

    public static class DictGroup {
        private String groupName;
        private HashSet<String> names = new HashSet();

        public DictGroup(String groupName) {
            this.groupName = groupName;
        }

        public DictGroup(String groupName, String ... names) {
            this(groupName);
            this.addNames(names);
        }

        public DictGroup(String groupName, DictFrame ... frames) {
            this(groupName);
            this.addFrames(frames);
        }

        public DictGroup addNames(String ... names) {
            for (String mat : names) {
                this.names.add(mat);
            }
            return this;
        }

        public DictGroup addFrames(DictFrame ... frames) {
            for (DictFrame frame : frames) {
                this.addNames(frame.mats);
            }
            return this;
        }

        public DictGroup addPrefix(String prefix, boolean inputPrefix) {
            String group = prefix + this.groupName;
            for (String name : this.names) {
                String original = (inputPrefix ? prefix : "") + name;
                OreDictManager.addReRegistration(original, group);
            }
            return this;
        }

        public DictGroup addFixed(String prefix, String original) {
            String group = prefix + this.groupName;
            OreDictManager.addReRegistration(original, group);
            return this;
        }

        public String any() {
            return "any" + this.groupName;
        }

        public String nugget() {
            return "nugget" + this.groupName;
        }

        public String tiny() {
            return "tiny" + this.groupName;
        }

        public String ingot() {
            return "ingot" + this.groupName;
        }

        public String dustTiny() {
            return "dustTiny" + this.groupName;
        }

        public String dust() {
            return "dust" + this.groupName;
        }

        public String gem() {
            return "gem" + this.groupName;
        }

        public String crystal() {
            return "crystal" + this.groupName;
        }

        public String plate() {
            return "plate" + this.groupName;
        }

        public String billet() {
            return "billet" + this.groupName;
        }

        public String block() {
            return "block" + this.groupName;
        }

        public String ore() {
            return "ore" + this.groupName;
        }
    }

    public static class DictFrame {
        public String[] mats;
        float hazMult = 1.0f;
        List<HazardEntry> hazards = new ArrayList<HazardEntry>();

        public DictFrame(String ... mats) {
            this.mats = mats;
        }

        public String any() {
            return "any" + this.mats[0];
        }

        public String nugget() {
            return "nugget" + this.mats[0];
        }

        public String tiny() {
            return "tiny" + this.mats[0];
        }

        public String ingot() {
            return "ingot" + this.mats[0];
        }

        public String dustTiny() {
            return "dustTiny" + this.mats[0];
        }

        public String dust() {
            return "dust" + this.mats[0];
        }

        public String gem() {
            return "gem" + this.mats[0];
        }

        public String crystal() {
            return "crystal" + this.mats[0];
        }

        public String plate() {
            return "plate" + this.mats[0];
        }

        public String billet() {
            return "billet" + this.mats[0];
        }

        public String block() {
            return "block" + this.mats[0];
        }

        public String ore() {
            return "ore" + this.mats[0];
        }

        public String[] anys() {
            return this.appendToAll("any");
        }

        public String[] nuggets() {
            return this.appendToAll("nugget");
        }

        public String[] tinys() {
            return this.appendToAll("tiny");
        }

        public String[] allNuggets() {
            return this.appendToAll("nugget", "tiny");
        }

        public String[] ingots() {
            return this.appendToAll("ingot");
        }

        public String[] dustTinys() {
            return this.appendToAll("dustTiny");
        }

        public String[] dusts() {
            return this.appendToAll("dust");
        }

        public String[] gems() {
            return this.appendToAll("gem");
        }

        public String[] crystals() {
            return this.appendToAll("crystal");
        }

        public String[] plates() {
            return this.appendToAll("plate");
        }

        public String[] billets() {
            return this.appendToAll("billet");
        }

        public String[] blocks() {
            return this.appendToAll("block");
        }

        public String[] ores() {
            return this.appendToAll("ore");
        }

        private String[] appendToAll(String ... prefix) {
            String[] names = new String[this.mats.length * prefix.length];
            for (int i = 0; i < this.mats.length; ++i) {
                for (int j = 0; j < prefix.length; ++j) {
                    names[i * prefix.length + j] = prefix[j] + this.mats[i];
                }
            }
            return names;
        }

        public DictFrame rad(float rad) {
            return this.haz(new HazardEntry(HazardRegistry.RADIATION, rad));
        }

        public DictFrame hot(float time) {
            return this.haz(new HazardEntry(HazardRegistry.HOT, time));
        }

        public DictFrame blinding(float time) {
            return this.haz(new HazardEntry(HazardRegistry.BLINDING, time));
        }

        public DictFrame asbestos(float asb) {
            return this.haz(new HazardEntry(HazardRegistry.ASBESTOS, asb));
        }

        public DictFrame hydro(float h) {
            return this.haz(new HazardEntry(HazardRegistry.HYDROACTIVE, h));
        }

        public DictFrame haz(HazardEntry hazard) {
            this.hazards.add(hazard);
            return this;
        }

        public static ItemStack fromOne(Item item, Enum en) {
            return new ItemStack(item, 1, en.ordinal());
        }

        public static ItemStack fromOne(Block block, Enum en) {
            return new ItemStack(block, 1, en.ordinal());
        }

        public static ItemStack fromOne(Item item, Enum en, int stacksize) {
            return new ItemStack(item, stacksize, en.ordinal());
        }

        public static ItemStack fromOne(Block block, Enum en, int stacksize) {
            return new ItemStack(block, stacksize, en.ordinal());
        }

        public static Object[] fromAll(Item item, Class<? extends Enum> en) {
            Enum[] vals = en.getEnumConstants();
            Object[] stacks = new Object[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                stacks[i] = new ItemStack(item, 1, vals[i].ordinal());
            }
            return stacks;
        }

        public DictFrame any(Object ... thing) {
            return this.makeObject("any", thing);
        }

        public DictFrame nugget(Object ... nugget) {
            this.hazMult = 0.1f;
            return this.makeObject("nugget", nugget).makeObject("tiny", nugget);
        }

        public DictFrame ingot(Object ... ingot) {
            this.hazMult = 1.0f;
            return this.makeObject("ingot", ingot);
        }

        public DictFrame dustSmall(Object ... dustSmall) {
            this.hazMult = 0.3f;
            return this.makeObject("dustTiny", dustSmall);
        }

        public DictFrame dust(Object ... dust) {
            this.hazMult = 3.0f;
            return this.makeObject("dust", dust);
        }

        public DictFrame gem(Object ... gem) {
            this.hazMult = 1.0f;
            return this.makeObject("gem", gem);
        }

        public DictFrame crystal(Object ... crystal) {
            this.hazMult = 1.0f;
            return this.makeObject("crystal", crystal);
        }

        public DictFrame plate(Object ... plate) {
            this.hazMult = 1.0f;
            return this.makeObject("plate", plate);
        }

        public DictFrame billet(Object ... billet) {
            this.hazMult = 0.5f;
            return this.makeObject("billet", billet);
        }

        public DictFrame block(Object ... block) {
            this.hazMult = 10.0f;
            return this.makeObject("block", block);
        }

        public DictFrame ore(Object ... ore) {
            this.hazMult = 1.0f;
            return this.makeObject("ore", ore);
        }

        public DictFrame oreNether(Object ... oreNether) {
            this.hazMult = 1.0f;
            return this.makeObject("oreNether", oreNether);
        }

        public DictFrame makeObject(String tag, Object ... objects) {
            for (Object o : objects) {
                if (o instanceof Item) {
                    this.registerStack(tag, new ItemStack((Item)o));
                }
                if (o instanceof Block) {
                    this.registerStack(tag, new ItemStack((Block)o));
                }
                if (!(o instanceof ItemStack)) continue;
                this.registerStack(tag, (ItemStack)o);
            }
            return this;
        }

        public DictFrame makeItem(String tag, Item ... items) {
            for (Item i : items) {
                this.registerStack(tag, new ItemStack(i));
            }
            return this;
        }

        public DictFrame makeStack(String tag, ItemStack ... stacks) {
            for (ItemStack s : stacks) {
                this.registerStack(tag, s);
            }
            return this;
        }

        public DictFrame makeBlocks(String tag, Block ... blocks) {
            for (Block b : blocks) {
                this.registerStack(tag, new ItemStack(b));
            }
            return this;
        }

        public void registerStack(String tag, ItemStack stack) {
            for (String mat : this.mats) {
                OreDictionary.registerOre((String)(tag + mat), (ItemStack)stack);
                if (this.hazards.isEmpty() || !(this.hazMult > 0.0f)) continue;
                HazardData data = new HazardData().setMutex(1);
                for (HazardEntry hazard : this.hazards) {
                    data.addEntry(hazard.clone(this.hazMult));
                }
                HazardSystem.register(tag + mat, data);
            }
            if ("ingot".equals(tag)) {
                this.registerStack("", stack);
            }
        }
    }
}

