/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.interfaces.IBulletHitBehavior;
import com.hbm.interfaces.IBulletImpactBehavior;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.misc.RenderScreenOverlay;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Gun556mmFactory {
    static float inaccuracy = 2.5f;

    public static GunConfiguration getEuphieConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 2;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.hasSights = false;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 40;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CROSS;
        config.durability = 10000;
        config.reloadSound = GunConfiguration.RSOUND_MAG;
        config.firingSound = HBMSoundHandler.hksShoot;
        config.reloadSoundEnd = false;
        config.name = "Britannian Standard Issue Assault Rifle";
        config.manufacturer = "BAE Systems plc";
        config.comment.add("Why is this gun so sticky?");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.R556_GOLD);
        config.config.add(BulletConfigSyncingUtil.R556_NORMAL);
        config.config.add(BulletConfigSyncingUtil.R556_TRACER);
        config.config.add(BulletConfigSyncingUtil.R556_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.R556_AP);
        config.config.add(BulletConfigSyncingUtil.R556_DU);
        config.config.add(BulletConfigSyncingUtil.R556_STAR);
        config.config.add(BulletConfigSyncingUtil.CHL_R556);
        config.config.add(BulletConfigSyncingUtil.R556_SLEEK);
        config.config.add(BulletConfigSyncingUtil.R556_K);
        return config;
    }

    public static GunConfiguration getSPIWConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 3;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.hasSights = true;
        config.reloadDuration = 25;
        config.firingDuration = 0;
        config.ammoCap = 30;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_BOX;
        config.durability = 7000;
        config.reloadSound = GunConfiguration.RSOUND_MAG;
        config.firingSound = HBMSoundHandler.hksShoot;
        config.reloadSoundEnd = false;
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.5, 0.0, 0.0, 25)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 75))));
        config.name = "H&R SPIW";
        config.manufacturer = "Harrington & Richardson";
        config.comment.add("Launch some flechettes in the breeze");
        config.comment.add("Find his arms nailed to the trees");
        config.comment.add("Napalm sticks to kids");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.R556_FLECHETTE);
        config.config.add(BulletConfigSyncingUtil.R556_FLECHETTE_INCENDIARY);
        config.config.add(BulletConfigSyncingUtil.R556_FLECHETTE_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.R556_FLECHETTE_DU);
        config.config.add(BulletConfigSyncingUtil.CHL_R556_FLECHETTE);
        config.config.add(BulletConfigSyncingUtil.R556_FLECHETTE_SLEEK);
        config.config.add(BulletConfigSyncingUtil.R556_K);
        return config;
    }

    public static GunConfiguration getGLauncherConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 60;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.hasSights = true;
        config.reloadDuration = 40;
        config.firingDuration = 0;
        config.ammoCap = 0;
        config.reloadType = 0;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCUMFLEX;
        config.firingSound = HBMSoundHandler.glauncher;
        config.reloadSound = GunConfiguration.RSOUND_GRENADE;
        config.reloadSoundEnd = false;
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.GRENADE_NORMAL);
        config.config.add(BulletConfigSyncingUtil.GRENADE_HE);
        config.config.add(BulletConfigSyncingUtil.GRENADE_INCENDIARY);
        config.config.add(BulletConfigSyncingUtil.GRENADE_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.GRENADE_CHEMICAL);
        config.config.add(BulletConfigSyncingUtil.GRENADE_CONCUSSION);
        config.config.add(BulletConfigSyncingUtil.GRENADE_FINNED);
        config.config.add(BulletConfigSyncingUtil.GRENADE_SLEEK);
        config.config.add(BulletConfigSyncingUtil.GRENADE_NUCLEAR);
        config.config.add(BulletConfigSyncingUtil.GRENADE_TRACER);
        config.config.add(BulletConfigSyncingUtil.GRENADE_KAMPF);
        return config;
    }

    public static BulletConfiguration get556Config() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_556;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 2.0f;
        bullet.dmgMax = 4.0f;
        return bullet;
    }

    public static BulletConfiguration get556GoldConfig() {
        BulletConfiguration bullet = Gun556mmFactory.get556Config();
        bullet.ammo = ModItems.ammo_566_gold;
        bullet.spread = 0.0f;
        return bullet;
    }

    public static BulletConfiguration get556PhosphorusConfig() {
        BulletConfiguration bullet = Gun556mmFactory.get556Config();
        bullet.ammo = ModItems.ammo_556_phosphorus;
        bullet.wear = 15;
        bullet.incendiary = 5;
        bullet.doesPenetrate = false;
        PotionEffect eff = new PotionEffect((Potion)HbmPotion.phosphorus, 400, 0, true, false);
        eff.getCurativeItems().clear();
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(eff));
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaburst");
                data.func_74778_a("mode", "flame");
                data.func_74768_a("count", 15);
                data.func_74780_a("motion", 0.05);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0));
            }
        };
        return bullet;
    }

    public static BulletConfiguration get556APConfig() {
        BulletConfiguration bullet = Gun556mmFactory.get556Config();
        bullet.ammo = ModItems.ammo_556_ap;
        bullet.dmgMin = 4.0f;
        bullet.dmgMax = 6.0f;
        bullet.wear = 15;
        bullet.leadChance = 10;
        return bullet;
    }

    public static BulletConfiguration get556DUConfig() {
        BulletConfiguration bullet = Gun556mmFactory.get556Config();
        bullet.ammo = ModItems.ammo_556_du;
        bullet.dmgMin = 8.0f;
        bullet.dmgMax = 10.0f;
        bullet.wear = 25;
        bullet.leadChance = 50;
        return bullet;
    }

    public static BulletConfiguration get556StarConfig() {
        BulletConfiguration bullet = Gun556mmFactory.get556Config();
        bullet.ammo = ModItems.ammo_556_star;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 20.0f;
        bullet.wear = 25;
        bullet.leadChance = 100;
        return bullet;
    }

    public static BulletConfiguration get556TracerConfig() {
        BulletConfiguration bullet = Gun556mmFactory.get556Config();
        bullet.ammo = ModItems.ammo_556_tracer;
        bullet.vPFX = "reddust";
        return bullet;
    }

    public static BulletConfiguration get556SleekConfig() {
        BulletConfiguration bullet = Gun556mmFactory.get556Config();
        bullet.ammo = ModItems.ammo_556_sleek;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 20.0f;
        bullet.wear = 10;
        bullet.leadChance = 100;
        bullet.doesPenetrate = false;
        bullet.bHit = new IBulletHitBehavior(){

            @Override
            public void behaveEntityHit(EntityBulletBase bullet, Entity hit) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                EntityBulletBase meteor = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.MASKMAN_METEOR);
                meteor.func_70107_b(hit.field_70165_t, hit.field_70163_u + 30.0 + (double)meteor.field_70170_p.field_73012_v.nextInt(10), hit.field_70161_v);
                meteor.field_70181_x = -1.0;
                meteor.shooter = bullet.shooter;
                bullet.field_70170_p.func_72838_d((Entity)meteor);
            }
        };
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (y == -1) {
                    return;
                }
                EntityBulletBase meteor = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.MASKMAN_METEOR);
                meteor.func_70107_b(bullet.field_70165_t, bullet.field_70163_u + 30.0 + (double)meteor.field_70170_p.field_73012_v.nextInt(10), bullet.field_70161_v);
                meteor.field_70181_x = -1.0;
                meteor.shooter = bullet.shooter;
                bullet.field_70170_p.func_72838_d((Entity)meteor);
            }
        };
        return bullet;
    }

    public static BulletConfiguration get556FlechetteSleekConfig() {
        BulletConfiguration bullet = Gun556mmFactory.get556FlechetteConfig();
        bullet.ammo = ModItems.ammo_556_flechette_sleek;
        bullet.dmgMin = 12.0f;
        bullet.dmgMax = 16.0f;
        bullet.wear = 10;
        bullet.leadChance = 50;
        bullet.doesPenetrate = false;
        bullet.bHit = new IBulletHitBehavior(){

            @Override
            public void behaveEntityHit(EntityBulletBase bullet, Entity hit) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                EntityBulletBase meteor = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.MASKMAN_METEOR);
                meteor.func_70107_b(hit.field_70165_t, hit.field_70163_u + 30.0 + (double)meteor.field_70170_p.field_73012_v.nextInt(10), hit.field_70161_v);
                meteor.field_70181_x = -1.0;
                meteor.shooter = bullet.shooter;
                bullet.field_70170_p.func_72838_d((Entity)meteor);
            }
        };
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (y == -1) {
                    return;
                }
                EntityBulletBase meteor = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.MASKMAN_METEOR);
                meteor.func_70107_b(bullet.field_70165_t, bullet.field_70163_u + 30.0 + (double)meteor.field_70170_p.field_73012_v.nextInt(10), bullet.field_70161_v);
                meteor.field_70181_x = -1.0;
                meteor.shooter = bullet.shooter;
                bullet.field_70170_p.func_72838_d((Entity)meteor);
            }
        };
        return bullet;
    }

    public static BulletConfiguration get556FlechetteConfig() {
        BulletConfiguration bullet = Gun556mmFactory.get556Config();
        bullet.ammo = ModItems.ammo_556_flechette;
        bullet.dmgMin = 6.0f;
        bullet.dmgMax = 8.0f;
        bullet.HBRC = 2;
        bullet.LBRC = 95;
        bullet.wear = 15;
        bullet.style = 1;
        bullet.doesPenetrate = false;
        return bullet;
    }

    public static BulletConfiguration get556FlechetteIncendiaryConfig() {
        BulletConfiguration bullet = Gun556mmFactory.get556FlechetteConfig();
        bullet.ammo = ModItems.ammo_556_flechette_incendiary;
        bullet.incendiary = 5;
        return bullet;
    }

    public static BulletConfiguration get556FlechettePhosphorusConfig() {
        BulletConfiguration bullet = Gun556mmFactory.get556FlechetteConfig();
        bullet.ammo = ModItems.ammo_556_flechette_phosphorus;
        bullet.incendiary = 5;
        PotionEffect eff = new PotionEffect((Potion)HbmPotion.phosphorus, 400, 0, true, false);
        eff.getCurativeItems().clear();
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(eff));
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaburst");
                data.func_74778_a("mode", "flame");
                data.func_74768_a("count", 15);
                data.func_74780_a("motion", 0.05);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0));
            }
        };
        return bullet;
    }

    public static BulletConfiguration get556FlechetteDUConfig() {
        BulletConfiguration bullet = Gun556mmFactory.get556FlechetteConfig();
        bullet.ammo = ModItems.ammo_556_flechette_du;
        bullet.dmgMin = 12.0f;
        bullet.dmgMax = 16.0f;
        bullet.wear = 25;
        bullet.leadChance = 50;
        bullet.doesPenetrate = true;
        return bullet;
    }

    public static BulletConfiguration get556KConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_556_k;
        bullet.dmgMin = 0.0f;
        bullet.dmgMax = 0.0f;
        bullet.maxAge = 0;
        return bullet;
    }
}

