/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.items.weapon.ItemMissile;
import com.hbm.render.misc.MissileMultipart;
import com.hbm.render.misc.MissilePart;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MissileStruct {
    public ItemMissile warhead;
    public ItemMissile fuselage;
    public ItemMissile fins;
    public ItemMissile thruster;
    public static final DataSerializer<MissileStruct> SERIALIZER = new DataSerializer<MissileStruct>(){

        public void write(PacketBuffer buf, MissileStruct value) {
            if (value == null) {
                buf.writeInt(-1);
                return;
            }
            buf.writeInt(Item.func_150891_b((Item)value.warhead));
            buf.writeInt(Item.func_150891_b((Item)value.fuselage));
            buf.writeInt(value.fins == null ? -1 : Item.func_150891_b((Item)value.fins));
            buf.writeInt(Item.func_150891_b((Item)value.thruster));
        }

        public MissileStruct read(PacketBuffer buf) throws IOException {
            int i = buf.readInt();
            if (i < 0) {
                return null;
            }
            Item w = Item.func_150899_d((int)i);
            Item f = Item.func_150899_d((int)buf.readInt());
            i = buf.readInt();
            Item s = i < 0 ? null : Item.func_150899_d((int)i);
            Item t = Item.func_150899_d((int)buf.readInt());
            return new MissileStruct(w, f, s, t);
        }

        public DataParameter<MissileStruct> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public MissileStruct copyValue(MissileStruct value) {
            return value;
        }
    };

    public MissileStruct() {
    }

    public MissileStruct(ItemStack w, ItemStack f, ItemStack s, ItemStack t) {
        if (w != null && w.func_77973_b() instanceof ItemMissile) {
            this.warhead = (ItemMissile)w.func_77973_b();
        }
        if (f != null && f.func_77973_b() instanceof ItemMissile) {
            this.fuselage = (ItemMissile)f.func_77973_b();
        }
        if (s != null && s.func_77973_b() instanceof ItemMissile) {
            this.fins = (ItemMissile)s.func_77973_b();
        }
        if (t != null && t.func_77973_b() instanceof ItemMissile) {
            this.thruster = (ItemMissile)t.func_77973_b();
        }
    }

    public MissileStruct(Item w, Item f, Item s, Item t) {
        if (w instanceof ItemMissile) {
            this.warhead = (ItemMissile)w;
        }
        if (f instanceof ItemMissile) {
            this.fuselage = (ItemMissile)f;
        }
        if (s instanceof ItemMissile) {
            this.fins = (ItemMissile)s;
        }
        if (t instanceof ItemMissile) {
            this.thruster = (ItemMissile)t;
        }
    }

    public void writeToByteBuffer(ByteBuf buf) {
        if (this.warhead != null && this.warhead.type == ItemMissile.PartType.WARHEAD) {
            buf.writeInt(Item.func_150891_b((Item)this.warhead));
        } else {
            buf.writeInt(0);
        }
        if (this.fuselage != null && this.fuselage.type == ItemMissile.PartType.FUSELAGE) {
            buf.writeInt(Item.func_150891_b((Item)this.fuselage));
        } else {
            buf.writeInt(0);
        }
        if (this.fins != null && this.fins.type == ItemMissile.PartType.FINS) {
            buf.writeInt(Item.func_150891_b((Item)this.fins));
        } else {
            buf.writeInt(0);
        }
        if (this.thruster != null && this.thruster.type == ItemMissile.PartType.THRUSTER) {
            buf.writeInt(Item.func_150891_b((Item)this.thruster));
        } else {
            buf.writeInt(0);
        }
    }

    public static MissileStruct readFromByteBuffer(ByteBuf buf) {
        MissileStruct multipart = new MissileStruct();
        int w = buf.readInt();
        int f = buf.readInt();
        int s = buf.readInt();
        int t = buf.readInt();
        if (w != 0) {
            multipart.warhead = (ItemMissile)Item.func_150899_d((int)w);
        }
        if (f != 0) {
            multipart.fuselage = (ItemMissile)Item.func_150899_d((int)f);
        }
        if (s != 0) {
            multipart.fins = (ItemMissile)Item.func_150899_d((int)s);
        }
        if (t != 0) {
            multipart.thruster = (ItemMissile)Item.func_150899_d((int)t);
        }
        return multipart;
    }

    @SideOnly(value=Side.CLIENT)
    public MissileMultipart multipart() {
        MissileMultipart missile = new MissileMultipart();
        missile.warhead = MissilePart.getPart(this.warhead);
        missile.fuselage = MissilePart.getPart(this.fuselage);
        missile.fins = MissilePart.getPart(this.fins);
        missile.thruster = MissilePart.getPart(this.thruster);
        return missile;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MissileStruct)) {
            return false;
        }
        MissileStruct str = (MissileStruct)obj;
        return this.warhead == str.warhead && this.fuselage == str.fuselage && this.fins == str.fins && this.thruster == str.thruster;
    }

    public int hashCode() {
        int hashcode = 17;
        hashcode = 31 * hashcode + ((Object)((Object)this.warhead)).hashCode();
        hashcode = 31 * hashcode + ((Object)((Object)this.fuselage)).hashCode();
        if (this.fins != null) {
            hashcode = 31 * hashcode + ((Object)((Object)this.fins)).hashCode();
        }
        hashcode = 31 * hashcode + ((Object)((Object)this.thruster)).hashCode();
        return hashcode;
    }
}

