/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.animloader;

import com.hbm.render.amlfrom1710.Vec3;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;

public class Transform {
    protected static FloatBuffer auxGLMatrix = GLAllocation.func_74529_h((int)16);
    Vec3 scale;
    Vec3 translation;
    Quaternion rotation;
    boolean hidden = false;

    public Transform(float[] matrix) {
        this.scale = this.getScaleFromMatrix(matrix);
        auxGLMatrix.put(matrix);
        auxGLMatrix.rewind();
        this.rotation = new Quaternion().setFromMatrix((Matrix4f)new Matrix4f().load(auxGLMatrix));
        this.translation = Vec3.createVectorHelper(matrix[3], matrix[7], matrix[11]);
        auxGLMatrix.rewind();
    }

    private Vec3 getScaleFromMatrix(float[] matrix) {
        float scaleX = (float)Vec3.createVectorHelper(matrix[0], matrix[1], matrix[2]).lengthVector();
        float scaleY = (float)Vec3.createVectorHelper(matrix[4], matrix[5], matrix[6]).lengthVector();
        float scaleZ = (float)Vec3.createVectorHelper(matrix[8], matrix[9], matrix[10]).lengthVector();
        matrix[0] = matrix[0] / scaleX;
        matrix[1] = matrix[1] / scaleX;
        matrix[2] = matrix[2] / scaleX;
        matrix[4] = matrix[4] / scaleY;
        matrix[5] = matrix[5] / scaleY;
        matrix[6] = matrix[6] / scaleY;
        matrix[8] = matrix[8] / scaleZ;
        matrix[9] = matrix[9] / scaleZ;
        matrix[10] = matrix[10] / scaleZ;
        return Vec3.createVectorHelper(scaleX, scaleY, scaleZ);
    }

    public void interpolateAndApply(Transform other, float inter) {
        Vec3 trans = this.translation.interpolate(other.translation, inter);
        Vec3 scale = this.scale.interpolate(other.scale, inter);
        Quaternion rot = this.slerp(this.rotation, other.rotation, inter);
        GlStateManager.func_187418_a((FloatBuffer)auxGLMatrix, (Quaternion)rot);
        this.scale(auxGLMatrix, scale);
        auxGLMatrix.put(12, (float)trans.xCoord);
        auxGLMatrix.put(13, (float)trans.yCoord);
        auxGLMatrix.put(14, (float)trans.zCoord);
        GlStateManager.func_179110_a((FloatBuffer)auxGLMatrix);
    }

    private void scale(FloatBuffer matrix, Vec3 scale) {
        matrix.put(0, (float)((double)matrix.get(0) * scale.xCoord));
        matrix.put(4, (float)((double)matrix.get(4) * scale.xCoord));
        matrix.put(8, (float)((double)matrix.get(8) * scale.xCoord));
        matrix.put(12, (float)((double)matrix.get(12) * scale.xCoord));
        matrix.put(1, (float)((double)matrix.get(1) * scale.yCoord));
        matrix.put(5, (float)((double)matrix.get(5) * scale.yCoord));
        matrix.put(9, (float)((double)matrix.get(9) * scale.yCoord));
        matrix.put(13, (float)((double)matrix.get(13) * scale.yCoord));
        matrix.put(2, (float)((double)matrix.get(2) * scale.zCoord));
        matrix.put(6, (float)((double)matrix.get(6) * scale.zCoord));
        matrix.put(10, (float)((double)matrix.get(10) * scale.zCoord));
        matrix.put(14, (float)((double)matrix.get(14) * scale.zCoord));
    }

    protected Quaternion slerp(Quaternion v0, Quaternion v1, float t) {
        double dot = Quaternion.dot((Quaternion)v0, (Quaternion)v1);
        if (dot < 0.0) {
            v1 = new Quaternion(-v1.x, -v1.y, -v1.z, -v1.w);
            dot = -dot;
        }
        double DOT_THRESHOLD = 0.9999999;
        if (dot > 0.9999999) {
            Quaternion result = new Quaternion(v0.x + t * v1.x, v0.y + t * v1.y, v0.z + t * v1.z, v0.w + t * v1.w);
            result.normalise();
            return result;
        }
        double theta_0 = Math.acos(dot);
        double theta = theta_0 * (double)t;
        double sin_theta = Math.sin(theta);
        double sin_theta_0 = Math.sin(theta_0);
        float s0 = (float)(Math.cos(theta) - dot * sin_theta / sin_theta_0);
        float s1 = (float)(sin_theta / sin_theta_0);
        return new Quaternion(s0 * v0.x + s1 * v1.x, s0 * v0.y + s1 * v1.y, s0 * v0.z + s1 * v1.z, s0 * v0.w + s1 * v1.w);
    }
}

