/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energy;

import api.hbm.energy.IEnergyConnector;
import api.hbm.energy.IPowerNet;
import com.hbm.lib.ForgeDirection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public interface IEnergyConductor
extends IEnergyConnector {
    public IPowerNet getPowerNet();

    public void setPowerNet(IPowerNet var1);

    default public int getIdentity() {
        return IEnergyConductor.getIdentityFromTile((TileEntity)this);
    }

    public static int getIdentityFromTile(TileEntity te) {
        return IEnergyConductor.getIdentityFromPos(te.func_174877_v());
    }

    public static int getIdentityFromPos(BlockPos pos) {
        int prime = 27644437;
        int result = 1;
        result = 27644437 * result + pos.func_177958_n();
        result = 27644437 * result + pos.func_177956_o();
        result = 27644437 * result + pos.func_177952_p();
        return result;
    }

    default public boolean canReevaluate() {
        return !((TileEntity)this).func_145837_r();
    }

    default public void reevaluate(HashMap<Integer, IEnergyConductor> copy, HashMap<Integer, Integer> proxies) {
        for (BlockPos pos : this.getConnectionPoints()) {
            Integer newId;
            int id = IEnergyConductor.getIdentityFromPos(pos);
            IEnergyConductor neighbor = copy.get(id);
            if (neighbor == null && (newId = proxies.get(id)) != null) {
                neighbor = copy.get(newId);
            }
            if (neighbor == null || !this.canReevaluate() || !neighbor.canReevaluate() || neighbor.getPowerNet() == null) continue;
            if (this.getPowerNet() == null) {
                neighbor.getPowerNet().joinLink(this);
                continue;
            }
            this.getPowerNet().joinNetworks(neighbor.getPowerNet());
        }
    }

    default public List<BlockPos> getConnectionPoints() {
        ArrayList<BlockPos> pos = new ArrayList<BlockPos>();
        TileEntity tile = (TileEntity)this;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            pos.add(tile.func_174877_v().func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ));
        }
        return pos;
    }

    @Override
    default public boolean isLoaded() {
        return true;
    }

    @Override
    default public long transferPower(long power) {
        if (this.getPowerNet() == null) {
            return power;
        }
        return this.getPowerNet().transferPower(power);
    }

    default public boolean hasProxies() {
        return false;
    }

    default public List<Integer> getProxies() {
        return new ArrayList<Integer>();
    }
}

