/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox.entrys;

import com.google.common.collect.ImmutableList;
import com.troblecodings.signals.enums.EnumPathUsage;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.entrys.BlockposEntry;
import com.troblecodings.signals.signalbox.entrys.BoolEntry;
import com.troblecodings.signals.signalbox.entrys.ByteEntry;
import com.troblecodings.signals.signalbox.entrys.EnumEntry;
import com.troblecodings.signals.signalbox.entrys.IPathEntry;
import com.troblecodings.signals.signalbox.entrys.IntegerEntry;
import com.troblecodings.signals.signalbox.entrys.PointEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.math.BlockPos;

public final class PathEntryType<T> {
    private static final Map<String, PathEntryType<?>> NAME_TO_TYPE = new HashMap();
    public static final List<PathEntryType<?>> ALL_ENTRIES = new ArrayList();
    private final Class<? extends IPathEntry<T>> entryClass;
    private final String name;
    private final int entryID;
    public static final PathEntryType<BlockPos> SIGNAL = new PathEntryType(BlockposEntry.class, "signal");
    public static final PathEntryType<BlockPos> BLOCKING = new PathEntryType(BlockposEntry.class, "blocking");
    public static final PathEntryType<BlockPos> RESETING = new PathEntryType(BlockposEntry.class, "reseting");
    public static final PathEntryType<BlockPos> OUTPUT = new PathEntryType(BlockposEntry.class, "output");
    public static final PathEntryType<Integer> SPEED = new PathEntryType(IntegerEntry.class, "speed");
    public static final PathEntryType<Byte> ZS2 = new PathEntryType(ByteEntry.class, "zs2");
    public static final PathEntryType<Boolean> SIGNAL_REPEATER = new PathEntryType(BoolEntry.class, "signal_repeater");
    public static final PathEntryType<Integer> DELAY = new PathEntryType(IntegerEntry.class, "delay");
    public static final PathEntryType<Point> POINT = new PathEntryType(PointEntry.class, "pointentry");
    public static final PathEntryType<BlockPos> SIGNALBOX = new PathEntryType(BlockposEntry.class, "signalbox");
    public static final PathEntryType<EnumPathUsage> PATHUSAGE = new PathEntryType(EnumPathUsageEntry.class, "pathusage");

    private PathEntryType(Class<? extends IPathEntry<T>> entryClass, String name) {
        this.entryClass = entryClass;
        this.name = name;
        this.entryID = ALL_ENTRIES.size();
        NAME_TO_TYPE.put(name, this);
        ALL_ENTRIES.add(this);
    }

    public IPathEntry<T> newValue() {
        try {
            IPathEntry<T> t = this.entryClass.newInstance();
            t.setName(this.name);
            return t;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Class<? extends IPathEntry<T>> getEntryClass() {
        return this.entryClass;
    }

    public String getName() {
        return this.name;
    }

    public static PathEntryType<?> getType(String name) {
        return NAME_TO_TYPE.get(name);
    }

    public static List<PathEntryType<?>> typeList() {
        return ImmutableList.copyOf(NAME_TO_TYPE.values());
    }

    public int getID() {
        return this.entryID;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PathEntryType other = (PathEntryType)obj;
        return Objects.equals(this.entryClass, other.entryClass) && Objects.equals(this.name, other.name);
    }

    public String toString() {
        return this.name;
    }

    private static final class EnumPathUsageEntry
    extends EnumEntry<EnumPathUsage> {
        public EnumPathUsageEntry() {
            super(EnumPathUsage.class);
        }
    }
}

