/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox;

import com.troblecodings.signals.config.ConfigHandler;
import com.troblecodings.signals.enums.EnumPathUsage;
import com.troblecodings.signals.enums.PathType;
import com.troblecodings.signals.signalbox.Path;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxNode;
import com.troblecodings.signals.signalbox.SignalBoxPathway;
import com.troblecodings.signals.signalbox.debug.SignalBoxFactory;
import com.troblecodings.signals.signalbox.entrys.PathEntryType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.Rotation;

public final class SignalBoxUtil {
    public static final int FREE_COLOR = ConfigHandler.signalboxFreeColor;
    public static final int SELECTED_COLOR = ConfigHandler.signalboxSelectColor;
    public static final int USED_COLOR = ConfigHandler.signalboxUsedColor;
    public static final int PREPARED_COLOR = ConfigHandler.signalboxPreparedColor;

    private SignalBoxUtil() {
    }

    private static double calculateHeuristic(Point p1, Point p2) {
        int dX = p2.getX() - p1.getX();
        int dY = p2.getY() - p1.getY();
        return Math.hypot(dX, dY);
    }

    public static Rotation getRotationFromDelta(Point delta) {
        if (delta.getX() > 0) {
            return Rotation.CLOCKWISE_180;
        }
        if (delta.getX() < 0) {
            return Rotation.NONE;
        }
        if (delta.getY() > 0) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        return Rotation.CLOCKWISE_90;
    }

    public static Optional<SignalBoxPathway> requestWay(Map<Point, SignalBoxNode> modeGrid, Point p1, Point p2) {
        if (!modeGrid.containsKey(p1) || !modeGrid.containsKey(p2)) {
            return Optional.empty();
        }
        SignalBoxNode lastNode = modeGrid.get(p2);
        SignalBoxNode firstNode = modeGrid.get(p1);
        PathType pathType = firstNode.getPathType(lastNode);
        if (pathType.equals((Object)PathType.NONE)) {
            return Optional.empty();
        }
        HashMap<Point, Point> closedList = new HashMap<Point, Point>();
        HashMap<Point, Double> fscores = new HashMap<Point, Double>();
        HashMap<Point, Double> gscores = new HashMap<Point, Double>();
        ArrayList<Point> openList = new ArrayList<Point>();
        HashSet<Path> visitedPaths = new HashSet<Path>();
        openList.add(p1);
        gscores.put(p1, 0.0);
        fscores.put(p1, SignalBoxUtil.calculateHeuristic(p1, p2));
        SignalBoxFactory factory = SignalBoxFactory.getFactory();
        ConnectionChecker checker = factory.getConnectionChecker();
        checker.visited = visitedPaths;
        checker.lastNode = lastNode;
        checker.type = pathType;
        while (!openList.isEmpty()) {
            Point currentNode = (Point)openList.stream().min((n1, n2) -> Double.compare(fscores.getOrDefault(n1, (Double)Double.MAX_VALUE), fscores.getOrDefault(n2, (Double)Double.MAX_VALUE))).get();
            openList.remove(currentNode);
            SignalBoxNode nextSignalnode = modeGrid.get(currentNode);
            if (currentNode.equals(p2)) {
                ArrayList<SignalBoxNode> nodes = new ArrayList<SignalBoxNode>();
                Point point = currentNode;
                while (point != null) {
                    SignalBoxNode boxNode = modeGrid.get(point);
                    nodes.add(boxNode);
                    point = (Point)closedList.get(point);
                }
                return Optional.of(factory.getPathway(modeGrid, nodes, pathType));
            }
            if (nextSignalnode == null) continue;
            checker.nextNode = nextSignalnode;
            for (Path entry : nextSignalnode.connections()) {
                double tScore;
                Point neighbour = entry.point2;
                checker.previous = (Point)closedList.get(currentNode);
                if (checker.previous != null) {
                    checker.path = new Path(checker.previous, neighbour);
                }
                if (!currentNode.equals(p1) && !checker.check() || !((tScore = gscores.getOrDefault(currentNode, (Double)Double.MAX_VALUE) + 1.0) < gscores.getOrDefault(neighbour, (Double)Double.MAX_VALUE))) continue;
                closedList.put(neighbour, currentNode);
                gscores.put(neighbour, tScore);
                fscores.put(neighbour, tScore + SignalBoxUtil.calculateHeuristic(neighbour, p2));
                visitedPaths.add(entry);
                visitedPaths.add(entry.getInverse());
                if (openList.contains(neighbour)) continue;
                openList.add(neighbour);
            }
        }
        return Optional.empty();
    }

    public static class ConnectionChecker {
        public Path path;
        public SignalBoxNode nextNode;
        public PathType type;
        public SignalBoxNode lastNode;
        public Point previous;
        public Set<Path> visited;

        public boolean check() {
            if (this.nextNode == null || !this.nextNode.canMakePath(this.path, this.type)) {
                return false;
            }
            Optional optional = this.nextNode.getOption(this.path).flatMap(entry -> entry.getEntry(PathEntryType.PATHUSAGE));
            if (optional.isPresent() && !((EnumPathUsage)((Object)optional.get())).equals((Object)EnumPathUsage.FREE)) {
                return false;
            }
            if (this.nextNode.equals(this.lastNode)) {
                return true;
            }
            return this.previous.equals(this.path.point1) && !this.visited.contains(this.path);
        }
    }
}

