/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox;

import com.troblecodings.core.NBTWrapper;
import com.troblecodings.guilib.ecs.interfaces.ISyncable;
import com.troblecodings.guilib.ecs.interfaces.UIClientSync;
import com.troblecodings.linkableapi.ILinkableTile;
import com.troblecodings.signals.blocks.BasicBlock;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.core.LoadHolder;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.core.StateLoadHolder;
import com.troblecodings.signals.enums.LinkType;
import com.troblecodings.signals.handler.SignalBoxHandler;
import com.troblecodings.signals.handler.SignalStateHandler;
import com.troblecodings.signals.handler.SignalStateInfo;
import com.troblecodings.signals.init.OSBlocks;
import com.troblecodings.signals.signalbox.SignalBoxGrid;
import com.troblecodings.signals.signalbox.debug.SignalBoxFactory;
import com.troblecodings.signals.tileentitys.SyncableTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SignalBoxTileEntity
extends SyncableTileEntity
implements ISyncable,
ILinkableTile {
    private final SignalBoxGrid grid = SignalBoxFactory.getFactory().getGrid();
    private NBTWrapper copy = null;

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.grid.setTile(this);
    }

    @Override
    public void saveWrapper(NBTWrapper wrapper) {
        NBTWrapper gridTag = new NBTWrapper();
        this.grid.write(gridTag);
        this.grid.writePathways(wrapper);
        SignalBoxHandler.writeTileNBT(new StateInfo(this.field_145850_b, this.field_174879_c), wrapper);
        wrapper.putWrapper("guiTag", gridTag);
    }

    @Override
    public void loadWrapper(NBTWrapper wrapper) {
        this.grid.setTile(this);
        this.grid.read(wrapper.getWrapper("guiTag"));
        this.grid.readPathways(wrapper);
        this.copy = wrapper.copy();
        if (this.field_145850_b != null) {
            this.onLoad();
        }
    }

    @Override
    public boolean hasLink() {
        return !SignalBoxHandler.isTileEmpty(new StateInfo(this.field_145850_b, this.field_174879_c));
    }

    @Override
    public boolean link(BlockPos pos, NBTTagCompound tag) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("opensignals", tag.func_74779_i(pos.toString())));
        if (block == null || block instanceof BlockAir) {
            return false;
        }
        LinkType type = LinkType.SIGNAL;
        if (block == OSBlocks.REDSTONE_IN || block == OSBlocks.COMBI_REDSTONE_INPUT) {
            type = LinkType.INPUT;
        } else if (block == OSBlocks.REDSTONE_OUT) {
            type = LinkType.OUTPUT;
        } else if (block == OSBlocks.SIGNAL_BOX) {
            type = LinkType.SIGNALBOX;
        }
        if (type.equals(LinkType.SIGNAL) && !this.field_145850_b.field_72995_K) {
            SignalStateHandler.loadSignal(new StateLoadHolder(new SignalStateInfo(this.field_145850_b, pos, (Signal)block), new LoadHolder<StateInfo>(new StateInfo(this.field_145850_b, pos))));
        }
        return SignalBoxHandler.linkPosToSignalBox(new StateInfo(this.field_145850_b, this.field_174879_c), pos, (BasicBlock)block, type);
    }

    public void onLoad() {
        this.grid.setTile(this);
        this.grid.onLoad();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        StateInfo identifier = new StateInfo(this.field_145850_b, this.field_174879_c);
        SignalBoxHandler.putGrid(identifier, this.grid);
        SignalBoxHandler.readTileNBT(identifier, this.copy == null ? new NBTWrapper() : this.copy);
        SignalBoxHandler.loadSignals(identifier);
    }

    public void onChunkUnload() {
        SignalBoxHandler.unloadSignals(new StateInfo(this.field_145850_b, this.field_174879_c));
    }

    @Override
    public boolean unlink() {
        SignalBoxHandler.unlinkAll(new StateInfo(this.field_145850_b, this.field_174879_c));
        return true;
    }

    public boolean isBlocked() {
        return !this.clientSyncs.isEmpty();
    }

    @Override
    public boolean isValid(EntityPlayer player) {
        if (this.clientSyncs.isEmpty()) {
            return false;
        }
        return ((UIClientSync)this.clientSyncs.get(0)).getPlayer().equals((Object)player);
    }

    public SignalBoxGrid getSignalBoxGrid() {
        return this.grid;
    }

    @Override
    public boolean canBeLinked() {
        return true;
    }
}

