/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.signalbox;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.troblecodings.core.NBTWrapper;
import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.signals.core.TrainNumber;
import com.troblecodings.signals.enums.EnumGuiMode;
import com.troblecodings.signals.enums.PathType;
import com.troblecodings.signals.signalbox.ModeSet;
import com.troblecodings.signals.signalbox.Path;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxUtil;
import com.troblecodings.signals.signalbox.debug.SignalBoxFactory;
import com.troblecodings.signals.signalbox.entrys.INetworkSavable;
import com.troblecodings.signals.signalbox.entrys.PathEntryType;
import com.troblecodings.signals.signalbox.entrys.PathOptionEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class SignalBoxNode
implements INetworkSavable,
Iterable<ModeSet> {
    public static final Set<EnumGuiMode> VALID_MODES = ImmutableSet.of((Object)((Object)EnumGuiMode.HP), (Object)((Object)EnumGuiMode.RS), (Object)((Object)EnumGuiMode.RA10), (Object)((Object)EnumGuiMode.END));
    private final HashMap<Path, ModeSet> possibleConnections = new HashMap();
    private final HashMap<ModeSet, PathOptionEntry> possibleModes = new HashMap();
    private final List<ModeSet> manuellEnabledOutputs = new ArrayList<ModeSet>();
    private final Point point;
    private boolean isAutoPoint = false;
    private String customText = "";
    private TrainNumber trainNumber = TrainNumber.DEFAULT;
    private static final String POINT_LIST = "pointList";
    private static final String ENABLED_OUTPUTS = "enabledOutputs";
    private static final String IS_AUTO_POINT = "isAutoPoint";
    private static final String CUSTOM_NAME = "customTextName";

    public SignalBoxNode() {
        this(new Point());
    }

    public SignalBoxNode(Point point) {
        this.point = Objects.requireNonNull(point);
    }

    public void add(ModeSet modeSet) {
        this.possibleModes.put(modeSet, SignalBoxFactory.getFactory().getEntry());
    }

    public <T> void addAndSetEntry(ModeSet mode, PathEntryType<T> entry, T type) {
        PathOptionEntry optionEntry = this.possibleModes.computeIfAbsent(mode, _u -> SignalBoxFactory.getFactory().getEntry());
        optionEntry.setEntry(entry, type);
    }

    public boolean has(ModeSet modeSet) {
        return this.possibleModes.containsKey(modeSet);
    }

    public void addManuellOutput(ModeSet mode) {
        if (!this.manuellEnabledOutputs.contains(mode)) {
            this.manuellEnabledOutputs.add(mode);
        }
    }

    public void removeManuellOutput(ModeSet mode) {
        this.manuellEnabledOutputs.remove(mode);
    }

    public List<BlockPos> clearAllManuellOutputs() {
        ArrayList<BlockPos> returnList = new ArrayList<BlockPos>();
        this.manuellEnabledOutputs.forEach(mode -> returnList.add(this.possibleModes.get(mode).getEntry(PathEntryType.OUTPUT).get()));
        this.manuellEnabledOutputs.clear();
        return returnList;
    }

    public List<ModeSet> getManuellEnabledOutputs() {
        return ImmutableList.copyOf(this.manuellEnabledOutputs);
    }

    public void remove(ModeSet modeSet) {
        this.possibleModes.remove(modeSet);
    }

    public void setAutoPoint(boolean isAutoPoint) {
        this.isAutoPoint = isAutoPoint;
    }

    public boolean isAutoPoint() {
        return this.isAutoPoint;
    }

    public void setTrainNumber(TrainNumber number) {
        this.trainNumber = number;
    }

    public void removeTrainNumber() {
        this.trainNumber = TrainNumber.DEFAULT;
    }

    public TrainNumber getTrainNumber() {
        return this.trainNumber == null ? TrainNumber.DEFAULT : this.trainNumber;
    }

    public void post() {
        this.possibleConnections.clear();
        block19: for (Map.Entry<ModeSet, PathOptionEntry> entry : this.possibleModes.entrySet()) {
            ModeSet mode = entry.getKey();
            if (mode.mode.equals((Object)EnumGuiMode.SH2)) {
                this.possibleConnections.clear();
                return;
            }
            Point p1 = new Point(this.point);
            Point p2 = new Point(this.point);
            block0 : switch (mode.mode) {
                case CORNER: {
                    switch (mode.rotation) {
                        case NONE: {
                            p1.translate(0, 1);
                            p2.translate(-1, 0);
                            break block0;
                        }
                        case CLOCKWISE_90: {
                            p1.translate(0, -1);
                            p2.translate(-1, 0);
                            break block0;
                        }
                        case CLOCKWISE_180: {
                            p1.translate(0, -1);
                            p2.translate(1, 0);
                            break block0;
                        }
                        case COUNTERCLOCKWISE_90: {
                            p1.translate(0, 1);
                            p2.translate(1, 0);
                            break block0;
                        }
                    }
                    break;
                }
                case STRAIGHT: 
                case END: {
                    switch (mode.rotation) {
                        case NONE: 
                        case CLOCKWISE_180: {
                            p1.translate(1, 0);
                            p2.translate(-1, 0);
                            break block0;
                        }
                        case CLOCKWISE_90: 
                        case COUNTERCLOCKWISE_90: {
                            p1.translate(0, 1);
                            p2.translate(0, -1);
                            break block0;
                        }
                    }
                    break;
                }
                case IN_CONNECTION: {
                    switch (mode.rotation) {
                        case NONE: 
                        case CLOCKWISE_180: {
                            p1.translate(1, 0);
                            p2.translate(-1, 0);
                            break block0;
                        }
                        case CLOCKWISE_90: 
                        case COUNTERCLOCKWISE_90: {
                            p1.translate(0, 1);
                            p2.translate(0, -1);
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    continue block19;
                }
            }
            Path path = new Path(p1, p2);
            this.possibleConnections.put(path, mode);
            this.possibleConnections.put(path.getInverse(), mode);
        }
    }

    public Point getPoint() {
        return this.point;
    }

    @Override
    public void write(NBTWrapper compound) {
        compound.putList(POINT_LIST, this.possibleModes.entrySet().stream().map(entry -> {
            NBTWrapper wrapper = new NBTWrapper();
            ((ModeSet)entry.getKey()).write(wrapper);
            ((PathOptionEntry)entry.getValue()).write(wrapper);
            return wrapper;
        })::iterator);
        ArrayList<NBTWrapper> enabledOutputs = new ArrayList<NBTWrapper>();
        this.manuellEnabledOutputs.forEach(mode -> {
            NBTWrapper wrapper = new NBTWrapper();
            mode.write(wrapper);
            enabledOutputs.add(wrapper);
        });
        compound.putList(ENABLED_OUTPUTS, enabledOutputs);
        this.point.write(compound);
        compound.putBoolean(IS_AUTO_POINT, this.isAutoPoint);
        compound.putString(CUSTOM_NAME, this.customText);
        if (this.trainNumber != null) {
            this.trainNumber.writeTag(compound);
        }
    }

    @Override
    public void read(NBTWrapper compound) {
        SignalBoxFactory factory = SignalBoxFactory.getFactory();
        compound.getList(POINT_LIST).forEach(tag -> {
            PathOptionEntry entry = factory.getEntry();
            entry.read((NBTWrapper)tag);
            this.possibleModes.put(new ModeSet((NBTWrapper)tag), entry);
        });
        compound.getList(ENABLED_OUTPUTS).forEach(tag -> {
            ModeSet modeSet = new ModeSet((NBTWrapper)tag);
            if (!this.manuellEnabledOutputs.contains(modeSet)) {
                this.manuellEnabledOutputs.add(modeSet);
            }
        });
        this.point.read(compound);
        this.isAutoPoint = compound.getBoolean(IS_AUTO_POINT);
        this.customText = compound.getString(CUSTOM_NAME);
        this.trainNumber = TrainNumber.of(compound);
        this.post();
    }

    public Optional<PathOptionEntry> getOption(Path path) {
        return this.getOption(Optional.ofNullable(this.possibleConnections.get(path)));
    }

    public ModeSet getMode(Path path) {
        return this.possibleConnections.get(path);
    }

    public Optional<PathOptionEntry> getOption(ModeSet mode) {
        return Optional.ofNullable(this.possibleModes.get(mode));
    }

    public Optional<PathOptionEntry> getOption(Optional<ModeSet> mode) {
        return mode.flatMap(this::getOption);
    }

    public PathType getPathType(SignalBoxNode other) {
        if (other == null || other.getPoint().equals(this.getPoint())) {
            return PathType.NONE;
        }
        Set thisMode = this.possibleModes.keySet().stream().map(mode -> mode.mode).collect(Collectors.toSet());
        Set otherMode = other.possibleModes.keySet().stream().map(mode -> mode.mode).collect(Collectors.toSet());
        for (PathType type : PathType.values()) {
            boolean thisContains = Arrays.stream(type.getModes()).anyMatch(thisMode::contains);
            boolean otherContains = Arrays.stream(type.getModes()).anyMatch(otherMode::contains);
            if (!thisContains || !otherContains) continue;
            return type;
        }
        return PathType.NONE;
    }

    public boolean canMakePath(Path path, PathType type) {
        ModeSet modeSet = this.possibleConnections.get(path);
        if (modeSet == null) {
            return false;
        }
        Rotation rotation = SignalBoxUtil.getRotationFromDelta(path.point1.delta(this.point));
        for (EnumGuiMode mode : type.getModes()) {
            ModeSet possibleOverStepping = new ModeSet(mode, rotation);
            if (!this.possibleModes.containsKey(possibleOverStepping)) continue;
            return false;
        }
        return true;
    }

    public boolean containsManuellOutput(ModeSet mode) {
        return this.manuellEnabledOutputs.contains(mode);
    }

    public boolean isEmpty() {
        return this.possibleModes.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.point, this.possibleModes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SignalBoxNode other = (SignalBoxNode)obj;
        return Objects.equals(this.point, other.point) && Objects.equals(this.possibleModes, other.possibleModes);
    }

    public String toString() {
        return "SignalBoxNode [point=" + this.point + ", possibleConnections=" + this.possibleConnections + ", possibleModes=" + this.possibleModes + "]";
    }

    public boolean isValidStart() {
        return this.possibleModes.keySet().stream().anyMatch(modeSet -> VALID_MODES.contains((Object)modeSet.mode));
    }

    public boolean isValidEnd() {
        return this.possibleModes.keySet().stream().anyMatch(modeSet -> VALID_MODES.contains((Object)modeSet.mode) || modeSet.mode.equals((Object)EnumGuiMode.OUT_CONNECTION));
    }

    public boolean containsInConnection() {
        return this.possibleModes.keySet().stream().anyMatch(modeSet -> modeSet.mode.equals((Object)EnumGuiMode.IN_CONNECTION));
    }

    public boolean containsOutConnection() {
        return this.possibleModes.keySet().stream().anyMatch(modeSet -> modeSet.mode.equals((Object)EnumGuiMode.OUT_CONNECTION));
    }

    public Set<Path> connections() {
        return ImmutableSet.copyOf(this.possibleConnections.keySet());
    }

    @Override
    public Iterator<ModeSet> iterator() {
        return this.possibleModes.keySet().iterator();
    }

    @Override
    public void readNetwork(ReadBuffer buffer) {
        this.possibleModes.clear();
        this.manuellEnabledOutputs.clear();
        int size = buffer.getByteToUnsignedInt();
        SignalBoxFactory factory = SignalBoxFactory.getFactory();
        for (int i = 0; i < size; ++i) {
            ModeSet mode = ModeSet.of(buffer);
            PathOptionEntry entry = factory.getEntry();
            entry.readNetwork(buffer);
            this.possibleModes.put(mode, entry);
        }
        int outputsSize = buffer.getByteToUnsignedInt();
        for (int i = 0; i < outputsSize; ++i) {
            ModeSet modeSet = ModeSet.of(buffer);
            if (this.manuellEnabledOutputs.contains(modeSet)) continue;
            this.manuellEnabledOutputs.add(modeSet);
        }
        this.isAutoPoint = buffer.getBoolean();
        this.customText = buffer.getString();
        this.trainNumber = TrainNumber.of(buffer);
        this.post();
    }

    public void readUpdateNetwork(ReadBuffer buffer) {
        int size = buffer.getByteToUnsignedInt();
        for (int i = 0; i < size; ++i) {
            ModeSet mode = ModeSet.of(buffer);
            PathOptionEntry entry = this.possibleModes.computeIfAbsent(mode, _u -> SignalBoxFactory.getFactory().getEntry());
            entry.readNetwork(buffer);
            this.possibleModes.put(mode, entry);
        }
        int outputsSize = buffer.getByteToUnsignedInt();
        if (outputsSize == 0) {
            this.manuellEnabledOutputs.clear();
        }
        for (int i = 0; i < outputsSize; ++i) {
            ModeSet modeSet = ModeSet.of(buffer);
            if (this.manuellEnabledOutputs.contains(modeSet)) continue;
            this.manuellEnabledOutputs.add(modeSet);
        }
        this.isAutoPoint = buffer.getBoolean();
        this.customText = buffer.getString();
        this.trainNumber = TrainNumber.of(buffer);
        this.post();
    }

    @Override
    public void writeNetwork(WriteBuffer buffer) {
        buffer.putByte((byte)this.possibleModes.size());
        this.possibleModes.forEach((? super K mode, ? super V entry) -> {
            mode.writeNetwork(buffer);
            entry.writeNetwork(buffer);
        });
        buffer.putByte((byte)this.manuellEnabledOutputs.size());
        this.manuellEnabledOutputs.forEach(mode -> mode.writeNetwork(buffer));
        buffer.putBoolean(this.isAutoPoint);
        buffer.putString(this.customText);
        if (this.trainNumber != null) {
            this.trainNumber.writeNetwork(buffer);
        } else {
            TrainNumber.DEFAULT.writeNetwork(buffer);
        }
    }

    public void writeUpdateNetwork(WriteBuffer buffer) {
        int size = 0;
        for (PathOptionEntry entry2 : this.possibleModes.values()) {
            if (!entry2.containsEntry(PathEntryType.PATHUSAGE)) continue;
            ++size;
        }
        buffer.putByte((byte)size);
        this.possibleModes.forEach((? super K mode, ? super V entry) -> {
            if (entry.containsEntry(PathEntryType.PATHUSAGE)) {
                mode.writeNetwork(buffer);
                entry.writeUpdateNetwork(buffer);
            }
        });
        buffer.putByte((byte)0);
        buffer.putBoolean(this.isAutoPoint);
        buffer.putString(this.customText);
        if (this.trainNumber != null) {
            this.trainNumber.writeNetwork(buffer);
        } else {
            TrainNumber.DEFAULT.writeNetwork(buffer);
        }
    }

    public String getCustomText() {
        return this.customText;
    }

    public void setCustomText(String text) {
        this.customText = text;
    }

    public Map<ModeSet, PathOptionEntry> getModes() {
        return ImmutableMap.copyOf(this.possibleModes);
    }
}

