/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.properties;

import com.troblecodings.signals.SEProperty;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PredicatedPropertyBase<T, P>
implements Predicate<P> {
    public final Predicate<P> predicate;
    public final T state;

    public PredicatedPropertyBase(Predicate<P> predicate, T state) {
        this.predicate = Objects.requireNonNull(predicate);
        this.state = state;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PredicatedPropertyBase other = (PredicatedPropertyBase)obj;
        return Objects.equals(this.state, other.state);
    }

    public String toString() {
        return "PredicatedProperty [state=" + this.state + "]";
    }

    @Override
    public boolean test(P t) {
        return this.predicate.test(t);
    }

    public static class ConfigProperty
    extends PredicatedPropertyBase<Map<SEProperty, String>, Map<Class<?>, Object>> {
        public ConfigProperty(Predicate<Map<Class<?>, Object>> predicate, Map<SEProperty, String> state) {
            super(predicate, state);
        }
    }

    public static class PredicateProperty<T>
    extends PredicatedPropertyBase<T, Map<SEProperty, String>> {
        public PredicateProperty(Predicate<Map<SEProperty, String>> predicate, T state) {
            super(predicate, state);
        }
    }
}

