/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.models;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.models.ModelExtention;
import com.troblecodings.signals.models.Models;
import java.util.HashMap;
import java.util.Map;

public class ModelStats {
    private Map<String, String> textures;
    private Map<String, Models> models;

    public ImmutableMap<String, Models> getModels() {
        if (this.models == null) {
            this.models = new HashMap<String, Models>();
        }
        return ImmutableMap.copyOf(this.models);
    }

    public static Map<String, Object> getfromJson(String directory) {
        Gson gson = new Gson();
        HashMap<String, Object> content = new HashMap<String, Object>();
        OpenSignalsMain.contentPacks.getFiles(directory).forEach(entry -> {
            String filename = (String)entry.getKey();
            String file = (String)entry.getValue();
            if (!filename.endsWith("extention.json")) {
                ModelStats json = (ModelStats)gson.fromJson(file, ModelStats.class);
                content.put(filename, json);
            } else {
                ModelExtention json = (ModelExtention)gson.fromJson(file, ModelExtention.class);
                content.put(filename, json);
            }
        });
        return content;
    }

    public Map<String, String> createRetexture(Map<String, String> textureNames) {
        if (this.textures == null || this.textures.isEmpty()) {
            return textureNames;
        }
        HashMap<String, String> retexturemap = new HashMap<String, String>();
        if (textureNames != null) {
            for (Map.Entry<String, String> entry : textureNames.entrySet()) {
                String key = entry.getKey();
                String textureVariable = entry.getValue();
                String texture = this.textures.get(textureVariable);
                if (texture == null) {
                    retexturemap.put(key, textureVariable);
                    continue;
                }
                retexturemap.put(key, texture);
            }
        }
        return retexturemap;
    }
}

