/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.models;

import com.google.common.collect.ImmutableMap;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.contentpacks.ContentPackException;
import com.troblecodings.signals.core.SignalAngel;
import com.troblecodings.signals.models.ImplAutoBlockStatePredicate;
import com.troblecodings.signals.models.ModelExtention;
import com.troblecodings.signals.models.ModelStats;
import com.troblecodings.signals.models.Models;
import com.troblecodings.signals.models.SignalCustomModel;
import com.troblecodings.signals.models.SignalModelLoaderInfo;
import com.troblecodings.signals.models.TextureStats;
import com.troblecodings.signals.parser.FunctionParsingInfo;
import com.troblecodings.signals.parser.LogicParser;
import com.troblecodings.signals.parser.LogicalParserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BuiltInModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class CustomModelLoader
implements ICustomModelLoader {
    private static HashMap<String, List<SignalModelLoaderInfo>> registeredModels = new HashMap();
    public static final CustomModelLoader INSTANCE = new CustomModelLoader();

    private CustomModelLoader() {
    }

    private static void loadExtention(TextureStats texturestate, Map<String, ModelExtention> extention, String modelname, ModelStats states, Models models, FunctionParsingInfo info, List<SignalModelLoaderInfo> accumulator) {
        String blockstate = texturestate.getBlockstate();
        ImmutableMap<String, String> retexture = texturestate.getRetextures();
        for (Map.Entry<String, Map<String, String>> extentions : texturestate.getExtentions().entrySet()) {
            String extentionName = extentions.getKey();
            Map<String, String> extentionProperties = extentions.getValue();
            ModelExtention extentionValues = extention.get(extentionName);
            if (extentionValues == null) {
                throw new ContentPackException(String.format("There doesn't exists an extention named [%s]!", extentionName) + " Valid Extentions: " + extention.keySet());
            }
            for (Map.Entry entry : extentionValues.getExtention().entrySet()) {
                String enumValue = (String)entry.getKey();
                String retextureValue = (String)entry.getValue();
                for (Map.Entry<String, String> extProperties : extentionProperties.entrySet()) {
                    String retextureKey;
                    String seProperty = extProperties.getKey();
                    boolean load = texturestate.appendExtention(seProperty, enumValue, retextureKey = extProperties.getValue(), retextureValue);
                    if (!load) continue;
                    try {
                        accumulator.add(new SignalModelLoaderInfo(modelname, LogicParser.predicate(texturestate.getBlockstate(), info), models.getX(texturestate.getOffsetX()), models.getY(texturestate.getOffsetY()), models.getZ(texturestate.getOffsetZ()), states.createRetexture((Map<String, String>)texturestate.getRetextures())));
                    }
                    catch (LogicalParserException e) {
                        throw new ContentPackException("There was an problem during loading an extention into " + modelname + " with the blockstate '" + texturestate.getBlockstate() + "'!", e);
                    }
                    finally {
                        texturestate.resetStates(blockstate, (Map<String, String>)retexture);
                    }
                }
            }
        }
    }

    public void func_110549_a(IResourceManager manager) {
        registeredModels.clear();
        HashMap<String, ModelExtention> extentions = new HashMap<String, ModelExtention>();
        Map<String, Object> modelmap = ModelStats.getfromJson("modeldefinitions");
        modelmap.forEach((filename, content) -> {
            if (filename.endsWith(".extention.json")) {
                ModelExtention ext = (ModelExtention)content;
                extentions.put(filename.replace(".extention", ""), ext);
            }
        });
        for (Map.Entry<String, Object> modelstatemap : modelmap.entrySet()) {
            String filename2 = modelstatemap.getKey();
            if (filename2.endsWith(".extention.json")) continue;
            ArrayList<SignalModelLoaderInfo> accumulator = new ArrayList<SignalModelLoaderInfo>();
            ModelStats content2 = (ModelStats)modelstatemap.getValue();
            String lowercaseName = filename2.replace(".json", "").toLowerCase();
            Signal signaltype = Signal.SIGNALS.get(lowercaseName);
            if (signaltype == null) {
                OpenSignalsMain.getLogger().error("There doesn't exists a signalsystem named " + lowercaseName + "!");
                return;
            }
            FunctionParsingInfo parsinginfo = new FunctionParsingInfo(signaltype);
            for (Map.Entry modelsmap : content2.getModels().entrySet()) {
                String modelname = (String)modelsmap.getKey();
                Models modelstats = (Models)modelsmap.getValue();
                for (int i = 0; i < modelstats.getTexture().size(); ++i) {
                    TextureStats texturestate = (TextureStats)modelstats.getTexture().get(i);
                    String blockstate = texturestate.getBlockstate();
                    ImplAutoBlockStatePredicate state = null;
                    boolean extentionloaded = false;
                    if (!texturestate.isautoBlockstate()) {
                        Map<String, Map<String, String>> texturemap = texturestate.getExtentions();
                        if (texturemap != null && !texturemap.isEmpty()) {
                            CustomModelLoader.loadExtention(texturestate, extentions, modelname, content2, modelstats, parsinginfo, accumulator);
                            extentionloaded = true;
                        }
                        if (!extentionloaded) {
                            try {
                                state = LogicParser.predicate(blockstate, parsinginfo);
                            }
                            catch (LogicalParserException e) {
                                OpenSignalsMain.getLogger().error("There was an problem during loading " + modelname + " with the blockstate '" + texturestate.getBlockstate() + " '!");
                                e.printStackTrace();
                                return;
                            }
                        }
                    }
                    if ((state != null || texturestate.isautoBlockstate()) && !extentionloaded) {
                        accumulator.add(new SignalModelLoaderInfo(modelname, texturestate.isautoBlockstate() ? new ImplAutoBlockStatePredicate() : state, modelstats.getX(texturestate.getOffsetX()), modelstats.getY(texturestate.getOffsetY()), modelstats.getZ(texturestate.getOffsetZ()), content2.createRetexture((Map<String, String>)texturestate.getRetextures())));
                        continue;
                    }
                    if (state != null || texturestate.isautoBlockstate() || extentionloaded) continue;
                    OpenSignalsMain.getLogger().error("The predicate of " + modelname + " in " + filename2 + " is null! This shouldn't be the case!");
                    return;
                }
            }
            registeredModels.put(lowercaseName, accumulator);
        }
    }

    public boolean accepts(ResourceLocation modelLocation) {
        if (!modelLocation.func_110624_b().equals("opensignals")) {
            return false;
        }
        return registeredModels.containsKey(modelLocation.func_110623_a()) || modelLocation.func_110623_a().equals("ghostblock");
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        if (modelLocation.func_110623_a().equals("ghostblock")) {
            return (state, format, bak) -> new BuiltInModel(ItemCameraTransforms.field_178357_a, ItemOverrideList.field_188022_a);
        }
        ModelResourceLocation mrl = (ModelResourceLocation)modelLocation;
        String[] strs = mrl.func_177518_c().split("=");
        if (strs.length < 2) {
            return new SignalCustomModel(registeredModels.get(modelLocation.func_110623_a()), SignalAngel.ANGEL0);
        }
        return new SignalCustomModel(registeredModels.get(modelLocation.func_110623_a()), Enum.valueOf(SignalAngel.class, strs[1].toUpperCase()));
    }
}

