/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.init;

import com.google.common.base.Predicate;
import com.google.gson.Gson;
import com.troblecodings.core.NBTWrapper;
import com.troblecodings.linkableapi.Linkingtool;
import com.troblecodings.linkableapi.MultiLinkingTool;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.init.OSBlocks;
import com.troblecodings.signals.init.OSTabs;
import com.troblecodings.signals.items.ItemArmorTemplate;
import com.troblecodings.signals.items.Placementtool;
import com.troblecodings.signals.items.ToolParser;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

public final class OSItems {
    public static final Linkingtool LINKING_TOOL = new Linkingtool(OSTabs.TAB, (world, pos) -> {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        boolean isRedstoneBlock = block == OSBlocks.REDSTONE_IN || block == OSBlocks.REDSTONE_OUT || block == OSBlocks.COMBI_REDSTONE_INPUT;
        return isRedstoneBlock || block instanceof Signal && ((Signal)block).canBeLinked() || block == OSBlocks.SIGNAL_BOX;
    }, (Predicate<TileEntity>)((Predicate)_u -> true), (level, pos, tag) -> {
        IBlockState state = level.func_180495_p(pos);
        NBTWrapper wrapper = new NBTWrapper(tag);
        wrapper.putString(pos.toString(), state.func_177230_c().getRegistryName().func_110623_a());
    });
    public static final MultiLinkingTool MULTI_LINKING_TOOL = new MultiLinkingTool(OSTabs.TAB, (world, pos) -> {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        boolean isRedstoneBlock = block == OSBlocks.REDSTONE_IN || block == OSBlocks.REDSTONE_OUT || block == OSBlocks.COMBI_REDSTONE_INPUT;
        return isRedstoneBlock || block instanceof Signal && ((Signal)block).canBeLinked() || block == OSBlocks.SIGNAL_BOX;
    }, (Predicate<TileEntity>)((Predicate)_u -> true), (level, pos, tag) -> {
        IBlockState state = level.func_180495_p(pos);
        NBTWrapper wrapper = new NBTWrapper(tag);
        wrapper.putString(pos.toString(), state.func_177230_c().getRegistryName().func_110623_a());
    });
    public static final Item CONDUCTOR_TROWEL_GREEN = new Item().func_77637_a(CreativeTabs.field_78037_j);
    public static final Item CONDUCTOR_TROWEL_RED = new Item().func_77637_a(CreativeTabs.field_78037_j);
    public static final Item WARNING_FLAG = new Item().func_77637_a(CreativeTabs.field_78037_j);
    public static final Item K_BOARD = new Item().func_77637_a(CreativeTabs.field_78037_j);
    public static final Item L_BOARD = new Item().func_77637_a(CreativeTabs.field_78037_j);
    public static final ItemArmorTemplate REFLECTIVE_HEAD = new ItemArmorTemplate(ItemArmorTemplate.REFLECTIVE_ARMOR_MATERIAL, 1, EntityEquipmentSlot.HEAD);
    public static final ItemArmorTemplate REFLECTIVE_CHESTPLATE = new ItemArmorTemplate(ItemArmorTemplate.REFLECTIVE_ARMOR_MATERIAL, 1, EntityEquipmentSlot.CHEST);
    public static final ItemArmorTemplate REFLECTIVE_PANTS = new ItemArmorTemplate(ItemArmorTemplate.REFLECTIVE_ARMOR_MATERIAL, 1, EntityEquipmentSlot.LEGS);
    public static final ItemArmorTemplate REFLECTIVE_SHOES = new ItemArmorTemplate(ItemArmorTemplate.REFLECTIVE_ARMOR_MATERIAL, 1, EntityEquipmentSlot.FEET);
    public static final ItemArmorTemplate DISPATCHER_HEAD = new ItemArmorTemplate(ItemArmorTemplate.DISPATCHER_ARMOR_MATERIAL, 1, EntityEquipmentSlot.HEAD);
    public static final ItemArmorTemplate DISPATCHER_CHESTPLATE = new ItemArmorTemplate(ItemArmorTemplate.DISPATCHER_ARMOR_MATERIAL, 1, EntityEquipmentSlot.CHEST);
    public static final ItemArmorTemplate DISPATCHER_PANTS = new ItemArmorTemplate(ItemArmorTemplate.DISPATCHER_ARMOR_MATERIAL, 1, EntityEquipmentSlot.LEGS);
    public static final ItemArmorTemplate DISPATCHER_SHOES = new ItemArmorTemplate(ItemArmorTemplate.DISPATCHER_ARMOR_MATERIAL, 1, EntityEquipmentSlot.FEET);
    public static final ItemArmorTemplate STATION_MANAGER_HEAD = new ItemArmorTemplate(ItemArmorTemplate.STATIONMANAGER_ARMOR_MATERIAL, 1, EntityEquipmentSlot.HEAD);
    public static final ItemArmorTemplate STATION_MANAGER_CHESTPLATE = new ItemArmorTemplate(ItemArmorTemplate.STATIONMANAGER_ARMOR_MATERIAL, 1, EntityEquipmentSlot.CHEST);
    public static final ItemArmorTemplate STATION_MANAGER_PANTS = new ItemArmorTemplate(ItemArmorTemplate.STATIONMANAGER_ARMOR_MATERIAL, 1, EntityEquipmentSlot.LEGS);
    public static final ItemArmorTemplate STATION_MANAGER_SHOES = new ItemArmorTemplate(ItemArmorTemplate.STATIONMANAGER_ARMOR_MATERIAL, 1, EntityEquipmentSlot.FEET);
    public static final ItemArmorTemplate TRAIN_DRIVER_HEAD = new ItemArmorTemplate(ItemArmorTemplate.TRAINDRIVER_ARMOR_MATERIAL, 1, EntityEquipmentSlot.HEAD);
    public static final ItemArmorTemplate TRAIN_DRIVER_CHESTPLATE = new ItemArmorTemplate(ItemArmorTemplate.TRAINDRIVER_ARMOR_MATERIAL, 1, EntityEquipmentSlot.CHEST);
    public static final ItemArmorTemplate TRAIN_DRIVER_PANTS = new ItemArmorTemplate(ItemArmorTemplate.TRAINDRIVER_ARMOR_MATERIAL, 1, EntityEquipmentSlot.LEGS);
    public static final ItemArmorTemplate TRAIN_DRIVER_SHOES = new ItemArmorTemplate(ItemArmorTemplate.TRAINDRIVER_ARMOR_MATERIAL, 1, EntityEquipmentSlot.FEET);
    public static final ItemArmorTemplate CONDUCTOR_HEAD = new ItemArmorTemplate(ItemArmorTemplate.CONDUCTOR_ARMOR_MATERIAL, 1, EntityEquipmentSlot.HEAD);
    public static final ItemArmorTemplate CONDUCTOR_CHESTPLATE = new ItemArmorTemplate(ItemArmorTemplate.CONDUCTOR_ARMOR_MATERIAL, 1, EntityEquipmentSlot.CHEST);
    public static final ItemArmorTemplate CONDUCTOR_PANTS = new ItemArmorTemplate(ItemArmorTemplate.CONDUCTOR_ARMOR_MATERIAL, 1, EntityEquipmentSlot.LEGS);
    public static final ItemArmorTemplate CONDUCTOR_SHOES = new ItemArmorTemplate(ItemArmorTemplate.CONDUCTOR_ARMOR_MATERIAL, 1, EntityEquipmentSlot.FEET);
    public static final Item SIGNAL_PLATE = new Item().func_77637_a(CreativeTabs.field_78026_f);
    public static final Item SIGNAL_SHIELD = new Item().func_77637_a(CreativeTabs.field_78026_f);
    public static final Item LAMPS = new Item().func_77637_a(CreativeTabs.field_78026_f);
    public static final Item ELECTRIC_PARTS = new Item().func_77637_a(CreativeTabs.field_78026_f);
    public static final Item MANIPULATOR = new Item().func_77637_a(OSTabs.TAB);
    public static ArrayList<Item> registeredItems = new ArrayList();
    public static ArrayList<Placementtool> placementtools = new ArrayList();
    private static final Gson GSON = new Gson();

    private OSItems() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Linkingtool linkingtool = LINKING_TOOL;
        synchronized (linkingtool) {
            Field[] fields;
            if (LINKING_TOOL.getRegistryName() != null) {
                return;
            }
            for (Field field : fields = OSItems.class.getFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers)) continue;
                String name = field.getName().toLowerCase().replace("_", "");
                try {
                    Item item = (Item)field.get(null);
                    item.setRegistryName(new ResourceLocation("opensignals", name));
                    item.func_77655_b(name);
                    registeredItems.add(item);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            OSItems.loadTools();
        }
    }

    private static void loadTools() {
        OpenSignalsMain.contentPacks.getFiles("tools").forEach(entry -> {
            ToolParser tools = (ToolParser)GSON.fromJson((String)entry.getValue(), ToolParser.class);
            tools.getPlacementTools().forEach(placementtool -> {
                Placementtool tool = new Placementtool();
                String name = placementtool.toLowerCase().replace("_", "").trim();
                tool.setRegistryName(new ResourceLocation("opensignals", name));
                tool.func_77655_b(name);
                placementtools.add(tool);
                registeredItems.add(tool);
            });
        });
    }

    @SubscribeEvent
    public static void registerItem(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registeredItems.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }
}

