/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.handler;

import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.handler.SignalStatePosV2;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class SignalStateFileV2 {
    public static final int HEADER_SIZE = 4;
    public static final int MAX_ELEMENTS_PER_FILE = 256;
    public static final int ALIGNMENT_PER_INDEX_ITEM = 4;
    public static final int SIZE_OF_OCCUPIED_MARKER = 32;
    public static final int START_OFFSET = 40;
    public static final int SIZE_OF_INDEX = 1024;
    public static final int MAX_OFFSET_OF_INDEX = 1064;
    public static final byte HEADER_VERSION = 2;
    public static final int STATE_BLOCK_SIZE = 256;
    private static final byte[] DEFAULT_HEADER = new byte[]{2, 0, 0, 0};
    private final Map<ChunkPos, Path> pathCache = new HashMap<ChunkPos, Path>();
    private final Path path;

    public SignalStateFileV2(Path path) {
        this.path = path;
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Path getFileForPos(BlockPos pos) {
        ChunkPos file = new ChunkPos(pos);
        return this.pathCache.computeIfAbsent(file, identifier -> {
            Path nextFile = this.path.resolve(SignalStateFileV2.getFileNameForChunk(identifier));
            if (!Files.exists(nextFile, new LinkOption[0])) {
                try (RandomAccessFile stream = new RandomAccessFile(nextFile.toFile(), "rw");){
                    stream.write(DEFAULT_HEADER);
                    stream.writeInt(0);
                    stream.write(new byte[32]);
                    byte[] zeroMemory = new byte[1024];
                    stream.write(zeroMemory);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return nextFile;
        });
    }

    private static int getNextFreeOffset(RandomAccessFile stream) {
        try {
            stream.seek(8L);
            for (int i = 0; i < 32; ++i) {
                boolean[] isSectionOccupied = SignalStateFileV2.getStatesFromByte(stream.readByte());
                for (int j = 0; j < isSectionOccupied.length; ++j) {
                    if (isSectionOccupied[j]) continue;
                    return i * 8 + j;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1;
    }

    private static boolean[] getStatesFromByte(byte b) {
        boolean[] bits = new boolean[8];
        for (int i = 7; i >= 0; --i) {
            bits[i] = (b & 1 << i) != 0;
        }
        return bits;
    }

    private static void setOffsetOccupied(RandomAccessFile stream, int offset, boolean setOccupied) {
        byte bytePosition = (byte)Math.floor(offset / 8);
        byte bitPosition = (byte)(offset % 8);
        try {
            int bytePos = 8 + bytePosition;
            stream.seek(bytePos);
            byte b = stream.readByte();
            byte byteToWrite = (byte)(setOccupied ? b | 1 << bitPosition : b & ~(1 << bitPosition));
            stream.seek(bytePos);
            stream.writeByte(byteToWrite);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte[] getChunkPosFromPos(ChunkPos chunk, BlockPos pos) {
        byte[] array = new byte[3];
        byte chunkCoordX = (byte)Math.floor(pos.func_177958_n() - 16 * chunk.field_77276_a);
        byte chunkCoordZ = (byte)Math.floor(pos.func_177952_p() - 16 * chunk.field_77275_b);
        array[0] = (byte)(chunkCoordX << 4 | chunkCoordZ);
        array[1] = (byte)(pos.func_177956_o() + 64 >> 8 & 0xFF);
        array[2] = (byte)(pos.func_177956_o() + 64 & 0xFF);
        return array;
    }

    public static BlockPos getPosFromChunkPos(ChunkPos chunk, byte[] array) {
        int chunkPosX = Byte.toUnsignedInt(array[0]) >> 4;
        int chunkPosZ = array[0] & 0xF;
        int blockX = chunkPosX + 16 * chunk.field_77276_a;
        int blockY = ((array[1] & 0xFF) << 8 | array[2] & 0xFF) - 64;
        int blockZ = chunkPosZ + 16 * chunk.field_77275_b;
        return new BlockPos(blockX, blockY, blockZ);
    }

    private static String getFileNameForChunk(ChunkPos pos) {
        return pos.field_77276_a + "." + pos.field_77275_b;
    }

    public static long hash(BlockPos pos, ChunkPos chunk) {
        int chunkCoordX = (int)Math.floor(pos.func_177958_n() - 16 * chunk.field_77276_a);
        int chunkCoordY = pos.func_177956_o();
        int chunkCoordZ = (int)Math.floor(pos.func_177952_p() - 16 * chunk.field_77275_b);
        return Integer.toUnsignedLong((chunkCoordY + chunkCoordZ * 31) * 31 + chunkCoordX) % 256L * 4L + 40L;
    }

    public synchronized SignalStatePosV2 find(BlockPos pos) {
        return (SignalStatePosV2)this.internalFind(pos, (stream, blockPos, offset, file) -> new SignalStatePosV2(file, offset), "r");
    }

    public synchronized SignalStatePosV2 deleteIndex(BlockPos pos) {
        return (SignalStatePosV2)this.internalFind(pos, (stream, blockPos, offset, file) -> {
            try {
                long pointer = stream.getFilePointer();
                stream.seek(pointer - 4L);
                stream.writeInt(0);
                SignalStateFileV2.setOffsetOccupied(stream, offset, false);
                stream.seek(4L);
                int addedElements = stream.readInt();
                stream.seek(4L);
                stream.writeInt(addedElements - 1);
                return new SignalStatePosV2(file, offset);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }, "rw");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Object internalFind(BlockPos pos, InternalFunction function, String acces) {
        Path file = this.getFileForPos(pos);
        try (RandomAccessFile stream = new RandomAccessFile(file.toFile(), acces);){
            byte[] header = new byte[4];
            stream.read(header);
            if (header[0] != 2) {
                OpenSignalsMain.getLogger().error("Header Version miss match! No file for [" + pos + "]!");
                Object var8_10 = null;
                return var8_10;
            }
            if (stream.readInt() == 0) {
                Object var8_11 = null;
                return var8_11;
            }
            ChunkPos chunk = new ChunkPos(pos);
            long hashOffset = SignalStateFileV2.hash(pos, chunk);
            stream.seek(hashOffset);
            BlockPos currenPosition = null;
            int offset = 0;
            boolean startSearchAtBegin = false;
            do {
                byte[] array = new byte[3];
                stream.readFully(array);
                currenPosition = SignalStateFileV2.getPosFromChunkPos(chunk, array);
                offset = Byte.toUnsignedInt(stream.readByte());
                long currentOffset = stream.getFilePointer();
                if (currentOffset >= 1064L) {
                    if (startSearchAtBegin) {
                        Object var17_22 = null;
                        return var17_22;
                    }
                    stream.seek(40L);
                    startSearchAtBegin = true;
                }
                if (currentOffset != hashOffset) continue;
                Object var17_23 = null;
                return var17_23;
            } while (!pos.equals((Object)currenPosition));
            Object object = function.apply(stream, currenPosition, offset, chunk);
            return object;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public synchronized ByteBuffer read(SignalStatePosV2 pos) {
        try (RandomAccessFile stream = new RandomAccessFile(this.pathCache.get(pos.file).toFile(), "r");){
            ByteBuffer buffer = ByteBuffer.allocate(256);
            stream.seek(pos.offset * 256 + 1064);
            stream.read(buffer.array());
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized void write(SignalStatePosV2 pos, ByteBuffer buffer) {
        try (RandomAccessFile stream = new RandomAccessFile(this.pathCache.get(pos.file).toFile(), "rw");){
            stream.seek(pos.offset * 256 + 1064);
            stream.write(buffer.array());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized SignalStatePosV2 create(BlockPos pos) {
        return this.create(pos, new byte[256]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized SignalStatePosV2 create(BlockPos pos, byte[] array) {
        try {
            Path file = this.getFileForPos(pos);
            try (RandomAccessFile stream = new RandomAccessFile(file.toFile(), "rw");){
                byte[] header = new byte[4];
                stream.read(header);
                if (header[0] != 2) {
                    OpenSignalsMain.getLogger().error("Header version miss match! No write!");
                    SignalStatePosV2 signalStatePosV2 = null;
                    return signalStatePosV2;
                }
                int addedElements = stream.readInt();
                if (addedElements >= 256) {
                    OpenSignalsMain.getLogger().error("No free space in %s this should not happen", (Object)this.path.toString());
                    SignalStatePosV2 signalStatePosV2 = null;
                    return signalStatePosV2;
                }
                ChunkPos chunk = new ChunkPos(pos);
                long offsetHash = SignalStateFileV2.hash(pos, chunk);
                stream.seek(offsetHash);
                while (stream.readInt() != 0) {
                    if (stream.getFilePointer() >= 1064L) {
                        stream.seek(40L);
                    }
                    if (stream.getFilePointer() != offsetHash) continue;
                    OpenSignalsMain.getLogger().error("No free space in %s this should not happen", (Object)this.path.toString());
                    SignalStatePosV2 signalStatePosV2 = null;
                    return signalStatePosV2;
                }
                long actualOffset = stream.getFilePointer() - 4L;
                int freeOffsetInFile = SignalStateFileV2.getNextFreeOffset(stream);
                int offset = freeOffsetInFile * 256 + 1064;
                stream.seek(actualOffset);
                stream.write(SignalStateFileV2.getChunkPosFromPos(chunk, pos));
                stream.writeByte(freeOffsetInFile);
                stream.seek(offset);
                stream.write(array);
                stream.seek(4L);
                stream.writeInt(addedElements + 1);
                SignalStateFileV2.setOffsetOccupied(stream, freeOffsetInFile, true);
                SignalStatePosV2 signalStatePosV2 = new SignalStatePosV2(chunk, freeOffsetInFile);
                return signalStatePosV2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int hashCode() {
        return Objects.hash(this.path, this.pathCache);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignalStateFileV2 other = (SignalStateFileV2)obj;
        return Objects.equals(this.path, other.path) && Objects.equals(this.pathCache, other.pathCache);
    }

    @FunctionalInterface
    public static interface InternalFunction {
        public Object apply(RandomAccessFile var1, BlockPos var2, int var3, ChunkPos var4);
    }
}

