/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.google.common.collect.ImmutableList;
import com.troblecodings.core.I18Wrapper;
import com.troblecodings.guilib.ecs.DrawUtil;
import com.troblecodings.guilib.ecs.GuiElements;
import com.troblecodings.guilib.ecs.entitys.UIBox;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.entitys.UIScrollBox;
import com.troblecodings.guilib.ecs.entitys.UITextInput;
import com.troblecodings.guilib.ecs.entitys.input.UIClickable;
import com.troblecodings.guilib.ecs.entitys.input.UIOnUpdate;
import com.troblecodings.guilib.ecs.entitys.input.UIScroll;
import com.troblecodings.guilib.ecs.entitys.render.UIBorder;
import com.troblecodings.guilib.ecs.entitys.render.UIButton;
import com.troblecodings.guilib.ecs.entitys.render.UIColor;
import com.troblecodings.guilib.ecs.entitys.render.UILabel;
import com.troblecodings.guilib.ecs.entitys.render.UIScissor;
import com.troblecodings.guilib.ecs.entitys.render.UITexture;
import com.troblecodings.guilib.ecs.entitys.render.UIToolTip;
import com.troblecodings.guilib.ecs.entitys.transform.UIRotate;
import com.troblecodings.guilib.ecs.entitys.transform.UIScale;
import com.troblecodings.signals.core.ModeIdentifier;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.core.SubsidiaryEntry;
import com.troblecodings.signals.core.SubsidiaryHolder;
import com.troblecodings.signals.core.SubsidiaryState;
import com.troblecodings.signals.enums.EnumGuiMode;
import com.troblecodings.signals.enums.EnumPathUsage;
import com.troblecodings.signals.guis.GuiSignalBox;
import com.troblecodings.signals.guis.UISignalBoxTile;
import com.troblecodings.signals.handler.ClientNameHandler;
import com.troblecodings.signals.signalbox.MainSignalIdentifier;
import com.troblecodings.signals.signalbox.ModeSet;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxNode;
import com.troblecodings.signals.signalbox.entrys.PathEntryType;
import com.troblecodings.signals.signalbox.entrys.PathOptionEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SidePanel {
    public static final ResourceLocation REDSTONE_OFF = new ResourceLocation("opensignals", "gui/textures/redstone_off.png");
    public static final ResourceLocation REDSTONE_OFF_BLOCKED = new ResourceLocation("opensignals", "gui/textures/redstone_off_blocked.png");
    public static final ResourceLocation REDSTONE_ON = new ResourceLocation("opensignals", "gui/textures/redstone_on.png");
    public static final ResourceLocation REDSTONE_ON_BLOCKED = new ResourceLocation("opensignals", "gui/textures/redstone_on_blocked.png");
    private boolean showHelpPage = false;
    private final UIEntity helpPage = new UIEntity();
    private final UIEntity infoEntity = new UIEntity();
    private final UIButton helpPageButton = new UIButton(">");
    private final UIEntity lowerEntity;
    private final UIEntity button = new UIEntity();
    private final UIEntity label = new UIEntity();
    private final UIEntity spacerEntity = new UIEntity();
    private final UIEntity helpPageSpacer = new UIEntity();
    private UIEntity counterButton = new UIEntity();
    private final GuiSignalBox gui;
    private BiConsumer<BlockPos, SubsidiaryHolder> disableSubsidiary;

    public SidePanel(UIEntity lowerEntity, GuiSignalBox gui) {
        this.lowerEntity = lowerEntity;
        this.gui = gui;
        this.infoEntity.setInherits(true);
        this.infoEntity.add(new UIBox(UIBox.VBOX, 2));
        this.helpPage.setInherits(true);
        this.helpPage.add(new UIBox(UIBox.VBOX, 2));
        UIRotate rotate = new UIRotate();
        rotate.setRotateZ(90.0f);
        this.label.add(rotate);
        UILabel labelComponent = new UILabel(I18Wrapper.format("info.infolabel", new Object[0]));
        labelComponent.setTextColor(new UIEntity().getBasicTextColor());
        this.label.add(labelComponent);
        this.label.setX(2.0);
        this.button.setInheritWidth(true);
        this.button.setHeight(20.0);
        this.button.add(this.helpPageButton);
        this.button.add(new UIClickable(entity -> {
            this.showHelpPage = !this.showHelpPage;
            this.addHelpPageToPlane();
        }));
        this.addHelpPageToPlane();
        UIEntity entity2 = new UIEntity();
        entity2.setInherits(true);
        entity2.add(new UIBox(UIBox.HBOX, 0));
        entity2.add(GuiElements.createSpacerH(4));
        entity2.add(this.helpPage);
        this.spacerEntity.setInheritHeight(true);
        this.spacerEntity.add(new UIBox(UIBox.VBOX, 0));
        this.spacerEntity.add(this.button);
        this.spacerEntity.add(entity2);
        this.spacerEntity.add(new UIColor(GuiSignalBox.BACKGROUND_COLOR));
        lowerEntity.add(this.spacerEntity);
        this.helpPageSpacer.setHeight(30.0);
    }

    public void addHelpPageToPlane() {
        if (this.showHelpPage) {
            this.helpPageButton.setText(I18Wrapper.format("info.info", new Object[0]) + "  >");
            this.spacerEntity.setWidth(80.0);
            this.helpPage.clearChildren();
            this.helpPage.add(this.infoEntity);
            this.lowerEntity.update();
        } else {
            this.helpPageButton.setText("<");
            this.helpPage.clearChildren();
            this.helpPage.add(this.helpPageSpacer);
            this.helpPage.add(this.label);
            this.spacerEntity.setWidth(12.0);
            this.lowerEntity.update();
        }
        this.infoEntity.forEach(entity -> entity.setVisible(this.showHelpPage));
        this.label.setVisible(true);
        this.button.setVisible(true);
        this.helpPageSpacer.setVisible(true);
        this.helpPage.update();
    }

    protected void setShowHelpPage(boolean showHelpPage) {
        this.showHelpPage = showHelpPage;
        this.addHelpPageToPlane();
    }

    public void reset() {
    }

    public void add(UIEntity entity) {
        this.helpPage.add(entity);
    }

    public void updateNextNode(int selection, int rotation) {
        this.infoEntity.clearChildren();
        this.infoEntity.add(GuiElements.createSpacerV(2));
        this.infoEntity.add(GuiElements.createLabel(I18Wrapper.format("info.nextelement", new Object[0]), new UIEntity().getBasicTextColor(), 0.8f));
        UIEntity preview = new UIEntity();
        preview.setInheritWidth(true);
        preview.add(new UIOnUpdate(() -> {
            if (preview.getHeight() != preview.getWidth()) {
                preview.setHeight(preview.getWidth());
                this.helpPage.update();
            }
        }));
        preview.add(new UIColor(-5263441));
        SignalBoxNode node = new SignalBoxNode(new Point(-1, -1));
        EnumGuiMode modes = EnumGuiMode.values()[selection];
        node.add(new ModeSet(modes, Rotation.values()[rotation]));
        UISignalBoxTile sbt = new UISignalBoxTile(node);
        preview.add(sbt);
        preview.add(new UIBorder(new UIEntity().getBasicTextColor()));
        this.infoEntity.add(preview);
        this.infoEntity.add(GuiElements.createSpacerV(5));
        this.infoEntity.add(GuiElements.createLabel("[R] = " + I18Wrapper.format("info.editor.key.r", new Object[0]), new UIEntity().getInfoTextColor(), 0.5f));
        this.infoEntity.add(GuiElements.createLabel("[LMB] = " + I18Wrapper.format("info.editor.key.lmb", new Object[0]), new UIEntity().getInfoTextColor(), 0.5f));
        this.infoEntity.add(GuiElements.createLabel("[RMB] = " + I18Wrapper.format("info.editor.key.rmb", new Object[0]), new UIEntity().getInfoTextColor(), 0.5f));
        this.infoEntity.add(GuiElements.createSpacerV(5));
        this.infoEntity.add(GuiElements.createLabel(I18Wrapper.format("info.description", new Object[0]), new UIEntity().getBasicTextColor(), 0.8f));
        this.infoEntity.add(GuiElements.createLabel(I18Wrapper.format("info." + modes.toString().toLowerCase(), new Object[0]), new UIEntity().getInfoTextColor(), 0.5f));
        this.addHelpPageToPlane();
    }

    protected void updateCounterButton() {
        this.counterButton.findRecursive(UIButton.class).forEach(button -> button.setText(this.gui.container.grid.getCurrentCounter() + ""));
        this.lowerEntity.update();
    }

    public void helpUsageMode(Map<BlockPos, SubsidiaryHolder> subsidiaries, SignalBoxNode node, List<SignalBoxNode> allNodes, Map<BlockPos, List<SubsidiaryState>> possibleSubsidiaries) {
        this.infoEntity.clearChildren();
        UIEntity helpScroll = new UIEntity();
        helpScroll.setInheritHeight(true);
        helpScroll.setInheritWidth(true);
        helpScroll.add(new UIBox(UIBox.HBOX, 0));
        helpScroll.add(new UIScissor());
        this.infoEntity.add(helpScroll);
        UIEntity helpList = new UIEntity();
        helpScroll.add(helpList);
        helpList.setInheritHeight(true);
        helpList.setInheritWidth(true);
        UIScrollBox helpScrollbox = new UIScrollBox(UIBox.VBOX, 2);
        if (node != null) {
            helpList.add(GuiElements.createLabel(node.getPoint().toShortString(), new UIEntity().getBasicTextColor(), 0.8f));
        }
        helpList.add(GuiElements.createLabel(I18Wrapper.format("info.keys", new Object[0]), new UIEntity().getBasicTextColor(), 0.8f));
        helpList.add(GuiElements.createLabel("[LMB] = " + I18Wrapper.format("info.usage.key.lmb", new Object[0]), new UIEntity().getInfoTextColor(), 0.5f));
        helpList.add(GuiElements.createLabel("[RMB] = " + I18Wrapper.format("info.usage.key.rmb", new Object[0]), new UIEntity().getInfoTextColor(), 0.5f));
        this.counterButton = GuiElements.createButton(this.gui.container.grid.getCurrentCounter() + "");
        this.counterButton.setScaleX(0.8f);
        this.counterButton.setScaleY(0.8f);
        this.counterButton.setX(5.0);
        this.counterButton.add(new UIToolTip(I18Wrapper.format("btn.counter.tooltip", new Object[0])));
        helpList.add(this.counterButton);
        Minecraft mc = Minecraft.func_71410_x();
        if (!allNodes.isEmpty()) {
            UIEntity manuelButton = GuiElements.createButton(I18Wrapper.format("info.usage.manuel", new Object[0]), e -> {
                UIEntity screen = GuiElements.createScreen(searchPanel -> {
                    UIEntity searchBar = new UIEntity();
                    searchBar.setInheritWidth(true);
                    searchBar.setHeight(20.0);
                    UITextInput input = new UITextInput("");
                    searchBar.add(input);
                    searchPanel.add(searchBar);
                    UIEntity listWithScroll = new UIEntity();
                    listWithScroll.setInheritHeight(true);
                    listWithScroll.setInheritWidth(true);
                    listWithScroll.add(new UIBox(UIBox.HBOX, 2));
                    listWithScroll.add(new UIScissor());
                    listWithScroll.add(new UIBorder(-16711681));
                    searchPanel.add(listWithScroll);
                    UIEntity list = new UIEntity();
                    listWithScroll.add(list);
                    list.setInherits(true);
                    UIScrollBox scrollbox = new UIScrollBox(UIBox.VBOX, 2);
                    list.add(scrollbox);
                    HashMap nameToUIEntity = new HashMap();
                    allNodes.forEach(currentNode -> {
                        UILabel currentStatus = new UILabel(I18Wrapper.format("info.usage.status", new Object[0]) + " : " + I18Wrapper.format("info.usage.status.free", new Object[0]));
                        currentStatus.setTextColor(new UIEntity().getBasicTextColor());
                        UIEntity statusEntity = new UIEntity();
                        statusEntity.setInheritWidth(true);
                        statusEntity.setHeight(20.0);
                        statusEntity.add(new UIScale(1.1f, 1.1f, 1.0f));
                        statusEntity.add(currentStatus);
                        AtomicBoolean canBeManuelChanged = new AtomicBoolean(true);
                        currentNode.getModes().forEach((mode, entry) -> {
                            Optional<EnumPathUsage> pathUsage = entry.getEntry(PathEntryType.PATHUSAGE);
                            if (pathUsage.isPresent() && !pathUsage.get().equals((Object)EnumPathUsage.FREE)) {
                                currentStatus.setText(I18Wrapper.format("info.usage.status", new Object[0]) + " : " + I18Wrapper.format("info.usage.status.blocked", new Object[0]));
                                canBeManuelChanged.set(false);
                            }
                            if (!entry.containsEntry(PathEntryType.OUTPUT)) {
                                return;
                            }
                            String name = currentNode.getPoint().toString() + " - " + ClientNameHandler.getClientName(new StateInfo((World)mc.field_71441_e, entry.getEntry(PathEntryType.OUTPUT).get()));
                            UIEntity button = GuiElements.createButton(name, e1 -> {
                                this.gui.pop();
                                UIEntity info = new UIEntity();
                                info.setInherits(true);
                                info.add(new UIBox(UIBox.VBOX, 5));
                                info.add(new UIClickable(_u -> this.gui.pop(), 1));
                                info.add(new UIColor(GuiSignalBox.BACKGROUND_COLOR));
                                info.add(statusEntity);
                                UIEntity textureEntity = new UIEntity();
                                textureEntity.setHeight(40.0);
                                textureEntity.setWidth(40.0);
                                textureEntity.setX(120.0);
                                textureEntity.add(new UIToolTip(I18Wrapper.format("info.usage.rs.desc", new Object[0])));
                                if (canBeManuelChanged.get()) {
                                    if (currentNode.containsManuellOutput((ModeSet)mode)) {
                                        textureEntity.add(new UITexture(REDSTONE_ON));
                                    } else {
                                        textureEntity.add(new UITexture(REDSTONE_OFF));
                                    }
                                } else if (pathUsage.isPresent() && !((EnumPathUsage)((Object)((Object)((Object)((Object)((Object)((Object)pathUsage.get()))))))).equals((Object)EnumPathUsage.FREE)) {
                                    textureEntity.add(new UITexture(REDSTONE_ON_BLOCKED));
                                } else {
                                    textureEntity.add(new UITexture(REDSTONE_OFF_BLOCKED));
                                }
                                info.add(textureEntity);
                                UILabel outputStatus = new UILabel(pathUsage.isPresent() && !((EnumPathUsage)((Object)((Object)((Object)((Object)((Object)((Object)pathUsage.get()))))))).equals((Object)EnumPathUsage.FREE) || currentNode.containsManuellOutput((ModeSet)mode) ? I18Wrapper.format("info.usage.rs.true", new Object[0]) : I18Wrapper.format("info.usage.rs.false", new Object[0]));
                                outputStatus.setCenterY(false);
                                outputStatus.setTextColor(new UIEntity().getBasicTextColor());
                                UIEntity outputEntity = new UIEntity();
                                outputEntity.setInheritWidth(true);
                                outputEntity.setHeight(20.0);
                                outputEntity.add(outputStatus);
                                info.add(outputEntity);
                                if (!canBeManuelChanged.get()) {
                                    this.gui.push(GuiElements.createScreen(entity -> entity.add(info)));
                                    return;
                                }
                                info.add(GuiElements.createButton(I18Wrapper.format("info.usage.change", new Object[0]), i -> {
                                    boolean turnOff = currentNode.containsManuellOutput((ModeSet)mode);
                                    textureEntity.clear();
                                    textureEntity.add(new UIToolTip(I18Wrapper.format("info.usage.rs.desc", new Object[0])));
                                    if (turnOff) {
                                        this.gui.changeRedstoneOutput(currentNode.getPoint(), (ModeSet)mode, false);
                                        outputStatus.setText(I18Wrapper.format("info.usage.rs.false", new Object[0]));
                                        textureEntity.add(new UITexture(REDSTONE_OFF));
                                    } else {
                                        this.gui.changeRedstoneOutput(currentNode.getPoint(), (ModeSet)mode, true);
                                        outputStatus.setText(I18Wrapper.format("info.usage.rs.true", new Object[0]));
                                        textureEntity.add(new UITexture(REDSTONE_ON));
                                    }
                                }));
                                this.gui.push(GuiElements.createScreen(entity -> entity.add(info)));
                            });
                            list.add(button);
                            nameToUIEntity.put(name.toLowerCase(), button);
                        });
                    });
                    UIScroll scroll = new UIScroll();
                    UIEntity scrollBar = GuiElements.createScrollBar(scrollbox, 10, scroll);
                    scrollbox.setConsumer(size -> {
                        if ((double)size > list.getHeight()) {
                            listWithScroll.add(scroll);
                            listWithScroll.add(scrollBar);
                        } else {
                            listWithScroll.remove(scrollBar);
                            listWithScroll.remove(scroll);
                        }
                    });
                    input.setOnTextUpdate(string -> nameToUIEntity.forEach((name, entity) -> {
                        if (!name.contains(string.toLowerCase())) {
                            list.remove((UIEntity)entity);
                        } else {
                            list.add((UIEntity)entity);
                        }
                    }));
                });
                screen.add(new UIClickable(e1 -> this.gui.pop(), 1));
                this.gui.push(screen);
            });
            manuelButton.setScaleX(0.8f);
            manuelButton.setScaleY(0.8f);
            manuelButton.setX(5.0);
            helpList.add(manuelButton);
            manuelButton.add(new UIToolTip(I18Wrapper.format("info.usage.manuel.desc", new Object[0])));
        }
        UIEntity savedPathways = GuiElements.createButton(I18Wrapper.format("info.usage.savedpathways", new Object[0]), e -> {
            UIEntity screen = GuiElements.createScreen(entity -> {
                UIEntity listWithScroll = new UIEntity();
                listWithScroll.setInheritHeight(true);
                listWithScroll.setInheritWidth(true);
                listWithScroll.add(new UIBox(UIBox.HBOX, 2));
                listWithScroll.add(new UIScissor());
                listWithScroll.add(new UIBorder(-16711681));
                entity.add(listWithScroll);
                UIEntity list = new UIEntity();
                listWithScroll.add(list);
                list.setInherits(true);
                UIScrollBox scrollbox = new UIScrollBox(UIBox.VBOX, 2);
                list.add(scrollbox);
                this.gui.container.nextPathways.forEach(entry -> {
                    UIEntity layout = new UIEntity();
                    layout.setHeight(20.0);
                    layout.setInheritWidth(true);
                    layout.add(new UIBox(UIBox.HBOX, 2));
                    UIEntity button = GuiElements.createButton("Start: " + ((Point)entry.getKey()).toShortString() + ", End: " + ((Point)entry.getValue()).toShortString());
                    layout.add(button);
                    layout.add(GuiElements.createButton(I18Wrapper.format("info.usage.show", new Object[0]), 40, _u -> {
                        this.gui.resetTileSelection();
                        this.gui.pop();
                        this.setShowHelpPage(false);
                        this.addColorToTile((Point)entry.getKey(), (Point)entry.getValue(), 687931136);
                    }));
                    layout.add(GuiElements.createButton("x", 20, _u -> {
                        this.gui.container.nextPathways.remove(entry);
                        list.remove(layout);
                        this.gui.removeNextPathwayFromServer((Point)entry.getKey(), (Point)entry.getValue());
                        this.gui.pop();
                    }));
                    list.add(layout);
                });
                UIScroll scroll = new UIScroll();
                UIEntity scrollBar = GuiElements.createScrollBar(scrollbox, 10, scroll);
                scrollbox.setConsumer(size -> {
                    if ((double)size > list.getHeight()) {
                        listWithScroll.add(scroll);
                        listWithScroll.add(scrollBar);
                    } else {
                        listWithScroll.remove(scrollBar);
                        listWithScroll.remove(scroll);
                    }
                });
            });
            screen.add(new UIClickable(_u -> this.gui.pop(), 1));
            this.gui.push(screen);
        });
        savedPathways.setScaleX(0.8f);
        savedPathways.setScaleY(0.8f);
        savedPathways.setX(5.0);
        helpList.add(savedPathways);
        if (node != null) {
            Map<ModeSet, PathOptionEntry> modes = node.getModes();
            List guiModes = modes.keySet().stream().map(mode -> mode.mode).collect(Collectors.toList());
            helpList.add(GuiElements.createLabel(I18Wrapper.format("info.usage.node", new Object[0]), new UIEntity().getBasicTextColor(), 0.8f));
            UIEntity reset = GuiElements.createButton(I18Wrapper.format("button.reset", new Object[0]), e -> {
                UIEntity screen = GuiElements.createScreen(selectionEntity -> {
                    UIBox hbox = new UIBox(UIBox.VBOX, 3);
                    selectionEntity.add(hbox);
                    UIEntity question = new UIEntity();
                    UILabel label = new UILabel(I18Wrapper.format("sb.resetpage", new Object[0]));
                    label.setTextColor(-1);
                    question.setScaleX(1.1f);
                    question.setScaleY(1.1f);
                    question.add(label);
                    question.setInherits(true);
                    UILabel info = new UILabel(I18Wrapper.format("sb.pathwayreset", new Object[0]));
                    info.setTextColor(-1);
                    UIEntity infoEntity = new UIEntity();
                    infoEntity.add(info);
                    infoEntity.setInherits(true);
                    selectionEntity.add(question);
                    selectionEntity.add(infoEntity);
                    UIEntity buttons = new UIEntity();
                    UIEntity buttonYes = GuiElements.createButton(I18Wrapper.format("btn.yes", new Object[0]), e1 -> {
                        this.gui.pop();
                        this.gui.resetPathwayOnServer(node);
                    });
                    UIEntity buttonNo = GuiElements.createButton(I18Wrapper.format("btn.no", new Object[0]), e2 -> this.gui.pop());
                    buttons.setInherits(true);
                    UIBox vbox = new UIBox(UIBox.HBOX, 1);
                    buttons.add(vbox);
                    buttons.add(buttonYes);
                    buttons.add(buttonNo);
                    selectionEntity.add(buttons);
                });
                this.gui.push(screen);
            });
            reset.setScaleX(0.8f);
            reset.setScaleY(0.8f);
            reset.setX(5.0);
            helpList.add(reset);
            reset.add(new UIToolTip(I18Wrapper.format("button.reset.desc", new Object[0])));
            if (guiModes.contains((Object)EnumGuiMode.HP)) {
                UIEntity entity = GuiElements.createBoolElement(DrawUtil.BoolIntegerables.of("auto_pathway"), e -> {
                    this.gui.setAutoPoint(node.getPoint(), (byte)e);
                    node.setAutoPoint(e == 1);
                }, node.isAutoPoint() ? 1 : 0);
                entity.setScaleX(0.8f);
                entity.setScaleY(0.8f);
                entity.setX(5.0);
                helpList.add(entity);
            }
            for (Map.Entry<ModeSet, PathOptionEntry> mapEntry : modes.entrySet()) {
                ModeSet mode2 = mapEntry.getKey();
                PathOptionEntry option = mapEntry.getValue();
                if (!option.containsEntry(PathEntryType.SIGNAL)) continue;
                BlockPos signalPos = option.getEntry(PathEntryType.SIGNAL).get();
                String signalName = ClientNameHandler.getClientName(new StateInfo((World)mc.field_71441_e, signalPos));
                helpList.add(GuiElements.createLabel((signalName.isEmpty() ? "Rotaion: " + mode2.rotation.toString() : signalName) + " - " + mode2.mode.toString(), new UIEntity().getBasicTextColor(), 0.8f));
                UIEntity entity = GuiElements.createButton(I18Wrapper.format("btn.subsidiary", new Object[0]), e -> {
                    UIBox hbox = new UIBox(UIBox.VBOX, 1);
                    UIEntity list = new UIEntity();
                    list.setInherits(true);
                    list.add(hbox);
                    list.add(GuiElements.createButton(I18n.func_135052_a((String)"btn.return", (Object[])new Object[0]), a -> this.gui.pop()));
                    List<SubsidiaryState> possibleSubsidiaires = possibleSubsidiaries.getOrDefault(signalPos, SubsidiaryState.ALL_STATES);
                    possibleSubsidiaires.forEach(state -> {
                        int defaultValue = this.gui.container.grid.getSubsidiaryState(node.getPoint(), mode2, (SubsidiaryState)state) ? 0 : 1;
                        list.add(GuiElements.createEnumElement(new DrawUtil.SizeIntegerables<String>(state.getName(), 2, i -> i == 1 ? "false" : "true"), a -> {
                            SubsidiaryEntry entry = new SubsidiaryEntry((SubsidiaryState)state, a == 0);
                            this.gui.sendSubsidiaryRequest(entry, node.getPoint(), mode2);
                            this.gui.container.grid.setClientState(node.getPoint(), mode2, entry);
                            if (signalPos != null) {
                                if (entry.state) {
                                    subsidiaries.put(signalPos, new SubsidiaryHolder(entry, node.getPoint(), mode2));
                                } else {
                                    subsidiaries.remove(signalPos);
                                }
                            }
                            this.gui.pop();
                            this.helpUsageMode(subsidiaries, node, allNodes, possibleSubsidiaries);
                            MainSignalIdentifier identifier = new MainSignalIdentifier(new ModeIdentifier(node.getPoint(), mode2), signalPos, MainSignalIdentifier.SignalState.combine(state.getSubsidiaryShowType()));
                            List greenSignals = this.gui.container.greenSignals.computeIfAbsent(identifier.getPoint(), _u -> new ArrayList());
                            if (entry.state) {
                                if (greenSignals.contains(identifier)) {
                                    greenSignals.remove(identifier);
                                }
                                greenSignals.add(identifier);
                            } else {
                                greenSignals.remove(identifier);
                            }
                            this.gui.updateSignals((List<Point>)ImmutableList.of((Object)node.getPoint()));
                            if (state.isCountable() && entry.state) {
                                this.gui.container.grid.countOne();
                                this.gui.updateCounter();
                                this.gui.sendCurrentCounterToServer();
                            }
                        }, defaultValue));
                    });
                    UIEntity screen = GuiElements.createScreen(selection -> {
                        selection.add(list);
                        selection.add(GuiElements.createPageSelect(hbox));
                    });
                    this.gui.push(screen);
                });
                entity.setScaleX(0.8f);
                entity.setScaleY(0.8f);
                entity.setX(5.0);
                helpList.add(entity);
                entity.add(new UIToolTip(I18Wrapper.format("btn.subsidiary.desc", new Object[0])));
            }
            UIEntity edit = GuiElements.createButton(I18Wrapper.format("info.usage.edit", new Object[0]), e -> {
                this.helpUsageMode(subsidiaries, null, allNodes, possibleSubsidiaries);
                this.gui.initializePageTileConfig(node);
            });
            edit.setScaleX(0.8f);
            edit.setScaleY(0.8f);
            edit.setX(5.0);
            helpList.add(edit);
            edit.add(new UIToolTip(I18Wrapper.format("info.usage.edit.desc", new Object[0])));
        }
        if (!subsidiaries.isEmpty()) {
            helpList.add(GuiElements.createLabel(I18Wrapper.format("info.usage.subsidiary", new Object[0]), new UIEntity().getBasicTextColor(), 0.8f));
            subsidiaries.forEach((pos, holder) -> {
                String name = ClientNameHandler.getClientName(new StateInfo((World)mc.field_71441_e, (BlockPos)pos));
                UIEntity button = GuiElements.createButton(name, e -> {
                    UIEntity screen = GuiElements.createScreen(selectionEntity -> {
                        UIBox hbox = new UIBox(UIBox.VBOX, 3);
                        selectionEntity.add(hbox);
                        UIEntity question = new UIEntity();
                        UILabel label = new UILabel(name + " : " + holder.entry.enumValue.toString().toUpperCase());
                        label.setTextColor(-1);
                        question.setScaleX(1.1f);
                        question.setScaleY(1.1f);
                        question.add(label);
                        question.setInherits(true);
                        UILabel info = new UILabel(I18Wrapper.format("sb.disablesubsidiary", new Object[0]));
                        info.setTextColor(-1);
                        UIEntity infoEntity = new UIEntity();
                        infoEntity.add(info);
                        infoEntity.setInherits(true);
                        selectionEntity.add(question);
                        selectionEntity.add(infoEntity);
                        UIEntity buttons = new UIEntity();
                        UIEntity buttonYes = GuiElements.createButton(I18Wrapper.format("btn.yes", new Object[0]), e1 -> {
                            this.gui.pop();
                            this.disableSubsidiary.accept((BlockPos)pos, (SubsidiaryHolder)holder);
                        });
                        UIEntity buttonNo = GuiElements.createButton(I18Wrapper.format("btn.no", new Object[0]), e2 -> this.gui.pop());
                        buttons.setInherits(true);
                        UIBox vbox = new UIBox(UIBox.HBOX, 1);
                        buttons.add(vbox);
                        buttons.add(buttonYes);
                        buttons.add(buttonNo);
                        selectionEntity.add(buttons);
                    });
                    this.gui.push(screen);
                });
                button.setScaleX(0.8f);
                button.setScaleY(0.8f);
                button.setX(5.0);
                helpList.add(button);
            });
        }
        UIScroll helpScrolling = new UIScroll();
        UIEntity helpScrollBar = GuiElements.createScrollBar(helpScrollbox, 7, helpScrolling);
        helpScrollbox.setConsumer(size -> {
            if ((double)size > helpList.getHeight()) {
                helpScroll.add(helpScrolling);
                helpScroll.add(helpScrollBar);
            } else {
                helpScroll.remove(helpScrollBar);
                helpScroll.remove(helpScrolling);
            }
        });
        helpList.add(helpScrollbox);
        this.addHelpPageToPlane();
    }

    public void setDisableSubdsidiary(BiConsumer<BlockPos, SubsidiaryHolder> consumer) {
        this.disableSubsidiary = consumer;
    }

    private void addColorToTile(Point start, Point end, int color) {
        UISignalBoxTile startTile = this.gui.allTiles.get(start);
        UISignalBoxTile endTile = this.gui.allTiles.get(end);
        if (startTile == null || endTile == null) {
            return;
        }
        UIColor uiColor = new UIColor(color);
        new Thread(() -> {
            startTile.getParent().add(uiColor);
            endTile.getParent().add(uiColor);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            startTile.getParent().remove(uiColor);
            endTile.getParent().remove(uiColor);
        }, "GuiSignalBox:showNextPathway").start();
    }
}

