/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.troblecodings.core.I18Wrapper;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.GuiBase;
import com.troblecodings.guilib.ecs.GuiElements;
import com.troblecodings.guilib.ecs.GuiInfo;
import com.troblecodings.guilib.ecs.entitys.UIBox;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.entitys.UITextInput;
import com.troblecodings.guilib.ecs.entitys.render.UILabel;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.guis.NamableContainer;
import com.troblecodings.signals.handler.ClientNameHandler;
import com.troblecodings.signals.init.OSBlocks;
import com.troblecodings.signals.tileentitys.RedstoneIOTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class NamableGui
extends GuiBase {
    private UILabel labelComp;
    private final NamableContainer container;
    private final EntityPlayer player;

    public NamableGui(GuiInfo info) {
        super(info);
        this.container = (NamableContainer)info.base;
        this.player = info.player;
    }

    private void initOwn() {
        this.entity.clear();
        this.entity.add(new UIBox(UIBox.HBOX, 5));
        UIEntity inner = new UIEntity();
        inner.setInheritHeight(true);
        inner.setInheritWidth(true);
        inner.add(new UIBox(UIBox.VBOX, 2));
        this.entity.add(GuiElements.createSpacerH(10));
        this.entity.add(inner);
        this.entity.add(GuiElements.createSpacerH(10));
        UIEntity label = GuiElements.createLabel(this.container.tile.getNameWrapper(), 7764128);
        label.setScaleX(1.5f);
        label.setScaleY(1.5f);
        label.findRecursive(UILabel.class).forEach(l -> {
            this.labelComp = l;
        });
        this.labelComp.setCenterX(false);
        inner.add(GuiElements.createSpacerV(10));
        inner.add(label);
        inner.add(GuiElements.createSpacerV(8));
        UIEntity hbox = new UIEntity();
        hbox.add(new UIBox(UIBox.HBOX, 2));
        hbox.setHeight(25.0);
        hbox.setInheritWidth(true);
        UIEntity textfield = new UIEntity();
        textfield.setHeight(20.0);
        textfield.setInheritWidth(true);
        UITextInput input = new UITextInput(this.container.tile.getNameWrapper());
        textfield.add(input);
        hbox.add(textfield);
        UIEntity apply = GuiElements.createButton(I18Wrapper.format("btn.apply", new Object[0]), _u -> this.updateText(input.getText()));
        apply.setInheritWidth(false);
        apply.setWidth(60.0);
        hbox.add(apply);
        inner.add(hbox);
        if (!(this.container.tile instanceof RedstoneIOTileEntity)) {
            return;
        }
        inner.add(GuiElements.createLabel(I18Wrapper.format("label.linkedto", new Object[0])));
        UIEntity list = new UIEntity();
        list.setInheritHeight(true);
        list.setInheritWidth(true);
        UIBox layout = new UIBox(UIBox.VBOX, 5);
        list.add(layout);
        this.container.linkedPos.forEach(pos -> list.add(GuiElements.createLabel(String.format("%s: x = %d, y = %d, z = %d", OSBlocks.SIGNAL_BOX.func_149732_F(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()))));
        this.container.linkedController.forEach(pos -> list.add(GuiElements.createLabel(String.format("%s: x = %d, y = %d, z = %d", OSBlocks.HV_SIGNAL_CONTROLLER.func_149732_F(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()))));
        inner.add(list);
        inner.add(GuiElements.createPageSelect(layout));
    }

    private void updateText(String input) {
        if (input.isEmpty() || input.equals(ClientNameHandler.getClientName(new StateInfo((World)this.field_146297_k.field_71441_e, this.container.pos)))) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putString(input);
        OpenSignalsMain.network.sendTo(this.player, buffer.build());
        this.labelComp.setText(input);
    }

    @Override
    public void updateFromContainer() {
        this.initOwn();
    }

    @Override
    public ContainerBase getNewGuiContainer(GuiInfo info) {
        return new NamableContainer(info);
    }
}

