/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.GuiInfo;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.handler.NameHandler;
import com.troblecodings.signals.tileentitys.BasicBlockEntity;
import com.troblecodings.signals.tileentitys.RedstoneIOTileEntity;
import com.troblecodings.signals.tileentitys.SignalTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;

public class NamableContainer
extends ContainerBase {
    protected BasicBlockEntity tile;
    protected BlockPos pos;
    protected final List<BlockPos> linkedPos = new ArrayList<BlockPos>();
    protected final List<BlockPos> linkedController = new ArrayList<BlockPos>();

    public NamableContainer(GuiInfo info) {
        super(info);
        this.tile = (BasicBlockEntity)info.getTile();
    }

    private void sendSignalPos() {
        WriteBuffer buffer = new WriteBuffer();
        if (this.tile == null) {
            this.tile = (BasicBlockEntity)this.info.getTile();
        }
        buffer.putBlockPos(this.info.pos);
        List<BlockPos> linkedPos = this.tile.getLinkedPos();
        buffer.putByte((byte)linkedPos.size());
        linkedPos.forEach(pos -> buffer.putBlockPos((BlockPos)pos));
        if (this.tile instanceof RedstoneIOTileEntity) {
            List<BlockPos> linkedController = ((RedstoneIOTileEntity)this.tile).getLinkedController();
            buffer.putByte((byte)linkedController.size());
            linkedController.forEach(pos -> buffer.putBlockPos((BlockPos)pos));
        }
        OpenSignalsMain.network.sendTo(this.info.player, buffer.build());
    }

    @Override
    public void sendAllDataToRemote() {
        this.sendSignalPos();
    }

    @Override
    public void deserializeClient(ReadBuffer buffer) {
        this.linkedPos.clear();
        this.linkedController.clear();
        this.pos = buffer.getBlockPos();
        int size = buffer.getByteToUnsignedInt();
        for (int i = 0; i < size; ++i) {
            this.linkedPos.add(buffer.getBlockPos());
        }
        this.tile = (BasicBlockEntity)this.info.world.func_175625_s(this.pos);
        this.update();
    }

    @Override
    public void deserializeServer(ReadBuffer buffer) {
        StateInfo info = new StateInfo(this.info.world, this.info.pos);
        String name = buffer.getString();
        if (this.tile instanceof SignalTileEntity) {
            NameHandler.setNameForSignal(info, name);
        } else {
            NameHandler.setNameForNonSignal(info, name);
        }
    }
}

