/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.troblecodings.core.I18Wrapper;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.DrawUtil;
import com.troblecodings.guilib.ecs.GuiBase;
import com.troblecodings.guilib.ecs.GuiElements;
import com.troblecodings.guilib.ecs.GuiInfo;
import com.troblecodings.guilib.ecs.entitys.UIBox;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.entitys.UIEnumerable;
import com.troblecodings.guilib.ecs.entitys.input.UIClickable;
import com.troblecodings.guilib.ecs.entitys.render.UIColor;
import com.troblecodings.guilib.ecs.entitys.render.UILabel;
import com.troblecodings.guilib.ecs.entitys.render.UITexture;
import com.troblecodings.guilib.ecs.entitys.transform.UIScale;
import com.troblecodings.guilib.ecs.interfaces.IIntegerable;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.enums.EnumMode;
import com.troblecodings.signals.enums.EnumState;
import com.troblecodings.signals.enums.SignalControllerNetwork;
import com.troblecodings.signals.guis.ContainerSignalController;
import com.troblecodings.signals.guis.PreviewSideBar;
import com.troblecodings.signals.handler.ClientNameHandler;
import com.troblecodings.signals.handler.ClientSignalStateHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSignalController
extends GuiBase {
    private final ContainerSignalController controller;
    private final UIEntity lowerEntity = new UIEntity();
    private boolean loaded = false;
    private final EntityPlayer player;
    private EnumMode currentMode;
    private int currentProfile = 0;
    private final BlockPos pos;
    private final PreviewSideBar previewSidebar = new PreviewSideBar(-8.0f);
    private final PreviewSideBar previewRedstone = new PreviewSideBar(-8.0f);

    public GuiSignalController(GuiInfo info) {
        super(info);
        this.controller = (ContainerSignalController)info.base;
        this.player = info.player;
        this.pos = info.pos;
        this.initInternal();
    }

    private void initMode(EnumMode mode) {
        this.lowerEntity.clear();
        this.currentMode = mode;
        this.sendCurrentMode();
        switch (mode) {
            case MANUELL: {
                this.addManuellMode();
                break;
            }
            case SINGLE: {
                this.addSingleRSMode();
                break;
            }
            case RS_INPUT: {
                this.addRSInputMode();
                break;
            }
        }
    }

    private void createPageForSide(EnumFacing face, UIEntity leftSide) {
        UIEntity middlePart = new UIEntity();
        IIntegerable<String> profile = DrawUtil.SizeIntegerables.of("profile", 32, in -> String.valueOf(in));
        UIEnumerable profileEnum = new UIEnumerable(32, "profile");
        leftSide.add(GuiElements.createEnumElement(profileEnum, profile, x -> {
            this.currentProfile = x;
            this.sendRSProfile(x);
            this.updateProfileProperties(middlePart, profileEnum);
        }, this.controller.lastProfile));
        this.currentProfile = this.controller.lastProfile;
        middlePart.setInheritHeight(true);
        middlePart.setInheritWidth(true);
        UIBox boxMode = new UIBox(UIBox.VBOX, 1);
        middlePart.add(boxMode);
        this.updateProfileProperties(middlePart, profileEnum);
        leftSide.add(middlePart);
        int onIndex = -1;
        int offIndex = -1;
        if (this.controller.enabledRSStates.containsKey(face)) {
            Map<EnumState, Integer> states = this.controller.enabledRSStates.get(face);
            if (states.containsKey(EnumState.ONSTATE)) {
                onIndex = states.get(EnumState.ONSTATE);
            }
            if (states.containsKey(EnumState.OFFSTATE)) {
                offIndex = states.get(EnumState.OFFSTATE);
            }
        }
        DrawUtil.DisableIntegerable<String> offProfile = new DrawUtil.DisableIntegerable<String>(DrawUtil.SizeIntegerables.of("profileOff." + face.func_176610_l(), 32, in -> String.valueOf(in)));
        DrawUtil.DisableIntegerable<String> onProfile = new DrawUtil.DisableIntegerable<String>(DrawUtil.SizeIntegerables.of("profileOn." + face.func_176610_l(), 32, in -> String.valueOf(in)));
        UIEntity offElement = GuiElements.createEnumElement(offProfile, e -> this.sendAndSetProfile(face, e, EnumState.OFFSTATE), offIndex);
        UIEntity onElement = GuiElements.createEnumElement(onProfile, e -> this.sendAndSetProfile(face, e, EnumState.ONSTATE), onIndex);
        leftSide.add(offElement);
        leftSide.add(onElement);
        leftSide.add(GuiElements.createPageSelect(boxMode));
    }

    private void updateProfileProperties(UIEntity middlePart, UIEnumerable profile) {
        middlePart.clearChildren();
        profile.setIndex(this.currentProfile);
        Map properties = this.controller.allRSStates.computeIfAbsent(this.currentProfile, _u -> new HashMap());
        this.controller.getProperties().forEach((property, value) -> {
            if (!properties.containsKey(property)) {
                properties.put(property, "DISABLED");
            }
        });
        ClientSignalStateHandler.getClientStates(new StateInfo((World)this.field_146297_k.field_71441_e, this.controller.getPos())).forEach((property, value) -> this.previewRedstone.addToRenderNormal((SEProperty)property, property.getParent().getIDFromValue((String)value)));
        properties.forEach((property, value) -> {
            UIEntity entity = GuiElements.createEnumElement(new DrawUtil.DisableIntegerable<String>((IIntegerable<String>)property), e -> {
                this.previewRedstone.addToRenderNormal((SEProperty)property, e);
                this.sendPropertyToServer((SEProperty)property, e);
                if (e == -1) {
                    properties.remove(property);
                } else {
                    properties.put(property, property.getObjFromID(e));
                }
                this.previewRedstone.update(this.controller.getSignal());
            }, property.getParent().getIDFromValue((String)value));
            middlePart.add(entity);
        });
        this.previewRedstone.update(this.controller.getSignal());
    }

    private void addSingleRSMode() {
        this.lowerEntity.add(new UIBox(UIBox.HBOX, 2));
        UIEntity leftSide = new UIEntity();
        leftSide.setInheritHeight(true);
        leftSide.setInheritWidth(true);
        leftSide.add(new UIBox(UIBox.VBOX, 2));
        this.lowerEntity.add(leftSide);
        this.lowerEntity.add(this.previewRedstone.get());
        UIEntity rightSide = new UIEntity();
        rightSide.setInheritHeight(true);
        rightSide.setWidth(30.0);
        rightSide.add(new UIBox(UIBox.VBOX, 4));
        this.currentProfile = this.controller.lastProfile;
        this.createPageForSide(EnumFacing.DOWN, leftSide);
        Minecraft mc = Minecraft.func_71410_x();
        IBlockState state = mc.field_71439_g.field_70170_p.func_180495_p(this.pos);
        IBakedModel model = mc.func_175602_ab().func_184389_a(state);
        UIEnumerable toggle = new UIEnumerable(EnumFacing.values().length, "singleModeFace");
        toggle.setOnChange(e -> {
            EnumFacing faceing = EnumFacing.values()[e];
            List<UIColor> colors = rightSide.findRecursive(UIColor.class);
            colors.forEach(c -> c.setColor(0x70000000));
            colors.get(e).setColor(0x70FF0000);
            leftSide.clearChildren();
            this.createPageForSide(faceing, leftSide);
        });
        rightSide.add(toggle);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            List quad = model.func_188616_a(state, face, 0L);
            UIEntity faceEntity = new UIEntity();
            faceEntity.setWidth(20.0);
            faceEntity.setHeight(20.0);
            faceEntity.add(new UITexture(((BakedQuad)quad.get(0)).func_187508_a()));
            UIColor color = new UIColor(0x70000000);
            faceEntity.add(color);
            faceEntity.add(new UIClickable(e -> toggle.setIndex(face.ordinal())));
            UILabel label = new UILabel(face.func_176610_l().substring(0, 1).toUpperCase());
            label.setTextColor(-1);
            faceEntity.add(label);
            rightSide.add(faceEntity);
        }
        this.lowerEntity.add(rightSide);
    }

    private void addRSInputMode() {
        this.lowerEntity.add(new UIBox(UIBox.VBOX, 5));
        BlockPos link = this.controller.linkedRSInput;
        String posString = link == null ? "not linked" : link.func_177958_n() + ", " + link.func_177956_o() + ", " + link.func_177952_p();
        UILabel label = new UILabel("Linked To: " + posString);
        this.lowerEntity.add(label);
        DrawUtil.DisableIntegerable<String> profile = new DrawUtil.DisableIntegerable<String>(DrawUtil.SizeIntegerables.of("profile", 32, in -> String.valueOf(in)));
        this.lowerEntity.add(GuiElements.createEnumElement(profile, e -> this.sendRSInputProfileToServer(e), this.controller.linkedRSInputProfile));
        this.lowerEntity.add(GuiElements.createButton(I18Wrapper.format("gui.unlink", new Object[0]), e -> {
            this.unlinkInputPos();
            label.setText("Linked To: not linked");
        }));
    }

    private void initInternal() {
        this.entity.clear();
        Signal signal = this.controller.getSignal();
        if (signal == null) {
            this.entity.add(new UILabel("Not connected"));
            return;
        }
        this.lowerEntity.setInheritHeight(true);
        this.lowerEntity.setInheritWidth(true);
        String name = I18Wrapper.format("tile." + signal.getRegistryName().func_110623_a() + ".name", new Object[0]) + "; Name: " + ClientNameHandler.getClientName(new StateInfo((World)this.field_146297_k.field_71441_e, this.controller.getPos()));
        UILabel titlelabel = new UILabel(name);
        titlelabel.setCenterX(false);
        UIEntity titel = new UIEntity();
        titel.add(new UIScale(1.2f, 1.2f, 1.0f));
        titel.add(titlelabel);
        titel.setInheritHeight(true);
        titel.setInheritWidth(true);
        UIEntity header = new UIEntity();
        header.setInheritWidth(true);
        header.setHeight(45.0);
        header.add(new UIBox(UIBox.VBOX, 1));
        header.add(titel);
        DrawUtil.EnumIntegerable<EnumMode> enumMode = new DrawUtil.EnumIntegerable<EnumMode>(EnumMode.class);
        UIEnumerable enumModes = new UIEnumerable(enumMode.count(), enumMode.getName());
        UIEntity rsMode = GuiElements.createEnumElement(enumModes, enumMode, in -> {
            this.lowerEntity.clearChildren();
            this.initMode((EnumMode)((Object)((Object)enumMode.getObjFromID(in))));
        }, this.controller.currentMode.ordinal());
        this.initMode(this.controller.currentMode);
        header.add(rsMode);
        UIEntity middlePart = new UIEntity();
        middlePart.setInheritHeight(true);
        middlePart.setInheritWidth(true);
        middlePart.add(new UIBox(UIBox.VBOX, 4));
        middlePart.add(header);
        middlePart.add(this.lowerEntity);
        this.entity.add(GuiElements.createSpacerH(10));
        this.entity.add(middlePart);
        this.entity.add(GuiElements.createSpacerH(10));
        this.entity.add(new UIBox(UIBox.HBOX, 1));
    }

    private void addManuellMode() {
        UIEntity list = new UIEntity();
        list.setInheritHeight(true);
        list.setInheritWidth(true);
        UIBox vbox = new UIBox(UIBox.VBOX, 1);
        list.add(vbox);
        UIEntity leftSide = new UIEntity();
        leftSide.setInheritHeight(true);
        leftSide.setInheritWidth(true);
        leftSide.add(list);
        leftSide.add(GuiElements.createPageSelect(vbox));
        leftSide.add(new UIBox(UIBox.VBOX, 5));
        this.lowerEntity.add(leftSide);
        this.previewSidebar.clear();
        this.lowerEntity.add(this.previewSidebar.get());
        this.lowerEntity.add(new UIBox(UIBox.HBOX, 1));
        ClientSignalStateHandler.getClientStates(new StateInfo((World)this.field_146297_k.field_71441_e, this.controller.getPos())).forEach((property, value) -> this.previewSidebar.addToRenderNormal((SEProperty)property, property.getParent().getIDFromValue((String)value)));
        Map<SEProperty, String> map = this.controller.getProperties();
        if (map == null) {
            return;
        }
        map.forEach((property, value) -> {
            UIEnumerable enumarable = new UIEnumerable(property.count(), property.getName());
            int index = property.getParent().getIDFromValue((String)value);
            list.add(GuiElements.createEnumElement(enumarable, property, e -> {
                this.previewSidebar.addToRenderNormal((SEProperty)property, e);
                if (this.loaded) {
                    this.sendPropertyToServer((SEProperty)property, enumarable.getIndex());
                    this.previewSidebar.update(this.controller.getSignal());
                }
            }, index));
        });
        this.previewSidebar.update(this.controller.getSignal());
    }

    private void sendAndSetProfile(EnumFacing facing, int profile, EnumState state) {
        if (!this.loaded) {
            return;
        }
        Map map = this.controller.enabledRSStates.computeIfAbsent(facing, _u -> new HashMap());
        if (profile == -1) {
            map.remove(state);
        } else {
            map.put(state, profile);
        }
        WriteBuffer buffer = new WriteBuffer();
        if (profile == -1) {
            buffer.putEnumValue(SignalControllerNetwork.REMOVE_PROFILE);
        } else {
            buffer.putEnumValue(SignalControllerNetwork.SET_PROFILE);
        }
        buffer.putByte((byte)state.ordinal());
        buffer.putByte((byte)facing.ordinal());
        buffer.putByte((byte)profile);
        OpenSignalsMain.network.sendTo(this.player, buffer);
    }

    private void sendCurrentMode() {
        if (!this.loaded) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalControllerNetwork.SEND_MODE);
        buffer.putByte((byte)this.currentMode.ordinal());
        OpenSignalsMain.network.sendTo(this.player, buffer);
    }

    private void sendRSProfile(int profile) {
        if (!this.loaded) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalControllerNetwork.SEND_RS_PROFILE);
        buffer.putByte((byte)profile);
        OpenSignalsMain.network.sendTo(this.player, buffer);
    }

    private void sendPropertyToServer(SEProperty property, int value) {
        if (!this.loaded) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        if (value == -1) {
            buffer.putEnumValue(SignalControllerNetwork.REMOVE_PROPERTY);
        } else {
            buffer.putEnumValue(SignalControllerNetwork.SEND_PROPERTY);
        }
        buffer.putByte((byte)this.controller.getSignal().getIDFromProperty(property));
        buffer.putByte((byte)value);
        OpenSignalsMain.network.sendTo(this.player, buffer);
    }

    private void sendRSInputProfileToServer(int profile) {
        if (!this.loaded) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        if (profile == -1) {
            buffer.putEnumValue(SignalControllerNetwork.REMOVE_RS_INPUT_PROFILE);
        } else {
            buffer.putEnumValue(SignalControllerNetwork.SET_RS_INPUT_PROFILE);
        }
        buffer.putByte((byte)profile);
        OpenSignalsMain.network.sendTo(this.player, buffer);
    }

    private void unlinkInputPos() {
        this.controller.linkedRSInput = null;
        WriteBuffer buffer = new WriteBuffer();
        buffer.putEnumValue(SignalControllerNetwork.UNLINK_INPUT_POS);
        OpenSignalsMain.network.sendTo(this.player, buffer);
    }

    @Override
    public void updateFromContainer() {
        this.initInternal();
        this.loaded = true;
    }

    @Override
    public ContainerBase getNewGuiContainer(GuiInfo info) {
        return new ContainerSignalController(info);
    }
}

